/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesAnimalMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesAnimalPanicGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotesvillage.entity.Animal.BeachTerrorBirdEntity;
import com.jerotes.jerotesvillage.entity.Animal.WildernessRamblerEntity;
import com.jerotes.jerotesvillage.entity.Animal.WonderlandRamblerEntity;
import com.jerotes.jerotesvillage.entity.Boss.ProsperousEnvoyEntity;
import com.jerotes.jerotesvillage.goal.FollowProsperousEnvoyGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RamblerEntity
extends Animal
implements JerotesEntity,
NeutralMob {
    public AnimationState attackAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("jerotes", "animal_foods/grass_foods")));
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RamblerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(RamblerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public RamblerEntity(EntityType<? extends RamblerEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalMeleeAttackGoal((Animal)this, 1.3, true));
        if (!(this instanceof WildernessRamblerEntity) && !(this instanceof ProsperousEnvoyEntity)) {
            this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
            if (!(this instanceof WonderlandRamblerEntity)) {
                this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, BeachTerrorBirdEntity.class, 32.0f, 1.3, 1.4, EntitySelector.f_20408_::test));
            }
        } else {
            this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalPanicGoal((Animal)this, 1.3));
        }
        if (!(this instanceof ProsperousEnvoyEntity)) {
            this.f_21345_.m_25352_(2, (Goal)new FollowProsperousEnvoyGoal(this, 1.1f));
            this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
            this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
            this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        }
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this instanceof WildernessRamblerEntity || this instanceof ProsperousEnvoyEntity) {
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{RamblerEntity.class}));
            if (this instanceof ProsperousEnvoyEntity) {
                this.f_21346_.m_25352_(1, (Goal)new ProsperousEnvoyHelpGoal(LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
            }
        }
        this.f_21346_.m_25352_(1, (Goal)new HelpProsperousEnvoyGoal(LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((RamblerEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.RAMBLER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.RAMBLER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.RAMBLER_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.RAMBLER_WALK, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Nullable
    public RamblerEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (RamblerEntity)((EntityType)JerotesVillageEntityType.RAMBLER.get()).m_20615_((Level)serverLevel);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 1.1f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof ProsperousEnvoyEntity) {
            return super.m_7327_(entity);
        }
        this.attackAnimation();
        boolean bl = super.m_7327_(entity);
        if (bl && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.RAMBLER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public void attackAnimation() {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(5);
            this.setAnimationState("attack");
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (!(this instanceof ProsperousEnvoyEntity) && ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    class ProsperousEnvoyHelpGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity attack;

        public ProsperousEnvoyHelpGoal(Class<LivingEntity> class_, @Nullable boolean bl, boolean bl2, Predicate<LivingEntity> predicate) {
            super((Mob)RamblerEntity.this, class_, 10, bl, bl2, predicate);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            if (this.f_26135_.m_5448_() != null) {
                return false;
            }
            List list = RamblerEntity.this.m_9236_().m_45976_(RamblerEntity.class, RamblerEntity.this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            double d = Double.MAX_VALUE;
            for (RamblerEntity other : list) {
                if (other == null || this.f_26135_ == other || RamblerEntity.this.m_20280_((Entity)other) > d || RamblerEntity.this.m_5448_() != null || (other.m_5647_() != null || RamblerEntity.this.m_5647_() != null) && !RamblerEntity.this.m_7307_((Entity)other) || other.m_21188_() == null || !RamblerEntity.this.m_6779_(other.m_21188_()) || !RamblerEntity.this.m_6549_(other.m_21188_().m_6095_()) || RamblerEntity.this.m_5448_() != null && RamblerEntity.this.m_5448_() instanceof LivingEntity || other.m_21188_().m_7307_((Entity)RamblerEntity.this) || other.m_21188_().m_7307_((Entity)other)) continue;
                this.attack = other.m_21188_();
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.attack);
            super.m_8056_();
        }
    }

    class HelpProsperousEnvoyGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity attack;

        public HelpProsperousEnvoyGoal(Class<LivingEntity> class_, @Nullable boolean bl, boolean bl2, Predicate<LivingEntity> predicate) {
            super((Mob)RamblerEntity.this, class_, 10, bl, bl2, predicate);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            if (this.f_26135_.m_5448_() != null) {
                return false;
            }
            List list = RamblerEntity.this.m_9236_().m_45976_(ProsperousEnvoyEntity.class, RamblerEntity.this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            double d = Double.MAX_VALUE;
            for (ProsperousEnvoyEntity other : list) {
                if (other == null || this.f_26135_ == other || RamblerEntity.this.m_20280_((Entity)other) > d || RamblerEntity.this.m_5448_() != null || (other.m_5647_() != null || RamblerEntity.this.m_5647_() != null) && !RamblerEntity.this.m_7307_((Entity)other) || other.m_5448_() == null || !RamblerEntity.this.m_6779_(other.m_5448_()) || !RamblerEntity.this.m_6549_(other.m_5448_().m_6095_()) || RamblerEntity.this.m_5448_() != null && RamblerEntity.this.m_5448_() instanceof LivingEntity || other.m_5448_().m_7307_((Entity)RamblerEntity.this) || other.m_5448_().m_7307_((Entity)other)) continue;
                this.attack = other.m_5448_();
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.attack);
            super.m_8056_();
        }
    }
}

