/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesAnimalMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesAnimalPanicGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesFollowParentGoal;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.event.AdvancementEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SandstoneBeastEntity
extends Animal
implements JerotesEntity,
NeutralMob {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_});
    private static final EntityDataAccessor<Boolean> STONE = SynchedEntityData.m_135353_(SandstoneBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SandstoneBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SandstoneBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("c2ae70b1-7c42-43c8-a279-7cae22727cac");
    private int stoneTick;
    public String stoneDropItem = "jerotesvillage:gameplay/jerotesvillage_other/sandstone_beast_stone_drop";
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public SandstoneBeastEntity(EntityType<? extends SandstoneBeastEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SandstoneBeastFloatGoal());
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalMeleeAttackGoal((Animal)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalPanicGoal((Animal)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesFollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SandstoneBeastEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.22);
        builder = builder.m_22268_(Attributes.f_22276_, 40.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.8);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.85);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SANDSTONE_BEAST_AMBIENT;
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SANDSTONE_BEAST_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SANDSTONE_BEAST_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.SANDSTONE_BEAST_WALK, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.6f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Nullable
    public SandstoneBeastEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (SandstoneBeastEntity)((EntityType)JerotesVillageEntityType.SANDSTONE_BEAST.get()).m_20615_((Level)serverLevel);
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -42000 : 0);
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SANDSTONE_BEAST_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.isStone()) {
            if (this.stoneTick > 0) {
                --this.stoneTick;
            }
            if (this.stoneTick <= 0 && !this.m_6162_() && !this.m_9236_().f_46443_) {
                livingEntity = this.m_9236_();
                if (livingEntity instanceof ServerLevel) {
                    ServerLevel projectileLevel = (ServerLevel)livingEntity;
                    for (int i = 0; i < 12; ++i) {
                        projectileLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12447_, this.m_5720_(), 5.0f, 1.0f);
                this.setStone(true);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return this.isStone() && this.m_6084_() || super.m_5829_();
    }

    public boolean isStone() {
        return (Boolean)this.m_20088_().m_135370_(STONE);
    }

    public void setStone(boolean bl) {
        this.m_20088_().m_135381_(STONE, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Armor movement speed", -0.06, AttributeModifier.Operation.ADDITION));
        }
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128379_("IsStone", this.isStone());
        compoundTag.m_128405_("StoneTick", this.stoneTick);
        compoundTag.m_128359_("StoneDropItem", this.stoneDropItem);
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setStone(compoundTag.m_128471_("IsStone"));
        this.stoneTick = compoundTag.m_128451_("StoneTick");
        this.stoneDropItem = compoundTag.m_128461_("StoneDropItem");
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(STONE, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.f_271360_) && this.isStone() && !this.m_6162_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                AdvancementEvent.AdvancementGive(serverPlayer, "jerotesvillage:the_walking_vein");
            }
            if (!this.m_9236_().f_46443_) {
                player.m_6674_(interactionHand);
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12442_, this.m_5720_(), 5.0f, 1.0f);
                int n = 1;
                Item item = itemStack.m_41720_();
                if (item instanceof PickaxeItem) {
                    PickaxeItem pickaxeItem = (PickaxeItem)item;
                    n = (int)pickaxeItem.m_43314_().m_6624_() + pickaxeItem.getEnchantmentLevel(itemStack, Enchantments.f_44984_);
                }
                if (Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)12) < n) {
                    this.drops();
                    itemStack.m_41622_(1, (LivingEntity)player, livingEntitys -> player.m_21190_(interactionHand));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    public void drops() {
        this.setStone(false);
        int reward = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.f_20888_, (int)this.m_213860_());
        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)reward);
        this.stoneTick = 72000;
        int n = 1 + Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)5);
        if (this.m_9236_() instanceof ServerLevel) {
            for (int i = 0; i < n; ++i) {
                BlockPos blockPos = new BlockPos((int)this.m_20185_(), (int)(this.m_20188_() + 0.2), (int)this.m_20189_());
                for (ItemStack drop : this.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation(this.stoneDropItem)).m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81461_, (Object)this.m_9236_().m_8055_(blockPos)).m_287289_(LootContextParams.f_81462_, (Object)this.m_9236_().m_7702_(blockPos)).m_287235_(LootContextParamSets.f_81410_))) {
                    ItemEntity itemEntity = this.m_5552_(drop, 1.0f);
                    if (itemEntity == null) continue;
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
                }
            }
        }
    }

    public ItemStack dropItemStack(float dropItem) {
        if ((double)dropItem > 0.85) {
            return new ItemStack((ItemLike)JerotesVillageItems.PURPLE_SAND.get());
        }
        if ((double)dropItem > 0.8) {
            return new ItemStack((ItemLike)Items.f_151050_);
        }
        if ((double)dropItem > 0.75) {
            return new ItemStack((ItemLike)Items.f_151051_);
        }
        if ((double)dropItem > 0.745) {
            return new ItemStack((ItemLike)Items.f_151053_);
        }
        if ((double)dropItem > 0.65) {
            return new ItemStack((ItemLike)Items.f_42413_);
        }
        if ((double)dropItem > 0.5) {
            return new ItemStack((ItemLike)Items.f_42484_);
        }
        if ((double)dropItem > 0.4975) {
            return new ItemStack((ItemLike)Items.f_42415_);
        }
        if ((double)dropItem > 0.495) {
            return new ItemStack((ItemLike)Items.f_42616_);
        }
        if ((double)dropItem > 0.46) {
            return new ItemStack((ItemLike)Items.f_42534_);
        }
        if ((double)dropItem > 0.43) {
            return new ItemStack((ItemLike)Items.f_42451_);
        }
        if ((double)dropItem > 0.4) {
            return new ItemStack((ItemLike)Items.f_42692_);
        }
        if ((double)dropItem > 0.38) {
            return new ItemStack((ItemLike)Items.f_151049_);
        }
        return new ItemStack((ItemLike)JerotesVillageItems.PURPLE_SANDSTONE.get());
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        Entity entity;
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (this.isStone() && EntityAndItemFind.isMeleeDamage((DamageSource)damagesource) && (entity = damagesource.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack handItem = livingEntity.m_21205_();
            if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand((LivingEntity)livingEntity)) {
                handItem = livingEntity.m_21206_();
            }
            if (handItem.m_41720_() instanceof PickaxeItem) {
                return super.m_6469_(damagesource, amount);
            }
            if (damagesource.m_269533_(DamageTypeTags.f_268549_)) {
                amount *= 0.25f;
            }
            if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                amount *= 0.25f;
            }
            if (!damagesource.m_269533_(DamageTypeTags.f_268490_)) {
                amount *= 0.5f;
            }
        }
        return super.m_6469_(damagesource, amount);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    class SandstoneBeastFloatGoal
    extends FloatGoal {
        public SandstoneBeastFloatGoal() {
            super((Mob)SandstoneBeastEntity.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !SandstoneBeastEntity.this.isStone();
        }
    }
}

