/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.goal.JerotesAnimalMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesAnimalPanicGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesHelpMobOwnerGoal;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.ItemBaseGiantBeastArmor;
import com.jerotes.jerotes.item.ItemBeastArmor;
import com.jerotes.jerotes.item.ItemGiantBeastArmor;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public class ScalyBearEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Boolean> IS_SNOW = SynchedEntityData.m_135353_(ScalyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_SCALE = SynchedEntityData.m_135353_(ScalyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public AnimationState danceAnimationState = new AnimationState();
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("e853c6e2-1f42-4935-abba-1c493e6c210a");
    private static final UUID ARMOR_TOUGHNESS_MODIFIER_UUID = UUID.fromString("fd71c48c-d096-4768-b927-b801148e4019");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("a0cdafe8-4617-46b0-b30d-27162dbdb421");
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ScalyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(ScalyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(ScalyBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private int danceTick = 0;
    private boolean dance;
    @Nullable
    private BlockPos jukebox;
    private int sitTick = 0;
    private int warningSoundTick;
    private int scaleTick = 36000;
    private double honeyLike = 12.0;
    private double meatLike = 32.0;
    private double fishLike = 32.0;
    private double otherLike = 64.0;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public ScalyBearEntity(EntityType<? extends ScalyBearEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.createInventory();
        this.m_252801_();
    }

    public boolean isWearingArmor() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return true;
    }

    public int getInventorySize() {
        return 2;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.setArmorEquipment(this.inventory.m_8020_(1));
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        ItemStack itemStack = this.getArmor();
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
        ItemStack itemStack2 = this.getArmor();
        if (this.f_19797_ > 20 && this.isArmor(itemStack2) && itemStack != itemStack2) {
            this.m_5496_(JerotesSounds.USE_BEAST_ARMOR, 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.28);
        builder = builder.m_22268_(Attributes.f_22276_, 60.0);
        builder = builder.m_22268_(Attributes.f_22284_, 15.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.3);
        builder = builder.m_22268_(Attributes.f_22281_, 11.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.7);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalMeleeAttackGoal((Animal)this, 1.6, true));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalPanicGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpMobOwnerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalOwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalOwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new ScalyBearHurtByTargetGoal());
        this.f_21346_.m_25352_(2, (Goal)new ScalyBearAttackPlayersGoal());
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ScalyBearEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected SoundEvent m_7515_() {
        if (this.m_6162_()) {
            return JerotesVillageSounds.SCALY_BEAR_BABY_AMBIENT;
        }
        return JerotesVillageSounds.SCALY_BEAR_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SCALY_BEAR_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SCALY_BEAR_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.SCALY_BEAR_WALK, 0.15f, 1.0f);
    }

    public int m_8100_() {
        return 600;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.35f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public boolean m_6898_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item.m_41472_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        ScalyBearEntity scalyBear = (ScalyBearEntity)((EntityType)JerotesVillageEntityType.SCALY_BEAR.get()).m_20615_((Level)serverLevel);
        if (scalyBear != null && (uUID = this.m_21805_()) != null) {
            scalyBear.m_21816_(uUID);
            scalyBear.m_7105_(true);
            if (ageableMob instanceof ScalyBearEntity) {
                ScalyBearEntity scalyBear1 = (ScalyBearEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    scalyBear.setSnow(this.isSnow());
                } else {
                    scalyBear.setSnow(scalyBear1.isSnow());
                }
            } else {
                scalyBear.setSnow(this.isSnow());
            }
        } else if (scalyBear != null) {
            if (ageableMob instanceof ScalyBearEntity) {
                ScalyBearEntity scalyBear1 = (ScalyBearEntity)ageableMob;
                if (this.f_19796_.m_188499_()) {
                    scalyBear.setSnow(this.isSnow());
                } else {
                    scalyBear.setSnow(scalyBear1.isSnow());
                }
            } else {
                scalyBear.setSnow(this.isSnow());
            }
        }
        return scalyBear;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_21824_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)JerotesVillageItems.SCALY_BEAR_HAIR.get(), 2);
            this.m_20000_((ItemLike)JerotesVillageItems.SCALY_BEAR_SCALE.get(), 2);
        }
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -42000 : 0);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = passenger.f_20900_ / 2.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public void m_6818_(BlockPos blockPos, boolean bl) {
        this.jukebox = blockPos;
        this.dance = bl;
    }

    public EntityDimensions m_6972_(Pose pose) {
        float scale = 1.0f;
        if (this.isSnow()) {
            scale = 1.075f;
        }
        return super.m_6972_(pose).m_20388_(scale);
    }

    public boolean isDance() {
        return this.dance;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.15, 0.15, 0.15);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public boolean isNoScale() {
        return (Boolean)this.m_20088_().m_135370_(NO_SCALE);
    }

    public void setNoScale(boolean bl) {
        this.m_20088_().m_135381_(NO_SCALE, (Object)bl);
        if (bl) {
            this.m_21051_(Attributes.f_22284_).m_22100_(5.0);
        } else {
            this.m_21051_(Attributes.f_22284_).m_22100_(15.0);
        }
    }

    public boolean isSnow() {
        return (Boolean)this.m_20088_().m_135370_(IS_SNOW);
    }

    public void setSnow(boolean bl) {
        this.m_20088_().m_135381_(IS_SNOW, (Object)bl);
        this.m_6210_();
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(75.0);
            this.m_21153_(75.0f);
            this.m_21051_(Attributes.f_22281_).m_22100_(14.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(60.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(11.0);
        }
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    private void setArmor(ItemStack itemStack) {
        this.m_8061_(EquipmentSlot.CHEST, itemStack);
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public boolean isArmor(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemBaseGiantBeastArmor;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "attack4")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128379_("Dance", this.dance);
        compoundTag.m_128405_("DanceTick", this.danceTick);
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128405_("WarningSoundTick", this.warningSoundTick);
        compoundTag.m_128405_("ScaleTick", this.scaleTick);
        compoundTag.m_128347_("HoneyLike", this.honeyLike);
        compoundTag.m_128347_("MeatLike", this.meatLike);
        compoundTag.m_128347_("FishLike", this.fishLike);
        compoundTag.m_128347_("OtherLike", this.otherLike);
        compoundTag.m_128379_("IsNoScale", this.isNoScale());
        compoundTag.m_128379_("IsSnow", this.isSnow());
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.dance = compoundTag.m_128471_("Dance");
        this.danceTick = compoundTag.m_128451_("DanceTick");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.warningSoundTick = compoundTag.m_128451_("WarningSoundTick");
        this.scaleTick = compoundTag.m_128451_("ScaleTick");
        this.honeyLike = compoundTag.m_128459_("HoneyLike");
        this.meatLike = compoundTag.m_128459_("MeatLike");
        this.fishLike = compoundTag.m_128459_("FishLike");
        this.otherLike = compoundTag.m_128459_("OtherLike");
        this.setNoScale(compoundTag.m_128471_("IsNoScale"));
        this.setSnow(compoundTag.m_128471_("IsSnow"));
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.updateContainerEquipment();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(NO_SCALE, (Object)false);
        this.m_20088_().m_135372_(IS_SNOW, (Object)false);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(4.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (this.m_21830_((LivingEntity)player) && this.m_21830_((LivingEntity)player)) {
                    if (this.canWearArmor() && this.isArmor(itemStack) && !this.isWearingArmor()) {
                        this.equipArmor(player, itemStack);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                    }
                    if (item instanceof BrushItem && !this.isNoScale()) {
                        this.setNoScale(true);
                        this.scaleTick = 0;
                        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_276624_, player.m_5720_(), 1.0f, 1.0f);
                        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_144242_, this.m_5720_(), 1.0f, 1.0f);
                        ItemStack scale = new ItemStack((ItemLike)JerotesVillageItems.SCALY_BEAR_SCALE.get(), 1);
                        ItemStack hair = new ItemStack((ItemLike)JerotesVillageItems.SCALY_BEAR_HAIR.get(), 1);
                        if (!player.m_150109_().m_36054_(scale)) {
                            player.m_36176_(scale, false);
                        }
                        if (!player.m_150109_().m_36054_(hair)) {
                            player.m_36176_(hair, false);
                        }
                        return InteractionResult.SUCCESS;
                    }
                }
                if (!(this.m_6898_(itemStack) || !this.m_6254_() || this.m_20160_() || player.m_36341_() || this.m_21827_())) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                this.m_213583_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack)) {
            return super.m_6071_(player, interactionHand);
        }
        if (this.m_21660_() || !this.m_6162_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        int FoodUse = 1;
        if (itemStack.m_41720_() == Items.f_42787_ || itemStack.m_41720_() == Items.f_42788_ || itemStack.m_41720_() == Items.f_42784_ || itemStack.m_41720_() == Items.f_42789_) {
            FoodUse = (int)this.honeyLike;
            this.honeyLike += 1.0;
        } else if (itemStack.m_204117_(ItemTags.f_13156_)) {
            FoodUse = (int)this.fishLike;
            this.fishLike += 1.0;
        } else if (itemStack.m_41720_().m_41473_().m_38746_()) {
            FoodUse = (int)this.meatLike;
            this.meatLike += 1.0;
        } else {
            FoodUse = (int)this.otherLike;
            this.otherLike += 1.0;
        }
        if (this.f_19796_.m_188503_(FoodUse) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return InteractionResult.SUCCESS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isNoScale() && this.scaleTick < 36000) {
            ++this.scaleTick;
            if (this.scaleTick >= 36000 && this.m_21223_() >= this.m_21233_() / 3.0f) {
                this.setNoScale(false);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_21223_() < this.m_21233_() / 3.0f) {
            this.setNoScale(true);
        }
        if (this.jukebox == null || !this.jukebox.m_203195_((Position)this.m_20182_(), 12.0) || !this.m_9236_().m_8055_(this.jukebox).m_60713_(Blocks.f_50131_)) {
            this.dance = false;
            this.jukebox = null;
        }
        if (this.isDance()) {
            if (this.danceTick <= 0) {
                this.danceTick = 20;
                this.danceAnimationState.m_216977_(this.f_19797_);
                this.sitAnimationState.m_216973_();
                this.stopSitAnimationState.m_216973_();
                this.toSitAnimationState.m_216973_();
            }
        } else {
            this.danceAnimationState.m_216973_();
            this.danceTick = 0;
        }
        if (this.danceTick > 0) {
            --this.danceTick;
        }
        if (this.honeyLike > 12.0) {
            this.honeyLike -= 0.0025;
        }
        if (this.honeyLike > 128.0) {
            this.honeyLike = 128.0;
        }
        if (this.meatLike > 32.0) {
            this.honeyLike -= 0.0025;
        }
        if (this.meatLike > 128.0) {
            this.meatLike = 128.0;
        }
        if (this.fishLike > 32.0) {
            this.honeyLike -= 0.0025;
        }
        if (this.fishLike > 128.0) {
            this.fishLike = 128.0;
        }
        if (this.otherLike > 64.0) {
            this.honeyLike -= 0.0025;
        }
        if (this.otherLike > 128.0) {
            this.otherLike = 128.0;
        }
        if (this.warningSoundTick > 0) {
            --this.warningSoundTick;
        }
        if (this.m_21825_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0 && !this.isDance()) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.isDance() && !this.m_9236_().m_5776_()) {
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                if (this.m_20160_()) {
                    this.setAnimTick(9);
                    this.setAnimationState("attack2");
                } else {
                    this.setAnimTick(10);
                    this.setAnimationState("attack1");
                }
            } else if (attackRandom > 10) {
                this.setAnimTick(9);
                this.setAnimationState("attack4");
            } else {
                this.setAnimTick(9);
                this.setAnimationState("attack3");
            }
        }
        if ((bl = super.m_7327_(entity)) && this.warningSoundTick <= 0) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.SCALY_BEAR_ATTACK, 1.0f, this.m_6100_());
            }
            List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(0.5, 0.2, 0.5));
            for (LivingEntity hurt : list) {
                ScalyBearEntity scalyBear;
                if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof ScalyBearEntity && (scalyBear = (ScalyBearEntity)hurt).m_5448_() != this && this.m_5448_() != scalyBear) continue;
                AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.5f, (float)0.5f, (boolean)false, (float)0.0f);
            }
            Main.sweepAttack((Entity)this);
            this.warningSoundTick = 40;
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (!this.isNoScale() && (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_))) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        int scale = 1;
        if (!this.isNoScale()) {
            scale = 2;
            if (damageSource.m_269533_(DamageTypeTags.f_268549_)) {
                scale = 4;
            }
            if (damageSource.m_276093_(DamageTypes.f_268565_)) {
                scale = 4;
            }
        }
        return super.m_6469_(damageSource, amount /= (float)scale);
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return ScalyBearEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                ScalyBearEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                ScalyBearEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean canWearArmor() {
        return true;
    }

    public void setArmorEquipment(ItemStack itemStack) {
        this.setArmor(itemStack);
        if (!this.m_9236_().f_46443_) {
            double n3;
            double n2;
            ItemGiantBeastArmor armor;
            int n;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22120_(ARMOR_TOUGHNESS_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Item item = itemStack.m_41720_();
            if (item instanceof ItemGiantBeastArmor && (n = (armor = (ItemGiantBeastArmor)item).getProtection()) != 0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Giant Beast Armor bonus", (double)n, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n2 = (armor = (ItemBeastArmor)item).getToughness()) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22118_(new AttributeModifier(ARMOR_TOUGHNESS_MODIFIER_UUID, "Giant Beast Armor toughness bonus", n2, AttributeModifier.Operation.ADDITION));
            }
            if ((item = itemStack.m_41720_()) instanceof ItemBeastArmor && (n3 = (armor = (ItemBeastArmor)item).getKnockbackResistance() * 0.1) != 0.0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Giant Beast Armor knockback resistance bonus", n3, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void equipArmor(Player player, ItemStack itemStack) {
        if (this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack.m_255036_(1));
            if (player != null && !player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
        }
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (spawnGroupData == null) {
            spawnGroupData = new AgeableMob.AgeableMobGroupData(1.0f);
        }
        if (mobSpawnType == MobSpawnType.CHUNK_GENERATION && serverLevelAccessor.m_213780_().m_188501_() > 0.55f) {
            this.m_6863_(true);
        }
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_263748_)) {
                this.setSnow(true);
            } else if (serverLevelAccessor.m_204166_(this.m_20183_()).m_203565_(JerotesVillageBiomes.BRIGHT_GRASSLAND)) {
                this.setSnow(false);
            } else {
                this.setSnow(serverLevelAccessor.m_213780_().m_188501_() > 0.9f);
            }
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    class ScalyBearHurtByTargetGoal
    extends HurtByTargetGoal {
        public ScalyBearHurtByTargetGoal() {
            super((PathfinderMob)ScalyBearEntity.this, new Class[0]);
        }

        public void m_8056_() {
            super.m_8056_();
            if (ScalyBearEntity.this.m_6162_()) {
                this.m_26047_();
                this.m_8041_();
            }
        }

        protected void m_5766_(Mob mob, LivingEntity livingEntity) {
            if (mob instanceof ScalyBearEntity && !mob.m_6162_()) {
                super.m_5766_(mob, livingEntity);
            }
        }
    }

    class ScalyBearAttackPlayersGoal
    extends NearestAttackableTargetGoal<Player> {
        public ScalyBearAttackPlayersGoal() {
            super((Mob)ScalyBearEntity.this, Player.class, 20, true, true, null);
        }

        public boolean m_8036_() {
            if (ScalyBearEntity.this.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                List list = ScalyBearEntity.this.m_9236_().m_45976_(ScalyBearEntity.class, ScalyBearEntity.this.m_20191_().m_82377_(8.0, 4.0, 8.0));
                for (ScalyBearEntity bear : list) {
                    if (!bear.m_6162_() || bear.m_21824_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

