/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesHelpMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesOpenTwoDoorGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeTemptGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.item.MountainRealmFlagSpear;
import com.jerotes.jerotesvillage.item.VirtualCaveFishingNet;
import com.jerotes.jerotesvillage.item.VirtualCaveFishingNetBlockItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Vector3f;

public class SnowyApeEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
UseThrowEntity,
RangedAttackMob,
UseThrownJavelinEntity,
Saddleable,
UseShieldEntity,
PlayerRideableJumping {
    public static final EntityDataAccessor<Boolean> THROW = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> THROWING_TICK = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SnowyApeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_151055_)});
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState throwAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public AnimationState shieldUseMainhandAnimationState = new AnimationState();
    public AnimationState shieldUseOffhandAnimationState = new AnimationState();
    private int sitTick = 0;
    public int shieldCoolDown;
    public int shieldCanUse = 1;
    @Nullable
    private LivingEntity thrower;
    @Nullable
    private UUID throwerUUID;
    protected boolean isJumping;
    protected float playerJumpPendingScale;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SnowyApeEntity(EntityType<? extends SnowyApeEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.6f);
        this.applyOpenDoorsAbility();
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
    }

    private void applyOpenDoorsAbility() {
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 65.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.2);
        builder = builder.m_22268_(Attributes.f_22281_, 9.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(0, (Goal)new JerotesOpenTwoDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.75, true));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CorrosiverEntity.class, 32.0f, 1.4, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new JerotesAnimalChangeTemptGoal(this, 1.1, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Animal.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpMobOwnerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalOwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalOwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SnowyApeEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(13);
            this.setAnimationState("throw");
        }
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SNOWY_APE_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.SNOWY_APE_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SNOWY_APE_DEATH;
    }

    public int m_8100_() {
        return 600;
    }

    public boolean m_6094_() {
        return !this.m_20160_();
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.7f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Nullable
    public SnowyApeEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uUID;
        SnowyApeEntity snowyApe = (SnowyApeEntity)((EntityType)JerotesVillageEntityType.SNOWY_APE.get()).m_20615_((Level)serverLevel);
        if (snowyApe != null && (uUID = this.m_21805_()) != null) {
            snowyApe.m_21816_(uUID);
            snowyApe.m_7105_(true);
        }
        return snowyApe;
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -48000 : 0);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 12;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 2.35f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6254_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = passenger.f_20900_ / 2.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.75, 0.75, 0.75);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public void setThrower(@Nullable LivingEntity livingEntity) {
        this.thrower = livingEntity;
        this.throwerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    @Nullable
    public LivingEntity getThrower() {
        Entity entity;
        if (this.thrower == null && this.throwerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.throwerUUID)) instanceof LivingEntity) {
            this.thrower = (LivingEntity)entity;
        }
        return this.thrower;
    }

    public boolean isThrow() {
        return (Boolean)this.f_19804_.m_135370_(THROW);
    }

    public void setThrow(boolean bl) {
        this.f_19804_.m_135381_(THROW, (Object)bl);
    }

    public void setShieldLevel(int n) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)n);
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    public boolean shieldCanUse() {
        return this.shieldCanUse == 1 && this.shieldCoolDown <= 0;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(80.0);
            this.m_21153_(80.0f);
            this.m_21051_(Attributes.f_22277_).m_22100_(48.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(65.0);
            this.m_21051_(Attributes.f_22277_).m_22100_(24.0);
        }
    }

    public void setThrowingTick(int n) {
        this.m_20088_().m_135381_(THROWING_TICK, (Object)n);
    }

    public int getThrowingTick() {
        return (Integer)this.m_20088_().m_135370_(THROWING_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "throw")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.throwAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128405_("ShieldCoolDown", this.shieldCoolDown);
        compoundTag.m_128405_("ShieldCanUse", this.shieldCanUse);
        compoundTag.m_128405_("ThrowingTick", this.getThrowingTick());
        compoundTag.m_128379_("IsThrow", this.isThrow());
        if (compoundTag.m_128403_("Thrower")) {
            this.throwerUUID = compoundTag.m_128342_("Thrower");
        }
        compoundTag.m_128405_("ShieldLevel", this.getShieldLevel());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.shieldCoolDown = compoundTag.m_128451_("ShieldCoolDown");
        this.shieldCanUse = compoundTag.m_128451_("ShieldCanUse");
        this.setThrow(compoundTag.m_128471_("IsThrow"));
        this.setThrowingTick(compoundTag.m_128451_("ThrowingTick"));
        if (this.throwerUUID != null) {
            compoundTag.m_128362_("Thrower", this.throwerUUID);
        }
        this.setShieldLevel(compoundTag.m_128451_("ShieldLevel"));
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(THROW, (Object)false);
        this.m_20088_().m_135372_(THROWING_TICK, (Object)0);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)1);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.throwAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throwAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            InteractionResult interactionResult;
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(5.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (!(this.m_6898_(itemStack) || player.m_20096_() || player.m_20069_() || !this.m_6254_() || this.m_20160_() || player.m_36341_() || this.m_21827_())) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
            if ((interactionResult = super.m_6071_(player, interactionHand)).m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_() && player.m_6144_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
            if (player.m_21120_(interactionHand).m_41619_()) {
                player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_42446_));
            }
        }
        if (this.f_19796_.m_188503_(4) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec3, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (this.m_269323_() == player && !player.m_5833_() && this.m_21824_() && !player.m_6144_() && (player.m_20096_() || player.m_20069_())) {
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemstack);
            if (itemstack.m_41720_() instanceof BookItem && this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                ItemStack glasses = new ItemStack((ItemLike)JerotesVillageItems.MYOPIA_GLASSES.get());
                if (this.m_217043_().m_188501_() > 0.66f) {
                    glasses = new ItemStack((ItemLike)JerotesVillageItems.PRESBYOPIC_GLASSES.get());
                } else if (this.m_217043_().m_188501_() > 0.33f) {
                    glasses = new ItemStack((ItemLike)JerotesVillageItems.SUNGLASSES.get());
                }
                this.m_8061_(EquipmentSlot.HEAD, glasses);
                equipmentSlot = EquipmentSlot.OFFHAND;
            }
            if (itemstack.m_41619_()) {
                EquipmentSlot equipmentSlot3 = this.getClickedSlot(vec3);
                EquipmentSlot equipmentSlot2 = this.isDisabled(equipmentSlot3) ? equipmentSlot : equipmentSlot3;
                EquipmentSlot equipmentSlot4 = equipmentSlot2;
                if (this.m_21033_(equipmentSlot2) && this.swapItem(player, equipmentSlot2, itemstack, interactionHand)) {
                    return InteractionResult.SUCCESS;
                }
            } else if (this.swapItem(player, equipmentSlot, itemstack, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_7111_(player, vec3, interactionHand);
    }

    private boolean isDisabled(EquipmentSlot equipmentSlot) {
        return equipmentSlot.m_20743_() != EquipmentSlot.Type.HAND && equipmentSlot != EquipmentSlot.HEAD;
    }

    private EquipmentSlot getClickedSlot(Vec3 vec3) {
        double d;
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        boolean bl = this.m_6162_();
        double d2 = d = bl ? vec3.f_82480_ * 2.0 : vec3.f_82480_;
        if (d >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.m_21033_(EquipmentSlot.MAINHAND)) {
            return equipmentSlot;
        }
        if (!this.m_21033_(EquipmentSlot.OFFHAND)) {
            return equipmentSlot;
        }
        return EquipmentSlot.OFFHAND;
    }

    private boolean swapItem(Player player, EquipmentSlot equipmentSlot, ItemStack itemStack, InteractionHand interactionHand) {
        if (this.m_6844_(equipmentSlot).m_41720_() instanceof BannerItem) {
            equipmentSlot = EquipmentSlot.HEAD;
        }
        if (itemStack.m_41720_() == Items.f_42747_ && !this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            equipmentSlot = EquipmentSlot.OFFHAND;
        }
        if (equipmentSlot != EquipmentSlot.OFFHAND && equipmentSlot != EquipmentSlot.HEAD) {
            equipmentSlot = EquipmentSlot.MAINHAND;
        }
        if ((itemStack.m_41720_() instanceof VirtualCaveFishingNet || itemStack.m_41720_() instanceof VirtualCaveFishingNetBlockItem || itemStack.m_41720_() instanceof MountainRealmFlagSpear) && !this.m_6844_(equipmentSlot).m_41619_()) {
            equipmentSlot = EquipmentSlot.MAINHAND;
        }
        if (this.m_6844_(equipmentSlot) == itemStack) {
            equipmentSlot = EquipmentSlot.MAINHAND;
        }
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        if (player.m_150110_().f_35937_ && itemStack2.m_41619_() && !itemStack.m_41619_()) {
            this.m_8061_(equipmentSlot, itemStack.m_255036_(1));
            return true;
        }
        if (!itemStack.m_41619_() && itemStack.m_41613_() > 1) {
            if (!itemStack2.m_41619_()) {
                return false;
            }
            this.m_8061_(equipmentSlot, itemStack.m_41620_(1));
            return true;
        }
        this.m_8061_(equipmentSlot, itemStack);
        player.m_21008_(interactionHand, itemStack2);
        return true;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 5 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 10 && this.m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.isThrow() && !this.m_9236_().m_5776_()) {
            this.setThrowingTick(15);
            this.setAnimTick(15);
            this.setAnimationState("attack2");
            this.setThrow(false);
        }
        if (this.getThrowingTick() <= 0 && this.getThrower() != null && !this.m_9236_().m_5776_()) {
            this.setThrower(null);
        }
        if (this.getThrowingTick() == 8 && this.m_6688_() != null) {
            LivingEntity livingEntity = this.m_6688_();
            livingEntity.m_8127_();
            livingEntity.m_20219_(this.getPassengerRidingPosition((Entity)livingEntity));
            this.setThrower(livingEntity);
        }
        if (this.getThrowingTick() == 5) {
            this.playThrowSound();
            if (this.getThrower() != null && this.m_20270_((Entity)this.getThrower()) < 5.0f) {
                this.RushAttack(this.getThrower());
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setThrowingTick(Math.max(0, this.getThrowingTick() - 1));
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.m_21825_()) {
            this.idleAnimationState.m_216973_();
        } else {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
            this.shieldCanUse = 0;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCanUse = 1;
        }
        this.useBlockingItem((Mob)this);
        if (this.m_5912_() && this.shieldCanUse() && this.m_6117_() && this.m_21211_().m_41720_() instanceof ShieldItem) {
            if (this.m_21206_().m_41720_() instanceof ShieldItem) {
                this.shieldUseOffhandAnimationState.m_216977_(this.f_19797_);
            } else {
                this.shieldUseOffhandAnimationState.m_216973_();
                if (this.m_21205_().m_41720_() instanceof ShieldItem) {
                    this.shieldUseMainhandAnimationState.m_216977_(this.f_19797_);
                } else {
                    this.shieldUseMainhandAnimationState.m_216973_();
                }
            }
        } else {
            this.shieldUseOffhandAnimationState.m_216973_();
            this.shieldUseMainhandAnimationState.m_216973_();
        }
    }

    public boolean RushAttack(LivingEntity livingEntity) {
        float f = livingEntity.m_146908_();
        float f2 = livingEntity.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 1.5f;
        livingEntity.m_6853_(false);
        livingEntity.m_5997_((double)(f3 *= f7 / f6 * 2.0f), (double)(f4 *= f7 / f6 * 3.0f), (double)(f5 *= f7 / f6 * 2.0f));
        return true;
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn instanceof BreakShieldEntity) {
            BreakShieldEntity breakShield = (BreakShieldEntity)entityIn;
            this.disableShieldBreak(breakShield.getShieldBreakStrength());
        }
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn) || entityIn.m_213824_()) {
            this.disableShield();
        }
        this.disableShieldTry();
    }

    public boolean isDamageSourceBlocks(DamageSource damageSource) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = this.m_20171_(0.0f, this.m_6080_());
            Vec3 vec32 = object.m_82505_(this.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    protected void m_7909_(float f) {
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_SHIELD_CAN_BREAK) && this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && f >= 3.0f) {
            int n = 1 + Mth.m_14143_((float)f);
            InteractionHand interactionHand = this.m_7655_();
            this.f_20935_.m_41622_(n, (LivingEntity)this, player -> player.m_21190_(interactionHand));
            if (this.f_20935_.m_41619_()) {
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void disableShield() {
        if (this.m_217043_().m_188501_() <= 1.0f - (float)(this.getShieldLevel() - 1) * 0.2f) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldTry() {
        if ((double)this.m_217043_().m_188501_() <= 0.15 - (double)((float)(this.getShieldLevel() - 1) * 0.05f)) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldBreak(int tick) {
        if (tick == 0) {
            return;
        }
        if (this.shieldCoolDown < tick) {
            this.shieldCoolDown = tick;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (JerotesGameRules.JEROTES_ARMOR_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_ARMOR_CAN_BREAK) && damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
            if (!damageSource.m_276093_(DamageTypes.f_268468_) || !head.m_41720_().m_41475_() && !damageSource.m_269533_(DamageTypeTags.f_268490_)) {
                if (head.m_41720_() instanceof ArmorItem) {
                    head.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.HEAD));
                }
                if (chest.m_41720_() instanceof ArmorItem) {
                    chest.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.CHEST));
                }
                if (legs.m_41720_() instanceof ArmorItem) {
                    legs.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.LEGS));
                }
                if (feet.m_41720_() instanceof ArmorItem) {
                    feet.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(0);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom < 10) {
                this.setAnimTick(12);
                this.setAnimationState("attack3");
            } else {
                if (attackRandom < 15) {
                    this.setAnimTick(15);
                    this.setAttackTick(15);
                    this.setAnimationState("attack2");
                    return true;
                }
                this.setAnimTick(12);
                this.setAnimationState("attack1");
            }
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.SNOWY_APE_ATTACK, 1.0f, 1.0f);
            }
            if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                ItemStack hand = this.m_21205_();
                hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return bl;
    }

    public boolean trueHurt() {
        if (!this.m_20067_() && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SNOWY_APE_ATTACK, 1.0f, 1.0f);
        }
        float reach = 0.5f;
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            boolean bl = super.m_7327_((Entity)hurt);
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        int freezeAmount = 2;
        if (damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            amount /= (float)freezeAmount;
        }
        return super.m_6469_(damageSource, amount);
    }

    protected void m_5907_() {
        super.m_5907_();
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return super.m_6688_();
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_() && this.m_20096_()) {
            this.setIsJumping(false);
            if (this.playerJumpPendingScale > 0.0f && !this.isJumping()) {
                this.executeRidersJump(this.playerJumpPendingScale, vec3);
            }
            this.playerJumpPendingScale = 0.0f;
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        if (this.m_20096_() && this.playerJumpPendingScale == 0.0f) {
            return Vec3.f_82478_;
        }
        float f = player.f_20900_ * 0.5f;
        float f2 = player.f_20902_;
        if (f2 <= 0.0f) {
            f2 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f2);
    }

    public void m_7888_(int n) {
        if (!this.m_6254_()) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        this.playerJumpPendingScale = n >= 90 ? 1.0f : 0.4f + 0.4f * (float)n / 90.0f;
    }

    public boolean m_7132_() {
        return this.m_6254_();
    }

    public void m_7199_(int n) {
        this.playJumpSound();
        if (n >= 90 && n <= 100 && !this.m_9236_().m_5776_()) {
            this.setThrow(true);
        }
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public void setIsJumping(boolean bl) {
        this.isJumping = bl;
    }

    protected void executeRidersJump(float f, Vec3 vec3) {
        if (f < 0.9f) {
            double d = 1.0 * (double)f * (double)this.m_20098_();
            double d2 = d + (double)this.m_285755_();
            Vec3 vec32 = this.m_20184_();
            this.m_20334_(vec32.f_82479_, d2, vec32.f_82481_);
            this.setIsJumping(true);
            this.f_19812_ = true;
            if (vec3.f_82481_ > 0.0) {
                float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * f), 0.0, (double)(0.4f * f3 * f)));
            }
        }
    }

    public void m_8012_() {
    }

    protected void playJumpSound() {
        this.m_5496_(JerotesVillageSounds.SNOWY_APE_JUMP, 0.4f, 1.0f);
    }

    protected void playThrowSound() {
        this.m_5496_(JerotesVillageSounds.SNOWY_APE_THROW, 1.0f, 1.0f);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

