/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.HornableEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class SoftSpiralSheepEntity
extends Sheep
implements JerotesEntity,
HornableEntity {
    private static final EntityDataAccessor<Boolean> NO_HORN = SynchedEntityData.m_135353_(SoftSpiralSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> NEED_RUSH = SynchedEntityData.m_135353_(SoftSpiralSheepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SoftSpiralSheepEntity(EntityType<? extends SoftSpiralSheepEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder m_29873_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.28);
        return builder;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.15f * entityDimensions.f_20378_;
    }

    public boolean isNoHorn() {
        return (Boolean)this.m_20088_().m_135370_(NO_HORN);
    }

    public void setNoHorn(boolean bl) {
        this.m_20088_().m_135381_(NO_HORN, (Object)bl);
    }

    public boolean isNeedRush() {
        return (Integer)this.m_20088_().m_135370_(NEED_RUSH) > 0;
    }

    public int getNeedRush() {
        return (Integer)this.m_20088_().m_135370_(NEED_RUSH);
    }

    public void setNeedRush(int n) {
        this.m_20088_().m_135381_(NEED_RUSH, (Object)n);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsNoHorn", this.isNoHorn());
        compoundTag.m_128379_("IsNeedRush", this.isNeedRush());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("IsNoHorn")) {
            this.setNoHorn(compoundTag.m_128471_("IsNoHorn"));
        }
        if (compoundTag.m_128441_("IsNeedRush")) {
            this.setNoHorn(compoundTag.m_128471_("IsNeedRush"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(NO_HORN, (Object)false);
        this.m_20088_().m_135372_(NEED_RUSH, (Object)0);
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        super.m_7472_(damageSource, n, bl);
        if (this.isHorn()) {
            this.m_20000_((ItemLike)Items.f_220219_, Main.randomReach((RandomSource)this.m_217043_(), (int)0, (int)2));
        }
    }

    @Nullable
    public SoftSpiralSheepEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        SoftSpiralSheepEntity sheep = (SoftSpiralSheepEntity)((EntityType)JerotesVillageEntityType.SOFT_SPIRAL_SHEEP.get()).m_20615_((Level)serverLevel);
        if (sheep != null) {
            sheep.setNoHorn(this.isNoHorn());
        }
        return sheep;
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        SoftSpiralSheepEntity sheep;
        if (animal instanceof SoftSpiralSheepEntity && (sheep = (SoftSpiralSheepEntity)animal).isHorn() != this.isHorn()) {
            for (int i = 0; i < Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)3); ++i) {
                SoftSpiralSheepEntity ageableMob = this.getBreedOffspring(serverLevel, (AgeableMob)animal);
                if (ageableMob == null) {
                    return;
                }
                ageableMob.m_6863_(true);
                ageableMob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                this.m_277117_(serverLevel, animal, (AgeableMob)ageableMob);
                serverLevel.m_47205_((Entity)ageableMob);
            }
        } else {
            super.m_27563_(serverLevel, animal);
        }
    }

    public boolean isHorn() {
        return !this.m_6162_() && !this.isNoHorn();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_21188_() != null) {
            if (!this.m_9236_().m_5776_()) {
                this.setNeedRush(Math.min(this.getNeedRush() + 1, 20));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setNeedRush(Math.max(this.getNeedRush() - 1, 0));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setNoHorn(this.m_217043_().m_188499_());
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

