/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.google.common.annotations.VisibleForTesting;
import com.jerotes.jerotes.entity.ArmorEntity;
import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.CatchEntity;
import com.jerotes.jerotes.goal.JerotesAnimalMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesAnimalOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesBreedGoal;
import com.jerotes.jerotes.goal.JerotesHelpMobOwnerGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.control.VirtualCaveCockroachFlyMoveControl;
import com.jerotes.jerotesvillage.entity.Animal.BaseTamableAnimalEntity;
import com.jerotes.jerotesvillage.goal.BrightMouseTemptGoal;
import com.jerotes.jerotesvillage.goal.Change.JerotesAnimalChangeFollowParentGoal;
import com.jerotes.jerotesvillage.goal.VirtualCaveCockroachLeapAtTargetAndLookGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class VirtualCaveCockroachEntity
extends BaseTamableAnimalEntity
implements NeutralMob,
CatchEntity,
BreakShieldEntity,
Saddleable,
ArmorEntity,
ContainerListener,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLY_TICK = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();
    public AnimationState toSitAnimationState = new AnimationState();
    public AnimationState stopSitAnimationState = new AnimationState();
    public AnimationState climbAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> DATA_ID_CHEST = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> CLIMB = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_CATCH = SynchedEntityData.m_135353_(VirtualCaveCockroachEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    public int sitTick = 0;
    public double blockDestroyTick;
    public double attackGet = 5.0;
    public double attackTameGet = 6.25;
    public double healthGet = Math.max(25, 1);
    public double healthTameGet = (float)Math.max(25, 1) * 1.25f;
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public SimpleContainer inventory() {
        return this.inventory;
    }

    public VirtualCaveCockroachEntity(EntityType<? extends VirtualCaveCockroachEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(0.5f);
        this.createInventory();
        this.m_252801_();
    }

    public boolean isJerotesFlyingMob() {
        return this.canFlySize();
    }

    public boolean isWearingArmor() {
        return false;
    }

    public boolean isWarBeastArmor() {
        return false;
    }

    public boolean isGiantBeastArmor() {
        return false;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected void updateContainerEquipment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
        this.m_21409_(EquipmentSlot.CHEST, 0.0f);
    }

    public void m_5757_(Container p_30548_) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
    }

    public SoundEvent m_246265_() {
        return JerotesSounds.USE_SADDLE;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22280_, 2.275);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.325);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAnimalMeleeAttackGoal((Animal)this, 1.4, true));
        this.f_21345_.m_25352_(2, (Goal)new VirtualCaveCockroachLeapAtTargetAndLookGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesBreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BrightMouseTemptGoal((PathfinderMob)this, 0.9, false){

            @Override
            public boolean m_8036_() {
                if (VirtualCaveCockroachEntity.this.m_269323_() == null || VirtualCaveCockroachEntity.this.getChangeType() == 1) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if (VirtualCaveCockroachEntity.this.m_269323_() == null || VirtualCaveCockroachEntity.this.getChangeType() == 1) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new JerotesAnimalChangeFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpMobOwnerGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesAnimalOwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesAnimalOwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((VirtualCaveCockroachEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected SoundEvent m_7515_() {
        if (this.getSizeLike() > 2) {
            return JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_AMBIENT_GIANT;
        }
        return JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_AMBIENT_SMALL;
    }

    public int m_8100_() {
        if (this.getSizeLike() > 3) {
            return 400;
        }
        return super.m_8100_();
    }

    protected float m_6121_() {
        if (this.getSizeLike() > 2) {
            return super.m_6121_();
        }
        return 0.1f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_DEATH;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean m_7848_(Animal animal) {
        VirtualCaveCockroachEntity virtualCaveCockroachEntity;
        int otherSize;
        if (animal instanceof VirtualCaveCockroachEntity && ((otherSize = (virtualCaveCockroachEntity = (VirtualCaveCockroachEntity)animal).getSizeLike() - this.getSizeLike()) > 1 || otherSize < -1)) {
            return false;
        }
        if (animal instanceof VirtualCaveCockroachEntity) {
            virtualCaveCockroachEntity = (VirtualCaveCockroachEntity)animal;
            if (this.m_21824_() != virtualCaveCockroachEntity.m_21824_()) {
                return false;
            }
        }
        return super.m_7848_(animal);
    }

    @Nullable
    public VirtualCaveCockroachEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        VirtualCaveCockroachEntity virtualCaveCockroachEntity = (VirtualCaveCockroachEntity)((EntityType)JerotesVillageEntityType.VIRTUAL_CAVE_COCKROACH.get()).m_20615_((Level)serverLevel);
        if (virtualCaveCockroachEntity != null) {
            VirtualCaveCockroachEntity virtualCaveCockroachEntity2;
            float sizeFind = this.m_217043_().m_188501_();
            float sizeOtherFind = this.m_217043_().m_188501_();
            if (sizeFind > 0.6666667f) {
                if (sizeOtherFind > 0.5f && ageableMob instanceof VirtualCaveCockroachEntity) {
                    virtualCaveCockroachEntity2 = (VirtualCaveCockroachEntity)ageableMob;
                    virtualCaveCockroachEntity.setSize(virtualCaveCockroachEntity2.getSize(), true);
                } else {
                    virtualCaveCockroachEntity.setSize(this.getSize(), true);
                }
            } else if (sizeFind > 0.33333334f && ageableMob instanceof VirtualCaveCockroachEntity) {
                VirtualCaveCockroachEntity virtualCaveCockroachEntity22 = (VirtualCaveCockroachEntity)ageableMob;
                virtualCaveCockroachEntity.setSize((int)((float)(this.getSize() + virtualCaveCockroachEntity22.getSize()) / 2.0f), true);
            } else if (sizeOtherFind > 0.75f && ageableMob instanceof VirtualCaveCockroachEntity) {
                virtualCaveCockroachEntity2 = (VirtualCaveCockroachEntity)ageableMob;
                virtualCaveCockroachEntity.setSize(virtualCaveCockroachEntity2.getSize() + Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)2), true);
            } else if (sizeOtherFind > 0.5f && ageableMob instanceof VirtualCaveCockroachEntity) {
                virtualCaveCockroachEntity2 = (VirtualCaveCockroachEntity)ageableMob;
                virtualCaveCockroachEntity.setSize(virtualCaveCockroachEntity2.getSize() - Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)2), true);
            } else if (sizeOtherFind > 0.25f) {
                virtualCaveCockroachEntity.setSize(this.getSize() - Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)2), true);
            } else {
                virtualCaveCockroachEntity.setSize(this.getSize() + Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)2), true);
            }
            float colorFind = this.m_217043_().m_188501_();
            float colorOtherFind = this.m_217043_().m_188501_();
            if (colorFind > 0.6666667f && ageableMob instanceof VirtualCaveCockroachEntity) {
                virtualCaveCockroachEntity2 = (VirtualCaveCockroachEntity)ageableMob;
                int color = this.createColor(this.getColor(), virtualCaveCockroachEntity2.getColor(), true);
                virtualCaveCockroachEntity.setColor(color);
            } else if (colorFind > 0.33333334f && ageableMob instanceof VirtualCaveCockroachEntity) {
                VirtualCaveCockroachEntity virtualCaveCockroachEntity23 = (VirtualCaveCockroachEntity)ageableMob;
                int color = this.createColor(this.getColor(), virtualCaveCockroachEntity23.getColor(), false);
                virtualCaveCockroachEntity.setColor(color);
            } else if (colorOtherFind > 0.5f && ageableMob instanceof VirtualCaveCockroachEntity) {
                VirtualCaveCockroachEntity virtualCaveCockroachEntity24 = (VirtualCaveCockroachEntity)ageableMob;
                virtualCaveCockroachEntity.setColor(virtualCaveCockroachEntity24.getColor());
            } else {
                virtualCaveCockroachEntity.setColor(this.getColor());
            }
            UUID uUID = this.m_21805_();
            if (uUID != null) {
                virtualCaveCockroachEntity.m_21816_(uUID);
                virtualCaveCockroachEntity.m_7105_(true);
            }
        }
        return virtualCaveCockroachEntity;
    }

    public int createColor(int n, int n2, boolean bl) {
        if (!bl) {
            int f0 = n >> 16 & 0xFF;
            int f1 = n >> 8 & 0xFF;
            int f2 = n & 0xFF;
            int f02 = n2 >> 16 & 0xFF;
            int f12 = n2 >> 8 & 0xFF;
            int f22 = n2 & 0xFF;
            int f03 = (f0 + f02) / 2;
            int f13 = (f1 + f12) / 2;
            int f23 = (f2 + f22) / 2;
            return 65536 * f03 + 256 * f13 + f23;
        }
        int f0 = n >> 16 & 0xFF;
        int f1 = n >> 8 & 0xFF;
        int f2 = n & 0xFF;
        int f02 = n2 >> 16 & 0xFF;
        int f12 = n2 >> 8 & 0xFF;
        int f22 = n2 & 0xFF;
        int f03 = Math.min((f0 + f02) / 2, 255);
        int f13 = Math.min((f1 + f12) / 2, 255);
        int f23 = Math.min((f2 + f22) / 2, 255);
        if (this.m_217043_().m_188501_() > 0.33333334f) {
            f03 = Math.min((f0 + f02) / 2 + Main.randomReach((RandomSource)this.m_217043_(), (int)-10, (int)10), 255);
        }
        if (this.m_217043_().m_188501_() > 0.33333334f) {
            f13 = Math.min((f1 + f12) / 2 + Main.randomReach((RandomSource)this.m_217043_(), (int)-10, (int)10), 255);
        } else {
            f23 = Math.min((f2 + f22) / 2 + Main.randomReach((RandomSource)this.m_217043_(), (int)-10, (int)10), 255);
        }
        return 65536 * f03 + 256 * f13 + f23;
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        for (int i = 0; i < this.f_19796_.m_216339_(1, 4); ++i) {
            VirtualCaveCockroachEntity ageableMob = this.getBreedOffspring(serverLevel, (AgeableMob)animal);
            if (ageableMob == null) {
                return;
            }
            ageableMob.m_6863_(true);
            ageableMob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            this.m_277117_(serverLevel, animal, (AgeableMob)ageableMob);
            serverLevel.m_47205_((Entity)ageableMob);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = (float)this.getSize() * 0.06f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    public boolean m_6063_() {
        if (this.getSizeLike() > 3 && !this.m_6162_()) {
            return false;
        }
        return super.m_6094_();
    }

    public boolean m_6094_() {
        if (this.getSizeLike() > 3 && !this.m_6162_()) {
            return false;
        }
        return super.m_6094_();
    }

    public boolean m_6573_(Player player) {
        if (this.getSizeLike() > 3 && !this.m_6162_()) {
            return false;
        }
        return super.m_6573_(player);
    }

    public boolean m_213824_() {
        return this.getSizeLike() > 3;
    }

    public boolean m_5843_() {
        if (this.getSizeLike() > 2) {
            return this.m_20184_().m_165925_() > 2.500000277905201E-7;
        }
        return super.m_5843_();
    }

    public boolean m_6898_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item.m_41472_();
    }

    protected void m_142043_() {
        this.m_5496_(JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_FLY, 0.15f, 1.0f);
    }

    public void m_6863_(boolean bl) {
        this.m_146762_(bl ? -10000 * this.getSizeLike() : 0);
    }

    public boolean isFlying() {
        if (!this.canFlySize() || this.m_6162_()) {
            return false;
        }
        if (Main.isInFluid((LivingEntity)this) && this.m_5448_() == null || this.m_20096_() && this.m_5448_() == null) {
            return false;
        }
        if (this.isClimbing() && this.m_5448_() == null) {
            return false;
        }
        if (this.m_21825_()) {
            return false;
        }
        return this.getFlyTick() > 300 || this.m_6688_() instanceof Player || this.m_5448_() != null;
    }

    @NotNull
    public PathNavigation m_21573_() {
        Entity entity = this.m_275832_();
        if (entity instanceof Mob) {
            return super.m_21573_();
        }
        if (!this.canGiantNavigationSize()) {
            if (this.canClimbSize()) {
                return super.m_21573_();
            }
            return new GroundPathNavigation((Mob)this, this.m_9236_());
        }
        return new GroundPathNavigation((Mob)this, this.m_9236_());
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                if (!this.m_20096_() && !Main.isInFluid((LivingEntity)this)) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22280_));
                }
                float forward = passenger.f_20902_;
                float strafe = passenger.f_20900_ / 2.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.4f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected float getSinglePassengerXOffset() {
        return 0.0f;
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        if (!this.m_6254_()) {
            return new Vector3f(0.0f, entityDimensions.f_20378_, 1.0f);
        }
        float f2 = this.getSinglePassengerXOffset();
        float f3 = 0.0f;
        float f4 = 0.055f * (float)this.getSize();
        int i = this.m_20197_().indexOf(entity);
        if (i == 0) {
            f2 = 0.04f;
            f3 = 0.0f;
        }
        if (i == 1) {
            f2 = 0.035f;
            f3 = 0.0f;
        }
        return new Vector3f(f3 * (float)this.getSize(), f4, f2 * (float)this.getSize());
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        double d = (double)this.getSizeLike() * 0.02;
        return aabb1.m_82377_(d, d, d);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    protected void playChestEquipsSound() {
        this.m_5496_(JerotesSounds.USE_CHEST, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public int getShieldBreakStrength() {
        if (this.getSizeLike() > 3) {
            return 100;
        }
        return 0;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    protected int getMaxPassengers() {
        if (this.getSizeLike() > 3) {
            if (!this.m_6254_()) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    public boolean OwnerCanOrderAttack() {
        return this.getSizeLike() > 3 || this.getSizeLike() > 2 && !this.m_6162_();
    }

    public boolean hasChest() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ID_CHEST);
    }

    public void setChest(boolean p_30505_) {
        this.m_20088_().m_135381_(DATA_ID_CHEST, (Object)p_30505_);
    }

    public int getInventorySize() {
        return 27;
    }

    public int getInventoryColumns() {
        return 5;
    }

    protected void setFlag(int n, boolean n2) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (n2) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | n)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~n)));
        }
    }

    protected boolean getFlag(int n) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & n) != 0;
    }

    public ItemStack getArmor() {
        return this.m_6844_(EquipmentSlot.CHEST);
    }

    public boolean isArmor(ItemStack itemStack) {
        return false;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(CLIMB) & 1) != 0;
    }

    public void setClimbing(boolean bl) {
        byte by = (Byte)this.f_19804_.m_135370_(CLIMB);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMB, (Object)by);
    }

    public void setColor(int n) {
        this.m_20088_().m_135381_(COLOR, (Object)n);
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setFlyTick(int n) {
        this.m_20088_().m_135381_(FLY_TICK, (Object)n);
    }

    public int getFlyTick() {
        return (Integer)this.m_20088_().m_135370_(FLY_TICK);
    }

    public ItemStack getCatchItemStack() {
        return new ItemStack((ItemLike)JerotesVillageItems.CAPTURED_VIRTUAL_CAVE_COCKROACH.get());
    }

    public SoundEvent getPickupSound() {
        return JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_AMBIENT_SMALL;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromCatch();
    }

    public boolean m_6785_(double d) {
        return !this.fromCatch() && !this.m_8077_() && super.m_6785_(d);
    }

    public boolean fromCatch() {
        return (Boolean)this.f_19804_.m_135370_(FROM_CATCH);
    }

    public void setFromCatch(boolean bl) {
        this.f_19804_.m_135381_(FROM_CATCH, (Object)bl);
    }

    public void m_7105_(boolean bl) {
        int f2 = this.getSize();
        this.f_19804_.m_135381_(ID_SIZE, (Object)f2);
        float health = Math.max((float)((int)((double)(f2 * f2) * 0.25)), 1.0f);
        float healthTame = health * 1.25f;
        float attack = (float)f2 * 0.5f;
        float attackTame = attack * 1.25f;
        this.healthGet = health;
        this.healthTameGet = healthTame;
        this.attackGet = attack;
        this.attackTameGet = attackTame;
        boolean tame = this.m_21824_();
        super.m_7105_(bl);
        if (bl) {
            if (!tame) {
                this.m_21051_(Attributes.f_22276_).m_22100_(this.healthTameGet);
                this.m_21153_((float)this.healthTameGet);
                this.m_21051_(Attributes.f_22281_).m_22100_(this.attackTameGet);
            }
        } else if (tame) {
            this.m_21051_(Attributes.f_22276_).m_22100_(this.healthGet);
            this.m_21051_(Attributes.f_22281_).m_22100_(this.attackGet);
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return super.m_6972_(pose).m_20388_(0.1f * (float)this.getSize());
    }

    @VisibleForTesting
    public void setSize(int f, boolean bl) {
        int f2 = (int)Mth.m_14008_((double)f, (double)1.0, (double)OtherMainConfig.VirtualCaveCockroachMaxSize);
        this.f_19804_.m_135381_(ID_SIZE, (Object)f2);
        float health = Math.max((float)((int)((double)(f2 * f2) * 0.25)), 1.0f);
        float healthTame = health * 1.25f;
        float attack = (float)f2 * 0.5f;
        float attackTame = attack * 1.25f;
        this.healthGet = health;
        this.healthTameGet = healthTame;
        this.attackGet = attack;
        this.attackTameGet = attackTame;
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(this.healthTameGet);
            if (bl) {
                this.m_21153_((float)this.healthTameGet);
            }
            this.m_21051_(Attributes.f_22281_).m_22100_(this.attackTameGet);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(this.healthGet);
            if (bl) {
                this.m_21153_((float)this.healthGet);
            }
            this.m_21051_(Attributes.f_22281_).m_22100_(this.attackGet);
        }
        if (f2 <= 20) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.25 + (double)((float)f2 * 0.0075f));
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3999999910593033 + (double)((float)(f2 - 20) * 0.0015f));
        }
        if (f2 <= 20) {
            this.m_21051_(Attributes.f_22280_).m_22100_(0.25 + (double)((float)f2 * 0.0525f));
        } else {
            this.m_21051_(Attributes.f_22280_).m_22100_((double)1.3f + (double)((float)(f2 - 20) * 0.0105f));
        }
        this.m_21051_(Attributes.f_22278_).m_22100_((double)Math.min((float)f2 * 0.025f, 1.0f));
        this.m_21051_(Attributes.f_22282_).m_22100_((double)Math.min((float)f2 * 0.1f, 5.0f));
        this.m_21051_(Attributes.f_22284_).m_22100_((double)Math.min((float)f2 * 0.3f, 16.0f));
        if (f2 < 10) {
            this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
            this.m_21441_(BlockPathTypes.FENCE, -1.0f);
            this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, -1.0f);
            this.m_21441_(BlockPathTypes.WATER, 8.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
            this.f_21342_ = new VirtualCaveCockroachFlyMoveControl((Mob)this, 10);
        } else if (f2 < 20) {
            this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
            this.m_21441_(BlockPathTypes.FENCE, -1.0f);
            this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
            this.m_21441_(BlockPathTypes.WATER, 8.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
            this.f_21342_ = new VirtualCaveCockroachFlyMoveControl((Mob)this, 10);
        } else if (f2 < 40) {
            this.m_21441_(BlockPathTypes.LEAVES, -1.0f);
            this.m_21441_(BlockPathTypes.FENCE, -1.0f);
            this.m_21441_(BlockPathTypes.BLOCKED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, -1.0f);
            this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
            this.m_21441_(BlockPathTypes.WATER, 8.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
            this.f_21342_ = new VirtualCaveCockroachFlyMoveControl((Mob)this, 10);
        } else {
            this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
            this.m_21441_(BlockPathTypes.FENCE, 4.0f);
            this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
            this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
            this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
            this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
            this.f_21342_ = new GiantMoveControl((Mob)this);
        }
        this.m_20090_();
        this.m_6210_();
        this.m_274367_(0.5f + (float)this.getSize() * 0.05f);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    protected void m_30232_() {
        super.m_30232_();
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public int getSizeLike() {
        float size = this.getSize();
        if (size < 10.0f) {
            return 1;
        }
        if (size < 20.0f) {
            return 2;
        }
        if (size < 40.0f) {
            return 3;
        }
        return 4;
    }

    public boolean canClimbSize() {
        return this.getSizeLike() < 4;
    }

    public boolean canTameSize() {
        return this.getSizeLike() > 1;
    }

    public boolean canFlySize() {
        return this.getSizeLike() < 4;
    }

    public boolean canRideSize() {
        return this.getSizeLike() > 1;
    }

    public boolean canChestSize() {
        return this.getSizeLike() > 3;
    }

    public boolean canBreakBlockSize() {
        return this.getSizeLike() > 3;
    }

    public boolean canGiantNavigationSize() {
        return this.getSizeLike() > 3;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128379_("FromCatch", this.fromCatch());
        compoundTag.m_128405_("Color", this.getColor());
        compoundTag.m_128405_("Size", this.getSize());
        compoundTag.m_128405_("FlyTick", this.getSizeLike());
        compoundTag.m_128347_("AttackGet", this.attackGet);
        compoundTag.m_128347_("AttackTameGet", this.attackTameGet);
        compoundTag.m_128347_("HealthGet", this.healthGet);
        compoundTag.m_128347_("HealthTameGet", this.healthTameGet);
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            compoundTag.m_128365_("SaddleItem", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            compoundTag.m_128365_("ArmorItem", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            ListTag $$1 = new ListTag();
            for (int $$2 = 2; $$2 < this.inventory.m_6643_(); ++$$2) {
                ItemStack $$3 = this.inventory.m_8020_($$2);
                if ($$3.m_41619_()) continue;
                CompoundTag $$4 = new CompoundTag();
                $$4.m_128344_("Slot", (byte)$$2);
                $$3.m_41739_($$4);
                $$1.add((Object)$$4);
            }
            compoundTag.m_128365_("Items", (Tag)$$1);
        }
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        ItemStack itemStack;
        ItemStack itemstack;
        this.setSize(compoundTag.m_128451_("Size"), false);
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setFromCatch(compoundTag.m_128471_("FromCatch"));
        this.setColor(compoundTag.m_128451_("Color"));
        this.setFlyTick(compoundTag.m_128451_("FlyTick"));
        this.attackGet = compoundTag.m_128459_("AttackGet");
        this.attackTameGet = compoundTag.m_128459_("AttackTameGet");
        this.healthGet = compoundTag.m_128459_("HealthGet");
        this.healthTameGet = compoundTag.m_128459_("HealthTameGet");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        if (compoundTag.m_128425_("SaddleItem", 10) && (itemstack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("SaddleItem"))).m_150930_(Items.f_42450_)) {
            this.inventory.m_6836_(0, itemstack);
        }
        if (compoundTag.m_128425_("ArmorItem", 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ArmorItem"))).m_41619_() && this.isArmor(itemStack)) {
            this.inventory.m_6836_(1, itemStack);
        }
        this.setChest(compoundTag.m_128471_("ChestedHorse"));
        this.createInventory();
        if (this.hasChest()) {
            ListTag $$1 = compoundTag.m_128437_("Items", 10);
            for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
                CompoundTag $$3 = $$1.m_128728_($$2);
                int $$4 = $$3.m_128445_("Slot") & 0xFF;
                if ($$4 < 2 || $$4 >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_($$4, ItemStack.m_41712_((CompoundTag)$$3));
            }
        }
        this.updateContainerEquipment();
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(COLOR, (Object)1);
        this.m_20088_().m_135372_(FLY_TICK, (Object)400);
        this.m_20088_().m_135372_(FROM_CATCH, (Object)false);
        this.m_20088_().m_135372_(DATA_ID_FLAGS, (Object)0);
        this.m_20088_().m_135372_(CLIMB, (Object)0);
        this.m_20088_().m_135372_(DATA_ID_CHEST, (Object)false);
        this.m_20088_().m_135372_(ID_SIZE, (Object)10);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ID_SIZE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void saveToCatchTag(ItemStack itemStack) {
        CatchEntity.saveDefaultDataToCatchTag((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
        this.m_21678_(compoundTag);
    }

    public void loadFromCatchTag(CompoundTag compoundTag) {
        CatchEntity.loadDefaultDataFromCatchTag((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
        this.updateContainerEquipment();
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.canClimbSize()) {
            if (!this.m_9236_().f_46443_) {
                this.setClimbing(this.f_19862_);
            }
        } else if (this.isClimbing() && !this.m_9236_().f_46443_) {
            this.setClimbing(false);
        }
    }

    @Override
    public void m_8107_() {
        float f;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.isClimbing() && this.canClimbSize()) {
            this.climbAnimationState.m_216977_(this.f_19797_);
        } else {
            this.climbAnimationState.m_216973_();
        }
        if (this.getFlyTick() > 0) {
            this.setFlyTick(this.getFlyTick() - 1);
        } else {
            this.setFlyTick(400);
        }
        if (this.canFlySize() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
            if (this.f_19790_ != this.m_20185_() || this.f_19792_ != this.m_20189_()) {
                double d = Math.abs(this.m_20185_() - this.f_19790_);
                double d2 = Math.abs(this.m_20189_() - this.f_19792_);
                if (d >= 0.01 || d2 >= 0.01) {
                    if (this.m_20184_().f_82480_ < (double)0.6f && this.m_20184_().f_82480_ > (double)-0.6f) {
                        float headXRot = player.m_146909_();
                        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(headXRot / 2.0f * -0.0025f), 0.0));
                    }
                } else if (this.m_20184_().f_82480_ > -0.5) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.05f, 0.0));
                }
            } else if (this.m_20184_().f_82480_ > -0.5) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.05f, 0.0));
            }
        }
        if (this.f_267362_.m_267780_() && this.m_20096_() && this.m_21223_() > this.m_21233_() / 4.0f && !this.m_6162_() && this.canGiantNavigationSize() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (!this.m_21825_()) {
            this.sitAnimationState.m_216973_();
        }
        if (this.m_21825_() && this.sitTick <= 0) {
            this.sitTick = 40;
        }
        if (!this.m_21825_() && this.sitTick > 0) {
            this.stopSitAnimationState.m_216977_(this.f_19797_);
            this.sitTick = 0;
            this.sitAnimationState.m_216973_();
            this.toSitAnimationState.m_216973_();
        }
        if (this.sitTick == 40) {
            this.toSitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick == 30) {
            this.toSitAnimationState.m_216973_();
            this.sitAnimationState.m_216977_(this.f_19797_);
        }
        if (this.sitTick > 5) {
            --this.sitTick;
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        if (this.canBreakBlockSize() && this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)5.0f);
            if (blockDestroy) {
                this.blockDestroyTick = 60.0;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (!this.canTameSize()) {
            return CatchEntity.catchMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.m_6071_(player, interactionHand));
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemStack) && !this.m_21824_() && !this.m_21660_();
            boolean bl3 = bl2 = this.m_21824_() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.m_21824_()) {
            if (!player.m_6144_()) {
                if (this.m_6898_(itemStack)) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(this.getSizeLike() * 4);
                        if (!player.m_150110_().f_35937_) {
                            itemStack.m_41774_(1);
                        }
                        this.m_146852_(GameEvent.f_157806_, (Entity)this);
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, interactionHand);
                }
                if (!this.hasChest() && itemStack.m_150930_(Items.f_42009_) && this.canChestSize()) {
                    this.equipChest(player, itemStack);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (!this.m_6898_(itemStack) && this.canRideSize() && this.m_6254_() && this.m_20197_().size() < this.getMaxPassengers() && !player.m_36341_() && !this.m_21827_()) {
                    if (!this.m_9236_().f_46443_) {
                        player.m_20329_((Entity)this);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.canRideSize() || this.canChestSize() || this.m_6254_() || this.hasChest()) {
                    this.m_213583_(player);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            int pose = this.getChangeType() + 1;
            if (pose > 4) {
                pose = 1;
            }
            this.setChangeType(pose, player);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_6898_(itemStack) || this.m_21660_() || !this.canTameSize()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(24 * this.getSizeLike()) == 1 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    private void equipChest(Player player, ItemStack itemStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.createInventory();
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(6);
            this.setAnimationState("attack");
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.VIRTUAL_CAVE_COCKROACH_ATTACK, 1.0f, 1.0f);
            }
            if (this.getSizeLike() > 3) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(2.0, 1.2, 2.0));
                for (LivingEntity hurt : list) {
                    VirtualCaveCockroachEntity virtualCaveCockroachEntity;
                    if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof VirtualCaveCockroachEntity && (virtualCaveCockroachEntity = (VirtualCaveCockroachEntity)hurt).m_5448_() != this) continue;
                    AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                    AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.5f, (float)0.5f, (boolean)false, (float)0.0f);
                }
                Main.sweepAttack((Entity)this);
            }
        }
        return bl;
    }

    protected int m_5639_(float f, float f2) {
        if (this.getSizeLike() > 3) {
            return super.m_5639_(f, f2) - 40;
        }
        if (this.getSizeLike() > 2) {
            return super.m_5639_(f, f2) - 30;
        }
        return super.m_5639_(f, f2) - 20;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.getSizeLike() > 2 && (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_))) {
            return true;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) && this.canFlySize()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_142535_(float f, float f2, DamageSource damageSource) {
        boolean flag = false;
        int i = this.m_5639_(f, f2);
        if (i > 0) {
            this.m_5496_(this.m_5896_(i), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(damageSource, i);
            return true;
        }
        return flag;
    }

    private SoundEvent m_5896_(int p_21313_) {
        return p_21313_ > 4 ? this.m_196493_().f_196627_() : this.m_196493_().f_196626_();
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.getSizeLike() > 3 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (this.getSizeLike() > 3 && mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_() && this.getSizeLike() > 2;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChest(false);
        }
    }

    private SlotAccess createEquipmentSlotAccess(final int p_149503_, final Predicate<ItemStack> p_149504_) {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return VirtualCaveCockroachEntity.this.inventory.m_8020_(p_149503_);
            }

            public boolean m_142104_(ItemStack p_149528_) {
                if (!p_149504_.test(p_149528_)) {
                    return false;
                }
                VirtualCaveCockroachEntity.this.inventory.m_6836_(p_149503_, p_149528_);
                VirtualCaveCockroachEntity.this.updateContainerEquipment();
                return true;
            }
        };
    }

    public SlotAccess m_141942_(int p_149479_) {
        return p_149479_ == 499 ? new SlotAccess(){

            public ItemStack m_142196_() {
                return VirtualCaveCockroachEntity.this.hasChest() ? new ItemStack((ItemLike)Items.f_42009_) : ItemStack.f_41583_;
            }

            public boolean m_142104_(ItemStack p_149485_) {
                if (p_149485_.m_41619_()) {
                    if (VirtualCaveCockroachEntity.this.hasChest()) {
                        VirtualCaveCockroachEntity.this.setChest(false);
                        VirtualCaveCockroachEntity.this.createInventory();
                    }
                    return true;
                }
                if (p_149485_.m_150930_(Items.f_42009_)) {
                    if (!VirtualCaveCockroachEntity.this.hasChest()) {
                        VirtualCaveCockroachEntity.this.setChest(true);
                        VirtualCaveCockroachEntity.this.createInventory();
                    }
                    return true;
                }
                return false;
            }
        } : this.getSlots(p_149479_);
    }

    public SlotAccess getSlots(int p_149514_) {
        int j;
        int i = p_149514_ - this.getAddNumber();
        if (i >= 0 && i < 2 && i < this.inventory.m_6643_()) {
            if (i == 0) {
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || p_149516_.m_150930_(Items.f_42450_));
            }
            if (i == 1) {
                if (!this.canWearArmor()) {
                    return SlotAccess.f_147290_;
                }
                return this.createEquipmentSlotAccess(i, p_149516_ -> p_149516_.m_41619_() || this.isArmor((ItemStack)p_149516_));
            }
        }
        return (j = p_149514_ - 500 + 2) >= 2 && j < this.inventory.m_6643_() ? SlotAccess.m_147292_((Container)this.inventory, (int)j) : super.m_141942_(p_149514_);
    }

    public boolean hasInventoryChanged(Container p_149512_) {
        return this.inventory != p_149512_;
    }

    public boolean m_6254_() {
        return this.getFlag(4);
    }

    public boolean canWearArmor() {
        return false;
    }

    public void m_5853_(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public void m_213583_(Player player) {
        if (!this.m_9236_().f_46443_ && (!this.m_20160_() || this.m_20363_((Entity)player)) && this.m_21824_()) {
            if (player.f_36096_ != player.f_36095_) {
                player.m_6915_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openSuchInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this);
            }
        }
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(livingEntity);
        }
        int[][] arrn = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockPos = this.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Pose pose : livingEntity.m_7431_()) {
            AABB aABB = livingEntity.m_21270_(pose);
            for (int[] arrn2 : arrn) {
                mutableBlockPos.m_122178_(blockPos.m_123341_() + arrn2[0], blockPos.m_123342_(), blockPos.m_123343_() + arrn2[1]);
                double d = this.m_9236_().m_45573_((BlockPos)mutableBlockPos);
                if (!DismountHelper.m_38439_((double)d)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)mutableBlockPos, (double)d);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)livingEntity, (AABB)aABB.m_82383_(vec3))) continue;
                livingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(livingEntity);
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_19915_(player.m_146908_(), player.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player player) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION && mobSpawnType != MobSpawnType.BREEDING) {
            this.setSize(randomSource.m_216339_(4, 6), true);
            this.setColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)0, (int)0xFFFFFF));
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ == 5) {
            for (int i = 0; i < this.getSize() * 5; ++i) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                double d3 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123810_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, d2, d3);
            }
        }
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }
}

