/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.jerotes.jerotes.entity.BasePartLivingEntity;
import com.jerotes.jerotes.entity.CanBeSerponFactionEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesLeapAtTargetAndLookGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.entity.Animal.RoyalWarPythonEntity;
import com.jerotes.jerotesvillage.goal.FollowSerponCombatExecuterGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class WarPythonEntity
extends Animal
implements NeutralMob,
JerotesEntity,
FireAbsorptionEntity,
CanBeSerponFactionEntity {
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(WarPythonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public WarPythonEntity(EntityType<? extends WarPythonEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.1f);
        this.m_20242_(true);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        if (this.isNotSerpon()) {
            return false;
        }
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionSerponCombatTeam(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        if (this.isNotSerpon()) {
            return "";
        }
        return "serpon_combat_team";
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new JerotesLeapAtTargetAndLookGoal((Mob)this, 0.5f));
        this.f_21345_.m_25352_(2, (Goal)new FollowSerponCombatExecuterGoal((Mob)this, 1.1f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{WarPythonEntity.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, (LivingEntity)livingEntity)));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((WarPythonEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22280_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 45.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_(Attributes.f_22278_, 0.3);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.WAR_PYTHON_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.WAR_PYTHON_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.WAR_PYTHON_DEATH;
    }

    public void m_21229_() {
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean isNotSerpon() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_42613_);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)JerotesVillageEntityType.WAR_PYTHON.get()).m_20615_((Level)serverLevel);
    }

    public double FireAbsorptionPercentage() {
        return 20.0;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20095_();
        this.m_20242_(true);
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public void m_8119_() {
        Entity child;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (child = this.getChild()) == null) {
            WarPythonEntity partParent = this;
            int segments = 16;
            for (int i = 0; i < 16; ++i) {
                BasePartLivingEntity part = !(this instanceof RoyalWarPythonEntity) ? new BasePartLivingEntity((EntityType)JerotesVillageEntityType.WAR_PYTHON_PART.get(), (LivingEntity)partParent, 0.4f, 180.0f, 0.0f) : new BasePartLivingEntity((EntityType)JerotesVillageEntityType.ROYAL_WAR_PYTHON_PART.get(), (LivingEntity)partParent, 0.48f, 180.0f, 0.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    PlayerTeam teams = (PlayerTeam)this.m_5647_();
                    if (teams != null) {
                        serverLevel.m_6188_().m_6546_(part.m_20149_(), teams);
                    }
                }
                part.setParent((Entity)partParent);
                part.setBodyIndex(i);
                if (partParent == this) {
                    this.setChildId(part.m_20148_());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                this.m_9236_().m_7967_((Entity)part);
            }
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CHILD_UUID, Optional.empty());
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        if (bl && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.WAR_PYTHON_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    protected void m_7324_(Entity entity) {
        if (!(entity instanceof BasePartLivingEntity)) {
            super.m_7324_(entity);
        }
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }
}

