/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Animal;

import com.google.common.collect.ImmutableList;
import com.jerotes.jerotes.entity.ChangePoseAbout;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.TameMobEntity;
import com.jerotes.jerotes.goal.JerotesChangeFollowOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeSitWhenOrderedToGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.entity.Animal.WonderlandGiantFrogEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.entity.in.HasHomePosEntity;
import com.jerotes.jerotesvillage.goal.BaseTamableAnimalGoHomeGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class WonderlandGiantFrogTadpoleEntity
extends AbstractFish
implements JerotesEntity,
TameMobEntity,
OwnableEntity,
ChangePoseAbout,
HasHomePosEntity {
    private static final EntityDataAccessor<Integer> FROG_TYPE = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_WANDER = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(WonderlandGiantFrogTadpoleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super WonderlandGiantFrogTadpoleEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)SensorType.f_217822_);
    @VisibleForTesting
    public static int ticksToBeFrog = Math.abs(-24000);
    public static float HITBOX_WIDTH = 1.0f;
    public static float HITBOX_HEIGHT = 0.8f;
    private int age;
    private boolean orderedToSit;

    public WonderlandGiantFrogTadpoleEntity(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
        this.reassessTameGoals();
        this.m_21530_();
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public static AttributeSupplier.Builder m_27495_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.8);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 20.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new JerotesChangeSitWhenOrderedToGoal((ChangePoseAbout)this));
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, GemstoneMalignasaurEntity.class, 32.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(3, (Goal)new BaseTamableAnimalGoHomeGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new JerotesChangeFollowOwnerGoal((ChangePoseAbout)this, 1.3, 5.0f, 1.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_215761_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_215758_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_215759_;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected void reassessTameGoals() {
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity == this.m_269323_();
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOwnerUUID(@javax.annotation.Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(uuid));
    }

    @javax.annotation.Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID)).orElse(null);
    }

    public void setTame(boolean bl) {
        byte bl1 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 | 4)));
            this.m_21051_(Attributes.f_22281_).m_22100_(7.0);
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 & 0xFFFFFFFB)));
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        this.reassessTameGoals();
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public void setOrderedToSit(boolean bl) {
        this.orderedToSit = bl;
    }

    public void setInSittingPose(boolean bl) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    public void setHomePos(BlockPos blockPos) {
        this.f_19804_.m_135381_(HOME_POS, (Object)blockPos);
    }

    @Override
    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    @Override
    public boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    @Override
    public void setGoingHome(boolean bl) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)bl);
    }

    public boolean isWander() {
        return (Boolean)this.m_20088_().m_135370_(IS_WANDER);
    }

    public void setWander(boolean bl) {
        this.m_20088_().m_135381_(IS_WANDER, (Object)bl);
    }

    @javax.annotation.Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : WonderlandGiantFrogTadpoleEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return WonderlandGiantFrogTadpoleEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public int getFrogType() {
        return (Integer)this.f_19804_.m_135370_(FROG_TYPE);
    }

    public void setFrogType(int id) {
        this.f_19804_.m_135381_(FROG_TYPE, (Object)id);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("FrogType", this.getFrogType());
        compoundTag.m_128379_("IsWander", this.isWander());
        compoundTag.m_128379_("IsGoingHome", this.isGoingHome());
        compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
        compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
        compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        compoundTag.m_128405_("Age", this.age);
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
        compoundTag.m_128379_("Sitting", this.orderedToSit);
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        this.setFrogType(compoundTag.m_128451_("FrogType"));
        this.setWander(compoundTag.m_128471_("IsWander"));
        this.setGoingHome(compoundTag.m_128471_("IsGoingHome"));
        int n = compoundTag.m_128451_("HomePosX");
        int n2 = compoundTag.m_128451_("HomePosY");
        int n3 = compoundTag.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(n, n2, n3));
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compoundTag.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.setAge(compoundTag.m_128451_("Age"));
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getChangeType() != 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FROG_TYPE, (Object)1);
        this.m_20088_().m_135372_(IS_WANDER, (Object)false);
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(GOING_HOME, (Object)false);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (this.isWander() && this.isInSittingPose() && !this.m_9236_().f_46443_) {
            this.setInSittingPose(false);
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (!this.m_9236_().f_46443_) {
            this.setAge(this.age + 1);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().f_46443_) {
            this.setAge(this.age + 1);
        }
    }

    public InteractionResult superMobInteract(Player p_218703_, InteractionHand p_218704_) {
        ItemStack itemstack = p_218703_.m_21120_(p_218704_);
        if (this.isFood(itemstack)) {
            this.feed(p_218703_, itemstack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return Bucketable.m_148828_((Player)p_218703_, (InteractionHand)p_218704_, (LivingEntity)this).orElse(super.m_6071_(p_218703_, p_218704_));
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl2;
            boolean bl = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isFood(itemStack) && !this.isTame();
            boolean bl3 = bl2 = this.isTame() && !player.m_6144_() && this.m_6162_();
            if (!bl2) {
                return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        if (this.isTame()) {
            if (!player.m_6144_() && this.isFood(itemStack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(5.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    this.m_146852_(GameEvent.f_157806_, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                this.feed(player, itemStack);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            InteractionResult interactionResult = this.superMobInteract(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.isOwnedBy((LivingEntity)player)) {
                return interactionResult;
            }
            if (!this.m_20160_()) {
                int pose = this.getChangeType() + 1;
                if (pose > 4) {
                    pose = 1;
                }
                this.setChangeType(pose, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isFood(itemStack)) {
            return this.superMobInteract(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(4) == 1) {
            this.tame(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setChangeType(1, player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    public int getChangeType() {
        return (this.isOrderedToSit() ? 1 : 2) + (this.isWander() ? 2 : 0);
    }

    public void setChangeType(int n) {
        n = Mth.m_14045_((int)n, (int)1, (int)4);
        switch (n) {
            case 1: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 2: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 3: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                    this.setHomePos(this.m_20183_());
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 4: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        }
    }

    public void setChangeType(int n, Player player) {
        this.setChangeType(n);
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)("talk.jerotes.pose_" + n), (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
        }
    }

    protected void spawnTamingParticles(boolean bl) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!bl) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void spawnHealParticles() {
        SimpleParticleType particleoptions = ParticleTypes.f_123748_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public boolean m_27487_() {
        return true;
    }

    public void m_27497_(boolean bl) {
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundTag = itemStack.m_41784_();
        this.m_7380_(compoundTag);
        itemStack.m_41739_(compoundTag);
    }

    public void m_142278_(CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        this.m_7378_(compoundTag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_GIANT_FROG_TADPOLE_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_215674_;
    }

    private boolean isFood(ItemStack itemStack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)JerotesVillageItems.PINK_SLIME_BALL.get()}).test(itemStack);
    }

    private void feed(Player player, ItemStack itemStack) {
        this.usePlayerItem(player, itemStack);
        this.ageUp(AgeableMob.m_216967_((int)this.getTicksLeftUntilAdult()));
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
    }

    private void usePlayerItem(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
    }

    private int getAge() {
        return this.age;
    }

    private void ageUp(int n) {
        this.setAge(this.age + n * 20);
    }

    private void setAge(int n) {
        this.age = n;
        if (this.age >= ticksToBeFrog) {
            this.ageUp();
        }
    }

    private void ageUp() {
        Level object = this.m_9236_();
        if (object instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            object = ((EntityType)JerotesVillageEntityType.WONDERLAND_GIANT_FROG.get()).m_20615_(this.m_9236_());
            if (object != null) {
                ((Entity)object).m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
                ((WonderlandGiantFrogEntity)object).m_6518_((ServerLevelAccessor)serverLevel, this.m_9236_().m_6436_(((Entity)object).m_20183_()), MobSpawnType.CONVERSION, null, null);
                ((Mob)object).m_21557_(this.m_21525_());
                if (this.m_8077_()) {
                    ((Entity)object).m_6593_(this.m_7770_());
                    ((Entity)object).m_20340_(this.m_20151_());
                }
                ((Mob)object).m_21530_();
                if (this.isTame()) {
                    ((WonderlandGiantFrogEntity)object).m_21816_(this.m_21805_());
                    ((WonderlandGiantFrogEntity)object).m_7105_(true);
                    LivingEntity livingEntity = this.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        ((WonderlandGiantFrogEntity)object).m_21828_(player);
                    }
                    ((WonderlandGiantFrogEntity)object).m_21839_(true);
                }
                ((WonderlandGiantFrogEntity)object).setFrogType(this.getFrogType());
                this.m_5496_(SoundEvents.f_215760_, 0.15f, 1.0f);
                serverLevel.m_47205_((Entity)object);
                this.m_146870_();
            }
        }
    }

    private int getTicksLeftUntilAdult() {
        return Math.max(0, ticksToBeFrog - this.age);
    }

    public boolean m_6149_() {
        return false;
    }

    public void m_7822_(byte by) {
        if (by == 7) {
            this.spawnTamingParticles(true);
        } else if (by == 6) {
            this.spawnTamingParticles(false);
        } else if (by == 11) {
            this.spawnHealParticles();
        } else {
            super.m_7822_(by);
        }
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            LivingEntity livingentity = this.m_269323_();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.isOwnedBy(livingEntity) && super.m_6779_(livingEntity);
    }

    public boolean wantsToAttack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return AttackFind.wantsToAttack((Mob)this, (LivingEntity)livingEntity, (LivingEntity)livingEntity2);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl && !this.m_9236_().m_5776_() && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag compoundTag) {
        this.setHomePos(this.m_20183_());
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6667_(DamageSource damageSource) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(damageSource);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }
}

