/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss.Biome;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.ShockEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GemstoneMalignasaurMoveControl;
import com.jerotes.jerotesvillage.entity.Animal.MalialosaurEntity;
import com.jerotes.jerotesvillage.entity.Animal.MalignasaurEntity;
import com.jerotes.jerotesvillage.entity.Part.MalignasaurPart;
import com.jerotes.jerotesvillage.entity.Shoot.Magic.Breath.OceanCurrentBreathEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Magic.MagicShoot.WhirlpoolEntity;
import com.jerotes.jerotesvillage.entity.in.ToughEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.goal.GemstoneMalignasaurTargetGoal;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import com.jerotes.jerotesvillage.util.ParticlesUse;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GemstoneMalignasaurEntity
extends MalignasaurEntity
implements ToughEntity,
ShockEntity,
SpellUseEntity,
BossEntity {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("cb367b0d-1028-4334-b48c-fc8c63a5d579");
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("64626148-1221-40de-b867-b91b01b88497");
    private static final UUID HUNGER_ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("1efac5b3-4016-4253-ba7b-4d8fe849b2b9");
    private static final UUID HUNGER_MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("82ad05ea-fb97-4db1-b3d3-1e4a19655f2c");
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.BLUE, false);
    private static final EntityDataAccessor<Integer> TOUGH_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> TOUGH_DAMAGE = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_TOUGH = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GEMSTONE_ARMOR = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HUNGER_OF = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_USE_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ARMOR_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CONTROL_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CONTROL_USE_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGRY_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANGRY_USE_TICK = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WATER_ANIM = SynchedEntityData.m_135353_(GemstoneMalignasaurEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> HUNT = livingEntity -> !(livingEntity instanceof MalignasaurEntity) && !(livingEntity instanceof MalialosaurEntity) && !(livingEntity instanceof Player) && (livingEntity.m_20070_() || livingEntity.m_20070_() || livingEntity.m_20072_());
    public int spellLevel = OtherMainConfig.GemstoneMalignasaurSpellNormalLevel;
    public int start = -101;
    private float health1 = 1.0f;
    public boolean isRainNavigatorType = false;
    @Nullable
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;

    public GemstoneMalignasaurEntity(EntityType<? extends GemstoneMalignasaurEntity> entityType, Level level) {
        super((EntityType<? extends MalignasaurEntity>)entityType, level);
        this.m_274367_(5.1f);
        this.f_21364_ = 400;
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.GemstoneMalignasaurMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.GemstoneMalignasaurMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.GemstoneMalignasaurArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.GemstoneMalignasaurMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.GemstoneMalignasaurAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.GemstoneMalignasaurKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.GemstoneMalignasaurMagicAttackPercentage;
        }
        return (float)OtherMainConfig.GemstoneMalignasaurAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.GemstoneMalignasaurDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.GemstoneMalignasaurDamageCooldownTick * base;
    }

    public int m_213860_() {
        return 400;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.start > 0) {
            this.bossEvent.m_142711_(this.health1 / this.m_21233_());
            this.health1 += (this.m_21223_() - this.health1) / 60.0f;
        } else {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 348.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.25);
        builder = builder.m_22268_(Attributes.f_22281_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22279_, 1.3);
        builder = builder.m_22268_(Attributes.f_22282_, 2.8);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            @Override
            public boolean m_8036_() {
                if (GemstoneMalignasaurEntity.this.start > 0) {
                    return false;
                }
                if (GemstoneMalignasaurEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, new GemstoneMalignasaurTargetGoal<Mob>((Mob)this, Mob.class, true, HUNT));
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.GEMSTONE_MALIGNASAUR_AMBIENT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.GEMSTONE_MALIGNASAUR_DEATH;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.GEMSTONE_MALIGNASAUR_HURT;
    }

    @Override
    protected SoundEvent m_5501_() {
        return JerotesVillageSounds.GEMSTONE_MALIGNASAUR_SWIM;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    @Override
    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.GEMSTONE_MALIGNASAUR_WALK, 0.15f, 1.0f);
    }

    public int m_6062_() {
        return 24000;
    }

    @Override
    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean m_6094_() {
        return false;
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        this.m_183634_();
    }

    @Override
    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public boolean m_6060_() {
        if (this.isTough()) {
            return false;
        }
        return super.m_6060_();
    }

    @Override
    @Nullable
    public GemstoneMalignasaurEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (GemstoneMalignasaurEntity)((EntityType)JerotesVillageEntityType.GEMSTONE_MALIGNASAUR.get()).m_20615_((Level)serverLevel);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        float height = 1.8f;
        if (this.m_6162_()) {
            return height / 2.0f;
        }
        return height;
    }

    @Override
    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("jerotes", "aa_creative_claw")));
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_20285_() {
        BlockPos blockpos = this.m_20183_();
        return this.m_9236_().m_46758_(blockpos) || this.m_9236_().m_46758_(BlockPos.m_274561_((double)blockpos.m_123341_(), (double)this.m_20191_().f_82292_, (double)blockpos.m_123343_()));
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20077_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.3, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
        if (this.m_21515_() && this.m_20285_() && !this.m_20069_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.7));
        }
    }

    public boolean useShock() {
        return this.getHungerOf() < -3000;
    }

    protected void m_7324_(Entity entity) {
        block4: {
            block5: {
                LivingEntity livingEntity;
                if (this.m_20096_() || this.m_21525_() || this.m_5912_() || !(entity instanceof LivingEntity) || !this.m_6779_(livingEntity = (LivingEntity)entity) || !this.m_6549_(livingEntity.m_6095_()) || this.m_7307_((Entity)livingEntity) || entity instanceof MalignasaurEntity) break block4;
                if (!(entity instanceof ServerPlayer)) break block5;
                ServerPlayer player = (ServerPlayer)entity;
                if (player.f_8941_.m_9290_() == GameType.CREATIVE || player.f_8941_.m_9290_() == GameType.SPECTATOR) break block4;
            }
            if (!entity.m_5833_()) {
                this.m_6710_((LivingEntity)entity);
            }
        }
        super.m_7324_(entity);
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.GEMSTONE_MALIGNASAUR_MUSIC;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setShootUseTick(int n) {
        this.m_20088_().m_135381_(SHOOT_USE_TICK, (Object)n);
    }

    public int getShootUseTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_USE_TICK);
    }

    public void setArmorTick(int n) {
        this.m_20088_().m_135381_(ARMOR_TICK, (Object)n);
    }

    public int getArmorTick() {
        return (Integer)this.m_20088_().m_135370_(ARMOR_TICK);
    }

    public void setControlTick(int n) {
        this.m_20088_().m_135381_(CONTROL_TICK, (Object)n);
    }

    public int getControlTick() {
        return (Integer)this.m_20088_().m_135370_(CONTROL_TICK);
    }

    public void setControlUseTick(int n) {
        this.m_20088_().m_135381_(CONTROL_USE_TICK, (Object)n);
    }

    public int getControlUseTick() {
        return (Integer)this.m_20088_().m_135370_(CONTROL_USE_TICK);
    }

    public void setAngryTick(int n) {
        this.m_20088_().m_135381_(ANGRY_TICK, (Object)n);
    }

    public int getAngryTick() {
        return (Integer)this.m_20088_().m_135370_(ANGRY_TICK);
    }

    public void setAngryUseTick(int n) {
        this.m_20088_().m_135381_(ANGRY_USE_TICK, (Object)n);
    }

    public int getAngryUseTick() {
        return (Integer)this.m_20088_().m_135370_(ANGRY_USE_TICK);
    }

    public void setHungerOf(int n) {
        this.m_20088_().m_135381_(HUNGER_OF, (Object)n);
    }

    public int getHungerOf() {
        return (Integer)this.m_20088_().m_135370_(HUNGER_OF);
    }

    @Override
    public boolean specialAction() {
        return this.getJumpUseTick() > 0 || this.getAngryUseTick() > 0 || this.getControlUseTick() > 0 || this.getArmorTick() > 0 || this.getShootUseTick() > 0;
    }

    public boolean isArmor() {
        return (Boolean)this.m_20088_().m_135370_(GEMSTONE_ARMOR);
    }

    public void setArmor(boolean bl) {
        this.m_20088_().m_135381_(GEMSTONE_ARMOR, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            double d = OtherMainConfig.GemstoneMalignasaurArmorGemstoneArmor - OtherMainConfig.GemstoneMalignasaurArmor;
            double d2 = OtherMainConfig.GemstoneMalignasaurMovementSpeedGemstoneArmor - OtherMainConfig.GemstoneMalignasaurMovementSpeed;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Armor armor", d, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Armor movement speed", d2, AttributeModifier.Operation.ADDITION));
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setToughDamage(float f) {
        this.m_20088_().m_135381_(TOUGH_DAMAGE, (Object)Float.valueOf(f));
    }

    public float getToughDamage() {
        return ((Float)this.m_20088_().m_135370_(TOUGH_DAMAGE)).floatValue();
    }

    @Override
    public int getWaterAnim() {
        return (Integer)this.m_20088_().m_135370_(WATER_ANIM);
    }

    @Override
    public void setWaterAnim(int n) {
        this.m_20088_().m_135381_(WATER_ANIM, (Object)n);
    }

    @Override
    public boolean isTough() {
        return (Boolean)this.m_20088_().m_135370_(IS_TOUGH) != false && this.m_6084_();
    }

    public void setTough(boolean bl) {
        this.m_20088_().m_135381_(IS_TOUGH, (Object)bl);
    }

    public void setToughTick(int n) {
        this.m_20088_().m_135381_(TOUGH_TICK, (Object)n);
    }

    public int getToughTick() {
        return (Integer)this.m_20088_().m_135370_(TOUGH_TICK);
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128379_("Tough", this.isTough());
        compoundTag.m_128405_("ToughTick", this.getToughTick());
        compoundTag.m_128379_("IsArmor", this.isArmor());
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("ShootUseTick", this.getShootUseTick());
        compoundTag.m_128405_("HungerOf", this.getHungerOf());
        compoundTag.m_128405_("ArmorTick", this.getArmorTick());
        compoundTag.m_128405_("ControlTick", this.getControlTick());
        compoundTag.m_128405_("AngryTick", this.getAngryTick());
        compoundTag.m_128405_("ControlUseTick", this.getControlUseTick());
        compoundTag.m_128405_("AngryUseTick", this.getAngryUseTick());
        compoundTag.m_128405_("Start", this.start);
        compoundTag.m_128350_("Health1", this.health1);
        compoundTag.m_128350_("ToughDamage", this.getToughDamage());
        compoundTag.m_128405_("WaterAnim", this.getWaterAnim());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setTough(compoundTag.m_128471_("Tough"));
        this.setToughTick(compoundTag.m_128451_("ToughTick"));
        if (compoundTag.m_128441_("IsArmor")) {
            this.setArmor(compoundTag.m_128471_("IsArmor"));
        }
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setShootUseTick(compoundTag.m_128451_("ShootUseTick"));
        this.setHungerOf(compoundTag.m_128451_("HungerOf"));
        this.setArmorTick(compoundTag.m_128451_("ArmorTick"));
        this.setControlTick(compoundTag.m_128451_("ControlTick"));
        this.setAngryTick(compoundTag.m_128451_("AngryTick"));
        this.setControlUseTick(compoundTag.m_128451_("ControlUseTick"));
        this.setAngryUseTick(compoundTag.m_128451_("AngryUseTick"));
        this.start = compoundTag.m_128451_("Start");
        this.health1 = compoundTag.m_128457_("Health1");
        this.setToughDamage(compoundTag.m_128457_("ToughDamage"));
        this.setWaterAnim(compoundTag.m_128451_("WaterAnim"));
        this.m_147285_(this.m_9236_(), compoundTag);
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(GEMSTONE_ARMOR, (Object)false);
        this.m_20088_().m_135372_(HUNGER_OF, (Object)240);
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(ARMOR_TICK, (Object)-10);
        this.m_20088_().m_135372_(CONTROL_TICK, (Object)0);
        this.m_20088_().m_135372_(ANGRY_TICK, (Object)0);
        this.m_20088_().m_135372_(CONTROL_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(ANGRY_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(TOUGH_DAMAGE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(IS_TOUGH, (Object)false);
        this.m_20088_().m_135372_(TOUGH_TICK, (Object)0);
        this.m_20088_().m_135372_(WATER_ANIM, (Object)0);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick(Math.max(0, this.getToughTick() - 1));
        }
        if (this.getToughTick() > 0) {
            if (!this.isTough() && !this.m_9236_().m_5776_()) {
                this.setTough(true);
            }
        } else if (this.isTough() && !this.m_9236_().m_5776_()) {
            this.setTough(false);
        }
        if (this.isTough() && this.m_20094_() > 0) {
            this.m_20095_();
        }
    }

    @Override
    public void m_8107_() {
        boolean health;
        super.m_8107_();
        this.bossEvent.update();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_20285_() && !this.m_20069_() && !this.isRainNavigatorType) {
            this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
            this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_());
            this.isRainNavigatorType = true;
        }
        if ((!this.m_20285_() || this.m_20069_()) && this.isRainNavigatorType) {
            this.f_21342_ = new GemstoneMalignasaurMoveControl((Mob)this, 85, 85, 0.02f, 0.15f, false);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isRainNavigatorType = false;
        }
        if (this.m_20285_() && !this.m_20069_()) {
            Vec3 vec3 = this.m_20184_();
            if (this.m_5448_() != null && this.m_5448_().m_20188_() > this.m_20188_() + 1.0) {
                this.m_6853_(false);
                this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
                this.f_19812_ = true;
            }
            if (this.m_5448_() != null && this.m_5448_().m_20188_() + 6.0 < this.m_20188_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
                this.f_19812_ = true;
            }
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -(0.1 - vec3.f_82480_) * 0.1, 0.0));
                this.f_19812_ = true;
            }
            for (int i = 0; i < 3; ++i) {
                if (this.m_9236_().f_46443_) {
                    this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH.get(), this.m_20208_(0.8), this.m_20186_(), this.m_20262_(0.8), 0.0, (double)-0.1f, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH_FOG.get(), this.m_20208_(0.8), this.m_20186_(), this.m_20262_(0.8), 0.0, (double)-0.1f, 0.0);
                }
                if (this.head1 != null) {
                    this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH.get(), this.head1.m_20208_(0.8), this.head1.m_20186_(), this.head1.m_20262_(0.8), 0.0, (double)-0.1f, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH_FOG.get(), this.head1.m_20208_(0.8), this.head1.m_20186_(), this.head1.m_20262_(0.8), 0.0, (double)-0.1f, 0.0);
                }
                if (this.tail1 == null) continue;
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH.get(), this.tail1.m_20208_(1.5), this.tail1.m_20186_(), this.tail1.m_20262_(1.5), 0.0, (double)-0.1f, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.OCEAN_CURRENT_BREATH_FOG.get(), this.tail1.m_20208_(1.5), this.tail1.m_20186_(), this.tail1.m_20262_(1.5), 0.0, (double)-0.1f, 0.0);
            }
        }
        if ((this.m_20070_() || this.m_20072_()) && this.m_217043_().m_188503_(240) == 1 && this.m_6084_()) {
            this.m_5634_(3.0f);
        }
        if (this.m_217043_().m_188503_(60) == 1 && this.m_6084_()) {
            this.m_5634_(3.0f);
        }
        if (this.start > 0) {
            --this.start;
        } else if (this.start == 0) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.GEMSTONE_MALIGNASAUR_AMBIENT, 10.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 660, 1));
            }
            this.start = -1;
        } else if (this.start > -100) {
            --this.start;
        }
        if (this.start <= -100) {
            this.start = -101;
        }
        if (!(this.getHungerOf() <= 0 && this.getHungerOf() <= -20000 || this.m_9236_().m_5776_())) {
            this.setHungerOf(this.getHungerOf() - 1);
        }
        if (this.f_19797_ % 120 == 0) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(HUNGER_ATTACK_DAMAGE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(HUNGER_MOVEMENT_SPEED_MODIFIER_UUID);
            if (this.getHungerOf() < 0) {
                double d2;
                double d;
                if (this.m_6084_() && !this.m_21525_() && this.f_19797_ % 120 == 0) {
                    this.addAback();
                }
                if (this.getHungerOf() < -10000) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 80, 4), (Entity)this);
                    }
                    d = this.m_21172_(Attributes.f_22281_) * 1.25;
                    d2 = this.m_21172_(Attributes.f_22279_) / 2.0;
                } else if (this.getHungerOf() < -6000) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 80, 3), (Entity)this);
                    }
                    d = this.m_21172_(Attributes.f_22281_);
                    d2 = this.m_21172_(Attributes.f_22279_) / 3.0;
                } else if (this.getHungerOf() < -3000) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 80, 2), (Entity)this);
                    }
                    d = this.m_21172_(Attributes.f_22281_) / 3.0;
                    d2 = this.m_21172_(Attributes.f_22279_) / 4.0;
                } else if (this.getHungerOf() < -1000) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 80, 1), (Entity)this);
                    }
                    d = this.m_21172_(Attributes.f_22281_) / 6.0;
                    d2 = this.m_21172_(Attributes.f_22279_) / 5.0;
                } else {
                    if (!this.m_9236_().f_46443_) {
                        this.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 80, 0), (Entity)this);
                    }
                    d = this.m_21172_(Attributes.f_22281_) / 10.0;
                    d2 = this.m_21172_(Attributes.f_22279_) / 6.0;
                }
                Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(HUNGER_ATTACK_DAMAGE_MODIFIER_UUID, "Armor armor", d, AttributeModifier.Operation.ADDITION));
                Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(HUNGER_MOVEMENT_SPEED_MODIFIER_UUID, "Armor movement speed", d2, AttributeModifier.Operation.ADDITION));
            }
        }
        if (this.m_20070_() && this.m_6084_()) {
            for (int i = 0; i < 5; ++i) {
                if (!this.m_9236_().m_5776_()) continue;
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.GEMSTONE_BUBBLE.get(), this.m_20208_(0.8), this.m_20187_(), this.m_20262_(0.8), 0.0, 0.0, 0.0);
            }
        }
        boolean bl = health = this.m_21223_() < this.m_21233_() / 2.0f;
        if (health && this.getArmorTick() <= 0 && !this.isArmor() && this.m_6084_()) {
            Level d2;
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_ARMOR, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            if (!this.m_9236_().m_46471_() && !this.m_9236_().m_46470_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46150_)) {
                this.m_9236_().m_6106_().m_5565_(true);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setArmor(true);
                this.setArmorTick(20);
                this.setAnimTick(20);
                this.setAnimationState("armor");
            }
            if ((d2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)d2;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.GEMSTONE_SCALE_ARMOR_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!health && this.getArmorTick() <= 0 && this.isArmor() && this.m_6084_() && this.m_5448_() == null && !this.m_9236_().m_5776_()) {
            this.setArmor(false);
        }
        if (this.getArmorTick() > 0 && this.m_6084_()) {
            ParticlesUse.WaterSpiral((LivingEntity)this);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setArmorTick(Math.max(0, this.getArmorTick() - 1));
        }
        if (this.f_19797_ % 60 == 0 && this.m_6084_()) {
            List lists = this.m_9236_().m_45976_(Boat.class, this.m_20191_().m_82377_(15.0, 15.0, 15.0));
            for (Boat boat : lists) {
                if (this.m_7307_((Entity)boat) || (double)this.m_20270_((Entity)boat) > 16.0) continue;
                this.m_19998_((ItemLike)boat.m_38369_());
                boat.m_146870_();
            }
        }
        int spellLevel = this.getSpellLevel() - 1;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            spellLevel = this.getSpellLevel();
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            spellLevel = this.getSpellLevel() + 1;
        }
        if (this.getShootTick() >= (int)(OtherMainConfig.GemstoneMalignasaurBreathCooldown * 20.0) && this.spellNeed(0.0f, 24.0f, 1, true)) {
            if (this.m_9236_().m_213780_().m_188501_() > 0.5f) {
                if (!this.m_9236_().m_5776_()) {
                    this.setShootTick(0);
                    this.setShootUseTick(20);
                    this.setAnimTick(15);
                    this.setSpellTick(30);
                    this.setAnimationState("breath");
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setShootTick(0);
                this.setShootUseTick(20);
                this.setAnimTick(20);
                this.setSpellTick(30);
                this.setAnimationState("whirlpool");
            }
        }
        if (this.getShootUseTick() == 10 && this.m_6084_()) {
            GemstoneMalignasaurEntity livingEntity = this;
            if (this.m_5448_() != null) {
                livingEntity = this.m_5448_();
            }
            if (((Integer)this.m_20088_().m_135370_(ANIM_STATE)).intValue() == this.getAnimationState("breath")) {
                OtherSpellList.OceanCurrentBreath(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
            } else {
                OtherSpellList.Whirlpool(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
            }
        }
        if (this.getControlTick() >= (int)(OtherMainConfig.GemstoneMalignasaurControlCooldown * 20.0) && this.spellNeed(0.0f, 48.0f, 1, false)) {
            if (!this.m_9236_().m_5776_()) {
                this.setControlTick(0);
                this.setControlUseTick(18);
                this.setAnimTick(20);
                this.setSpellTick(25);
                this.setAnimationState("control");
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_CONTROL, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (this.getControlUseTick() == 10 && this.m_6084_()) {
            OtherSpellList.AsphyxiaControl(spellLevel, (LivingEntity)this, (Entity)this).spellUse();
        }
        if (this.getAngryTick() >= (int)(OtherMainConfig.GemstoneMalignasaurAngrySpellCooldown * 20.0) && this.spellNeed(0.0f, 24.0f, 1, true)) {
            if (this.m_9236_().m_213780_().m_188501_() > 0.5f) {
                Level level;
                if (!this.m_9236_().m_5776_()) {
                    this.setAngryTick(0);
                    this.setAngryUseTick(20);
                    this.setAnimTick(40);
                    this.setSpellTick(50);
                    this.setAnimationState("deter");
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.head1 != null) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.OCEAN_DRAGON_DETERRENCE.get()), this.head1.m_20208_(0.2), this.head1.m_20187_() + 3.0, this.head1.m_20262_(0.2), 4, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_DETER, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setAngryTick(0);
                this.setAngryUseTick(20);
                this.setAnimTick(20);
                this.setSpellTick(25);
                this.setAnimationState("bomb");
            }
        }
        if (this.getAngryUseTick() == 15 && this.m_6084_()) {
            if (((Integer)this.m_20088_().m_135370_(ANIM_STATE)).intValue() == this.getAnimationState("bomb")) {
                OtherSpellList.MalignasaurBomb(spellLevel, (LivingEntity)this, (Entity)this).spellUse();
            } else {
                OtherSpellList.OceanDragonDeterrence(spellLevel, (LivingEntity)this, (Entity)this).spellUse();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
            this.setShootTick(Math.min((int)(OtherMainConfig.GemstoneMalignasaurBreathCooldown * 20.0), this.getShootTick() + 1));
            this.setShootUseTick(Math.max(0, this.getShootUseTick() - 1));
            this.setControlTick(Math.min((int)(OtherMainConfig.GemstoneMalignasaurControlCooldown * 20.0), this.getControlTick() + 1));
            this.setControlUseTick(Math.max(0, this.getControlUseTick() - 1));
            this.setAngryTick(Math.min((int)(OtherMainConfig.GemstoneMalignasaurAngrySpellCooldown * 20.0), this.getAngryTick() + 1));
            this.setAngryUseTick(Math.max(0, this.getAngryUseTick() - 1));
        }
    }

    public boolean addAback() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        double d = Double.MAX_VALUE;
        for (LivingEntity shock : list) {
            if (shock == null || shock == this || this.m_20280_((Entity)shock) > d || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)shock) || EntityAndItemFind.isAbackAwayImmune((EntityType)shock.m_6095_()) || shock.m_21223_() > this.m_21223_() / 1.5f || shock.m_21023_((MobEffect)JerotesVillageMobEffects.ABUNDANT_COURAGE.get()) || shock.m_21023_((MobEffect)JerotesVillageMobEffects.RAMPANT.get()) || shock.m_9236_().f_46443_) continue;
            shock.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.ABACK.get(), 240, 0), (Entity)this);
            shock.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 240, 0), (Entity)this);
        }
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 24; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.ABACK.get(), this.m_20208_(0.5), this.m_20187_() + (double)(this.m_20206_() / 4.0f), this.m_20262_(0.5), 0.0, 0.02, 0.0);
            }
        }
        return true;
    }

    @Override
    public boolean trueHurt(MalignasaurPart[] area) {
        if (!this.m_20067_()) {
            if (this.getAttackUse() == 1) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_HEAD, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 2) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 3) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_TAIL, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else if (this.getAttackUse() == 4) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.GEMSTONE_MALIGNASAUR_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        int levels = 1;
        int levelsJump = OtherMainConfig.GemstoneMalignasaurJumpAttackLevel - 1;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            levels = 2;
            levelsJump = OtherMainConfig.GemstoneMalignasaurJumpAttackLevel;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            levels = 3;
            levelsJump = OtherMainConfig.GemstoneMalignasaurJumpAttackLevel + 1;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82377_(0.75, 0.75, 0.75));
        for (MalignasaurPart part : area) {
            List add = this.m_9236_().m_45976_(LivingEntity.class, part.m_20191_().m_82377_(1.35, 1.35, 1.35));
            list.addAll(add);
        }
        for (LivingEntity hurt : list) {
            MalialosaurEntity malialosaurEntity;
            MalignasaurEntity malignasaur;
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof MalignasaurEntity && (malignasaur = (MalignasaurEntity)hurt).m_5448_() != this && this.m_5448_() != malignasaur || hurt instanceof MalialosaurEntity && (malialosaurEntity = (MalialosaurEntity)hurt).m_5448_() != this && this.m_5448_() != malialosaurEntity) continue;
            double d = 0.0;
            if (hurt.m_21051_(Attributes.f_22278_) != null) {
                d = hurt.m_21133_(Attributes.f_22278_);
            }
            double d3 = Math.max(0.3, 1.3 - d);
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl2 = false;
            if (this.getAttackUse() == 1) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)0.5f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 2) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.5f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 3) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            } else if (this.getAttackUse() == 4) {
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.0f, (float)0.5f, (boolean)true, (float)(levels * 8));
            }
            if (!bl2) continue;
            if (this.getAttackUse() == 1 && !hurt.m_9236_().f_46443_) {
                hurt.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.BLEEDING.get(), 60, 0, false, false), (Entity)this);
            }
            if (this.getAttackUse() == 3) {
                if ((Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                    hurt.m_20256_(hurt.m_20184_().m_82520_(-(this.m_20185_() - hurt.m_20185_()) * 0.2 * d3, -(this.m_20186_() - hurt.m_20186_()) * 0.2 * d3, -(this.m_20189_() - hurt.m_20189_()) * 0.2 * d3));
                }
                hurt.m_147240_(0.8, (double)Mth.m_14031_((float)(this.m_146908_() * 0.08f)), (double)(-Mth.m_14089_((float)(this.m_146908_() * 0.08f))));
            }
            if (this.getJumpUseTick() <= 0) continue;
            if (!hurt.m_9236_().f_46443_) {
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 60, levelsJump - 1), (Entity)this);
                hurt.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 60, levelsJump - 1), (Entity)this);
            }
            if (this.m_9236_().m_5776_()) continue;
            this.setJumpUseTick(0);
        }
        if (this.getAttackUse() == 3 || this.getAttackUse() == 4) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        Main.sweepAttack((Entity)this);
        Level hurt = this.m_9236_();
        if (hurt instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)hurt;
            if ((this.getAttackUse() == 3 || this.getAttackUse() == 4) && this.tail1 != null) {
                AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.tail1.m_20185_(), this.tail1.m_20186_() - 1.0, this.tail1.m_20189_()), (double)(Main.mobWidth((Entity)this.tail1) / 2.0f + 2.0f), (double)0.0, (double)(Main.mobWidth((Entity)this.tail1) / 2.0f + 2.0f));
                for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
                }
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTargetHead(LivingEntity entity) {
        if (this.getAttackTick() > -((int)(OtherMainConfig.GemstoneMalignasaurMeleeAttackCooldown * 20.0)) || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(1);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("headAttack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("headAttack2");
            } else {
                this.setAnimationState("headAttack3");
            }
        }
        return true;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > -((int)(OtherMainConfig.GemstoneMalignasaurMeleeAttackCooldown * 20.0)) || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(2);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("attack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("attack2");
            } else {
                this.setAnimationState("attack3");
            }
        }
        return true;
    }

    @Override
    public boolean doHurtTargetTail(LivingEntity entity) {
        if (this.getAttackTick() > -((int)(OtherMainConfig.GemstoneMalignasaurMeleeAttackCooldown * 20.0)) || this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAttackUse(3);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimationState("tailAttack1");
            } else if (attackRandom < 10) {
                this.setAnimationState("tailAttack2");
            } else {
                this.setAnimationState("tailAttack3");
            }
        }
        return true;
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.m_9236_().m_5776_()) {
                this.setHungerOf(this.getHungerOf() + (int)(livingEntity.m_21233_() * 40.0f));
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        AreaEffectCloud area;
        WhirlpoolEntity whirlpool;
        OceanCurrentBreathEntity ocean;
        Entity entity;
        if (this.start > -100) {
            return true;
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource) && (damageSource.m_7639_() == this || (entity = damageSource.m_7640_()) instanceof OceanCurrentBreathEntity && (ocean = (OceanCurrentBreathEntity)entity).m_19749_() == this || (entity = damageSource.m_7640_()) instanceof WhirlpoolEntity && (whirlpool = (WhirlpoolEntity)entity).m_19749_() == this || (entity = damageSource.m_7640_()) instanceof AreaEffectCloud && (area = (AreaEffectCloud)entity).m_19749_() == this)) {
            return true;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268441_) || damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268434_)) {
            return true;
        }
        if (!this.isArmor()) {
            if (this.getArmorTick() > 0 && !damageSource.m_269533_(DamageTypeTags.f_268738_)) {
                return true;
            }
            if (damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268440_)) {
                return true;
            }
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (amount <= 4.0f) {
            return false;
        }
        float amountTrue = amount;
        double amountArmor = amountTrue;
        if (this.getHungerOf() < -10000) {
            amountArmor = amountTrue / 3.0f;
        } else if (this.getHungerOf() < -6000) {
            amountArmor = amountTrue / 2.0f;
        } else if (this.getHungerOf() < -3000) {
            amountArmor = amountTrue / 1.5f;
        } else if (this.getHungerOf() < -1000) {
            amountArmor = amountTrue / 1.25f;
        } else if (this.getHungerOf() < 0) {
            amountArmor = amountTrue / 1.05f;
        }
        if (!this.isArmor()) {
            if (this.getArmorTick() > 0 && !damagesource.m_269533_(DamageTypeTags.f_268738_)) {
                return false;
            }
            if ((double)this.m_21223_() - amountArmor < (double)(this.m_21233_() / 3.0f) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && amountArmor <= OtherMainConfig.GemstoneMalignasaurBreakFakeDamageCap * 10.0 && (double)(this.m_21223_() - this.m_21233_() / 3.0f) < amountArmor) {
                amountArmor = this.m_21223_() - this.m_21233_() / 3.0f;
            }
        }
        if (this.isArmor()) {
            float amount1;
            if (damagesource.m_276093_(DamageTypes.f_268515_)) {
                amountArmor = amountTrue / 2.0f;
            }
            if (amountArmor <= (double)(this.m_21233_() * 3.0f) && this.m_21223_() > this.m_21233_() / 10.0f && (double)this.m_21223_() - amountArmor < (double)(this.m_21233_() / 15.0f) && (double)(amount1 = this.m_21223_() - this.m_21233_() / 15.0f) < amountArmor) {
                amountArmor = amount1;
            }
            if (!damagesource.m_269533_(DamageTypeTags.f_268738_) && amountArmor > OtherMainConfig.GemstoneMalignasaurFakeDamageCap && amountArmor <= OtherMainConfig.GemstoneMalignasaurBreakFakeDamageCap) {
                amountArmor = OtherMainConfig.GemstoneMalignasaurFakeDamageCap;
            }
        }
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_) && this.isTough() && (double)amount <= (double)this.getToughDamage() * OtherMainConfig.GemstoneMalignasaurBreakHurtCooldownMultiple) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughDamage(amount);
        }
        double toughBase = OtherMainConfig.GemstoneMalignasaurHurtCooldown * 20.0;
        float toughMultiple = 0.5f;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            toughMultiple = 1.0f;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            toughMultiple = 1.5f;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setToughTick((int)(toughBase * (double)toughMultiple));
        }
        return super.m_6469_(damagesource, (float)amountArmor);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.MALIGNASAUR_ASPHYXIA.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.OCEAN_DRAGON_DETERRENCE.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        this.jumpAnimationState.m_216973_();
        this.armorAnimationState.m_216973_();
        this.controlAnimationState.m_216973_();
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    @Override
    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    @Override
    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    @Override
    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }
}

