/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss.Biome;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.SpellList;
import com.jerotes.jerotes.spell.SpellType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Monster.Hag.BaseHagEntity;
import com.jerotes.jerotesvillage.entity.Monster.SpirveEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import com.jerotes.jerotesvillage.spell.OtherSpellType;
import com.jerotes.jerotesvillage.util.ParticlesUse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.event.ForgeEventFactory;

public class PurpleSandHagEntity
extends BaseHagEntity
implements BossEntity {
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(PurpleSandHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PURPLE, false);
    public int spellLevel = OtherMainConfig.PurpleSandHagSpellNormalLevel;
    public int covenSpellLevel = OtherMainConfig.PurpleSandHagSpellNormalLevel + 1;

    public PurpleSandHagEntity(EntityType<? extends BaseHagEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 400;
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.PurpleSandHagMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.PurpleSandHagMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.PurpleSandHagArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.PurpleSandHagMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.PurpleSandHagAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.PurpleSandHagKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.PurpleSandHagMagicAttackPercentage;
        }
        return (float)OtherMainConfig.PurpleSandHagAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.PurpleSandHagDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.PurpleSandHagDamageCooldownTick * base;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 165.0);
        builder = builder.m_22268_(Attributes.f_22281_, 13.0);
        builder = builder.m_22268_(Attributes.f_22284_, 15.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f){

            public void m_8037_() {
                int spellLevels = PurpleSandHagEntity.this.getSpellLevel() - 1;
                if (PurpleSandHagEntity.this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    spellLevels = PurpleSandHagEntity.this.getSpellLevel();
                } else if (PurpleSandHagEntity.this.m_9236_().m_46791_() == Difficulty.HARD) {
                    spellLevels = PurpleSandHagEntity.this.getSpellLevel() + 1;
                }
                this.spellLevel = spellLevels;
                super.m_8037_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f){

            public void m_8037_() {
                int spellLevels = PurpleSandHagEntity.this.getSpellLevel() - 1;
                if (PurpleSandHagEntity.this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                    spellLevels = PurpleSandHagEntity.this.getSpellLevel();
                } else if (PurpleSandHagEntity.this.m_9236_().m_46791_() == Difficulty.HARD) {
                    spellLevels = PurpleSandHagEntity.this.getSpellLevel() + 1;
                }
                this.spellLevel = spellLevels;
                super.m_8037_();
            }
        });
    }

    @Override
    public List<SpellTypeInterface> SelfMainSpellList() {
        ArrayList<SpellTypeInterface> spellList = new ArrayList<SpellTypeInterface>();
        if (this.m_5448_() != null && EntityFactionFind.isHumanoid((LivingEntity)this.m_5448_()) && this.m_20270_((Entity)this.m_5448_()) <= 12.0f) {
            spellList.add((SpellTypeInterface)SpellType.JEROTES_HOLD_PERSON);
        } else {
            spellList.add((SpellTypeInterface)SpellType.JEROTES_RAY_OF_SICKNESS);
        }
        spellList.add((SpellTypeInterface)SpellType.JEROTES_PHANTASMAL_KILLER);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_EYEBITE);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_LIGHTNING_BOLT);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_VICIOUS_MOCKERY);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_RAY_OF_SICKNESS);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_BESTOW_CURSE);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_CURE_WOUNDS);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_MAGIC_MISSILE);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_RAY_OF_ENFEEBLEMENT);
        spellList.add(OtherSpellType.JEROTESVILLAGE_PURPLE_SAND_PHANTOM);
        return spellList;
    }

    @Override
    public List<SpellTypeInterface> SelfAddSpellList() {
        ArrayList<SpellTypeInterface> spellList = new ArrayList<SpellTypeInterface>();
        spellList.add((SpellTypeInterface)SpellType.JEROTES_MIRROR_IMAGE);
        spellList.add((SpellTypeInterface)SpellType.JEROTES_INVISIBLE_PASSAGE);
        if (this.m_21223_() <= this.m_21233_() && this.m_5448_() != null && this.m_5448_() instanceof SpellUseEntity) {
            spellList.add((SpellTypeInterface)SpellType.JEROTES_COUNTERSPELL);
        } else {
            spellList.add((SpellTypeInterface)SpellType.JEROTES_INVISIBLE_PASSAGE);
        }
        return spellList;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.PURPLE_SAND_HAG_MUSIC;
    }

    @Override
    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.PURPLE_SAND_HAG_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.PURPLE_SAND_HAG_HURT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.PURPLE_SAND_HAG_DEATH;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.PURPLE_SAND_HAG_LAUGH_1;
    }

    @Override
    public int getSpellLevel() {
        if (this.covenSpellLevel > this.spellLevel && this.isCoven()) {
            return this.covenSpellLevel;
        }
        return this.spellLevel;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("CovenSpellLevel", this.covenSpellLevel);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.covenSpellLevel = compoundTag.m_128451_("CovenSpellLevel");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.update();
        if (this.m_9236_().m_46791_() == Difficulty.HARD && !this.m_9236_().m_5776_()) {
            this.setConjurSpirve(Math.max(0, this.getConjurSpirve() - 1));
        }
        if (!(this.f_19797_ % 600 != 0 && this.f_19797_ != 1 || this.m_9236_().m_5776_())) {
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.COUNTERSPELL.get(), 600, this.spellLevel, false, false), (Entity)this);
        }
        List listHag = this.m_9236_().m_45976_(BaseHagEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listHag.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        List listSpirve = this.m_9236_().m_45976_(SpirveEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listSpirve.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        if ((double)this.m_21223_() < (double)this.m_21233_() * 0.6 && this.m_5448_() != null && this.f_20919_ == 0) {
            if (!this.isCovens()) {
                if (this.getConjurSpirve() <= 0) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setConjurSpirve((int)(OtherMainConfig.PurpleSandHagMainSpellCooldown * 20.0 * 10.0));
                        this.setInvisibility(false);
                        this.setCovens(true);
                        this.setAnimTick(15);
                        this.setAnimationState("spell2");
                    }
                    OtherSpellFind.HagCoven((LivingEntity)this, 3);
                    ParticlesUse.ParticleMagic((LivingEntity)this);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.PURPLE_SAND_HAG_COVENS, this.m_5720_(), 10.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
                    }
                }
            } else if (this.getConjurSpirve() <= 0 && listSpirve.size() < listHag.size() * 16) {
                if (!this.m_9236_().m_5776_()) {
                    this.setConjurSpirve((int)(OtherMainConfig.PurpleSandHagMainSpellCooldown * 20.0 * 10.0));
                    this.setInvisibility(false);
                    this.setCovens(true);
                    this.setAnimTick(15);
                    this.setAnimationState("spell2");
                }
                OtherSpellFind.ConjureSpirve((LivingEntity)this, 3);
                ParticlesUse.ParticleMagic((LivingEntity)this);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.PURPLE_SAND_HAG_CONJURE_SPIRVE, this.m_5720_(), 10.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
                }
            }
        }
    }

    public boolean m_214076_(ServerLevel serverLevel, LivingEntity livingEntity) {
        PlayerTeam teams = (PlayerTeam)this.m_5647_();
        boolean bl = super.m_214076_(serverLevel, livingEntity);
        if (livingEntity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)livingEntity;
            simpleContainer = villager.m_35311_();
            spirve = (SpirveEntity)villager.m_21406_((EntityType)JerotesVillageEntityType.SPIRVE.get(), true);
            if (spirve != null) {
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(spirve.m_20149_(), teams);
                }
                if (!this.m_20067_()) {
                    serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                bl = false;
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)spirve);
                for (n = 0; n < simpleContainer.m_6643_(); ++n) {
                    finds = simpleContainer.m_8020_(n);
                    spirve.mobInventory().m_19173_(finds);
                }
            }
        } else if (livingEntity instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)livingEntity;
            simpleContainer = new SimpleContainer(0);
            if (illager instanceof InventoryEntity) {
                inventoryEntity = (InventoryEntity)illager;
                simpleContainer = inventoryEntity.mobInventory();
            }
            if ((spirve = (SpirveEntity)illager.m_21406_((EntityType)JerotesVillageEntityType.SPIRVE.get(), true)) != null) {
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(spirve.m_20149_(), teams);
                }
                if (!this.m_20067_()) {
                    serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                bl = false;
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)spirve);
                for (n = 0; n < simpleContainer.m_6643_(); ++n) {
                    finds = simpleContainer.m_8020_(n);
                    spirve.mobInventory().m_19173_(finds);
                }
            }
        } else if (livingEntity instanceof Witch) {
            Witch witch = (Witch)livingEntity;
            simpleContainer = new SimpleContainer(0);
            if (witch instanceof InventoryEntity) {
                inventoryEntity = (InventoryEntity)witch;
                simpleContainer = inventoryEntity.mobInventory();
            }
            if ((spirve = (SpirveEntity)witch.m_21406_((EntityType)JerotesVillageEntityType.SPIRVE.get(), true)) != null) {
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(spirve.m_20149_(), teams);
                }
                if (!this.m_20067_()) {
                    serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                bl = false;
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)spirve);
                for (n = 0; n < simpleContainer.m_6643_(); ++n) {
                    finds = simpleContainer.m_8020_(n);
                    spirve.mobInventory().m_19173_(finds);
                }
            }
        }
        if (livingEntity instanceof SecondRounderEntity) {
            SecondRounderEntity secondRounder = (SecondRounderEntity)livingEntity;
            SimpleContainer simpleContainer = secondRounder.m_35311_();
            Boolean blSkinA = secondRounder.isSkinA();
            Boolean blSkinB = secondRounder.isSkinB();
            Boolean blSkinC = secondRounder.isSkinC();
            Boolean blGiant = secondRounder.isGiant();
            boolean getFemale = secondRounder.IsFemale();
            int getSkinType = secondRounder.SkinColor();
            int getSkinColor = secondRounder.SkinType();
            int getEyeType = secondRounder.EyeType();
            int getEyeColor = secondRounder.EyeColor();
            int getAddType_1 = secondRounder.AddType_1();
            int getAddType_2 = secondRounder.AddType_2();
            int getAddType_3 = secondRounder.AddType_3();
            int getHairType = secondRounder.HairType();
            int getHairColor = secondRounder.HairColor();
            int getJacketType = secondRounder.JacketType();
            int getJacketColor = secondRounder.JacketColor();
            int getPantsType = secondRounder.PantsType();
            int getPantsColor = secondRounder.PantsColor();
            int getGlovesType = secondRounder.GlovesType();
            int getGlovesColor = secondRounder.GlovesColor();
            int getBaubleType_1 = secondRounder.BaubleType_1();
            int getBaubleType_2 = secondRounder.BaubleType_2();
            int getBaubleType_3 = secondRounder.BaubleType_3();
            int getShoesType = secondRounder.ShoesType();
            int getShoesColor = secondRounder.ShoesColor();
            int getHatType = secondRounder.HatType();
            int getHatColor = secondRounder.HatColor();
            int getOvercoatType = secondRounder.OvercoatType();
            int getOvercoatColor = secondRounder.OvercoatColor();
            SpirveEntity spirve = (SpirveEntity)secondRounder.m_21406_((EntityType)JerotesVillageEntityType.SPIRVE.get(), true);
            if (spirve != null) {
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(spirve.m_20149_(), teams);
                }
                spirve.newSpawn = 1;
                spirve.setFemale(getFemale);
                spirve.setSkinType(getSkinType);
                spirve.setSkinColor(getSkinColor);
                spirve.setEyeType(getEyeType);
                spirve.setEyeColor(getEyeColor);
                spirve.setAddType_1(getAddType_1);
                spirve.setAddType_2(getAddType_2);
                spirve.setAddType_3(getAddType_3);
                spirve.setHairType(getHairType);
                spirve.setHairColor(getHairColor);
                spirve.setJacketType(getJacketType);
                spirve.setJacketColor(getJacketColor);
                spirve.setPantsType(getPantsType);
                spirve.setPantsColor(getPantsColor);
                spirve.setGlovesType(getGlovesType);
                spirve.setGlovesColor(getGlovesColor);
                spirve.setBaubleType_1(getBaubleType_1);
                spirve.setBaubleType_2(getBaubleType_2);
                spirve.setBaubleType_3(getBaubleType_3);
                spirve.setShoesType(getShoesType);
                spirve.setShoesColor(getShoesColor);
                spirve.setHatType(getHatType);
                spirve.setHatColor(getHatColor);
                spirve.setOvercoatType(getOvercoatType);
                spirve.setOvercoatColor(getOvercoatColor);
                spirve.setSkinA(blSkinA);
                spirve.setSkinB(blSkinB);
                spirve.setSkinC(blSkinC);
                spirve.setGiant(blGiant);
                if (!this.m_20067_()) {
                    serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                bl = false;
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)spirve);
                for (int n = 0; n < simpleContainer.m_6643_(); ++n) {
                    ItemStack finds = simpleContainer.m_8020_(n);
                    spirve.mobInventory().m_19173_(finds);
                }
            }
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_269533_(DamageTypeTags.f_268745_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268725_)) {
            return true;
        }
        if (damageSource.m_7640_() instanceof ThrownPotion || damageSource.m_7640_() instanceof AreaEffectCloud) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            int spellLevels = this.getSpellLevel() - 1;
            if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                spellLevels = this.getSpellLevel();
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                spellLevels = this.getSpellLevel() + 1;
            }
            SpellList.MagicAbsorption((int)spellLevels, (LivingEntity)this, (Entity)this).spellUse();
            if (amount <= (float)(spellLevels * 5) && !damagesource.m_276093_(JerotesDamageTypes.MAGIC_EFFECT)) {
                return false;
            }
            return super.m_6469_(damagesource, amount / 3.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    protected float m_6515_(DamageSource damageSource, float f) {
        f = super.m_6515_(damageSource, f);
        if (damageSource.m_7639_() == this) {
            f = 0.0f;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268731_)) {
            f *= 0.15f;
        }
        return f;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19610_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19597_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }
}

