/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss.Biome;

import com.google.common.collect.ImmutableList;
import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.SpellList;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Neutral.MerorMachine.MerorMachineEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.goal.SecondRounderGolemMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.SecondRounderGolemRangedAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.navigation.LineNavigation;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;

public class SecondRounderGolemEntity
extends MerorMachineEntity
implements RangedAttackMob,
BossEntity,
BreakShieldEntity,
FireAbsorptionEntity,
SpellUseEntity {
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("00a5ab13-dd26-489d-ac07-8f85efa400ee");
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("27bbfc47-7ced-43ee-88c7-4bca3ed4e02d");
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("fecce94e-9cb6-478e-92ef-a66823b14e53");
    private static final EntityDataAccessor<Float> BREATH_TICK = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ANGRY_TICK = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState standAnimationState = new AnimationState();
    public AnimationState standStartAnimationState = new AnimationState();
    public AnimationState standStopAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState blockAnimationState = new AnimationState();
    public AnimationState breathAnimationState = new AnimationState();
    public AnimationState swordAnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState attack5AnimationState = new AnimationState();
    public AnimationState attack6AnimationState = new AnimationState();
    public AnimationState angryAnimationState = new AnimationState();
    public AnimationState angrySword1AnimationState = new AnimationState();
    public AnimationState angrySword2AnimationState = new AnimationState();
    public AnimationState angrySword3AnimationState = new AnimationState();
    public AnimationState swordAttackAnimationState = new AnimationState();
    public AnimationState helpAnimationState = new AnimationState();
    public AnimationState cloakAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PINK, false);
    private static final EntityDataAccessor<Boolean> SWORD_USE = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLOAK = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STAND = SynchedEntityData.m_135353_(SecondRounderGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected MoveControl moveControls = new GiantMoveControl((Mob)this);
    public int spellLevel = OtherMainConfig.SecondRounderGolemSpellNormalLevel;
    public int standTick = -10;
    private int attackTick;
    private int swordTick = -10;
    private int swordAttackTick;
    private double blockDestroyTick;
    private double healTick;
    public double cloakTick;
    private int sitTick = 0;
    private double helpTick = 0.0;

    public SecondRounderGolemEntity(EntityType<? extends SecondRounderGolemEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(3.1f);
        this.f_21364_ = 1000;
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.SecondRounderGolemMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.SecondRounderGolemMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.SecondRounderGolemArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.SecondRounderGolemMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.SecondRounderGolemAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.SecondRounderGolemKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.SecondRounderGolemMagicAttackPercentage;
        }
        return (float)OtherMainConfig.SecondRounderGolemAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.SecondRounderGolemDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.SecondRounderGolemDamageCooldownTick * base;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 436.0);
        builder = builder.m_22268_(Attributes.f_22281_, 36.0);
        builder = builder.m_22268_(Attributes.f_22284_, 20.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SecondRounderGolemMeleeAttackGoal(this, 1.25, true));
        this.f_21345_.m_25352_(1, (Goal)new SecondRounderGolemRangedAttackGoal(this, 1.25, 40, 20.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SecondRounderGolemEntity)this).m_21674_(arg_0)));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.specialAction() && this.attackTick <= 0) {
            this.setBreathTick(0.0f);
            if (this.m_21223_() / this.m_21233_() > 0.25f) {
                this.setAngryTick((float)((double)this.getAngryTick() - OtherMainConfig.SecondRounderGolemIntenseBombingCooldown / 5.0 * 20.0));
            }
            this.m_9236_().m_7605_((Entity)this, (byte)14);
            int spellLevel = this.getSpellLevel() - 1;
            if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                spellLevel = this.getSpellLevel();
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                spellLevel = this.getSpellLevel() + 1;
            }
            SpellList.PoisonBreath((int)spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        }
    }

    protected SoundEvent m_7515_() {
        if (this.standTick > 0 && !this.isInSittingPose()) {
            return JerotesVillageSounds.SECOND_ROUNDER_GOLEM_AMBIENT;
        }
        return null;
    }

    public int m_8100_() {
        return 3200;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (!EntityAndItemFind.isMerorAttack((DamageSource)damageSource)) {
            return JerotesVillageSounds.SECOND_ROUNDER_GOLEM_MEROR_TOUGHNESS;
        }
        return JerotesVillageSounds.SECOND_ROUNDER_GOLEM_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SECOND_ROUNDER_GOLEM_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.SECOND_ROUNDER_GOLEM_WALK, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 4.8f;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.5 && this.f_19796_.m_188503_(5) == 1;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.2, 1.2, 1.2);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.SECOND_ROUNDER_GOLEM_MUSIC;
    }

    public int getShieldBreakStrength() {
        return 2400;
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        if (this.m_20069_()) {
            return new AmphibiousPathNavigation((Mob)this, level);
        }
        return new LineNavigation((Mob)this, level);
    }

    public double FireAbsorptionPercentage() {
        return OtherMainConfig.SecondRounderGolemFireAbsorptionPercentage;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public float getBreathTick() {
        return ((Float)this.f_19804_.m_135370_(BREATH_TICK)).floatValue();
    }

    public void setBreathTick(float f) {
        this.f_19804_.m_135381_(BREATH_TICK, (Object)Float.valueOf(Mth.m_14036_((float)f, (float)0.0f, (float)((float)OtherMainConfig.SecondRounderGolemBreathCooldown * 20.0f))));
    }

    public float getAngryTick() {
        return ((Float)this.f_19804_.m_135370_(ANGRY_TICK)).floatValue();
    }

    public void setAngryTick(float f) {
        this.f_19804_.m_135381_(ANGRY_TICK, (Object)Float.valueOf(Mth.m_14036_((float)f, (float)0.0f, (float)((float)OtherMainConfig.SecondRounderGolemIntenseBombingCooldown * 20.0f))));
    }

    public boolean isUseSword() {
        return (Boolean)this.m_20088_().m_135370_(SWORD_USE) != false && this.f_20919_ == 0;
    }

    public void setUseSword(boolean bl) {
        this.m_20088_().m_135381_(SWORD_USE, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            double d = OtherMainConfig.SecondRounderGolemMeleeDamageUseSword - OtherMainConfig.SecondRounderGolemMeleeDamage;
            double d2 = OtherMainConfig.SecondRounderGolemArmorUseSword - OtherMainConfig.SecondRounderGolemArmor;
            double d3 = OtherMainConfig.SecondRounderGolemMovementSpeedUseSword - OtherMainConfig.SecondRounderGolemMovementSpeed;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Use sword attack damage", d, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Use sword armor", d2, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Use sword movement speed", d3, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public boolean specialAction() {
        return (this.standTick < 0 || this.standTick > 780) && !this.isTame() || this.getBreathTick() < 20.0f && this.getBreathTick() > 0.0f || this.swordTick > 0 || this.swordAttackTick > 0 || this.cloakTick > OtherMainConfig.SecondRounderGolemPoisonFireCloakTime * 20.0 - 20.0;
    }

    public boolean isCloak() {
        return (Boolean)this.m_20088_().m_135370_(CLOAK);
    }

    public void setCloak(boolean bl) {
        this.m_20088_().m_135381_(CLOAK, (Object)bl);
    }

    public boolean isStand() {
        return (Boolean)this.m_20088_().m_135370_(STAND);
    }

    public void setStand(boolean bl) {
        this.m_20088_().m_135381_(STAND, (Object)bl);
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("StandTick", this.standTick);
        compoundTag.m_128379_("IsUseSword", this.isUseSword());
        compoundTag.m_128379_("IsCloak", this.isCloak());
        compoundTag.m_128379_("IsStand", this.isStand());
        compoundTag.m_128405_("AttackTick", this.attackTick);
        compoundTag.m_128350_("BreathTick", this.getBreathTick());
        compoundTag.m_128350_("AngryTick", this.getAngryTick());
        compoundTag.m_128405_("SwordTick", this.swordTick);
        compoundTag.m_128405_("SwordAttackTick", this.swordAttackTick);
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128347_("HealTick", this.healTick);
        compoundTag.m_128347_("CloakTick", this.cloakTick);
        compoundTag.m_128405_("SitTick", this.sitTick);
        compoundTag.m_128347_("HelpTick", this.helpTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.standTick = compoundTag.m_128451_("StandTick");
        if (compoundTag.m_128441_("IsUseSword")) {
            this.setUseSword(compoundTag.m_128471_("IsUseSword"));
        }
        if (compoundTag.m_128441_("IsCloak")) {
            this.setCloak(compoundTag.m_128471_("IsCloak"));
        }
        if (compoundTag.m_128441_("IsStand")) {
            this.setStand(compoundTag.m_128471_("IsStand"));
        }
        this.attackTick = compoundTag.m_128451_("AttackTick");
        if (compoundTag.m_128441_("BreathTick")) {
            this.setBreathTick(compoundTag.m_128457_("BreathTick"));
        }
        if (compoundTag.m_128441_("AngryTick")) {
            this.setAngryTick(compoundTag.m_128457_("AngryTick"));
        }
        this.swordTick = compoundTag.m_128451_("SwordTick");
        this.swordAttackTick = compoundTag.m_128451_("SwordAttackTick");
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.healTick = compoundTag.m_128459_("HealTick");
        this.cloakTick = compoundTag.m_128459_("CloakTick");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.helpTick = compoundTag.m_128459_("HelpTick");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SWORD_USE, (Object)false);
        this.m_20088_().m_135372_(CLOAK, (Object)false);
        this.m_20088_().m_135372_(STAND, (Object)false);
        this.m_20088_().m_135372_(BREATH_TICK, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(ANGRY_TICK, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(IS_LEGEND, (Object)true);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.update();
        if (this.m_20069_()) {
            this.f_19812_ = true;
        }
        if (this.m_6084_() && !this.isTame() && this.standTick > 0 || this.isTame() && !this.isInSittingPose()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.f_20919_ == 0) {
            if (this.isTame()) {
                if (this.isInSittingPose()) {
                    this.idleAnimationState.m_216973_();
                } else {
                    this.standAnimationState.m_216973_();
                }
                if (this.isInSittingPose() && this.sitTick <= 0) {
                    this.sitTick = 40;
                }
                if (!this.isInSittingPose() && this.sitTick > 0) {
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    this.sitTick = 0;
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216973_();
                }
                if (this.sitTick == 40) {
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick == 20) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick > 5) {
                    --this.sitTick;
                }
            } else {
                if (this.standTick >= 0) {
                    --this.standTick;
                }
                if (this.standTick < 0 && this.f_19796_.m_188503_(100) == 1 && this.f_20919_ == 0) {
                    this.m_5634_(5.0f);
                }
                if (this.m_5912_() || this.m_5448_() != null || this.m_21188_() != null) {
                    if (this.standTick <= 20) {
                        this.standTick = 800;
                        if (!this.m_9236_().m_5776_()) {
                            this.setStand(false);
                        }
                    } else if (this.standTick < 780) {
                        this.standTick = 780;
                    }
                }
                if (this.standTick == 800) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    this.idleAnimationState.m_216973_();
                }
                if (this.standTick == 780) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                    this.standStopAnimationState.m_216973_();
                }
                if (this.standTick == 20) {
                    this.standStopAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.standTick <= 0) {
                    this.standStartAnimationState.m_216973_();
                    this.standStopAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                    if (!this.isStand() && !this.m_9236_().m_5776_()) {
                        this.setStand(true);
                    }
                } else {
                    this.standAnimationState.m_216973_();
                }
            }
        }
        if (this.healTick <= 0.0) {
            if ((double)(this.m_21223_() / this.m_21233_()) < 0.2) {
                if (this.f_19796_.m_188503_(100) == 1 && this.f_20919_ == 0) {
                    this.m_5634_(20.0f);
                }
            } else if (this.f_19796_.m_188503_(200) == 1 && this.f_20919_ == 0) {
                this.m_5634_(10.0f);
            }
        }
        if ((double)this.getBreathTick() < 20.0 * OtherMainConfig.SecondRounderGolemBreathCooldown) {
            this.setBreathTick(this.getBreathTick() + 1.0f);
        }
        if (this.attackTick == 12 && this.f_20919_ == 0) {
            this.trueHurt();
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)60.0f);
            if (blockDestroy) {
                this.blockDestroyTick = OtherMainConfig.SecondRounderGolemBreakBlockCooldown * 20.0;
                if (!this.specialAction() && this.attackTick <= 0 && this.m_6084_()) {
                    this.trueHurt();
                    this.m_9236_().m_7605_((Entity)this, (byte)12);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_BLOCK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                }
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
        if (!this.specialAction() && this.attackTick <= 0) {
            if (this.m_5448_() != null || this.m_5912_()) {
                if ((double)this.getAngryTick() >= OtherMainConfig.SecondRounderGolemIntenseBombingCooldown * 20.0) {
                    int spellLevel = this.getSpellLevel() - 1;
                    if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                        spellLevel = this.getSpellLevel();
                    } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                        spellLevel = this.getSpellLevel() + 1;
                    }
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_ANGRY, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    OtherSpellFind.IntenseBombing((LivingEntity)this, spellLevel, 16, 4.0f);
                    if (!this.m_9236_().m_5776_()) {
                        this.setAngryTick(0.0f);
                    }
                    this.m_9236_().m_7605_((Entity)this, (byte)15);
                } else if ((double)this.getAngryTick() < OtherMainConfig.SecondRounderGolemIntenseBombingCooldown * 20.0) {
                    this.setAngryTick(this.getAngryTick() + 1.0f);
                }
            } else if (this.getAngryTick() > 0.0f && !this.m_9236_().m_5776_()) {
                this.setAngryTick(this.getAngryTick() - 1.0f);
            }
        }
        if (this.m_21223_() < this.m_21233_() / 2.0f && this.swordTick < -1) {
            this.m_9236_().m_7605_((Entity)this, (byte)13);
            this.swordTick = 15;
        }
        if (this.swordTick > 0) {
            --this.swordTick;
        }
        if (this.swordTick == 0) {
            if (!this.m_9236_().f_46443_) {
                this.setUseSword(true);
            }
            this.swordTick = -1;
        }
        if (this.swordAttackTick > 0) {
            --this.swordAttackTick;
        }
        if ((this.swordAttackTick == 5 || this.swordAttackTick == 22) && this.f_20919_ == 0) {
            this.trueHurt();
            Level blockDestroy = this.m_9236_();
            if (blockDestroy instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)blockDestroy;
                for (int i = 0; i < 48; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20208_(1.2f), this.m_20187_(), this.m_20262_(1.2f), 5, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_ATTACK_2, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (this.swordAttackTick == 1) {
            OtherSpellFind.SecondRounderSweep((LivingEntity)this, this.m_21133_(Attributes.f_22281_), 1);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_SWORD_ATTACK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (!this.specialAction() && this.attackTick <= 0) {
            if (this.m_5448_() != null && this.cloakTick <= 0.0 && this.m_217043_().m_188501_() < 0.0016666667f) {
                this.cloakTick = OtherMainConfig.SecondRounderGolemPoisonFireCloakTime * 20.0;
                this.m_9236_().m_7605_((Entity)this, (byte)17);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_CLOAK, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
            }
            if (this.cloakTick > 0.0 && this.cloakTick % 5.0 == 0.0) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox());
                for (LivingEntity hurt : list) {
                    if (hurt == null || this.m_20280_((Entity)hurt) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt)) continue;
                    DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268684_), (Entity)this, (Entity)this.m_269323_());
                    hurt.m_6469_(damageSource, (float)this.m_21133_(Attributes.f_22281_) / 4.0f);
                    hurt.m_20254_(OtherMainConfig.SecondRounderGolemPoisonFireCloakFireTime);
                    int spellLevel = OtherMainConfig.SecondRounderGolemPoisonFireCloakPotionLevel - 1;
                    if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                        spellLevel = OtherMainConfig.SecondRounderGolemPoisonFireCloakPotionLevel;
                    } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                        spellLevel = OtherMainConfig.SecondRounderGolemPoisonFireCloakPotionLevel + 1;
                    }
                    if (hurt.m_9236_().f_46443_) continue;
                    hurt.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.DEADLY_POISON.get(), spellLevel * 20, spellLevel));
                }
            }
            if (this.m_5448_() != null && this.helpTick <= 0.0 && this.m_217043_().m_188501_() < 0.008333334f) {
                this.helpTick = OtherMainConfig.SecondRounderGolemSagesCooldown * 20.0;
                this.m_9236_().m_7605_((Entity)this, (byte)18);
                OtherSpellFind.I_Sages((LivingEntity)this, this.getSpellLevel() * 3, 2, this.getSpellLevel() * 3, 2, 32);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_HELP, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
            }
            if (this.helpTick > 0.0) {
                this.helpTick -= 1.0;
            }
        }
        if (this.cloakTick > 0.0) {
            this.cloakTick -= 1.0;
            if (!this.isCloak() && !this.m_9236_().f_46443_) {
                this.setCloak(true);
            }
        } else if (this.isCloak() && !this.m_9236_().f_46443_) {
            this.setCloak(false);
        }
        if (this.healTick > 0.0) {
            this.healTick -= 1.0;
        }
    }

    protected void m_7324_(Entity entity) {
        LivingEntity livingEntity;
        if (!this.m_21525_() && !this.isTame() && !this.m_5912_() && entity instanceof LivingEntity && this.m_6779_(livingEntity = (LivingEntity)entity) && this.m_6549_(livingEntity.m_6095_()) && !this.m_7307_((Entity)livingEntity)) {
            this.m_6710_((LivingEntity)entity);
        }
        super.m_7324_(entity);
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.specialAction() || this.standTick > 780) {
            return false;
        }
        if (this.attackTick <= 0) {
            if (!this.m_9236_().f_46443_ && this.m_21223_() / this.m_21233_() > 0.33333334f) {
                this.setAngryTick(0.0f);
            }
            if (this.m_217043_().m_188501_() > 0.9f && this.isUseSword()) {
                this.swordAttackTick = 35;
                this.m_9236_().m_7605_((Entity)this, (byte)16);
                return true;
            }
            this.attackTick = 20;
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            if (!this.isUseSword()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_ATTACK_1, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            } else {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.SECOND_ROUNDER_GOLEM_ATTACK_2, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        int levels = 0;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            levels = 1;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            levels = 2;
        }
        int sword = 1;
        if (this.isUseSword()) {
            sword = 2;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82377_((double)(levels * 2 * sword), (double)(levels * 2 * sword), (double)(levels * 2 * sword)));
        for (LivingEntity hurt : list) {
            boolean bl2;
            if (hurt == null || this.m_20280_((Entity)hurt) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt)) continue;
            float damage = 1.0f;
            if (hurt.m_6095_() == JerotesVillageEntityType.VARIANT_ZSIEIN.get()) {
                damage = 5.0f;
            }
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            float damages = (float)this.m_21133_(Attributes.f_22281_) * damage;
            if (!this.isUseSword()) {
                percentage = (float)OtherMainConfig.SecondRounderGolemAttackPercentage;
                bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.0f, (float)1.0f, (boolean)true, (float)damages);
            } else {
                float f1;
                if (Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)4) == 1) {
                    percentage = (float)OtherMainConfig.SecondRounderGolemSwordAttackPercentage;
                    bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.0f, (float)1.0f, (boolean)true, (float)damages);
                } else {
                    percentage = (float)OtherMainConfig.SecondRounderGolemSwordAttackPercentage;
                    bl2 = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)hurt, (DamageSource)this.m_269291_().m_269104_((Entity)this, (Entity)this), (float)0.0f, (float)1.0f, (boolean)true, (float)damages);
                }
                if (bl2 && (f1 = (float)this.m_21133_(Attributes.f_22282_) + (float)EnchantmentHelper.m_44894_((LivingEntity)this)) > 0.0f) {
                    hurt.m_147240_((double)f1 * 0.5, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
            }
            if (!bl2) continue;
            BlockPos blockPos = hurt.m_20097_();
            BlockState blockState = hurt.m_9236_().m_8055_(blockPos);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                if (!blockState.m_60795_()) {
                    _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), hurt.m_20185_(), hurt.m_20186_(), hurt.m_20189_(), 15, 0.3, 0.0, 0.3, 0.0);
                }
            }
            double d1 = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level2 = this.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                for (int i = 0; i < 15; ++i) {
                    double xs = this.m_20185_() + d1 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20185_() - hurt.m_20185_()) / 2.0;
                    double ys = this.m_20227_(0.5) + (double)this.m_217043_().m_188501_() - 0.5 - (this.m_20186_() - hurt.m_20186_()) / 2.0;
                    double zs = this.m_20189_() + d2 + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f) - (this.m_20189_() - hurt.m_20189_()) / 2.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, xs, ys, zs, 0, d1, 0.0, d2, 0.0);
                }
            }
            double d = Math.max(0.0, 1.0 - hurt.m_21133_(Attributes.f_22278_));
            if ((Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                hurt.m_20256_(hurt.m_20184_().m_82520_(-(this.m_20185_() - hurt.m_20185_()) * 0.04 * d, -(this.m_20186_() - hurt.m_20186_()) * 0.02 * d, -(this.m_20189_() - hurt.m_20189_()) * 0.04 * d));
            }
            if (this.f_19796_.m_188503_(10) < levels * sword) {
                this.m_9236_().m_255391_((Entity)this, hurt.m_20185_(), hurt.m_20186_(), hurt.m_20189_(), 0.2f, false, Level.ExplosionInteraction.NONE);
            }
            if (!(hurt instanceof Player)) continue;
            Player player = (Player)hurt;
            Item item0 = hurt.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            Item item1 = hurt.m_21206_().m_41720_();
            if (item0 instanceof ShieldItem) {
                player.m_36335_().m_41524_(item0, 2000);
            }
            if (!(item1 instanceof ShieldItem)) continue;
            player.m_36335_().m_41524_(item1, 2000);
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        if (this.swordTick > 0) {
            return true;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        float n = 0.5f;
        if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
            n = 1.0f;
        } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            n = 1.5f;
        }
        this.healTick = OtherMainConfig.SecondRounderGolemNotAttackedStartHealCooldown * 20.0;
        this.setAngryTick((float)((double)this.getAngryTick() + OtherMainConfig.SecondRounderGolemIntenseBombingCooldown / 20.0 * 20.0));
        float damages = (float)((double)amount / (OtherMainConfig.SecondRounderGolemNormalMerorToughnessNonMagical * (double)n));
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            damages = (float)((double)amount / (OtherMainConfig.SecondRounderGolemNormalMerorToughnessMagical * (double)n));
        }
        if (this.isUseSword()) {
            if (EntityAndItemFind.isMerorAttack((DamageSource)damagesource)) {
                damages = amount * 0.5f;
            }
        } else if (EntityAndItemFind.isMerorAttack((DamageSource)damagesource)) {
            damages = amount;
        }
        Crackiness crackiness = this.getCrackiness();
        boolean bl = super.m_6469_(damagesource, damages);
        if (bl && this.getCrackiness() != crackiness) {
            this.m_5496_(JerotesVillageSounds.SECOND_ROUNDER_GOLEM_DAMAGE, 1.0f, 1.0f);
        }
        return bl;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        livingEntity.m_5810_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
            Item item0 = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
            Item item1 = player.m_21206_().m_41720_();
            if (item0 instanceof ShieldItem) {
                player.m_36335_().m_41524_(item0, 2000);
            }
            if (item1 instanceof ShieldItem) {
                player.m_36335_().m_41524_(item1, 2000);
            }
        }
        if (!livingEntity.m_9236_().f_46443_) {
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
        }
        AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)livingEntity, (DamageSource)this.m_269291_().m_269104_((Entity)this, (Entity)this), (float)1.0f, (float)2.0f, (boolean)false, (float)0.0f);
    }

    @Override
    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ANESTHETIZED.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ANESTHETIZED_HOLD.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ENSLAVEMENT.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    @Override
    public void m_7822_(byte by) {
        if (by == 4) {
            int attackRandom = this.f_19796_.m_188503_(30);
            if (!this.specialAction() || this.standTick > 780) {
                if (!this.isUseSword()) {
                    if (attackRandom > 27) {
                        this.attack1AnimationState.m_216977_(this.f_19797_);
                    } else if (attackRandom < 10) {
                        this.attack2AnimationState.m_216977_(this.f_19797_);
                    } else {
                        this.attack3AnimationState.m_216977_(this.f_19797_);
                    }
                } else if (attackRandom > 20) {
                    this.attack4AnimationState.m_216977_(this.f_19797_);
                } else if (attackRandom < 15) {
                    this.attack5AnimationState.m_216977_(this.f_19797_);
                } else {
                    this.attack6AnimationState.m_216977_(this.f_19797_);
                }
            }
        } else if (by == 12) {
            this.blockDestroyTick = OtherMainConfig.SecondRounderGolemBreakBlockCooldown * 20.0;
            if (this.swordTick <= 0) {
                this.blockAnimationState.m_216977_(this.f_19797_);
            }
        } else if (by == 13) {
            this.swordTick = 15;
            this.swordAnimationState.m_216977_(this.f_19797_);
        } else if (by == 14) {
            this.setBreathTick(0.0f);
            if (this.swordTick <= 0) {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
                this.attack3AnimationState.m_216973_();
                this.blockAnimationState.m_216973_();
                this.swordAnimationState.m_216973_();
                this.attack4AnimationState.m_216973_();
                this.attack5AnimationState.m_216973_();
                this.attack6AnimationState.m_216973_();
                this.angryAnimationState.m_216973_();
                this.cloakAnimationState.m_216973_();
                this.helpAnimationState.m_216973_();
                this.breathAnimationState.m_216977_(this.f_19797_);
            }
        } else if (by == 15) {
            if (this.swordTick <= 0) {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
                this.attack3AnimationState.m_216973_();
                this.blockAnimationState.m_216973_();
                this.breathAnimationState.m_216973_();
                this.swordAnimationState.m_216973_();
                this.attack4AnimationState.m_216973_();
                this.attack5AnimationState.m_216973_();
                this.attack6AnimationState.m_216973_();
                this.cloakAnimationState.m_216973_();
                this.helpAnimationState.m_216973_();
                if (!this.isUseSword()) {
                    this.angryAnimationState.m_216977_(this.f_19797_);
                } else {
                    int attackRandom = this.f_19796_.m_188503_(30);
                    if (attackRandom > 20) {
                        this.angrySword1AnimationState.m_216977_(this.f_19797_);
                    } else if (attackRandom < 10) {
                        this.angrySword2AnimationState.m_216977_(this.f_19797_);
                    } else {
                        this.angrySword3AnimationState.m_216977_(this.f_19797_);
                    }
                }
            }
        } else if (by == 16) {
            this.swordAttackTick = 35;
            this.swordAttackAnimationState.m_216977_(this.f_19797_);
        } else if (by == 17) {
            this.cloakTick = OtherMainConfig.SecondRounderGolemPoisonFireCloakTime * 20.0;
            if (this.swordTick <= 0) {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
                this.attack3AnimationState.m_216973_();
                this.blockAnimationState.m_216973_();
                this.breathAnimationState.m_216973_();
                this.swordAnimationState.m_216973_();
                this.attack4AnimationState.m_216973_();
                this.attack5AnimationState.m_216973_();
                this.attack6AnimationState.m_216973_();
                this.angryAnimationState.m_216973_();
                this.helpAnimationState.m_216973_();
                this.cloakAnimationState.m_216977_(this.f_19797_);
            }
            if (!this.m_20145_()) {
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.POISON_FIRE_CLOAK_DISPLAY.get(), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else if (by == 18) {
            this.helpTick = OtherMainConfig.SecondRounderGolemSagesCooldown * 20.0;
            if (this.swordTick <= 0) {
                this.attack1AnimationState.m_216973_();
                this.attack2AnimationState.m_216973_();
                this.attack3AnimationState.m_216973_();
                this.blockAnimationState.m_216973_();
                this.breathAnimationState.m_216973_();
                this.swordAnimationState.m_216973_();
                this.attack4AnimationState.m_216973_();
                this.attack5AnimationState.m_216973_();
                this.attack6AnimationState.m_216973_();
                this.angryAnimationState.m_216973_();
                this.swordAttackAnimationState.m_216973_();
                this.cloakAnimationState.m_216973_();
                this.helpAnimationState.m_216977_(this.f_19797_);
            }
        } else if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            this.deadAnimationState.m_216977_(this.f_19797_);
        }
        this.setBreathTick(0.0f);
        ++this.f_20919_;
        this.idleAnimationState.m_216973_();
        this.standAnimationState.m_216973_();
        this.standStartAnimationState.m_216973_();
        this.standStopAnimationState.m_216973_();
        this.attack1AnimationState.m_216973_();
        this.attack2AnimationState.m_216973_();
        this.attack3AnimationState.m_216973_();
        this.blockAnimationState.m_216973_();
        this.breathAnimationState.m_216973_();
        this.swordAnimationState.m_216973_();
        this.attack4AnimationState.m_216973_();
        this.attack5AnimationState.m_216973_();
        this.attack6AnimationState.m_216973_();
        this.angryAnimationState.m_216973_();
        this.swordAttackAnimationState.m_216973_();
        this.cloakAnimationState.m_216973_();
        this.helpAnimationState.m_216973_();
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float f) {
            this.fraction = f;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness crackiness : BY_DAMAGE) {
                if (!(p_28902_ < crackiness.fraction)) continue;
                return crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(crackiness -> crackiness.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

