/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Boss;

import com.jerotes.jerotes.client.sound.BossMusicPlayer;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BossEntity;
import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.OminouseBannerRaidForceEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.NoRotationControl;
import com.jerotes.jerotesvillage.entity.Animal.GiantMonsterEntity;
import com.jerotes.jerotesvillage.event.BossBarEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.Other;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class OminousBannerProjectionEntity
extends Raider
implements OminouseBannerRaidForceEntity,
BossEntity,
JerotesEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(OminousBannerProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(OminousBannerProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LAST_ROUND = SynchedEntityData.m_135353_(OminousBannerProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SUPPLEMENT = SynchedEntityData.m_135353_(OminousBannerProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LEGEND = SynchedEntityData.m_135353_(OminousBannerProjectionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState roundAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, false);
    private int round = 1;
    private int maxRound = OtherMainConfig.OminousBannerProjectionMaxRound;
    public double supplementTick;
    public double summonAmountMax = OtherMainConfig.OminousBannerProjectionRoundTimeMin * 20.0;
    public double summonAmountStopMax = OtherMainConfig.OminousBannerProjectionRoundTimeMax * 20.0;
    public double summonAmount = this.summonAmountMax;
    public float summonMaxHealth = 1.0f;
    public double points = OtherMainConfig.OminousBannerProjectionPointsBase;
    public float faces;

    public OminousBannerProjectionEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.1f);
        this.f_21364_ = 300;
        if (OtherMainConfig.BossBaseAttributeCanUseConfig) {
            this.m_21051_(Attributes.f_22276_).m_22100_(OtherMainConfig.OminousBannerProjectionMaxHealth);
            this.m_21153_(this.m_21233_());
            this.m_21051_(Attributes.f_22281_).m_22100_(OtherMainConfig.OminousBannerProjectionMeleeDamage);
            this.m_21051_(Attributes.f_22284_).m_22100_(OtherMainConfig.OminousBannerProjectionArmor);
            this.m_21051_(Attributes.f_22279_).m_22100_(OtherMainConfig.OminousBannerProjectionMovementSpeed);
            this.m_21051_(Attributes.f_22282_).m_22100_(OtherMainConfig.OminousBannerProjectionAttackKnockback);
            this.m_21051_(Attributes.f_22278_).m_22100_(OtherMainConfig.OminousBannerProjectionKnockbackResistance);
        }
        if (level.f_46443_) {
            BossBarEvent.BOSSES.add((Mob)this);
        }
    }

    public boolean hasPercentageDamage() {
        return MainConfig.HasPercentageDamage.contains(this.m_20078_()) || OtherMainConfig.BossHasPercentageDamage.contains(this.m_20078_()) || this.isLegend();
    }

    public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance((DamageSource)damageSource)) {
            return (float)OtherMainConfig.OminousBannerProjectionMagicAttackPercentage;
        }
        return (float)OtherMainConfig.OminousBannerProjectionAttackPercentage;
    }

    public boolean hasDamageCap() {
        return MainConfig.HasDamageCap.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCap.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCap(DamageSource damageSource, Entity entity) {
        return (float)OtherMainConfig.OminousBannerProjectionDamageCap;
    }

    public boolean hasDamageCooldownTick() {
        return MainConfig.HasDamageCooldownTick.contains(this.m_20078_()) || OtherMainConfig.BossHasDamageCooldownTick.contains(this.m_20078_()) || this.isLegend();
    }

    public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)OtherMainConfig.OminousBannerProjectionDamageCooldownTick * base;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (EntityFactionFind.isRaider((LivingEntity)(livingEntity = (LivingEntity)entity)) || OtherEntityFactionFind.isFactionOminousBannerRaidForce(livingEntity));
    }

    public String getFactionTypeName() {
        return "ominous_banner_raid_force";
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        this.bossEvent.m_6543_(serverPlayer);
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.bossEvent.m_6539_(serverPlayer);
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.isLastRound()) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        } else if (this.isSupplement()) {
            this.bossEvent.m_142711_((float)this.supplementTick);
        } else {
            this.bossEvent.m_142711_(Mth.m_14036_((float)(this.getHealthOfLivingRaider() / this.summonMaxHealth), (float)0.0f, (float)1.0f));
        }
    }

    public float getHealthOfLivingRaider() {
        float f = (float)(this.summonAmount / this.summonAmountMax);
        List listTeam = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listTeam.removeIf(entity -> entity instanceof OminousBannerProjectionEntity || !EntityFactionFind.isRaider((LivingEntity)entity) || !(entity instanceof NeutralMob) && !(entity instanceof Enemy));
        listTeam.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        for (Mob raider : listTeam) {
            f += raider.m_21223_();
        }
        return f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22276_, 200.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, (LivingEntity)livingEntity)));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (OminousBannerProjectionEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_AMBIENT;
    }

    public int m_8100_() {
        return 600;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_HURT;
    }

    public SoundEvent m_7930_() {
        return JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_CHEER;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public SoundEvent getBossMusic() {
        return JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_MUSIC;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_20256_(Vec3 vec3) {
        super.m_20256_(new Vec3(0.0, vec3.f_82480_, 0.0));
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new NoRotationControl((Mob)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean m_142066_() {
        if (!this.isLastRound()) {
            return false;
        }
        return super.m_142066_();
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.isLastRound();
    }

    public boolean isLastRound() {
        return (Boolean)this.m_20088_().m_135370_(IS_LAST_ROUND);
    }

    public void setLastRound(boolean bl) {
        this.m_20088_().m_135381_(IS_LAST_ROUND, (Object)bl);
        this.f_19794_ = false;
        if (bl) {
            this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public boolean isSupplement() {
        return (Boolean)this.m_20088_().m_135370_(IS_SUPPLEMENT);
    }

    public void setSupplement(boolean bl) {
        this.m_20088_().m_135381_(IS_SUPPLEMENT, (Object)bl);
    }

    public boolean isLegend() {
        return (Boolean)this.m_20088_().m_135370_(IS_LEGEND);
    }

    public void setLegend(boolean bl) {
        this.m_20088_().m_135381_(IS_LEGEND, (Object)bl);
    }

    public boolean isLegendary() {
        return this.isLegend() || this.hasPercentageDamage() && this.hasDamageCap() && this.hasDamageCooldownTick();
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "round")) {
            return 1;
        }
        if (Objects.equals(animation, "dead")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.roundAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Faces", this.faces);
        compoundTag.m_128379_("IsLegend", this.isLegend());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("Round", this.round);
        compoundTag.m_128405_("MaxRound", this.maxRound);
        compoundTag.m_128379_("IsLastRound", this.isLastRound());
        compoundTag.m_128379_("IsSupplement", this.isSupplement());
        compoundTag.m_128347_("SupplementTick", this.supplementTick);
        compoundTag.m_128347_("SummonAmount", this.summonAmount);
        compoundTag.m_128347_("SummonAmountMax", this.summonAmountMax);
        compoundTag.m_128347_("SummonAmountStopMax", this.summonAmountStopMax);
        compoundTag.m_128350_("SummonMaxHealth", this.summonMaxHealth);
        compoundTag.m_128347_("Points", this.points);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.faces = compoundTag.m_128457_("Faces");
        this.setLegend(compoundTag.m_128471_("IsLegend"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.round = compoundTag.m_128451_("Round");
        this.maxRound = compoundTag.m_128451_("MaxRound");
        if (compoundTag.m_128441_("IsLastRound")) {
            this.setLastRound(compoundTag.m_128471_("IsLastRound"));
        }
        if (compoundTag.m_128441_("IsSupplement")) {
            this.setSupplement(compoundTag.m_128471_("IsSupplement"));
        }
        this.supplementTick = compoundTag.m_128459_("SupplementTick");
        this.summonAmount = compoundTag.m_128459_("SummonAmount");
        this.summonAmountMax = compoundTag.m_128459_("SummonAmountMax");
        this.summonAmountStopMax = compoundTag.m_128459_("SummonAmountStopMax");
        this.summonMaxHealth = compoundTag.m_128457_("SummonMaxHealth");
        this.points = compoundTag.m_128459_("Points");
        this.bossEvent.setId(this.m_20148_());
        float facing = 0.0f;
        if (this.faces > 0.75f) {
            facing = 90.0f;
        } else if (this.faces > 0.5f) {
            facing = 180.0f;
        } else if (this.faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_LAST_ROUND, (Object)false);
        this.m_20088_().m_135372_(IS_SUPPLEMENT, (Object)true);
        this.m_20088_().m_135372_(IS_LEGEND, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.roundAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.roundAnimationState);
                    break;
                }
                case 2: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        List listTeam = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listTeam.removeIf(entity -> entity instanceof OminousBannerProjectionEntity || !EntityFactionFind.isRaider((LivingEntity)entity) || !(entity instanceof NeutralMob) && !(entity instanceof Enemy));
        listTeam.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        if (!this.isLastRound() && this.f_20919_ == 0) {
            int i;
            int time1 = (int)Math.max(this.summonAmount / 20.0, 0.0);
            int time2 = (int)((this.summonAmount + (this.summonAmountStopMax - this.summonAmountMax)) / 20.0);
            this.bossEvent.m_6456_((Component)Component.m_237115_((String)"entity.jerotesvillage.ominous_banner_raid").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.ominous_banner_raid_round", (Object[])new Object[]{String.valueOf(this.round)})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.ominous_banner_raid_time", (Object[])new Object[]{time1, time2})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"entity.jerotesvillage.ominous_banner_raid_count", (Object[])new Object[]{listTeam.size()})));
            if (this.supplementTick < 1.0) {
                this.supplementTick += 0.01;
                if (!this.m_9236_().m_5776_()) {
                    this.setSupplement(true);
                }
                this.summonMaxHealth = 1.0f;
                this.summonAmount = this.summonAmountMax;
                this.points = OtherMainConfig.OminousBannerProjectionPointsBase * (double)Other.getRaidBossCount((LivingEntity)this);
                for (i = 1; i < this.round; ++i) {
                    this.points = this.points * OtherMainConfig.OminousBannerProjectionPointsRoundGrowthMultiple * (double)Other.getRaidBossCount((LivingEntity)this);
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setSupplement(false);
            }
            if (!this.isSupplement()) {
                if (this.summonAmount > this.summonAmountMax - this.summonAmountStopMax) {
                    this.summonAmount -= 1.0;
                    if (this.summonAmount <= 0.0 && this.getHealthOfLivingRaider() <= 0.0f) {
                        ++this.round;
                        this.supplementTick = 0.0;
                        if (!this.m_9236_().m_5776_()) {
                            this.setSupplement(true);
                        }
                    }
                } else {
                    ++this.round;
                    this.supplementTick = 0.0;
                    if (!this.m_9236_().m_5776_()) {
                        this.setSupplement(true);
                    }
                }
            }
            if (this.round > this.maxRound) {
                if (!this.m_9236_().m_5776_()) {
                    this.setLastRound(true);
                }
                this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
                this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
            }
            if (this.points > 0.0 && !this.isSupplement()) {
                int i2;
                EntityType randomEntity;
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.OMINOUS_BANNER_PROJECTION_ROUND, this.m_5720_(), 10.0f, 1.0f);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setAnimTick(10);
                    this.setAnimationState("round");
                }
                if (this.round == this.maxRound) {
                    block1: for (i = 0; i < 2; ++i) {
                        for (int counts = 0; counts < Other.getRaidBossCount((LivingEntity)this); ++counts) {
                            if (OtherMainConfig.OminousBannerProjectionAXCrazyCanAppear || this.m_5448_() != null && this.m_5448_().m_21205_().m_204117_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid_summon_special_elite_item")))) {
                                randomEntity = this.entityTypeFind("elite_special");
                                if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                                this.summonEntity(randomEntity, 1, 16);
                                this.points -= 60.0;
                                continue block1;
                            }
                            randomEntity = this.entityTypeFind("elite");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 60.0;
                            continue block1;
                        }
                    }
                }
                i = 1;
                while ((double)i < this.maxSpawn(1.0)) {
                    if (this.points > 20.0 && this.m_217043_().m_188501_() > 0.5f) {
                        for (i2 = 1; i2 < 5; ++i2) {
                            randomEntity = this.entityTypeFind("normal_xx");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 20.0;
                            break;
                        }
                    }
                    ++i;
                }
                i = 1;
                while ((double)i < this.maxSpawn(1.0)) {
                    if (this.points > 15.0) {
                        for (i2 = 1; i2 < 5; ++i2) {
                            randomEntity = this.entityTypeFind("normal_xv");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 15.0;
                            break;
                        }
                    }
                    ++i;
                }
                i = 1;
                while ((double)i < this.maxSpawn(3.0)) {
                    if (this.points > 12.0) {
                        for (i2 = 1; i2 < 5; ++i2) {
                            randomEntity = this.entityTypeFind("normal_xii");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 12.0;
                            break;
                        }
                    }
                    ++i;
                }
                i = 1;
                while ((double)i < this.maxSpawn(5.0)) {
                    if (this.points > 8.0) {
                        for (i2 = 1; i2 < 5; ++i2) {
                            randomEntity = this.entityTypeFind("normal_viii");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 8.0;
                            break;
                        }
                    }
                    ++i;
                }
                i = 1;
                while ((double)i < this.maxSpawn(20.0)) {
                    if (this.points > 0.0) {
                        for (i2 = 1; i2 < 5; ++i2) {
                            randomEntity = this.entityTypeFind("normal_i");
                            if (!this.BiomeCanUse(randomEntity) || randomEntity == EntityType.f_20548_) continue;
                            this.summonEntity(randomEntity, 1, 16);
                            this.points -= 1.0;
                            break;
                        }
                    }
                    ++i;
                }
                if (this.round >= this.maxRound) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setLastRound(true);
                    }
                    this.bossEvent.m_6456_(Objects.requireNonNull(this.m_5446_()));
                    this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
                }
            }
        }
        this.m_6862_(false);
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        }
        if (!this.m_9236_().f_46443_ && this.getBossMusic() != null) {
            Player player;
            LivingEntity livingEntity;
            if (!this.m_20067_() && (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_6084_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
    }

    public EntityType entityTypeFind(String string) {
        List entityTypes = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.tags()).getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/" + string))).stream().toList();
        if (!entityTypes.isEmpty()) {
            return (EntityType)entityTypes.get(this.m_9236_().f_46441_.m_188503_(entityTypes.size()));
        }
        return EntityType.f_20548_;
    }

    public boolean BiomeCanUse(EntityType entityType) {
        if (OtherMainConfig.OminousBannerProjectionBiomeIllagerCanAppearInOtherBiome) {
            return true;
        }
        Holder biome = this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()));
        if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/i"))) && entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/i_biome")))) {
            return false;
        }
        if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/ii"))) && entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/ii_biome")))) {
            return false;
        }
        if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/iii"))) && entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/iii_biome")))) {
            return false;
        }
        if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/iv"))) && entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/iv_biome")))) {
            return false;
        }
        if (!biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/v"))) && entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/v_biome")))) {
            return false;
        }
        return biome.m_203656_(TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/vi"))) || !entityType.m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("jerotesvillage", "ominous_banner_raid/vi_biome")));
    }

    public double maxSpawn(double n) {
        for (int i = 1; i < this.round; ++i) {
            n = n * OtherMainConfig.OminousBannerProjectionPointsRoundGrowthMultiple * (double)0.8f * (double)Other.getRaidBossCount((LivingEntity)this);
        }
        return n;
    }

    public void summonEntity(EntityType entityType, int count, int summonDistance) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entityType == null) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                BlockPos summonPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)this, (int)summonDistance);
                if ((double)summonPos.m_123342_() < this.m_20186_()) {
                    summonPos = this.m_20097_().m_7494_();
                }
                Entity entity = entityType.m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.MOB_SUMMONED);
                PlayerTeam teams = (PlayerTeam)this.m_5647_();
                if (entity == null) continue;
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(entity.m_20149_(), teams);
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (entity instanceof CanBeIllagerFactionEntity) {
                        CanBeIllagerFactionEntity canBeIllagerFactionEntity = (CanBeIllagerFactionEntity)entity;
                        canBeIllagerFactionEntity.setIllagerFaction(true);
                    }
                    if (entity.m_6095_() == JerotesVillageEntityType.GIANT_MONSTER.get() && entity instanceof GiantMonsterEntity) {
                        GiantMonsterEntity giantMonsterEntity = (GiantMonsterEntity)entity;
                        giantMonsterEntity.setIllagerFaction(true);
                        giantMonsterEntity.m_5853_(SoundSource.NEUTRAL);
                        giantMonsterEntity.equipArmor(null, new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_GIANT_BEAST_ARMOR.get()));
                    }
                }
                if (!(entity instanceof Mob)) continue;
                Mob mob = (Mob)entity;
                if (this.m_5448_() != null) {
                    mob.m_6710_(this.m_5448_());
                }
                if (!mob.m_20145_()) {
                    for (int i2 = 0; i2 < 32; ++i2) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20208_(0.5), mob.m_20187_(), mob.m_20262_(0.5), 0, mob.m_217043_().m_188583_(), 0.0, mob.m_217043_().m_188583_(), 0.0);
                    }
                }
                this.summonMaxHealth += mob.m_21233_();
            }
            serverLevel.m_220407_(GameEvent.f_157810_, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), GameEvent.Context.m_223717_((Entity)this));
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.bossEvent.update();
        if (this.f_19796_.m_188503_(240) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (!this.isLastRound()) {
            if (amount < 8000.0f) {
                if (damageSource.m_7639_() instanceof Player) {
                    this.summonAmount -= (double)amount;
                }
                return false;
            }
            return super.m_6469_(damageSource, amount);
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_8127_() {
        super.m_8127_();
        float facing = 0.0f;
        if (this.faces > 0.75f) {
            facing = 90.0f;
        } else if (this.faces > 0.5f) {
            facing = 180.0f;
        } else if (this.faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        float faces;
        this.faces = faces = this.m_9236_().m_213780_().m_188501_();
        float facing = 0.0f;
        if (faces > 0.75f) {
            facing = 90.0f;
        } else if (faces > 0.5f) {
            facing = 180.0f;
        } else if (faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_7822_(byte by) {
        if (by == 67) {
            BossMusicPlayer.playBossMusic((BossEntity)this);
        } else if (by == 68) {
            BossMusicPlayer.stopBossMusic((BossEntity)this);
        } else {
            super.m_7822_(by);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(40);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 40 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

