/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Humanoid;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.CarvedEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.ShiftKeyDownEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.entity.UseBowEntity;
import com.jerotes.jerotes.entity.UseCrossbowEntity;
import com.jerotes.jerotes.entity.UseDaggerEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.entity.WizardEntity;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIVMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpCarvedGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesPikeUseGoal;
import com.jerotes.jerotes.goal.JerotesRangedBowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedCrossbowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.tool.ItemToolBaseCrossbow;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.CarvedHoundEntity;
import com.jerotes.jerotesvillage.entity.Animal.CarvedLlamaEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.DefectorEntity;
import com.jerotes.jerotesvillage.entity.Neutral.CarvedAllayEntity;
import com.jerotes.jerotesvillage.entity.in.SkinEntity;
import com.jerotes.jerotesvillage.event.RelationshipEvent;
import com.jerotes.jerotesvillage.goal.HelpVillagerGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.item.CarvedFlag;
import com.jerotes.jerotesvillage.item.CarvedHorn;
import com.jerotes.jerotesvillage.item.CarvedHorseSlab;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public class CarvedVillagerEntity
extends AbstractVillager
implements SpellUseEntity,
SkinEntity,
UseDaggerEntity,
ShiftKeyDownEntity,
WizardEntity,
UseThrowEntity,
UseThrownJavelinEntity,
InventoryEntity,
CrossbowAttackMob,
NeutralMob,
RangedAttackMob,
InventoryCarrier,
UseCrossbowEntity,
UseBowEntity,
UseShieldEntity,
JerotesEntity,
CarvedEntity {
    private static final EntityDataAccessor<Integer> COMBAT_STYLE = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> USE_SELF_NOT_SPELL_LIST = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SKIN = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPECIAL_SKIN = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_FEMALE = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOW_LEVEL = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ILLAGER = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PIGLIN = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ENDERMAN = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_INVENTORY = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_MELEE_OR_RANGE = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_WEAPON = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_SHIELD = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHANGE_INVENTORY_COOLDOWN_TICK = SynchedEntityData.m_135353_(CarvedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final SimpleContainer inventory = new SimpleContainer(this.inventoryCount());
    private LazyOptional<?> itemHandler = null;
    public AnimationState armWideScaleAnimationState = new AnimationState();
    public AnimationState armSlimScaleAnimationState = new AnimationState();
    public int shieldCoolDown;
    public int shieldCanUse = 1;
    public int hornCoolDown;
    public int spellLevel = 1;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public CarvedVillagerEntity(EntityType<? extends CarvedVillagerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.m_21530_();
        this.applyOpenDoorsAbility();
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_252801_();
        this.itemHandler = LazyOptional.of(this::createCombinedHandler);
    }

    private IItemHandler createCombinedHandler() {
        EntityHandsInvWrapper handsHandler = new EntityHandsInvWrapper((LivingEntity)this);
        EntityArmorInvWrapper armorHandler = new EntityArmorInvWrapper((LivingEntity)this);
        InvWrapper customHandler = new InvWrapper((Container)this.inventory);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{armorHandler, handsHandler, customHandler});
    }

    public boolean isOffHandItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CarvedHorn;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionCopperCarvedCompany(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "copper_carved_company";
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_HELMET.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        if (OtherMainConfig.SpawnEggCarvedVillagerHasArmor) {
            this.m_8061_(equipmentSlot, itemStack);
        }
    }

    @VisibleForDebug
    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    protected ItemStack addToInventory(ItemStack itemStack) {
        return this.inventory.m_19173_(itemStack);
    }

    protected boolean canAddToInventory(ItemStack itemStack) {
        return this.inventory.m_19183_(itemStack);
    }

    public ItemStack m_255207_(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        boolean bl = this.m_7808_(itemStack, itemStack2);
        if (equipmentSlot.m_254934_() && !bl) {
            equipmentSlot = EquipmentSlot.MAINHAND;
            itemStack2 = this.m_6844_(equipmentSlot);
            bl = itemStack2.m_41619_();
        }
        if (bl && this.m_7252_(itemStack)) {
            double d = this.m_21519_(equipmentSlot);
            if (this.canAddToInventory(itemStack2)) {
                this.addToInventory(itemStack2);
            } else {
                this.m_19983_(itemStack2);
            }
            if (equipmentSlot.m_254934_() && itemStack.m_41613_() > 1) {
                ItemStack itemStack3 = itemStack.m_255036_(1);
                this.m_21468_(equipmentSlot, itemStack3);
                return itemStack3;
            }
            this.m_21468_(equipmentSlot, itemStack);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        return InventoryEntity.canReplaceCurrentItem((InventoryEntity)this, (ItemStack)newItem, (ItemStack)oldItem);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.5);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        super.m_7472_(damageSource, n, bl);
        this.inventory.m_19195_().forEach(arg_0 -> ((CarvedVillagerEntity)this).m_19983_(arg_0));
    }

    private void applyOpenDoorsAbility() {
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIMagicAttackGoal((PathfinderMob)this, 0.2, true, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIVMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedCrossbowAttackGoal((Mob)this, 1.0, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesSpearUseGoal((PathfinderMob)this, 1.0, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesPikeUseGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, IronGolem.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, CarvedAllayEntity.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, CarvedHoundEntity.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, CarvedLlamaEntity.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{CarvedEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpCarvedGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HelpVillagerGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        if (OtherMainConfig.CarvedObligation) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> !(!(mob instanceof Enemy) && !OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) || OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) || mob instanceof Creeper && !OtherMainConfig.CarvedActiveAttackCreeper)));
        } else {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) && !OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) && (!(mob instanceof Creeper) || OtherMainConfig.CarvedActiveAttackCreeper)));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, 5, false, false, mob -> !(mob instanceof NeutralMob) && !OtherMainConfig.CarvedNeverGonnaActiveAttack.contains(mob.m_20078_())));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 5, false, false, mob -> !(mob instanceof NeutralMob) && !OtherMainConfig.CarvedNeverGonnaActiveAttack.contains(mob.m_20078_())));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> {
            Player player;
            return livingEntity instanceof Player && RelationshipEvent.LessCopperCarvedCompanyRelationship(player = (Player)livingEntity, -500) && !this.trusts(player.m_20148_());
        }));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CarvedVillagerEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
        }
        if (InventoryEntity.isBow((ItemStack)handItem)) {
            this.useBowShoot((LivingEntity)this, livingEntity, f, this.getBowLevel(), 20);
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (InventoryEntity.isCrossbow((ItemStack)handItem)) {
            this.useCrossbowShoot((LivingEntity)this, 3.15f);
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public ItemStack m_6298_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)item;
            Predicate predicate = projectileWeaponItem.m_6442_();
            ItemStack itemStack2 = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            if (predicate.test(this.m_21205_())) {
                itemStack2 = this.m_21205_();
            } else if (predicate.test(this.m_21206_())) {
                itemStack2 = this.m_21206_();
            } else {
                for (int n = 0; n < this.inventoryCount(); ++n) {
                    ItemStack finds = this.mobInventory().m_8020_(n);
                    if (!predicate.test(finds)) continue;
                    itemStack2 = finds;
                    break;
                }
            }
            return itemStack2.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemStack2;
        }
        return ItemStack.f_41583_;
    }

    public AbstractArrow getCustomArrow(ItemStack itemStack, float f) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemStack, (float)f);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean bl) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)bl);
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float f) {
        float f2;
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item;
            f2 = itemToolBaseCrossbow.m_40945_(itemStack);
        } else {
            f2 = 3.15f;
        }
        this.m_32322_((LivingEntity)this, livingEntity, projectile, f, f2);
    }

    public void m_32322_(LivingEntity livingEntity, LivingEntity livingEntity2, Projectile projectile, float f, float f2) {
        double d0 = livingEntity2.m_20185_() - livingEntity.m_20185_();
        double d1 = livingEntity2.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = livingEntity2.m_20227_(0.3333333333333333) - projectile.m_20186_() + d2 * 0.1;
        Vector3f vector3f = this.m_252851_(livingEntity, new Vec3(d0, d3, d1), f);
        projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), f2, (float)Math.max(0, 20 - this.getBowLevel()) / 5.0f);
        livingEntity.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem instanceof BowItem || projectileWeaponItem instanceof CrossbowItem || super.m_5886_(projectileWeaponItem);
    }

    protected SoundEvent m_7515_() {
        if (this.f_19797_ <= 20) {
            return null;
        }
        if (this.m_5803_()) {
            return null;
        }
        if (this.isSkin()) {
            return null;
        }
        if (this.isEndermanRace()) {
            return this.m_5912_() ? SoundEvents.f_11850_ : SoundEvents.f_11899_;
        }
        if (this.isIllagerRace()) {
            return SoundEvents.f_12307_;
        }
        if (this.isPiglinRace()) {
            return SoundEvents.f_12239_;
        }
        return SoundEvents.f_12503_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        if (this.isSkin()) {
            return damageSource.m_269415_().f_268686_().m_269402_();
        }
        if (this.isEndermanRace()) {
            return SoundEvents.f_11849_;
        }
        if (this.isIllagerRace()) {
            return SoundEvents.f_12310_;
        }
        if (this.isPiglinRace()) {
            return SoundEvents.f_12244_;
        }
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        if (this.isSkin()) {
            return SoundEvents.f_12322_;
        }
        if (this.isEndermanRace()) {
            return SoundEvents.f_11900_;
        }
        if (this.isIllagerRace()) {
            return SoundEvents.f_12309_;
        }
        if (this.isPiglinRace()) {
            return SoundEvents.f_12242_;
        }
        return SoundEvents.f_12505_;
    }

    protected void m_7604_() {
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)JerotesVillageEntityType.CARVED_VILLAGER.get()).m_20615_((Level)serverLevel);
    }

    protected void m_8058_(MerchantOffer merchantOffer) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected Component m_5677_() {
        if (this.isEndermanRace()) {
            return Component.m_237115_((String)"entity.jerotesvillage.carved_villager.enderman");
        }
        if (this.isPiglinRace()) {
            return Component.m_237115_((String)"entity.jerotesvillage.carved_villager.piglin");
        }
        if (this.isIllagerRace()) {
            return Component.m_237115_((String)"entity.jerotesvillage.carved_villager.illager");
        }
        return Component.m_237115_((String)this.m_6095_().m_20675_());
    }

    public boolean isEmerald(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42616_)}).test(stack);
    }

    public void m_6593_(Component component) {
        String string = ChatFormatting.m_126649_((String)component.getString());
        super.m_6593_(component);
        if (string != null && !string.isEmpty() && OtherMainConfig.CarvedVillagerCustomNameWide.contains(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if (string != null && !string.isEmpty() && OtherMainConfig.CarvedVillagerCustomNameSlim.contains(string)) {
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Steve".equals(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Alex".equals(string)) {
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Ari".equals(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Kai".equals(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Noor".equals(string)) {
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Sunny".equals(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Zuri".equals(string)) {
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Efe".equals(string)) {
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Makena".equals(string)) {
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if ("Enderman".equals(string)) {
            this.setSkin(false);
            this.setEndermanRace(true);
            this.setIllagerRace(false);
            this.setPiglinRace(false);
        } else if ("Piglin".equals(string)) {
            this.setSkin(false);
            this.setEndermanRace(false);
            this.setIllagerRace(false);
            this.setPiglinRace(true);
        } else if ("Illager".equals(string)) {
            this.setSkin(false);
            this.setEndermanRace(false);
            this.setIllagerRace(true);
            this.setPiglinRace(false);
        } else if ("Villager".equals(string)) {
            this.setSkin(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else {
            this.setSkin(false);
        }
        this.m_20090_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isEndermanRace() && !this.isSkin()) {
            return super.m_6972_(pose).m_20390_(1.0f, 1.6111112f);
        }
        if (this.isPiglinRace() && !this.isSkin()) {
            return super.m_6972_(pose).m_20390_(1.0f, 1.0833334f);
        }
        return super.m_6972_(pose);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        if (this.isEndermanRace() && !this.isSkin()) {
            return this.m_6162_() ? 1.275f : 2.55f;
        }
        if (this.isPiglinRace() && !this.isSkin()) {
            float f = 1.79f;
            return this.m_6162_() ? f - 0.82f : f;
        }
        return this.m_6162_() ? 0.93f : 1.62f;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        if (this.isEndermanRace() && !this.isSkin()) {
            return new Vector3f(0.0f, entityDimensions.f_20378_ - 0.09375f * f, 0.0f);
        }
        return new Vector3f(0.0f, entityDimensions.f_20378_ + 0.0625f * f, 0.0f);
    }

    public boolean m_6126_() {
        return this.isEndermanRace() && !this.isSkin() && this.m_6844_(EquipmentSlot.HEAD).m_41619_() && this.m_6844_(EquipmentSlot.CHEST).m_41619_() && this.m_6844_(EquipmentSlot.LEGS).m_41619_() && this.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.7f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public boolean shieldCanUse() {
        return this.shieldCanUse == 1 && this.shieldCoolDown <= 0;
    }

    public boolean isSkin() {
        return (Boolean)this.m_20088_().m_135370_(SKIN);
    }

    public void setSkin(boolean bl) {
        this.m_20088_().m_135381_(SKIN, (Object)bl);
    }

    public int getSpecialSkin() {
        return (Integer)this.m_20088_().m_135370_(SPECIAL_SKIN);
    }

    public void setSpecialSkin(int n) {
        this.m_20088_().m_135381_(SPECIAL_SKIN, (Object)n);
    }

    public boolean isIllagerRace() {
        return (Boolean)this.m_20088_().m_135370_(ILLAGER);
    }

    public boolean isPiglinRace() {
        return (Boolean)this.m_20088_().m_135370_(PIGLIN);
    }

    public boolean isEndermanRace() {
        return (Boolean)this.m_20088_().m_135370_(ENDERMAN);
    }

    public void setIllagerRace(boolean bl) {
        this.m_20088_().m_135381_(ILLAGER, (Object)bl);
        this.m_20090_();
        this.m_6210_();
    }

    public void setPiglinRace(boolean bl) {
        this.m_20088_().m_135381_(PIGLIN, (Object)bl);
        this.m_20090_();
        this.m_6210_();
    }

    public void setEndermanRace(boolean bl) {
        this.m_20088_().m_135381_(ENDERMAN, (Object)bl);
        if (bl) {
            if (this.m_21172_(Attributes.f_22276_) < 40.0) {
                this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
            }
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(24.0);
        }
        this.m_20090_();
        this.m_6210_();
    }

    public int getCombatStyle() {
        return (Integer)this.m_20088_().m_135370_(COMBAT_STYLE);
    }

    public void setCombatStyle(int n) {
        this.m_20088_().m_135381_(COMBAT_STYLE, (Object)n);
    }

    public boolean isUseSelfNotStringSpellList() {
        return (Boolean)this.m_20088_().m_135370_(USE_SELF_NOT_SPELL_LIST);
    }

    public void setUseSelfNotStringSpellList(boolean bl) {
        this.m_20088_().m_135381_(USE_SELF_NOT_SPELL_LIST, (Object)bl);
    }

    public SimpleContainer mobInventory() {
        return this.inventory;
    }

    public int inventoryCount() {
        return 8;
    }

    public boolean isCanChangeInventory() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_INVENTORY);
    }

    public void setCanChangeInventory(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_INVENTORY, (Object)bl);
    }

    public boolean isCanChangeMeleeOrRange() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_MELEE_OR_RANGE);
    }

    public void setCanChangeMeleeOrRange(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_MELEE_OR_RANGE, (Object)bl);
    }

    public boolean NonCombatEmptyWeapon() {
        return this.isNoCombatEmptyWeapon();
    }

    public boolean NonCombatEmptyShield() {
        return this.isNoCombatEmptyShield();
    }

    public int changeInventoryCooldownTick() {
        return this.getChangeInventoryCooldownTick();
    }

    public boolean isNoCombatEmptyWeapon() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_WEAPON);
    }

    public void setNoCombatEmptyWeapon(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_WEAPON, (Object)bl);
    }

    public boolean isNoCombatEmptyShield() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_SHIELD);
    }

    public void setNoCombatEmptyShield(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_SHIELD, (Object)bl);
    }

    public int getChangeInventoryCooldownTick() {
        return (Integer)this.m_20088_().m_135370_(CHANGE_INVENTORY_COOLDOWN_TICK);
    }

    public void setChangeInventoryCooldownTick(int n) {
        this.m_20088_().m_135381_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)n);
    }

    public void SpellUseAfterAttack(String string, MagicType magicType, MagicType magicType2) {
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(10);
        }
    }

    public List<SpellTypeInterface> SelfMainSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public List<SpellTypeInterface> SelfAddSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public void setBowLevel(int n) {
        this.m_20088_().m_135381_(BOW_LEVEL, (Object)n);
    }

    public int getBowLevel() {
        return (Integer)this.m_20088_().m_135370_(BOW_LEVEL);
    }

    public void setShieldLevel(int n) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)n);
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    @Override
    public boolean IsFemale() {
        return (Boolean)this.m_20088_().m_135370_(IS_FEMALE);
    }

    public void setFemale(boolean bl) {
        this.m_20088_().m_135381_(IS_FEMALE, (Object)bl);
    }

    public boolean isMagicUseStyle() {
        return this.getSpellTick() > 0;
    }

    public boolean isSpellHumanoid() {
        return true;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listTag = new ListTag();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
        }
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128405_("BowLevel", this.getBowLevel());
        compoundTag.m_128405_("ShieldLevel", this.getShieldLevel());
        compoundTag.m_128405_("CombatStyle", this.getCombatStyle());
        compoundTag.m_128379_("UseSelfNotStringSpellList", this.isUseSelfNotStringSpellList());
        compoundTag.m_128379_("IsNoCombatEmptyWeapon", this.isNoCombatEmptyWeapon());
        compoundTag.m_128379_("IsNoCombatEmptyShield", this.isNoCombatEmptyShield());
        compoundTag.m_128405_("ChangeInventoryCooldownTick", this.getChangeInventoryCooldownTick());
        compoundTag.m_128379_("IsCanChangeInventory", this.isCanChangeInventory());
        compoundTag.m_128379_("IsCanChangeMeleeOrRange", this.isCanChangeMeleeOrRange());
        compoundTag.m_128379_("IsFemale", this.IsFemale());
        compoundTag.m_128379_("IsSkin", this.isSkin());
        compoundTag.m_128379_("IsIllager", this.isIllagerRace());
        compoundTag.m_128379_("IsPiglin", this.isPiglinRace());
        compoundTag.m_128379_("IsEnderman", this.isEndermanRace());
        compoundTag.m_128365_("Trusted", (Tag)listTag);
        compoundTag.m_128405_("ShieldCoolDown", this.shieldCoolDown);
        compoundTag.m_128405_("ShieldCanUse", this.shieldCanUse);
        compoundTag.m_128405_("HornCoolDown", this.hornCoolDown);
        compoundTag.m_128405_("SpecialSkin", this.getSpecialSkin());
        this.m_21678_(compoundTag);
        this.m_252802_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        ListTag listTag = compoundTag.m_128437_("Trusted", 11);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setBowLevel(compoundTag.m_128451_("BowLevel"));
        this.setShieldLevel(compoundTag.m_128451_("ShieldLevel"));
        this.setCombatStyle(compoundTag.m_128451_("CombatStyle"));
        this.setUseSelfNotStringSpellList(compoundTag.m_128471_("UseSelfNotStringSpellList"));
        this.shieldCoolDown = compoundTag.m_128451_("ShieldCoolDown");
        this.shieldCanUse = compoundTag.m_128451_("ShieldCanUse");
        this.hornCoolDown = compoundTag.m_128451_("HornCoolDown");
        for (Tag tag : listTag) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)tag));
        }
        this.setNoCombatEmptyWeapon(compoundTag.m_128471_("IsNoCombatEmptyWeapon"));
        this.setNoCombatEmptyShield(compoundTag.m_128471_("IsNoCombatEmptyShield"));
        this.setChangeInventoryCooldownTick(compoundTag.m_128451_("ChangeInventoryCooldownTick"));
        this.setCanChangeInventory(compoundTag.m_128471_("IsCanChangeInventory"));
        this.setCanChangeMeleeOrRange(compoundTag.m_128471_("IsCanChangeMeleeOrRange"));
        this.setSkin(compoundTag.m_128471_("IsSkin"));
        this.setFemale(compoundTag.m_128471_("IsFemale"));
        this.setIllagerRace(compoundTag.m_128471_("IsIllager"));
        this.setPiglinRace(compoundTag.m_128471_("IsPiglin"));
        if (compoundTag.m_128471_("IsEnderman")) {
            this.setEndermanRace(compoundTag.m_128471_("IsEnderman"));
        }
        if (compoundTag.m_128451_("SpecialSkin") == 1) {
            this.m_6593_((Component)Component.m_237113_((String)"Sentnes"));
            this.setSpecialSkin(1);
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if (compoundTag.m_128451_("SpecialSkin") == 2) {
            this.m_6593_((Component)Component.m_237113_((String)"Maid"));
            this.setSpecialSkin(2);
            this.setSkin(true);
            this.setFemale(true);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        } else if (compoundTag.m_128451_("SpecialSkin") == 3) {
            this.m_6593_((Component)Component.m_237113_((String)"Jerotes"));
            this.setSpecialSkin(3);
            this.setSkin(true);
            this.setFemale(false);
            this.setEndermanRace(false);
            this.setPiglinRace(false);
            this.setIllagerRace(false);
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.m_253224_(compoundTag);
        this.m_20011_(this.m_142242_());
        if (compoundTag.m_128425_("Health", 99)) {
            this.m_21153_(compoundTag.m_128457_("Health"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(BOW_LEVEL, (Object)15);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)1);
        this.m_20088_().m_135372_(USE_SELF_NOT_SPELL_LIST, (Object)true);
        this.m_20088_().m_135372_(COMBAT_STYLE, (Object)1);
        this.m_20088_().m_135372_(IS_FEMALE, (Object)false);
        this.m_20088_().m_135372_(SKIN, (Object)false);
        this.m_20088_().m_135372_(SPECIAL_SKIN, (Object)0);
        this.m_20088_().m_135372_(ILLAGER, (Object)false);
        this.m_20088_().m_135372_(PIGLIN, (Object)false);
        this.m_20088_().m_135372_(ENDERMAN, (Object)false);
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.m_20088_().m_135372_(DATA_TYPE_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
        this.m_20088_().m_135372_(CAN_CHANGE_INVENTORY, (Object)false);
        this.m_20088_().m_135372_(CAN_CHANGE_MELEE_OR_RANGE, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_WEAPON, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_SHIELD, (Object)false);
        this.m_20088_().m_135372_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)50);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (SKIN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (SPECIAL_SKIN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ILLAGER.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (PIGLIN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ENDERMAN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public List<UUID> getTrustedUUIDs() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return arrayList;
    }

    void addTrustedUUID(@Nullable UUID uUID) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(uUID));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(uUID));
        }
    }

    protected void m_5502_(Player player, Mob mob) {
        this.addTrustedUUID(player.m_20148_());
    }

    public boolean trusts(UUID uUID) {
        return this.getTrustedUUIDs().contains(uUID);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_41720_() instanceof CarvedFlag) {
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                if (this.isSkin()) {
                    this.m_5496_(SoundEvents.f_12315_, 1.0f, f1);
                } else if (this.isEndermanRace()) {
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, f1);
                } else if (this.isIllagerRace()) {
                    this.m_5496_(SoundEvents.f_12308_, 1.0f, f1);
                } else if (this.isPiglinRace()) {
                    this.m_5496_(SoundEvents.f_12241_, 1.0f, f1);
                } else {
                    this.m_5496_(SoundEvents.f_12509_, 1.0f, f1);
                }
            }
            return InteractionResult.PASS;
        }
        if (!this.m_5912_() && this.isEmerald(itemstack)) {
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 12000, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 12000, 4));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 3));
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                if (this.isSkin()) {
                    this.m_5496_(SoundEvents.f_12315_, 1.0f, f1);
                } else if (this.isEndermanRace()) {
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, f1);
                } else if (this.isIllagerRace()) {
                    this.m_5496_(SoundEvents.f_12308_, 1.0f, f1);
                } else if (this.isPiglinRace()) {
                    this.m_5496_(SoundEvents.f_12241_, 1.0f, f1);
                } else {
                    this.m_5496_(SoundEvents.f_12509_, 1.0f, f1);
                }
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            float f = (float)this.m_20186_();
            Vec3 vec3 = this.m_20184_();
            for (int i = 0; i < 10; ++i) {
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)f2, (double)(f + 2.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            this.m_21553_(false);
            this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 2.0f;
            this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = 2.0f;
            this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = 2.0f;
            this.f_21348_[EquipmentSlot.FEET.m_20749_()] = 2.0f;
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = 2.0f;
            if (!this.trusts(player.m_20148_())) {
                RelationshipEvent.AddCopperCarvedCompanyRelationship(player, 5);
            }
            this.addTrustedUUID(player.m_20148_());
            return InteractionResult.SUCCESS;
        }
        if (!(!this.trusts(player.m_20148_()) || this.isEmerald(itemstack) || itemstack.m_41720_() instanceof CarvedFlag || itemstack.m_41720_() instanceof CarvedHorseSlab || player.m_36341_())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Main.openMobInventoryGui((ServerPlayer)serverPlayer, (LivingEntity)this, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean trustsBy(Player player) {
        float f = (float)this.m_20186_();
        Vec3 vec3 = this.m_20184_();
        for (int i = 0; i < 10; ++i) {
            float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
            float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)f2, (double)(f + 2.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
        this.m_21553_(false);
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.CHEST.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.LEGS.m_20749_()] = 2.0f;
        this.f_21348_[EquipmentSlot.FEET.m_20749_()] = 2.0f;
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = 2.0f;
        this.addTrustedUUID(player.m_20148_());
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.IsFemale()) {
            this.armSlimScaleAnimationState.m_216973_();
            this.armWideScaleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.armWideScaleAnimationState.m_216973_();
            this.armSlimScaleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.isEndermanRace() && !this.isSkin()) {
            this.m_21441_(BlockPathTypes.WATER, -1.0f);
        } else {
            this.m_21441_(BlockPathTypes.WATER, 8.0f);
        }
        if (this.isEndermanRace() && !this.isSkin() && this.m_5448_() != null) {
            if (this.m_5448_().m_20280_((Entity)this) < 16.0 && this.f_19796_.m_188501_() > 0.95f) {
                this.teleport();
            } else if (this.m_5448_().m_20280_((Entity)this) > 256.0 && this.f_19796_.m_188501_() > 0.95f) {
                this.teleportTowards((Entity)this.m_5448_());
            }
        }
    }

    public void m_8107_() {
        LivingEntity livingVehicle;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        this.m_21203_();
        this.updateNoActionTime();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
        }
        if (this.isEndermanRace() && !this.isSkin() && this.m_9236_().f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
            this.shieldCanUse = 0;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCanUse = 1;
        }
        if (this.hornCoolDown > 0) {
            --this.hornCoolDown;
        }
        if (this.m_6084_() && this.m_20202_() != null && (livingEntity = this.m_20202_()) instanceof LivingEntity && (livingVehicle = livingEntity).m_6084_() && !this.m_9236_().f_46443_) {
            livingVehicle.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10, 1, false, false));
        }
        Main.destroyRides((Mob)this);
        this.useBlockingItem((Mob)this);
        this.changeInventory((Mob)this);
        if (this.m_5912_() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_21206_().m_41720_() instanceof CarvedHorn && this.f_19796_.m_188503_(40) == 1 && this.hornCoolDown <= 0) {
            PlayerTeam teams = (PlayerTeam)this.m_5647_();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.CARVED_HORN_USE, SoundSource.NEUTRAL, 20.0f, 1.0f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 1.2f) + 0.5f);
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
            double d = Double.MAX_VALUE;
            for (LivingEntity livingEntity2 : list) {
                Mob mob;
                Player player1;
                if (livingEntity2 == null || livingEntity2.m_20280_((Entity)livingEntity2) > d || (teams == null ? !OtherEntityFactionFind.isCarved(livingEntity2.m_6095_()) && (!(livingEntity2 instanceof Player) || !RelationshipEvent.MoreCopperCarvedCompanyRelationship(player1 = (Player)livingEntity2, 500)) : !this.m_7307_((Entity)livingEntity2))) continue;
                if (livingEntity2 == this.m_5448_() || livingEntity2 instanceof Mob && this == (mob = (Mob)livingEntity2).m_5448_() || this.m_9236_().f_46443_) continue;
                livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 240, 0));
                livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 240, 0));
                livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 240, 0));
                livingEntity2.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 240, 0));
            }
            this.hornCoolDown = 120;
        }
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ = (int)((double)this.f_20891_ + 1.1);
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        if (bl && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return bl;
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn instanceof BreakShieldEntity) {
            BreakShieldEntity breakShield = (BreakShieldEntity)entityIn;
            this.disableShieldBreak(breakShield.getShieldBreakStrength());
        }
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn) || entityIn.m_213824_()) {
            this.disableShield();
        }
        this.disableShieldTry();
    }

    public boolean isDamageSourceBlocks(DamageSource damageSource) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = this.m_20171_(0.0f, this.m_6080_());
            Vec3 vec32 = object.m_82505_(this.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    protected void m_7909_(float f) {
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_SHIELD_CAN_BREAK) && this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && f >= 3.0f) {
            int n = 1 + Mth.m_14143_((float)f);
            InteractionHand interactionHand = this.m_7655_();
            this.f_20935_.m_41622_(n, (LivingEntity)this, player -> player.m_21190_(interactionHand));
            if (this.f_20935_.m_41619_()) {
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void disableShield() {
        if (this.m_217043_().m_188501_() <= 1.0f - (float)(this.getShieldLevel() - 1) * 0.2f) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldTry() {
        if ((double)this.m_217043_().m_188501_() <= 0.15 - (double)((float)(this.getShieldLevel() - 1) * 0.05f)) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldBreak(int tick) {
        if (tick == 0) {
            return;
        }
        if (this.shieldCoolDown < tick) {
            this.shieldCoolDown = tick;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (JerotesGameRules.JEROTES_ARMOR_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_ARMOR_CAN_BREAK) && damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
            if (!damageSource.m_276093_(DamageTypes.f_268468_) || !head.m_41720_().m_41475_() && !damageSource.m_269533_(DamageTypeTags.f_268490_)) {
                if (head.m_41720_() instanceof ArmorItem) {
                    head.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.HEAD));
                }
                if (chest.m_41720_() instanceof ArmorItem) {
                    chest.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.CHEST));
                }
                if (legs.m_41720_() instanceof ArmorItem) {
                    legs.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.LEGS));
                }
                if (feet.m_41720_() instanceof ArmorItem) {
                    feet.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        if (!this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 660, 0));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        Player player;
        Entity entity;
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        if (this.isEndermanRace() && !this.isSkin() && damageSource.m_269533_(DamageTypeTags.f_268524_)) {
            boolean bl2 = damageSource.m_7640_() instanceof ThrownPotion;
            boolean bl22 = bl2 && this.hurtWithCleanWater(damageSource, (ThrownPotion)damageSource.m_7640_(), f);
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return bl22;
        }
        if (this.isEndermanRace() && !this.isSkin() && !this.m_9236_().m_5776_() && !(damageSource.m_7639_() instanceof LivingEntity) && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        if ((bl = super.m_6469_(damageSource, f)) && (entity = damageSource.m_7639_()) instanceof Player && !this.trusts((player = (Player)entity).m_20148_()) && this.m_5448_() == null) {
            RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -2);
        }
        return bl;
    }

    private boolean hurtWithCleanWater(DamageSource damageSource, ThrownPotion thrownPotion, float f) {
        ItemStack itemStack = thrownPotion.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
        List list = PotionUtils.m_43547_((ItemStack)itemStack);
        boolean bl = potion == Potions.f_43599_ && list.isEmpty();
        boolean bl2 = bl;
        if (bl) {
            return super.m_6469_(damageSource, f);
        }
        return false;
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        Player player;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.trusts(entity.m_20148_())) {
            return true;
        }
        if (entity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)entity, 500)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        Player player;
        DefectorEntity defector;
        if (this.trusts(livingEntity.m_20148_())) {
            return false;
        }
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        if (OtherMainConfig.CarvedCanNotAttackList.contains(livingEntity.m_20078_())) {
            return false;
        }
        if (livingEntity instanceof DefectorEntity && (defector = (DefectorEntity)livingEntity).m_5448_() != this && !defector.isMustEnemy()) {
            return false;
        }
        if (livingEntity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)livingEntity, 500)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    protected boolean teleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double d = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(32) - 16);
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
        return this.teleport(d, d2, d3);
    }

    boolean teleportTowards(Entity entity) {
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), this.m_20227_(0.5) - entity.m_20188_(), this.m_20189_() - entity.m_20189_());
        vec3 = vec3.m_82541_();
        double d = 8.0;
        double d2 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vec3.f_82479_ * 8.0;
        double d3 = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 4) - vec3.f_82480_ * 8.0;
        double d4 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 4.0 - vec3.f_82481_ * 8.0;
        return this.teleport(d2, d3, d4);
    }

    private boolean teleport(double d, double d2, double d3) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(d, d2, d3);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!bl || bl2) {
            return false;
        }
        Vec3 vec3 = this.m_20182_();
        boolean bl3 = this.m_20984_(d, d2, d3, true);
        if (bl3) {
            this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            this.m_213946_(randomSource, difficultyInstance);
            RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
            if (randomSourceSkin.m_188501_() < 0.05f) {
                this.setEndermanRace(false);
                this.setIllagerRace(true);
                this.setPiglinRace(false);
            } else if (randomSourceSkin.m_188501_() < 0.075f) {
                this.setEndermanRace(false);
                this.setIllagerRace(false);
                this.setPiglinRace(true);
            } else if (randomSourceSkin.m_188501_() < 0.08f) {
                this.setEndermanRace(true);
                this.setIllagerRace(false);
                this.setPiglinRace(false);
            } else {
                this.setEndermanRace(false);
                this.setIllagerRace(false);
                this.setPiglinRace(false);
            }
            this.m_21153_(this.m_21233_());
            float weaponRandom = this.f_19796_.m_188501_();
            this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon(weaponRandom));
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public ItemStack createSpawnWeapon(float weaponRandom) {
        if ((double)weaponRandom > 0.6) {
            return new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_JAVELIN.get());
        }
        if ((double)weaponRandom > 0.5) {
            return new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_AXE.get());
        }
        if ((double)weaponRandom > 0.1) {
            return new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_SWORD.get());
        }
        return new ItemStack((ItemLike)JerotesVillageItems.VILLAGER_METAL_BOW.get());
    }

    public void m_6667_(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -10);
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && !this.getTrustedUUIDs().isEmpty()) {
            List<UUID> list = this.getTrustedUUIDs();
            for (UUID uUID : list) {
                ServerLevel serverLevel;
                Level level;
                if (uUID == null || !(this.m_9236_() instanceof ServerLevel) || !((level = this.m_9236_()) instanceof ServerLevel) || !((level = (serverLevel = (ServerLevel)level).m_8791_(uUID)) instanceof Player)) continue;
                Player player = (Player)level;
                player.m_213846_(this.m_21231_().m_19293_());
            }
        }
        super.m_6667_(damageSource);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

