/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.MagicSummoned.Botanize;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CelestialCoilvineEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Botanize.CoilvineBotanizeEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.MagicSummonedEntity;
import com.jerotes.jerotesvillage.event.AdvancementEvent;
import com.jerotes.jerotesvillage.goal.BotanizeFindAltarGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class BotanizeEntity
extends MagicSummonedEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState tiltAnimationState = new AnimationState();
    public AnimationState growAnimationState = new AnimationState();
    public AnimationState giveAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BotanizeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(BotanizeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TILT_TICK = SynchedEntityData.m_135353_(BotanizeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GROW_TICK = SynchedEntityData.m_135353_(BotanizeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GIVE_TICK = SynchedEntityData.m_135353_(BotanizeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public String giftItem = "jerotesvillage:gameplay/jerotesvillage_other/botanize_gift";

    public BotanizeEntity(EntityType<? extends BotanizeEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21530_();
        this.applyOpenDoorsAbility();
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionBotanizeVillage(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "botanize_village";
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    private void applyOpenDoorsAbility() {
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BotanizeFindAltarGoal(this));
        if (!(this instanceof CoilvineBotanizeEntity)) {
            this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        }
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, CelestialCoilvineEntity.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, (LivingEntity)livingEntity)));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void setTiltTick(int n) {
        this.m_20088_().m_135381_(TILT_TICK, (Object)n);
    }

    public int getTiltTick() {
        return (Integer)this.m_20088_().m_135370_(TILT_TICK);
    }

    public void setGiveTick(int n) {
        this.m_20088_().m_135381_(GIVE_TICK, (Object)n);
    }

    public int getGiveTick() {
        return (Integer)this.m_20088_().m_135370_(GIVE_TICK);
    }

    public void setGrowTick(int n) {
        this.m_20088_().m_135381_(GROW_TICK, (Object)n);
    }

    public int getGrowTick() {
        return (Integer)this.m_20088_().m_135370_(GROW_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "tilt")) {
            return 1;
        }
        if (Objects.equals(animation, "grow")) {
            return 2;
        }
        if (Objects.equals(animation, "give")) {
            return 3;
        }
        if (Objects.equals(animation, "shoot")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.tiltAnimationState);
        list.add(this.growAnimationState);
        list.add(this.giveAnimationState);
        list.add(this.shootAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("TiltTick", this.getTiltTick());
        compoundTag.m_128405_("GrowTick", this.getGrowTick());
        compoundTag.m_128405_("GiveTick", this.getGiveTick());
        compoundTag.m_128359_("GiftItem", this.giftItem);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setTiltTick(compoundTag.m_128451_("TiltTick"));
        this.setGrowTick(compoundTag.m_128451_("GrowTick"));
        this.setGiveTick(compoundTag.m_128451_("GiveTick"));
        this.giftItem = compoundTag.m_128461_("GiftItem");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(TILT_TICK, (Object)0);
        this.m_20088_().m_135372_(GROW_TICK, (Object)0);
        this.m_20088_().m_135372_(GIVE_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.tiltAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.tiltAnimationState);
                    break;
                }
                case 2: {
                    this.growAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.growAnimationState);
                    break;
                }
                case 3: {
                    this.giveAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.giveAnimationState);
                    break;
                }
                case 4: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ServerPlayer serverPlayer;
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!this.isTame() && !this.m_5912_() && this.m_5448_() == null && MainConfig.MobSayQuestionMark && !this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            if (interactionHand == InteractionHand.MAIN_HAND) {
                serverPlayer.m_213846_((Component)Component.m_237110_((String)"talk.jerotesvillage.normal", (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
            }
        }
        if (!(this.m_5912_() || this.m_5448_() != null || this instanceof CoilvineBotanizeEntity || player.m_6144_())) {
            if (this.getTiltTick() <= 0 && this.getGiveTick() <= 0) {
                if (!this.m_9236_().m_5776_()) {
                    this.setTiltTick(60);
                    this.setAnimTick(60);
                    this.setAnimationState("tilt");
                }
                return InteractionResult.SUCCESS;
            }
            if (this.getTiltTick() > 0 && this.getGiveTick() <= 0 && !itemStack.m_41619_()) {
                if (itemStack.m_204117_(ItemTags.f_13149_) && player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    AdvancementEvent.AdvancementGive(serverPlayer, "jerotesvillage:beautiful_world");
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setTiltTick(0);
                    this.setGiveTick(70);
                    this.setAnimTick(70);
                    this.setAnimationState("give");
                }
                this.swapItem(player, itemStack, interactionHand);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    private boolean swapItem(Player player, ItemStack itemStack, InteractionHand interactionHand) {
        ItemStack itemStack2 = this.m_6844_(EquipmentSlot.MAINHAND);
        if (player.m_150110_().f_35937_ && itemStack2.m_41619_() && !itemStack.m_41619_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_255036_(1));
            return true;
        }
        if (!itemStack.m_41619_() && itemStack.m_41613_() > 1) {
            if (!itemStack2.m_41619_()) {
                return false;
            }
            this.m_8061_(EquipmentSlot.MAINHAND, itemStack.m_41620_(1));
            return true;
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
        player.m_21008_(interactionHand, itemStack2);
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
        return true;
    }

    @Override
    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(300) == 1 && this.m_6084_()) {
            this.m_5634_(6.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ % 3 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_276452_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setTiltTick(Math.max(0, this.getTiltTick() - 1));
            this.setGiveTick(Math.max(0, this.getGiveTick() - 1));
            this.setGrowTick(Math.max(0, this.getGrowTick() - 1));
        }
        if (this.getTiltTick() > 0 || this.getGiveTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
            this.m_21573_().m_26573_();
        }
        if (this.getGiveTick() == 5) {
            this.giveGift();
        }
        if (this.f_19796_.m_188503_(600) == 1 && this.getGrowTick() <= 0 && this.m_6084_() && !this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            AABB aABB = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aABB.f_82288_), (int)Mth.m_14107_((double)aABB.f_82289_), (int)Mth.m_14107_((double)aABB.f_82290_), (int)Mth.m_14107_((double)aABB.f_82291_), (int)Mth.m_14107_((double)aABB.f_82292_), (int)Mth.m_14107_((double)aABB.f_82293_))) {
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                Block block = blockState.m_60734_();
                BlockState blockState1 = null;
                if (!blockState.m_204336_(BlockTags.f_13074_)) continue;
                if (block instanceof CropBlock) {
                    CropBlock cropblock = (CropBlock)block;
                    if (!cropblock.m_52307_(blockState)) {
                        blockState1 = cropblock.m_52289_(cropblock.m_52305_(blockState) + 1);
                    }
                } else if (block instanceof StemBlock) {
                    int k = (Integer)blockState.m_61143_((Property)StemBlock.f_57013_);
                    if (k < 7) {
                        blockState1 = (BlockState)blockState.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(k + 1));
                    }
                } else if (blockState.m_60713_(Blocks.f_50685_)) {
                    int j = (Integer)blockState.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                    if (j < 3) {
                        blockState1 = (BlockState)blockState.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(j + 1));
                    }
                } else if (blockState.m_60713_(Blocks.f_152538_) || blockState.m_60713_(Blocks.f_152539_)) {
                    ((BonemealableBlock)blockState.m_60734_()).m_214148_((ServerLevel)this.m_9236_(), this.f_19796_, blockPos, blockState);
                }
                if (blockState1 == null) continue;
                this.m_9236_().m_46796_(2005, blockPos, 0);
                this.m_9236_().m_46597_(blockPos, blockState1);
                this.setGrowTick(120);
            }
        }
        if (this.getGrowTick() == 115) {
            this.setAnimTick(20);
            this.setAnimationState("grow");
        }
    }

    public void giveGift() {
        if (this.m_9236_() instanceof ServerLevel) {
            ItemStack getItems = this.m_6844_(EquipmentSlot.MAINHAND);
            if (getItems.m_150930_((Item)JerotesVillageItems.WONDERLAND_SAPLING.get())) {
                this.cloneFriend();
                return;
            }
            if (getItems.m_204117_(ItemTags.f_13149_)) {
                BlockPos blockPos = new BlockPos((int)this.m_20185_(), (int)this.m_20188_(), (int)this.m_20189_());
                ObjectListIterator objectListIterator = this.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation(this.giftItem)).m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_287286_(LootContextParams.f_81461_, (Object)this.m_9236_().m_8055_(blockPos)).m_287289_(LootContextParams.f_81462_, (Object)this.m_9236_().m_7702_(blockPos)).m_287235_(LootContextParamSets.f_81410_)).iterator();
                while (objectListIterator.hasNext()) {
                    ItemStack drop;
                    getItems = drop = (ItemStack)objectListIterator.next();
                }
            }
            this.m_19983_(getItems);
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
            this.m_5496_(JerotesVillageSounds.BOTANIZE_GIFT, 1.0f, 1.0f);
        }
    }

    public void cloneFriend() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PlayerTeam teams = (PlayerTeam)this.m_5647_();
            BotanizeEntity botanize = serverLevel.m_8055_(this.m_20097_().m_7495_()).m_60795_() ? (BotanizeEntity)((EntityType)JerotesVillageEntityType.BOTANIZE.get()).m_262496_(serverLevel, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), MobSpawnType.MOB_SUMMONED) : (BotanizeEntity)((EntityType)JerotesVillageEntityType.BOTANIZE.get()).m_262496_(serverLevel, this.m_20097_().m_7494_(), MobSpawnType.MOB_SUMMONED);
            if (botanize != null) {
                if (teams != null) {
                    serverLevel.m_6188_().m_6546_(botanize.m_20149_(), teams);
                }
                for (int i = 0; i < 30; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, this.m_20208_(1.0), this.m_20187_(), this.m_20208_(1.0), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            serverLevel.m_220407_(GameEvent.f_157810_, new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_()), GameEvent.Context.m_223717_((Entity)this));
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_41852_));
            this.m_5496_(JerotesVillageSounds.BOTANIZE_GIFT, 1.0f, 1.0f);
        }
    }

    public SoundEvent m_7515_() {
        return JerotesVillageSounds.BOTANIZE_AMBIENT;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BOTANIZE_HURT;
    }

    public SoundEvent m_5592_() {
        return JerotesVillageSounds.BOTANIZE_DEATH;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.DAZZLING_LIGHT.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof CelestialCoilvineEntity) {
            AbstractArrow arrow;
            Entity entity;
            CelestialCoilvineEntity celestialCoilvineEntity = (CelestialCoilvineEntity)livingEntity;
            if (damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_269533_(DamageTypeTags.f_268419_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                amount *= 2.0f;
            }
            if (damageSource.m_7640_() != null && (entity = damageSource.m_7640_()) instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_6060_() || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                amount *= 1.5f;
            } else if (EntityAndItemFind.isMeleeDamage((DamageSource)damageSource) && (entity = damageSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                ItemStack handItem = livingEntity2.m_21205_();
                if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand((LivingEntity)livingEntity2)) {
                    handItem = livingEntity2.m_21206_();
                }
                if (handItem.getEnchantmentLevel(Enchantments.f_44981_) > 0) {
                    amount *= 1.5f;
                }
            }
        } else if (damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_269533_(DamageTypeTags.f_268419_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            amount *= 1.25f;
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl && this.getGiveTick() > 5) {
            this.giveGift();
            this.setAnimTick(70);
        }
        return bl;
    }
}

