/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge;

import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge.SeawaveEntity;
import com.jerotes.jerotesvillage.entity.MagicSummoned.MagicSummonedEntity;
import com.jerotes.jerotesvillage.goal.BulgeFloatGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class BulgeEntity
extends MagicSummonedEntity
implements RangedAttackMob,
SpellUseEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BulgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(BulgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellLevel = 1;

    public BulgeEntity(EntityType<? extends BulgeEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            super.m_7023_(vec3);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        if (!(this instanceof SeawaveEntity)) {
            this.f_21345_.m_25352_(0, (Goal)new BulgeFloatGoal((Mob)this, 0.35f));
            this.f_21345_.m_25352_(1, (Goal)new BulgeRangedAttackGoal());
            this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        }
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("shoot");
        }
        OtherSpellList.BulgeBullet(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        return builder;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public SoundEvent m_7515_() {
        return JerotesVillageSounds.BULGE_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BULGE_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BULGE_DEATH;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "shoot")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.shootAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (!(this instanceof SeawaveEntity) && ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_6063_() {
        return false;
    }

    public int m_8100_() {
        return 480;
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.125f;
    }

    @Override
    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20095_();
        if (!(this instanceof SeawaveEntity) && this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    class BulgeRangedAttackGoal
    extends RangedAttackGoal {
        public BulgeRangedAttackGoal() {
            super((RangedAttackMob)BulgeEntity.this, 1.0, 60, 20.0f);
        }

        public void m_8056_() {
            super.m_8056_();
            BulgeEntity.this.m_21561_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            BulgeEntity.this.m_21561_(false);
        }
    }
}

