/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.MagicSummoned.IronTeeth;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotesvillage.entity.MagicSummoned.MagicSummonedEntity;
import com.jerotes.jerotesvillage.goal.IronTeethMeleeAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class IronTeethEntity
extends MagicSummonedEntity
implements JerotesEntity {
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(IronTeethEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public IronTeethEntity(EntityType<? extends IronTeethEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new IronTeethMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAttackAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 4.0f, 1.0, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.38);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22284_, 15.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.1);
        builder = builder.m_22268_(Attributes.f_22281_, 18.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.6);
        return builder;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.IRON_TEETH_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.IRON_TEETH_DEATH;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268581_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.25f;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/iron")))) {
            this.repair(player, itemStack);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-50, this.getAttackTick() - 1));
        }
    }

    public boolean repair(Player player, ItemStack itemStack) {
        this.m_5634_(this.m_21233_() / 8.0f);
        float f2 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        this.m_5496_(JerotesSounds.REPAIR_MOB, 1.0f, f2);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return true;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getAttackTick() > -50) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(10);
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.IRON_TEETH_ATTACK, 1.0f, 1.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.BLEEDING.get(), 60, 0, false, false), (Entity)this);
                }
            }
        }
        return bl;
    }
}

