/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesItems;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class BitterColdWindEntity
extends Monster
implements JerotesEntity {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BitterColdWindEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = livingEntity -> livingEntity.m_21023_((MobEffect)JerotesVillageMobEffects.BITTER_COLD.get());

    public BitterColdWindEntity(EntityType<? extends BitterColdWindEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.1f);
        this.f_21364_ = 5;
        this.m_21553_(true);
    }

    public boolean m_7243_(ItemStack itemStack) {
        if (itemStack.canEquip(EquipmentSlot.HEAD, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.CHEST, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.LEGS, (Entity)this)) {
            return false;
        }
        if (itemStack.canEquip(EquipmentSlot.FEET, (Entity)this)) {
            return false;
        }
        return super.m_7243_(itemStack);
    }

    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        if (oldItem.m_150930_(Items.f_42363_)) {
            return false;
        }
        if (newItem.m_150930_(Items.f_42363_)) {
            return true;
        }
        return InventoryEntity.canReplaceCurrentItem((ItemStack)newItem, (ItemStack)oldItem, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21346_.m_25352_(1, (Goal)new HelpCorrosiverGoal(LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, true, PREY_SELECTOR));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.38);
        builder = builder.m_22268_(Attributes.f_22276_, 26.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22282_, 3.6);
        builder = builder.m_22268_(Attributes.f_22278_, 0.0);
        return builder;
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(d * 3.0, d2 * 3.0, d3 * 3.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(d * 3.0, d2 * 3.0, d3 * 3.0);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BITTER_COLD_WIND_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BITTER_COLD_WIND_AMBIENT;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.8f;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean bl) {
        byte by = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)by);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268419_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268468_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
            return super.m_6469_(damagesource, amount * 4.0f);
        }
        if (damagesource.m_276093_(DamageTypes.f_268612_)) {
            return super.m_6469_(damagesource, amount * 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20095_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.3, 1.0));
        }
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_7327_(Entity entity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        boolean bl = super.m_7327_(entity);
        if (bl) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.BITTER_COLD_WIND_AMBIENT, 1.0f, 1.0f);
            }
            if (this.m_21205_().m_41720_() == Items.f_42363_ && entity.m_146888_() < 220) {
                entity.m_146917_(220);
            }
            if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                ItemStack hand = this.m_21205_();
                hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return bl;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if (livingEntity instanceof CorrosiverEntity && (this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_())) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        this.m_213946_(randomSource, difficultyInstance);
        float weaponRandom = this.f_19796_.m_188501_();
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon(weaponRandom));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public ItemStack createSpawnWeapon(float weaponRandom) {
        if ((double)weaponRandom > 0.95) {
            return new ItemStack((ItemLike)Items.f_42383_);
        }
        if ((double)weaponRandom > 0.9) {
            return new ItemStack((ItemLike)Items.f_42386_);
        }
        if ((double)weaponRandom > 0.85) {
            return new ItemStack((ItemLike)Items.f_42420_);
        }
        if ((double)weaponRandom > 0.75) {
            return new ItemStack((ItemLike)Items.f_42423_);
        }
        if ((double)weaponRandom > 0.7) {
            return new ItemStack((ItemLike)JerotesItems.SIMPLE_JAVELIN.get());
        }
        if ((double)weaponRandom > 0.68) {
            return new ItemStack((ItemLike)JerotesItems.IRON_JAVELIN.get());
        }
        if ((double)weaponRandom > 0.55) {
            return new ItemStack((ItemLike)Items.f_42363_);
        }
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    class HelpCorrosiverGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity attack;

        public HelpCorrosiverGoal(Class<LivingEntity> class_, @Nullable boolean bl, boolean bl2, Predicate<LivingEntity> predicate) {
            super((Mob)BitterColdWindEntity.this, class_, 10, bl, bl2, predicate);
        }

        public boolean m_8036_() {
            if (this.f_26049_ > 0 && this.f_26135_.m_217043_().m_188503_(this.f_26049_) != 0) {
                return false;
            }
            if (this.f_26135_.m_5448_() != null) {
                return false;
            }
            List list = BitterColdWindEntity.this.m_9236_().m_45976_(CorrosiverEntity.class, BitterColdWindEntity.this.m_20191_().m_82377_(64.0, 64.0, 64.0));
            double d = Double.MAX_VALUE;
            for (CorrosiverEntity other : list) {
                if (other == null || this.f_26135_ == other || BitterColdWindEntity.this.m_20280_((Entity)other) > d || BitterColdWindEntity.this.m_5448_() != null || (other.m_5647_() != null || BitterColdWindEntity.this.m_5647_() != null) && !BitterColdWindEntity.this.m_7307_((Entity)other) || other.m_5448_() == null || !BitterColdWindEntity.this.m_6779_(other.m_5448_()) || !BitterColdWindEntity.this.m_6549_(other.m_5448_().m_6095_()) || BitterColdWindEntity.this.m_5448_() != null && BitterColdWindEntity.this.m_5448_() instanceof LivingEntity || other.m_5448_().m_7307_((Entity)BitterColdWindEntity.this) || other.m_5448_().m_7307_((Entity)other)) continue;
                this.attack = other.m_5448_();
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.m_26070_(this.attack);
            super.m_8056_();
        }
    }
}

