/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.LightningAbsorptionEntity;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantLookControl;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Part.DuneshocklerPart;
import com.jerotes.jerotesvillage.entity.in.StopLook;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;

public class DuneshocklerEntity
extends Monster
implements JerotesEntity,
LightningAbsorptionEntity,
StopLook,
SpellUseEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState shoot1AnimationState = new AnimationState();
    public AnimationState shoot2AnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_WALK = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(DuneshocklerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_12, false);
    public int spellLevel = 3;
    public double blockDestroyTick;

    public DuneshocklerEntity(EntityType<? extends DuneshocklerEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.f_21364_ = 100;
        this.f_21342_ = new GiantMoveControl((Mob)this);
        this.f_21365_ = new GiantLookControl((Mob)this, 1);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.3, true));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Animal.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (DuneshocklerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, HumanEntity.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.36);
        builder = builder.m_22268_(Attributes.f_22276_, 380.0);
        builder = builder.m_22268_(Attributes.f_22284_, 16.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 28.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.DUNESHOCKLER_AMBIENT;
    }

    public int m_8100_() {
        return 400;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.DUNESHOCKLER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.DUNESHOCKLER_DEATH;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public int m_21529_() {
        return 5;
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (!this.stopLookTime()) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (!this.stopLookTime()) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (!this.stopLookTime()) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (!this.stopLookTime()) {
            super.m_5618_(f);
        }
    }

    @Override
    public boolean stopLookTime() {
        return this.getAttackTick() > 0;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 7.0f;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public double LightningAbsorptionPercentage() {
        return 80.0;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_7023_(Vec3 dir) {
        if (this.m_21515_() && (this.m_20069_() || this.m_20077_())) {
            this.m_19920_(this.m_6113_(), dir);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.6));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(dir);
        }
        if (this.specialAction() && !this.m_20096_() || this.getAttackTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.005, 1.0, 0.005));
        }
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.5, 1.5, 1.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82377_((double)this.f_267362_.m_267731_() < 0.01 ? 0.0 : 1.0, 0.0, (double)this.f_267362_.m_267731_() < 0.01 ? 0.0 : 1.0).m_82381_(livingEntity.m_20191_());
    }

    public boolean m_7337_(Entity entity) {
        if (entity instanceof DuneshocklerPart) {
            return false;
        }
        return super.m_7337_(entity);
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public int getAttackWalk() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_WALK);
    }

    public void setAttackWalk(int n) {
        this.m_20088_().m_135381_(ATTACK_WALK, (Object)n);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "shoot1")) {
            return 4;
        }
        if (Objects.equals(animation, "shoot2")) {
            return 5;
        }
        if (Objects.equals(animation, "dead")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.shoot1AnimationState);
        list.add(this.shoot2AnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public boolean specialAction() {
        return false;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.m_9236_().f_46443_) {
            return ((ServerLevel)this.m_9236_()).m_8791_(id);
        }
        return null;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getChildId() != null) {
            compoundTag.m_128362_("ChildUUID", this.getChildId());
        }
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("AttackWalk", this.getAttackWalk());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128403_("ChildUUID")) {
            this.setChildId(compoundTag.m_128342_("ChildUUID"));
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setAttackWalk(compoundTag.m_128451_("AttackWalk"));
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CHILD_UUID, Optional.empty());
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(ATTACK_WALK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.shoot1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shoot1AnimationState);
                    break;
                }
                case 5: {
                    this.shoot2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shoot2AnimationState);
                    break;
                }
                case 6: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        Entity child;
        super.m_8119_();
        this.m_5618_(this.m_146908_());
        if (!this.m_9236_().f_46443_ && (child = this.getChild()) == null) {
            Object partParent = this;
            int segments = 7;
            for (int i = 0; i < 7; ++i) {
                DuneshocklerPart part = new DuneshocklerPart((EntityType)JerotesVillageEntityType.DUNESHOCKLER_PART.get(), (LivingEntity)partParent, (LivingEntity)this, i != 0 ? 2.1f : 2.2f, 180.0f, 0.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    PlayerTeam teams = (PlayerTeam)this.m_5647_();
                    if (teams != null) {
                        serverLevel.m_6188_().m_6546_(part.m_20149_(), teams);
                    }
                }
                part.setParent((Entity)partParent);
                part.setTrueParent((Entity)this);
                part.setBodyIndex(i);
                if (partParent == this) {
                    this.setChildId(part.m_20148_());
                }
                part.setInitialPartPos((Entity)this);
                partParent = part;
                this.m_9236_().m_7967_((Entity)part);
            }
        }
    }

    public void m_8107_() {
        float f;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(5.0f);
        }
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.f_267362_.m_267780_() && this.m_20096_() && this.m_21223_() > this.m_21233_() / 4.0f && !this.m_6162_() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        float breakLevel = 5.0f;
        double blockDestroyTickUse = 60.0;
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)breakLevel);
            if (blockDestroy) {
                this.blockDestroyTick = blockDestroyTickUse;
            }
            if (!this.m_9236_().f_46443_ && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 15 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.m_5448_() != null && this.getAttackTick() <= -10) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackTick() > 0 || this.m_5448_() != null && this.m_217066_(this.m_5448_())) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackWalk(Math.min(this.getAttackWalk() + 1, 40));
            }
            if (this.getAttackTick() > 0) {
                if (this.getAttackUse() == 4 || this.getAttackUse() == 3 || this.getAttackUse() == 1) {
                    this.m_21573_().m_26573_();
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackWalk(Math.min(this.getAttackWalk() + 1, 40));
                }
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAttackWalk(Math.max(this.getAttackWalk() - 1, 0));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (this.specialAction()) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 20) {
                this.setAnimTick(30);
                this.setAttackTick(30);
                this.setAnimationState("attack1");
                this.setAttackUse(1);
            } else if (attackRandom > 10) {
                this.setAnimTick(30);
                this.setAttackTick(30);
                this.setAnimationState("attack2");
                this.setAttackUse(1);
            } else {
                this.setAnimTick(30);
                this.setAttackTick(30);
                this.setAnimationState("attack3");
                this.setAttackUse(2);
            }
        }
        this.m_21573_().m_26573_();
        return true;
    }

    public boolean trueHurt() {
        Object hurt2;
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        float reach = 0.5f;
        if (this.getAttackUse() == 2) {
            damageBase = 1.5f;
            knockbackBase = 1.5f;
        }
        if (!this.m_20067_()) {
            if (this.getAttackUse() == 1) {
                this.m_5496_(JerotesVillageSounds.DUNESHOCKLER_SLASH, 5.0f, 1.2f);
            }
            if (this.getAttackUse() == 2) {
                this.m_5496_(JerotesVillageSounds.DUNESHOCKLER_TRAMPLE, 5.0f, 1.2f);
            }
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82400_((double)reach));
        for (Object hurt2 : list) {
            Object duneshocklerEntity;
            if (hurt2 == null || this.m_20280_((Entity)hurt2) > 128.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt2) || !this.m_142582_((Entity)hurt2) || !Main.canSee((Entity)hurt2, (Entity)this) && this.getAttackUse() != 2 || hurt2 instanceof DuneshocklerEntity && (duneshocklerEntity = (DuneshocklerEntity)hurt2).m_5448_() != this && this.m_5448_() != duneshocklerEntity) continue;
            if (hurt2 instanceof DuneshocklerPart) {
                duneshocklerEntity = (DuneshocklerPart)((Object)hurt2);
                if (this.m_5448_() != duneshocklerEntity) continue;
            }
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt2);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt2, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
            if (!bl || this.getAttackUse() != 1 && (this.getAttackUse() != 2 || !Main.canSee((Entity)hurt2, (Entity)this)) || hurt2.m_9236_().m_5776_()) continue;
            hurt2.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.BLEEDING.get(), 60, 0, false, false), (Entity)this);
        }
        if (this.getAttackUse() == 2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
            hurt2 = listShake.iterator();
            while (hurt2.hasNext()) {
                LivingEntity shake = (LivingEntity)hurt2.next();
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        Main.sweepAttack((Entity)this);
        if (this.getAttackUse() == 2 && (hurt2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)hurt2;
            AABB aabb = AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_()), (double)(Main.mobWidth((Entity)this) / 2.0f + 6.0f), (double)0.0, (double)(Main.mobWidth((Entity)this) / 2.0f + 6.0f));
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                Main.spawnFallingBlockByPos((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.BLEEDING.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

