/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Elite;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.FreezeAbsorptionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.SnowyApeEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.goal.FrostYetiMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.FrostYetiRangedAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class FrostYetiEntity
extends Monster
implements RangedAttackMob,
JerotesEntity,
FreezeAbsorptionEntity,
SpellUseEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState throwAnimationState = new AnimationState();
    public AnimationState deterAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("c237172f-7a44-460d-89a4-c9115ee0a48d");
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> THROW_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DETER_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RUNAWAY_TICK = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_DETER = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEED_RUSH = SynchedEntityData.m_135353_(FrostYetiEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10, false);
    public int spellLevel = 3;

    public FrostYetiEntity(EntityType<? extends FrostYetiEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.1f);
        this.f_21364_ = 50;
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FrostYetiMeleeAttackGoal(this, 1.2, true));
        this.f_21345_.m_25352_(1, (Goal)new FrostYetiRangedAttackGoal(this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, CorrosiverEntity.class, 32.0f, 1.4, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Animal.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (FrostYetiEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                if (FrostYetiEntity.this.getRunawayTick() > 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, HumanEntity.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (!this.m_9236_().m_5776_()) {
            this.setThrowTick(100);
            this.setAnimTick(13);
            this.setAnimationState("throw");
        }
        OtherSpellList.IceRockThrow(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 128.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.2);
        builder = builder.m_22268_(Attributes.f_22281_, 14.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        return builder;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.FROST_YETI_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.FROST_YETI_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.FROST_YETI_DEATH;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        if (this.isYetiRush()) {
            this.m_5496_(JerotesVillageSounds.FROST_YETI_RUSH, 0.15f, 1.0f);
        } else {
            super.m_7355_(blockPos, blockState);
        }
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 12;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 2.95f;
    }

    public double FreezeAbsorptionPercentage() {
        return 80.0;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.75, 0.75, 0.75);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setThrowTick(int n) {
        this.m_20088_().m_135381_(THROW_TICK, (Object)n);
    }

    public int getThrowTick() {
        return (Integer)this.m_20088_().m_135370_(THROW_TICK);
    }

    public void setDeterTick(int n) {
        this.m_20088_().m_135381_(DETER_TICK, (Object)n);
    }

    public int getDeterTick() {
        return (Integer)this.m_20088_().m_135370_(DETER_TICK);
    }

    public void setJumpTick(int n) {
        this.m_20088_().m_135381_(JUMP_TICK, (Object)n);
    }

    public int getJumpTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_TICK);
    }

    public void setRunawayTick(int n) {
        this.m_20088_().m_135381_(RUNAWAY_TICK, (Object)n);
    }

    public int getRunawayTick() {
        return (Integer)this.m_20088_().m_135370_(RUNAWAY_TICK);
    }

    public boolean isYetiRush() {
        return (Boolean)this.m_20088_().m_135370_(NEED_RUSH) != false && this.m_6084_();
    }

    public void setYetiRush(boolean bl) {
        this.m_20088_().m_135381_(NEED_RUSH, (Object)bl);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
        if (bl) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Rush movement speed", 0.1, AttributeModifier.Operation.ADDITION));
            this.m_274367_(3.1f);
        } else {
            this.m_274367_(1.1f);
        }
    }

    public boolean isShouldDeter() {
        return (Boolean)this.m_20088_().m_135370_(SHOULD_DETER);
    }

    public void setShouldDeter(boolean bl) {
        this.m_20088_().m_135381_(SHOULD_DETER, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "throw")) {
            return 4;
        }
        if (Objects.equals(animation, "deter")) {
            return 5;
        }
        if (Objects.equals(animation, "dead")) {
            return 6;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.throwAnimationState);
        list.add(this.deterAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128379_("IsYetiRush", this.isYetiRush());
        compoundTag.m_128405_("ThrowTick", this.getThrowTick());
        compoundTag.m_128405_("DeterTick", this.getDeterTick());
        compoundTag.m_128405_("JumpTick", this.getJumpTick());
        compoundTag.m_128379_("ShouldDeter", this.isShouldDeter());
        compoundTag.m_128405_("RunAwayTick", this.getRunawayTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setYetiRush(compoundTag.m_128471_("IsYetiRush"));
        this.setThrowTick(compoundTag.m_128451_("ThrowTick"));
        this.setDeterTick(compoundTag.m_128451_("DeterTick"));
        this.setJumpTick(compoundTag.m_128451_("JumpTick"));
        this.setShouldDeter(compoundTag.m_128471_("ShouldDeter"));
        this.setRunawayTick(compoundTag.m_128451_("RunAwayTick"));
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(NEED_RUSH, (Object)false);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(THROW_TICK, (Object)0);
        this.m_20088_().m_135372_(DETER_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_TICK, (Object)0);
        this.m_20088_().m_135372_(RUNAWAY_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOULD_DETER, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (NEED_RUSH.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.throwAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throwAnimationState);
                    break;
                }
                case 5: {
                    this.deterAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deterAnimationState);
                    break;
                }
                case 6: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (!this.m_9236_().m_5776_() && this.m_21023_(MobEffects.f_19605_) && this.getRunawayTick() > 0 && item == JerotesVillageItems.BITTER_COLD_BELL.get()) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.m_20000_((ItemLike)JerotesVillageItems.FROST_YETI_HAIR.get(), 1);
            SnowyApeEntity snowyApe = (SnowyApeEntity)this.m_21406_((EntityType)JerotesVillageEntityType.SNOWY_APE.get(), true);
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)snowyApe);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 32; ++i) {
                    double d = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    double d3 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d, d2, d3, 0.0);
                }
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_8107_() {
        Vec3 vec;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 5 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 10 && this.m_5448_() != null && this.getAttackTick() > 10) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.getRunawayTick() > 0) {
            this.setRunawayTick(this.getRunawayTick() - 1);
            if (this.m_20096_()) {
                Vec3 randomShake = new Vec3((double)(this.m_217043_().m_188501_() - 0.5f), 0.0, (double)(this.m_217043_().m_188501_() - 0.5f)).m_82490_((double)0.1f);
                this.m_20256_(this.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
            }
            if ((vec = LandRandomPos.m_148521_((PathfinderMob)this, (int)64, (int)24, (Vec3)this.m_20182_())) != null) {
                this.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setThrowTick(Math.max(0, this.getThrowTick() - 1));
            this.setDeterTick(Math.max(0, this.getDeterTick() - 1));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.f_19862_ && this.getJumpTick() > 0 && !this.m_9236_().m_5776_()) {
            this.setJumpTick(this.getJumpTick() - 1);
        }
        if (this.f_19862_ && !this.m_9236_().m_5776_()) {
            this.setJumpTick(this.getJumpTick() + 1);
        }
        if (this.f_19862_ && this.getJumpTick() < 40 && this.m_20096_()) {
            this.m_20334_(0.1, 0.8, 0.1);
            if (!this.m_9236_().m_5776_()) {
                this.setJumpTick(0);
            }
        }
        if (this.getDeterTick() >= 360) {
            this.attack1AnimationState.m_216973_();
            this.attack2AnimationState.m_216973_();
            this.attack3AnimationState.m_216973_();
            this.m_21573_().m_26573_();
        }
        if (this.m_5912_() && this.getRunawayTick() <= 0 && this.getDeterTick() <= 0 && this.isShouldDeter() && this.m_5448_() != null && this.m_5448_() instanceof LivingEntity) {
            if (!this.m_9236_().m_5776_()) {
                this.setShouldDeter(false);
                this.setDeterTick(400);
                this.setAnimTick(40);
                this.setAnimationState("deter");
            }
            OtherSpellFind.YetiDeter((LivingEntity)this, this.m_5448_(), this.getSpellLevel(), this.getSpellLevel(), 1, this.getSpellLevel() * 6);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.FROST_YETI_DETER, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (!(this.m_5912_() || this.m_5448_() != null || this.isShouldDeter() || this.m_9236_().m_5776_())) {
            this.setShouldDeter(true);
        }
        if (this.getRunawayTick() > 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setYetiRush(true);
            }
            if (this.m_5448_() != null && (vec = LandRandomPos.m_148521_((PathfinderMob)this, (int)64, (int)24, (Vec3)this.m_5448_().m_20182_())) != null) {
                this.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
            }
        } else if (this.m_5448_() != null && this.getDeterTick() < 360) {
            if (this.m_20270_((Entity)this.m_5448_()) < 24.0f && !this.f_19862_) {
                if (!this.m_9236_().m_5776_()) {
                    this.setYetiRush(false);
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setYetiRush(true);
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setYetiRush(false);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (this.getDeterTick() < 360 && this.getRunawayTick() <= 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(0);
                int attackRandom = this.m_217043_().m_188503_(30);
                if (attackRandom > 20) {
                    this.setAnimTick(12);
                    this.setAnimationState("attack1");
                } else {
                    if (attackRandom > 10) {
                        this.setAnimTick(15);
                        this.setAttackTick(15);
                        this.setAnimationState("attack2");
                        return true;
                    }
                    this.setAnimTick(12);
                    this.setAnimationState("attack3");
                }
            }
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268444_), (Entity)this);
            if (Main.randomReach((RandomSource)this.m_217043_(), (int)1, (int)3) == 1 && !entity.m_6673_(damageSource)) {
                if (entity instanceof LivingEntity) {
                    entity.m_146924_(true);
                    if (entity.m_146888_() < 240) {
                        entity.m_146917_(240);
                    }
                }
                AttackFind.attackBegin((LivingEntity)this, (Entity)entity);
                boolean bl = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)entity, (DamageSource)damageSource, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
                if (bl) {
                    LivingEntity livingEntity;
                    if (!this.m_20067_()) {
                        this.m_5496_(JerotesVillageSounds.FROST_YETI_ATTACK, 1.0f, 1.0f);
                    }
                    if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19613_)) {
                        int weak1 = Objects.requireNonNull(livingEntity.m_21124_(MobEffects.f_19613_)).m_19557_();
                        int weak2 = Objects.requireNonNull(livingEntity.m_21124_(MobEffects.f_19613_)).m_19564_();
                        if (!this.m_9236_().m_5776_()) {
                            this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.RAMPANT.get(), weak1, weak2), (Entity)this);
                        }
                    }
                    List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(0.5, 0.2, 0.5));
                    for (LivingEntity hurt : list) {
                        LivingEntity livingEntity2;
                        FrostYetiEntity frostYetiEntity;
                        if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof FrostYetiEntity && (frostYetiEntity = (FrostYetiEntity)hurt).m_5448_() != this && this.m_5448_() != frostYetiEntity) continue;
                        AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                        boolean bl2 = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)entity, (DamageSource)damageSource, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
                        if (!bl2 || !(entity instanceof LivingEntity) || !(livingEntity2 = (LivingEntity)entity).m_21023_(MobEffects.f_19613_)) continue;
                        int weak1 = Objects.requireNonNull(livingEntity2.m_21124_(MobEffects.f_19613_)).m_19557_();
                        int weak2 = Objects.requireNonNull(livingEntity2.m_21124_(MobEffects.f_19613_)).m_19564_();
                        if (this.m_9236_().m_5776_()) continue;
                        this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.RAMPANT.get(), weak1, weak2), (Entity)this);
                    }
                    Main.sweepAttack((Entity)this);
                }
                return bl;
            }
            boolean bl = super.m_7327_(entity);
            if (bl) {
                LivingEntity livingEntity;
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.FROST_YETI_ATTACK, 1.0f, 1.0f);
                }
                if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_(MobEffects.f_19613_)) {
                    int weak1 = Objects.requireNonNull(livingEntity.m_21124_(MobEffects.f_19613_)).m_19557_();
                    int weak2 = Objects.requireNonNull(livingEntity.m_21124_(MobEffects.f_19613_)).m_19564_();
                    if (!this.m_9236_().m_5776_()) {
                        this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.RAMPANT.get(), weak1, weak2), (Entity)this);
                    }
                }
                List list = this.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82377_(0.5, 0.2, 0.5));
                for (LivingEntity hurt : list) {
                    LivingEntity livingEntity3;
                    FrostYetiEntity frostYetiEntity;
                    if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt, (Entity)entity) || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || hurt instanceof FrostYetiEntity && (frostYetiEntity = (FrostYetiEntity)hurt).m_5448_() != this && this.m_5448_() != frostYetiEntity) continue;
                    AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                    boolean bl2 = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.5f, (float)0.5f, (boolean)false, (float)0.0f);
                    if (!bl2 || !(entity instanceof LivingEntity) || !(livingEntity3 = (LivingEntity)entity).m_21023_(MobEffects.f_19613_)) continue;
                    int weak1 = Objects.requireNonNull(livingEntity3.m_21124_(MobEffects.f_19613_)).m_19557_();
                    int weak2 = Objects.requireNonNull(livingEntity3.m_21124_(MobEffects.f_19613_)).m_19564_();
                    if (this.m_9236_().m_5776_()) continue;
                    this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.RAMPANT.get(), weak1, weak2), (Entity)this);
                }
                Main.sweepAttack((Entity)this);
            }
            return bl;
        }
        return false;
    }

    public boolean trueHurt() {
        if (this.getDeterTick() >= 360 || this.getRunawayTick() > 0) {
            return false;
        }
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.FROST_YETI_ATTACK, 2.0f, 1.0f);
        }
        float reach = 0.5f;
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268444_), (Entity)this);
            boolean bl = !hurt.m_6673_(damageSource) ? AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)hurt, (DamageSource)damageSource, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f) : AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            if (!bl || !hurt.m_21023_(MobEffects.f_19613_)) continue;
            int weak1 = Objects.requireNonNull(hurt.m_21124_(MobEffects.f_19613_)).m_19557_();
            int weak2 = Objects.requireNonNull(hurt.m_21124_(MobEffects.f_19613_)).m_19564_();
            if (this.m_9236_().m_5776_()) continue;
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.RAMPANT.get(), weak1, weak2), (Entity)this);
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setRunawayTick(0);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268524_)) {
            return super.m_6469_(damagesource, amount / 2.0f);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
            return super.m_6469_(damagesource, amount * 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack itemStack, float f) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (this.m_9236_().m_5776_()) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)f, this.m_20189_(), itemStack);
        itementity.m_32060_();
        if (itementity.m_32055_().m_41720_() == JerotesVillageItems.FROST_YETI_HAIR.get()) {
            itementity.m_146915_(true);
        }
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.m_9236_().m_7967_((Entity)itementity);
        }
        return itementity;
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

