/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Ender;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.control.GiantBodyRotationControl;
import com.jerotes.jerotesvillage.goal.BloodsuckerMeleeAttackGoal;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class EnderStowawayEntity
extends EnderMan
implements JerotesEntity {
    private int hurtsTick;

    public EnderStowawayEntity(EntityType<? extends EnderStowawayEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder m_32541_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 45.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionEnderStowawayCollective(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "ender_stowaway_collective";
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BloodsuckerMeleeAttackGoal((PathfinderMob)this, 1.2, true){

            @Override
            public boolean m_8036_() {
                String string = ChatFormatting.m_126649_((String)EnderStowawayEntity.this.m_7755_().getString());
                if (!"Elite".equals(string)) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                String string = ChatFormatting.m_126649_((String)EnderStowawayEntity.this.m_7755_().getString());
                if (!"Elite".equals(string)) {
                    return false;
                }
                return super.m_8045_();
            }
        });
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("HurtsTick", this.hurtsTick);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.hurtsTick = compoundTag.m_128451_("HurtsTick");
    }

    public boolean m_213824_() {
        return true;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.25, 0.25, 0.25);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GiantBodyRotationControl((Mob)this);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Elite".equals(string) && this.hurtsTick > 0) {
            this.hurtsTick -= 10;
        }
        if (this.hurtsTick > 0) {
            --this.hurtsTick;
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Elite".equals(string)) {
            if (this.m_217043_().m_188501_() > 0.15f) {
                this.m_32529_();
            }
        } else if (this.m_217043_().m_188501_() > 0.7f) {
            this.m_32529_();
        }
        return bl;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        boolean bl;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ((damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) && "Elite".equals(string) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_)) && (bl = this.m_32529_())) {
            return false;
        }
        if ("Elite".equals(string)) {
            f *= 0.5f;
        }
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && this.m_5448_() != null) {
            if ("Elite".equals(string)) {
                if (f < this.m_21223_() * 10.0f && this.m_217043_().m_188501_() > 0.25f) {
                    this.m_32529_();
                    return false;
                }
            } else if (f < this.m_21223_() * 5.0f && this.m_217043_().m_188501_() > 0.7f) {
                this.m_32529_();
                return false;
            }
        }
        if ((bl = super.m_6469_(damageSource, f)) && f > this.m_21223_() / 3.0f) {
            this.hurtsTick = 120;
        }
        return bl;
    }

    private boolean m_186272_(DamageSource p_186273_, ThrownPotion p_186274_, float p_186275_) {
        ItemStack itemstack = p_186274_.m_7846_();
        Potion potion = PotionUtils.m_43579_((ItemStack)itemstack);
        List list = PotionUtils.m_43547_((ItemStack)itemstack);
        boolean flag = potion == Potions.f_43599_ && list.isEmpty();
        return flag ? super.m_6469_(p_186273_, p_186275_) : false;
    }

    protected boolean m_32529_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.m_32543_(d0, d1, d2);
        }
        return false;
    }

    private boolean m_32543_(double p_32544_, double p_32545_, double p_32546_) {
        float find = 0.25f;
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Elite".equals(string)) {
            find = 0.025f;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_32544_, (double)p_32545_, (double)p_32546_);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_217043_().m_188501_() > find && this.m_5448_() != null && this.hurtsTick <= 0 ? this.findTeleport(this.m_5448_()) : this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public boolean findTeleport(LivingEntity entity) {
        int maxFind = 16;
        BlockPos summonPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)entity, (int)4);
        for (int find = 0; find < maxFind && Main.canSee((Entity)this, (Entity)entity); ++find) {
            summonPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)entity, (int)4);
        }
        this.m_6021_(summonPos.m_123341_(), summonPos.m_123342_(), summonPos.m_123343_());
        return true;
    }
}

