/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Hag;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.WizardEntity;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesTradeWithPlayerGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.control.QoaikuMoveControl;
import com.jerotes.jerotesvillage.entity.Boss.Biome.PurpleSandHagEntity;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Monster.Hag.CovenHagEntity;
import com.jerotes.jerotesvillage.entity.Monster.SpirveEntity;
import com.jerotes.jerotesvillage.entity.in.SkinEntity;
import com.jerotes.jerotesvillage.goal.HagAttackGoal;
import com.jerotes.jerotesvillage.goal.QoaikuGroundOpenDoorGoal;
import com.jerotes.jerotesvillage.goal.QoaikuOpenDoorGoal;
import com.jerotes.jerotesvillage.goal.SpirveOrHagAttackTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public abstract class BaseHagEntity
extends Raider
implements WizardEntity,
SpellUseEntity,
InventoryEntity,
UseShieldEntity,
NeutralMob,
InventoryCarrier,
Npc,
JerotesEntity,
SkinEntity,
Enemy,
Merchant {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState spell1AnimationState = new AnimationState();
    public AnimationState spell2AnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    public AnimationState shieldUseMainhandAnimationState = new AnimationState();
    public AnimationState shieldUseOffhandAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> COMBAT_STYLE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> USE_SELF_NOT_SPELL_LIST = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_MELEE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MELEE_TICK = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CONJUR_SPIRVE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> COVENS = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> INVISIBILITY = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> INVISIBILITY_TICK = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> COVEN = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FEMALE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SKIN_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EYE_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EYE_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAIR_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAIR_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ADD_TYPE_1 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ADD_TYPE_2 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ADD_TYPE_3 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JACKET_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JACKET_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PANTS_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PANTS_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GLOVES_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GLOVES_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BAUBLE_TYPE_1 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BAUBLE_TYPE_2 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BAUBLE_TYPE_3 = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOES_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOES_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAT_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAT_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OVERCOAT_TYPE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OVERCOAT_COLOR = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_INVENTORY = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_MELEE_OR_RANGE = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_WEAPON = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_SHIELD = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHANGE_INVENTORY_COOLDOWN_TICK = SynchedEntityData.m_135353_(BaseHagEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final SimpleContainer inventory = new SimpleContainer(this.inventoryCount());
    private LazyOptional<?> itemHandler = null;
    public boolean isLandNavigatorType = true;
    public int spellLevel = 3;
    public int covenSpellLevel = 4;
    public int shieldCoolDown;
    public int shieldCanUse = 1;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    @Nullable
    private BlockPos wanderTarget;
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> HAG = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)Items.f_42583_, 1), new ItemStack((ItemLike)Items.f_42500_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42500_, 1), new ItemStack((ItemLike)Items.f_42583_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42455_, 1), new ItemStack((ItemLike)Items.f_42447_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_41830_, 1), new ItemStack((ItemLike)JerotesVillageItems.PURPLE_SAND.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42591_, 32), new ItemStack((ItemLike)JerotesVillageItems.HAG_EYE.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.PINK_CACTUS.get(), 32), new ItemStack((ItemLike)JerotesVillageItems.WITCH_COVEN_MAP.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.PURPLE_SAND_GECKO_TAIL.get(), 1), new ItemStack((ItemLike)Items.f_151049_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42788_, 1), new ItemStack((ItemLike)Items.f_42785_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42498_, 1), new ItemStack((ItemLike)Items.f_42535_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42535_, 1), new ItemStack((ItemLike)Items.f_42498_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42787_, 1), new ItemStack((ItemLike)JerotesVillageItems.SPIRVE_BROKEN_BOOTLE.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42526_, 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)Items.f_42458_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42527_, 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)Items.f_42457_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42528_, 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)Items.f_42459_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42529_, 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)Items.f_42456_, 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.BRIGHT_GRASS_CARP.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.BRIGHT_GRASS_CARP_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.CHROMASNAP_BASS.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.CHROMASNAP_BASS_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.LAKE_LOACH.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.LAKE_LOACH_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.FLOWMINNOW.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.FLOWMINNOW_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.BITTER_COD.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.BITTER_COD_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.GREYSCALE.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.GREYSCALE_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.JEWELROAMER.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.JEWELROAMER_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.STARBRITE.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.STARBRITE_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.ABYSSALER.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.ABYSSALER_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.SUN_CRAB.get(), 1), new ItemStack((ItemLike)Items.f_42447_, 1), new ItemStack((ItemLike)JerotesVillageItems.SUN_CRAB_BUCKET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42407_, 1), new ItemStack((ItemLike)JerotesVillageItems.SPIRVE_HELMET.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42408_, 1), new ItemStack((ItemLike)JerotesVillageItems.SPIRVE_CHESTPLATE.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42462_, 1), new ItemStack((ItemLike)JerotesVillageItems.SPIRVE_LEGGINGS.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42463_, 1), new ItemStack((ItemLike)JerotesVillageItems.SPIRVE_BOOTS.get(), 1), 30, 5, 0.05f)}));

    protected BaseHagEntity(EntityType<? extends BaseHagEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(0.6f);
        this.f_21364_ = 50;
        this.m_21530_();
        this.applyOpenDoorsAbility();
        this.m_21553_(false);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.itemHandler = LazyOptional.of(this::createCombinedHandler);
    }

    private IItemHandler createCombinedHandler() {
        EntityHandsInvWrapper handsHandler = new EntityHandsInvWrapper((LivingEntity)this);
        EntityArmorInvWrapper armorHandler = new EntityArmorInvWrapper((LivingEntity)this);
        InvWrapper customHandler = new InvWrapper((Container)this.inventory);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{armorHandler, handsHandler, customHandler});
    }

    public ItemStack m_255207_(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        boolean bl = this.m_7808_(itemStack, itemStack2);
        if (equipmentSlot.m_254934_() && !bl) {
            equipmentSlot = EquipmentSlot.MAINHAND;
            itemStack2 = this.m_6844_(equipmentSlot);
            bl = itemStack2.m_41619_();
        }
        if (bl && this.m_7252_(itemStack)) {
            double d = this.m_21519_(equipmentSlot);
            if (this.canAddToInventory(itemStack2)) {
                this.addToInventory(itemStack2);
            } else {
                this.m_19983_(itemStack2);
            }
            if (equipmentSlot.m_254934_() && itemStack.m_41613_() > 1) {
                ItemStack itemStack3 = itemStack.m_255036_(1);
                this.m_21468_(equipmentSlot, itemStack3);
                return itemStack3;
            }
            this.m_21468_(equipmentSlot, itemStack);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        return InventoryEntity.canReplaceCurrentItem((InventoryEntity)this, (ItemStack)newItem, (ItemStack)oldItem);
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionPurpleSandSisterhood(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "purple_sand_sisterhood";
    }

    @VisibleForDebug
    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    protected ItemStack addToInventory(ItemStack itemStack) {
        return this.inventory.m_19173_(itemStack);
    }

    protected boolean canAddToInventory(ItemStack itemStack) {
        return this.inventory.m_19183_(itemStack);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 121.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        super.m_7472_(damageSource, n, bl);
        this.inventory.m_19195_().forEach(arg_0 -> ((BaseHagEntity)this).m_19983_(arg_0));
    }

    private void applyOpenDoorsAbility() {
        if (GoalUtils.m_26894_((Mob)this)) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(0, (Goal)new QoaikuOpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new QoaikuGroundOpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesTradeWithPlayerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAttackAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 4.0f, 1.0, 1.0){

            public boolean m_8036_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new HagAttackGoal((LivingEntity)this, 1.2, 10, 10.0f){

            @Override
            public boolean m_8036_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        if (!(this instanceof PurpleSandHagEntity)) {
            this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
            this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        }
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.3, false){

            public boolean m_8036_() {
                if (!BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (!BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false){

            public boolean m_8036_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (BaseHagEntity.this.isMelee()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Witch.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, SpirveEntity.class, 6.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, BaseHagEntity.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{BaseHagEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, (LivingEntity)livingEntity)));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, (Goal)new SpirveOrHagAttackTargetGoal<Player>((Mob)this, Player.class, true){

            @Override
            public boolean m_8036_() {
                if (BaseHagEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, new SpirveOrHagAttackTargetGoal<AbstractVillager>((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, new SpirveOrHagAttackTargetGoal<SecondRounderEntity>((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((BaseHagEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.HAG_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource) && this.isMelee()) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.HAG_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.HAG_DEATH;
    }

    public SoundEvent m_7930_() {
        return JerotesVillageSounds.HAG_LAUGH_1;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_ + 0.0625f * f, 0.0f);
    }

    protected float ridingOffset(Entity entity) {
        return -0.7f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.65f;
    }

    public boolean m_7490_() {
        return false;
    }

    public void setMelee(boolean bl) {
        this.m_20088_().m_135381_(IS_MELEE, (Object)bl);
    }

    public boolean isMelee() {
        return (Boolean)this.m_20088_().m_135370_(IS_MELEE);
    }

    public boolean shieldCanUse() {
        return this.shieldCanUse == 1 && this.shieldCoolDown <= 0;
    }

    public int getSpellLevel() {
        if (this.covenSpellLevel > this.spellLevel && this.isCoven()) {
            return this.covenSpellLevel;
        }
        return this.spellLevel;
    }

    public void setMeleeTick(int n) {
        this.m_20088_().m_135381_(MELEE_TICK, (Object)n);
    }

    public int getMeleeTick() {
        return (Integer)this.m_20088_().m_135370_(MELEE_TICK);
    }

    public void setConjurSpirve(int n) {
        this.m_20088_().m_135381_(CONJUR_SPIRVE, (Object)n);
    }

    public int getConjurSpirve() {
        return (Integer)this.m_20088_().m_135370_(CONJUR_SPIRVE);
    }

    public boolean isCovens() {
        return (Boolean)this.m_20088_().m_135370_(COVENS);
    }

    public void setCovens(boolean bl) {
        this.m_20088_().m_135381_(COVENS, (Object)bl);
    }

    public void setInvisibility(boolean bl) {
        this.m_20088_().m_135381_(INVISIBILITY, (Object)bl);
    }

    public boolean isInvisibility() {
        return (Boolean)this.m_20088_().m_135370_(INVISIBILITY);
    }

    public void setInvisibilityTick(int n) {
        this.m_20088_().m_135381_(INVISIBILITY_TICK, (Object)n);
    }

    public int getInvisibilityTick() {
        return (Integer)this.m_20088_().m_135370_(INVISIBILITY_TICK);
    }

    public boolean isCoven() {
        return (Boolean)this.m_20088_().m_135370_(COVEN);
    }

    public void setCoven(boolean bl) {
        this.m_20088_().m_135381_(COVEN, (Object)bl);
    }

    @Override
    public boolean IsFemale() {
        return (Boolean)this.m_20088_().m_135370_(IS_FEMALE);
    }

    public void setFemale(boolean bl) {
        this.m_20088_().m_135381_(IS_FEMALE, (Object)bl);
    }

    @Override
    public int SkinType() {
        return (Integer)this.m_20088_().m_135370_(SKIN_TYPE);
    }

    public void setSkinType(int n) {
        this.m_20088_().m_135381_(SKIN_TYPE, (Object)n);
    }

    @Override
    public int SkinColor() {
        return (Integer)this.m_20088_().m_135370_(SKIN_COLOR);
    }

    public void setSkinColor(int n) {
        this.m_20088_().m_135381_(SKIN_COLOR, (Object)n);
    }

    @Override
    public int EyeType() {
        return (Integer)this.m_20088_().m_135370_(EYE_TYPE);
    }

    public void setEyeType(int n) {
        this.m_20088_().m_135381_(EYE_TYPE, (Object)n);
    }

    @Override
    public int EyeColor() {
        return (Integer)this.m_20088_().m_135370_(EYE_COLOR);
    }

    public void setEyeColor(int n) {
        this.m_20088_().m_135381_(EYE_COLOR, (Object)n);
    }

    @Override
    public int HairType() {
        return (Integer)this.m_20088_().m_135370_(HAIR_TYPE);
    }

    public void setHairType(int n) {
        this.m_20088_().m_135381_(HAIR_TYPE, (Object)n);
    }

    @Override
    public int HairColor() {
        return (Integer)this.m_20088_().m_135370_(HAIR_COLOR);
    }

    public void setHairColor(int n) {
        this.m_20088_().m_135381_(HAIR_COLOR, (Object)n);
    }

    @Override
    public int AddType_1() {
        return (Integer)this.m_20088_().m_135370_(ADD_TYPE_1);
    }

    public void setAddType_1(int n) {
        this.m_20088_().m_135381_(ADD_TYPE_1, (Object)n);
    }

    @Override
    public int AddType_2() {
        return (Integer)this.m_20088_().m_135370_(ADD_TYPE_2);
    }

    public void setAddType_2(int n) {
        this.m_20088_().m_135381_(ADD_TYPE_2, (Object)n);
    }

    @Override
    public int AddType_3() {
        return (Integer)this.m_20088_().m_135370_(ADD_TYPE_3);
    }

    public void setAddType_3(int n) {
        this.m_20088_().m_135381_(ADD_TYPE_3, (Object)n);
    }

    @Override
    public int JacketType() {
        return (Integer)this.m_20088_().m_135370_(JACKET_TYPE);
    }

    public void setJacketType(int n) {
        this.m_20088_().m_135381_(JACKET_TYPE, (Object)n);
    }

    @Override
    public int JacketColor() {
        return (Integer)this.m_20088_().m_135370_(JACKET_COLOR);
    }

    public void setJacketColor(int n) {
        this.m_20088_().m_135381_(JACKET_COLOR, (Object)n);
    }

    @Override
    public int PantsType() {
        return (Integer)this.m_20088_().m_135370_(PANTS_TYPE);
    }

    public void setPantsType(int n) {
        this.m_20088_().m_135381_(PANTS_TYPE, (Object)n);
    }

    @Override
    public int PantsColor() {
        return (Integer)this.m_20088_().m_135370_(PANTS_COLOR);
    }

    public void setPantsColor(int n) {
        this.m_20088_().m_135381_(PANTS_COLOR, (Object)n);
    }

    @Override
    public int GlovesType() {
        return (Integer)this.m_20088_().m_135370_(GLOVES_TYPE);
    }

    public void setGlovesType(int n) {
        this.m_20088_().m_135381_(GLOVES_TYPE, (Object)n);
    }

    @Override
    public int GlovesColor() {
        return (Integer)this.m_20088_().m_135370_(GLOVES_COLOR);
    }

    public void setGlovesColor(int n) {
        this.m_20088_().m_135381_(GLOVES_COLOR, (Object)n);
    }

    @Override
    public int BaubleType_1() {
        return (Integer)this.m_20088_().m_135370_(BAUBLE_TYPE_1);
    }

    public void setBaubleType_1(int n) {
        this.m_20088_().m_135381_(BAUBLE_TYPE_1, (Object)n);
    }

    @Override
    public int BaubleType_2() {
        return (Integer)this.m_20088_().m_135370_(BAUBLE_TYPE_2);
    }

    public void setBaubleType_2(int n) {
        this.m_20088_().m_135381_(BAUBLE_TYPE_2, (Object)n);
    }

    @Override
    public int BaubleType_3() {
        return (Integer)this.m_20088_().m_135370_(BAUBLE_TYPE_3);
    }

    public void setBaubleType_3(int n) {
        this.m_20088_().m_135381_(BAUBLE_TYPE_3, (Object)n);
    }

    @Override
    public int ShoesType() {
        return (Integer)this.m_20088_().m_135370_(SHOES_TYPE);
    }

    public void setShoesType(int n) {
        this.m_20088_().m_135381_(SHOES_TYPE, (Object)n);
    }

    @Override
    public int ShoesColor() {
        return (Integer)this.m_20088_().m_135370_(SHOES_COLOR);
    }

    public void setShoesColor(int n) {
        this.m_20088_().m_135381_(SHOES_COLOR, (Object)n);
    }

    @Override
    public int HatType() {
        return (Integer)this.m_20088_().m_135370_(HAT_TYPE);
    }

    public void setHatType(int n) {
        this.m_20088_().m_135381_(HAT_TYPE, (Object)n);
    }

    @Override
    public int HatColor() {
        return (Integer)this.m_20088_().m_135370_(HAT_COLOR);
    }

    public void setHatColor(int n) {
        this.m_20088_().m_135381_(HAT_COLOR, (Object)n);
    }

    @Override
    public int OvercoatType() {
        return (Integer)this.m_20088_().m_135370_(OVERCOAT_TYPE);
    }

    public void setOvercoatType(int n) {
        this.m_20088_().m_135381_(OVERCOAT_TYPE, (Object)n);
    }

    @Override
    public int OvercoatColor() {
        return (Integer)this.m_20088_().m_135370_(OVERCOAT_COLOR);
    }

    public void setOvercoatColor(int n) {
        this.m_20088_().m_135381_(OVERCOAT_COLOR, (Object)n);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "spell1")) {
            return 3;
        }
        if (Objects.equals(animation, "spell2")) {
            return 4;
        }
        if (Objects.equals(animation, "dead")) {
            return 5;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.spell1AnimationState);
        list.add(this.spell2AnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public SimpleContainer mobInventory() {
        return this.inventory;
    }

    public int inventoryCount() {
        return 8;
    }

    public boolean isCanChangeInventory() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_INVENTORY);
    }

    public void setCanChangeInventory(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_INVENTORY, (Object)bl);
    }

    public boolean isCanChangeMeleeOrRange() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_MELEE_OR_RANGE);
    }

    public void setCanChangeMeleeOrRange(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_MELEE_OR_RANGE, (Object)bl);
    }

    public boolean canUseCrossbow() {
        return false;
    }

    public boolean canUseThrow() {
        return false;
    }

    public boolean canUseRangeJavelin() {
        return false;
    }

    public boolean canUseBow() {
        return false;
    }

    public boolean NonCombatEmptyWeapon() {
        return this.isNoCombatEmptyWeapon();
    }

    public boolean NonCombatEmptyShield() {
        return this.isNoCombatEmptyShield();
    }

    public int changeInventoryCooldownTick() {
        return this.getChangeInventoryCooldownTick();
    }

    public boolean isNoCombatEmptyWeapon() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_WEAPON);
    }

    public void setNoCombatEmptyWeapon(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_WEAPON, (Object)bl);
    }

    public boolean isNoCombatEmptyShield() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_SHIELD);
    }

    public void setNoCombatEmptyShield(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_SHIELD, (Object)bl);
    }

    public int getChangeInventoryCooldownTick() {
        return (Integer)this.m_20088_().m_135370_(CHANGE_INVENTORY_COOLDOWN_TICK);
    }

    public void setChangeInventoryCooldownTick(int n) {
        this.m_20088_().m_135381_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)n);
    }

    public void SpellUseAfterAttack(String string, MagicType magicType, MagicType magicType2) {
        if (magicType2 == MagicType.MAIN && magicType == MagicType.SHOOT) {
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(10);
                this.setAnimationState("spell1");
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(15);
            this.setAnimationState("spell2");
        }
    }

    public List<SpellTypeInterface> SelfMainSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public List<SpellTypeInterface> SelfAddSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public int getCombatStyle() {
        return (Integer)this.m_20088_().m_135370_(COMBAT_STYLE);
    }

    public void setCombatStyle(int n) {
        this.m_20088_().m_135381_(COMBAT_STYLE, (Object)n);
    }

    public boolean isUseSelfNotStringSpellList() {
        return (Boolean)this.m_20088_().m_135370_(USE_SELF_NOT_SPELL_LIST);
    }

    public void setUseSelfNotStringSpellList(boolean bl) {
        this.m_20088_().m_135381_(USE_SELF_NOT_SPELL_LIST, (Object)bl);
    }

    public void setShieldLevel(int n) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)n);
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    public boolean isMagicUseStyle() {
        return this.getSpellTick() > 0;
    }

    public boolean isSpellHumanoid() {
        return true;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128405_("ShieldLevel", this.getShieldLevel());
        compoundTag.m_128405_("CombatStyle", this.getCombatStyle());
        compoundTag.m_128379_("UseSelfNotStringSpellList", this.isUseSelfNotStringSpellList());
        compoundTag.m_128379_("IsNoCombatEmptyWeapon", this.isNoCombatEmptyWeapon());
        compoundTag.m_128379_("IsNoCombatEmptyShield", this.isNoCombatEmptyShield());
        compoundTag.m_128405_("ChangeInventoryCooldownTick", this.getChangeInventoryCooldownTick());
        compoundTag.m_128379_("IsCanChangeInventory", this.isCanChangeInventory());
        compoundTag.m_128379_("IsCanChangeMeleeOrRange", this.isCanChangeMeleeOrRange());
        compoundTag.m_128405_("ShieldCoolDown", this.shieldCoolDown);
        compoundTag.m_128405_("ShieldCanUse", this.shieldCanUse);
        compoundTag.m_128379_("IsMelee", this.isMelee());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("CovenSpellLevel", this.covenSpellLevel);
        compoundTag.m_128379_("Covens", this.isCovens());
        compoundTag.m_128405_("MeleeTick", this.getMeleeTick());
        compoundTag.m_128405_("ConjurSpirve", this.getConjurSpirve());
        compoundTag.m_128379_("Invisibility", this.isInvisibility());
        compoundTag.m_128347_("InvisibilityTick", (double)this.getInvisibilityTick());
        compoundTag.m_128379_("IsCoven", this.isCoven());
        MerchantOffers merchantOffers = this.m_6616_();
        if (!merchantOffers.isEmpty()) {
            compoundTag.m_128365_("Offers", (Tag)merchantOffers.m_45388_());
        }
        this.m_252802_(compoundTag);
        if (this.wanderTarget != null) {
            compoundTag.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
        compoundTag.m_128379_("IsFemale", this.IsFemale());
        compoundTag.m_128405_("SkinType", this.SkinType());
        compoundTag.m_128405_("SkinColor", this.SkinColor());
        compoundTag.m_128405_("EyeType", this.EyeType());
        compoundTag.m_128405_("EyeColor", this.EyeColor());
        compoundTag.m_128405_("HairType", this.HairType());
        compoundTag.m_128405_("HairColor", this.HairColor());
        compoundTag.m_128405_("AddType_1", this.AddType_1());
        compoundTag.m_128405_("AddType_2", this.AddType_2());
        compoundTag.m_128405_("AddType_3", this.AddType_3());
        compoundTag.m_128405_("JacketType", this.JacketType());
        compoundTag.m_128405_("JacketColor", this.JacketColor());
        compoundTag.m_128405_("PantsType", this.PantsType());
        compoundTag.m_128405_("PantsColor", this.PantsColor());
        compoundTag.m_128405_("GlovesType", this.GlovesType());
        compoundTag.m_128405_("GlovesColor", this.GlovesColor());
        compoundTag.m_128405_("BaubleType_1", this.BaubleType_1());
        compoundTag.m_128405_("BaubleType_2", this.BaubleType_2());
        compoundTag.m_128405_("BaubleType_3", this.BaubleType_3());
        compoundTag.m_128405_("ShoesType", this.ShoesType());
        compoundTag.m_128405_("ShoesColor", this.ShoesColor());
        compoundTag.m_128405_("HatType", this.HatType());
        compoundTag.m_128405_("HatColor", this.HatColor());
        compoundTag.m_128405_("OvercoatType", this.OvercoatType());
        compoundTag.m_128405_("OvercoatColor", this.OvercoatColor());
        if (compoundTag.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compoundTag.m_128469_("Offers"));
        }
        this.m_253224_(compoundTag);
        if (compoundTag.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("WanderTarget"));
        }
        this.m_21678_(compoundTag);
        this.m_252802_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setShieldLevel(compoundTag.m_128451_("ShieldLevel"));
        this.setCombatStyle(compoundTag.m_128451_("CombatStyle"));
        this.setUseSelfNotStringSpellList(compoundTag.m_128471_("UseSelfNotStringSpellList"));
        this.setNoCombatEmptyWeapon(compoundTag.m_128471_("IsNoCombatEmptyWeapon"));
        this.setNoCombatEmptyShield(compoundTag.m_128471_("IsNoCombatEmptyShield"));
        this.setChangeInventoryCooldownTick(compoundTag.m_128451_("ChangeInventoryCooldownTick"));
        this.setCanChangeInventory(compoundTag.m_128471_("IsCanChangeInventory"));
        this.setCanChangeMeleeOrRange(compoundTag.m_128471_("IsCanChangeMeleeOrRange"));
        this.shieldCoolDown = compoundTag.m_128451_("ShieldCoolDown");
        this.shieldCanUse = compoundTag.m_128451_("ShieldCanUse");
        this.setMelee(compoundTag.m_128471_("IsMelee"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.covenSpellLevel = compoundTag.m_128451_("CovenSpellLevel");
        this.setCovens(compoundTag.m_128471_("Covens"));
        this.setMeleeTick(compoundTag.m_128451_("MeleeTick"));
        this.setConjurSpirve(compoundTag.m_128451_("ConjurSpirve"));
        this.setInvisibility(compoundTag.m_128471_("Invisibility"));
        this.setInvisibilityTick(compoundTag.m_128451_("InvisibilityTick"));
        this.setCoven(compoundTag.m_128471_("IsCoven"));
        if (compoundTag.m_128441_("IsFemale")) {
            this.setFemale(compoundTag.m_128471_("IsFemale"));
        }
        if (compoundTag.m_128441_("SkinType")) {
            this.setSkinType(compoundTag.m_128451_("SkinType"));
        }
        if (compoundTag.m_128441_("SkinColor")) {
            this.setSkinColor(compoundTag.m_128451_("SkinColor"));
        }
        if (compoundTag.m_128441_("EyeType")) {
            this.setEyeType(compoundTag.m_128451_("EyeType"));
        }
        if (compoundTag.m_128441_("EyeColor")) {
            this.setEyeColor(compoundTag.m_128451_("EyeColor"));
        }
        if (compoundTag.m_128441_("HairType")) {
            this.setHairType(compoundTag.m_128451_("HairType"));
        }
        if (compoundTag.m_128441_("HairColor")) {
            this.setHairColor(compoundTag.m_128451_("HairColor"));
        }
        if (compoundTag.m_128441_("AddType_1")) {
            this.setAddType_1(compoundTag.m_128451_("AddType_1"));
        }
        if (compoundTag.m_128441_("AddType_2")) {
            this.setAddType_2(compoundTag.m_128451_("AddType_2"));
        }
        if (compoundTag.m_128441_("AddType_3")) {
            this.setAddType_3(compoundTag.m_128451_("AddType_3"));
        }
        if (compoundTag.m_128441_("JacketType")) {
            this.setJacketType(compoundTag.m_128451_("JacketType"));
        }
        if (compoundTag.m_128441_("JacketColor")) {
            this.setJacketColor(compoundTag.m_128451_("JacketColor"));
        }
        if (compoundTag.m_128441_("PantsType")) {
            this.setPantsType(compoundTag.m_128451_("PantsType"));
        }
        if (compoundTag.m_128441_("PantsColor")) {
            this.setPantsColor(compoundTag.m_128451_("PantsColor"));
        }
        if (compoundTag.m_128441_("GlovesType")) {
            this.setGlovesType(compoundTag.m_128451_("GlovesType"));
        }
        if (compoundTag.m_128441_("GlovesColor")) {
            this.setGlovesColor(compoundTag.m_128451_("GlovesColor"));
        }
        if (compoundTag.m_128441_("BaubleType_1")) {
            this.setBaubleType_1(compoundTag.m_128451_("BaubleType_1"));
        }
        if (compoundTag.m_128441_("BaubleType_2")) {
            this.setBaubleType_2(compoundTag.m_128451_("BaubleType_2"));
        }
        if (compoundTag.m_128441_("BaubleType_3")) {
            this.setBaubleType_3(compoundTag.m_128451_("BaubleType_3"));
        }
        if (compoundTag.m_128441_("ShoesType")) {
            this.setShoesType(compoundTag.m_128451_("ShoesType"));
        }
        if (compoundTag.m_128441_("ShoesColor")) {
            this.setShoesColor(compoundTag.m_128451_("ShoesColor"));
        }
        if (compoundTag.m_128441_("HatType")) {
            this.setHatType(compoundTag.m_128451_("HatType"));
        }
        if (compoundTag.m_128441_("HatColor")) {
            this.setHatColor(compoundTag.m_128451_("HatColor"));
        }
        if (compoundTag.m_128441_("OvercoatType")) {
            this.setOvercoatType(compoundTag.m_128451_("OvercoatType"));
        }
        if (compoundTag.m_128441_("OvercoatColor")) {
            this.setOvercoatColor(compoundTag.m_128451_("OvercoatColor"));
        }
        this.m_147285_(this.m_9236_(), compoundTag);
        this.m_253224_(compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(USE_SELF_NOT_SPELL_LIST, (Object)true);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)1);
        this.m_20088_().m_135372_(COMBAT_STYLE, (Object)1);
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_MELEE, (Object)false);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(CAN_CHANGE_INVENTORY, (Object)false);
        this.m_20088_().m_135372_(CAN_CHANGE_MELEE_OR_RANGE, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_WEAPON, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_SHIELD, (Object)false);
        this.m_20088_().m_135372_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)50);
        this.m_20088_().m_135372_(MELEE_TICK, (Object)0);
        this.m_20088_().m_135372_(CONJUR_SPIRVE, (Object)0);
        this.m_20088_().m_135372_(COVENS, (Object)false);
        this.m_20088_().m_135372_(INVISIBILITY, (Object)false);
        this.m_20088_().m_135372_(INVISIBILITY_TICK, (Object)0);
        this.m_20088_().m_135372_(COVEN, (Object)false);
        this.m_20088_().m_135372_(IS_FEMALE, (Object)true);
        this.m_20088_().m_135372_(SKIN_TYPE, (Object)1);
        this.m_20088_().m_135372_(ADD_TYPE_2, (Object)0);
        this.m_20088_().m_135372_(ADD_TYPE_3, (Object)0);
        this.m_20088_().m_135372_(JACKET_TYPE, (Object)1);
        this.m_20088_().m_135372_(JACKET_COLOR, (Object)1);
        this.m_20088_().m_135372_(PANTS_TYPE, (Object)1);
        this.m_20088_().m_135372_(PANTS_COLOR, (Object)1);
        this.m_20088_().m_135372_(GLOVES_TYPE, (Object)0);
        this.m_20088_().m_135372_(GLOVES_COLOR, (Object)1);
        this.m_20088_().m_135372_(BAUBLE_TYPE_1, (Object)0);
        this.m_20088_().m_135372_(BAUBLE_TYPE_2, (Object)0);
        this.m_20088_().m_135372_(BAUBLE_TYPE_3, (Object)0);
        this.m_20088_().m_135372_(SHOES_TYPE, (Object)1);
        this.m_20088_().m_135372_(SHOES_COLOR, (Object)1);
        this.m_20088_().m_135372_(HAT_COLOR, (Object)1);
        this.m_20088_().m_135372_(OVERCOAT_COLOR, (Object)1);
        if (this.m_6095_() == JerotesVillageEntityType.COVEN_HAG_ONE.get()) {
            this.m_20088_().m_135372_(SKIN_COLOR, (Object)7);
            this.m_20088_().m_135372_(EYE_TYPE, (Object)3);
            this.m_20088_().m_135372_(EYE_COLOR, (Object)1);
            this.m_20088_().m_135372_(HAIR_TYPE, (Object)17);
            this.m_20088_().m_135372_(HAIR_COLOR, (Object)3);
            this.m_20088_().m_135372_(ADD_TYPE_1, (Object)0);
            this.m_20088_().m_135372_(HAT_TYPE, (Object)9);
            this.m_20088_().m_135372_(OVERCOAT_TYPE, (Object)1);
        } else if (this.m_6095_() == JerotesVillageEntityType.COVEN_HAG_TWO.get()) {
            this.m_20088_().m_135372_(SKIN_COLOR, (Object)1);
            this.m_20088_().m_135372_(EYE_TYPE, (Object)1);
            this.m_20088_().m_135372_(EYE_COLOR, (Object)1);
            this.m_20088_().m_135372_(HAIR_TYPE, (Object)18);
            this.m_20088_().m_135372_(HAIR_COLOR, (Object)2);
            this.m_20088_().m_135372_(ADD_TYPE_1, (Object)0);
            this.m_20088_().m_135372_(HAT_TYPE, (Object)10);
            this.m_20088_().m_135372_(OVERCOAT_TYPE, (Object)2);
        } else if (this.m_6095_() == JerotesVillageEntityType.PURPLE_SAND_HAG.get()) {
            this.m_20088_().m_135372_(SKIN_COLOR, (Object)2);
            this.m_20088_().m_135372_(EYE_TYPE, (Object)1);
            this.m_20088_().m_135372_(EYE_COLOR, (Object)1);
            this.m_20088_().m_135372_(HAIR_TYPE, (Object)19);
            this.m_20088_().m_135372_(HAIR_COLOR, (Object)1);
            this.m_20088_().m_135372_(ADD_TYPE_1, (Object)1);
            this.m_20088_().m_135372_(HAT_TYPE, (Object)11);
            this.m_20088_().m_135372_(OVERCOAT_TYPE, (Object)3);
        } else {
            this.m_20088_().m_135372_(SKIN_COLOR, (Object)1);
            this.m_20088_().m_135372_(EYE_TYPE, (Object)1);
            this.m_20088_().m_135372_(EYE_COLOR, (Object)1);
            this.m_20088_().m_135372_(HAIR_TYPE, (Object)1);
            this.m_20088_().m_135372_(HAIR_COLOR, (Object)1);
            this.m_20088_().m_135372_(ADD_TYPE_1, (Object)0);
            this.m_20088_().m_135372_(HAT_TYPE, (Object)0);
            this.m_20088_().m_135372_(OVERCOAT_TYPE, (Object)4);
        }
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (COVEN.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (IS_FEMALE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.spell1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.spell1AnimationState);
                    break;
                }
                case 4: {
                    this.spell2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.spell2AnimationState);
                    break;
                }
                case 5: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (!this.m_5912_() && this.m_5448_() == null && MainConfig.MobSayQuestionMark && !this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (interactionHand == InteractionHand.MAIN_HAND) {
                serverPlayer.m_213846_((Component)Component.m_237110_((String)"talk.jerotesvillage.normal", (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
            }
        }
        if (!(this.m_5448_() != null || !this.m_6084_() || this.isTrading() || this instanceof PurpleSandHagEntity || this instanceof CovenHagEntity || player.m_6144_())) {
            if (interactionHand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.offers != null && !this.m_9236_().f_46443_ && !this.offers.isEmpty()) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_8107_() {
        BlockState blockState;
        Level level;
        Player player;
        MerchantOffer merchantOffer2;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.f_19796_.m_188503_(6000) == 1) {
            for (MerchantOffer merchantOffer2 : this.m_6616_()) {
                merchantOffer2.m_45372_();
            }
        }
        this.m_21203_();
        this.m_7562_();
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
            this.shieldCanUse = 0;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCanUse = 1;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (merchantOffer2 = this.m_5448_()) instanceof Player && ((player = (Player)merchantOffer2).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.isMelee() && this.getMeleeTick() <= 0 && this.m_6084_() && this.m_5448_() != null && this.m_217066_(this.m_5448_()) && this.getAttackBoundingBox().m_82381_(this.m_5448_().m_20191_()) && this.m_21574_().m_148306_((Entity)this.m_5448_())) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_7327_((Entity)this.m_5448_());
        }
        if (!this.m_9236_().m_5776_()) {
            this.setMeleeTick(Math.max(0, this.getMeleeTick() - 1));
            this.setConjurSpirve(Math.max(0, this.getConjurSpirve() - 1));
            this.setInvisibilityTick(Math.max(0, this.getInvisibilityTick() - 1));
        }
        List list = this.m_9236_().m_45976_(BaseHagEntity.class, this.m_20191_().m_82377_(10.0, 10.0, 10.0));
        list.removeIf(entity -> (entity.m_5647_() != null || this.m_5647_() != null) && !this.m_7307_((Entity)entity));
        if (!this.m_9236_().f_46443_) {
            this.setCoven(list.size() >= 3);
        }
        if (this.isCoven() && !this.m_20145_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_(), this.m_20227_(1.2f), this.m_20189_(), 0, (double)(this.m_217043_().m_188501_() / 5.0f - 0.1f), 0.15 + (double)(this.m_217043_().m_188501_() / 5.0f), (double)(this.m_217043_().m_188501_() / 5.0f - 0.1f), 0.0125);
        }
        if (this.isInvisibility() && this.m_5448_() != null && !this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5, 0));
        }
        Main.destroyRides((Mob)this);
        this.changeInventory((Mob)this);
        if (this.isMelee()) {
            this.useBlockingItem((Mob)this);
            if (this.m_5912_() && this.shieldCanUse() && this.m_6117_() && this.m_21211_().m_41720_() instanceof ShieldItem) {
                if (this.m_21206_().m_41720_() instanceof ShieldItem) {
                    this.shieldUseOffhandAnimationState.m_216977_(this.f_19797_);
                } else {
                    this.shieldUseOffhandAnimationState.m_216973_();
                    if (this.m_21205_().m_41720_() instanceof ShieldItem) {
                        this.shieldUseMainhandAnimationState.m_216977_(this.f_19797_);
                    } else {
                        this.shieldUseMainhandAnimationState.m_216973_();
                    }
                }
            } else {
                this.shieldUseOffhandAnimationState.m_216973_();
                this.shieldUseMainhandAnimationState.m_216973_();
            }
        }
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new QoaikuMoveControl((Mob)this);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level2 = this.m_9236_();
                if (!(level2 instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level2;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
    }

    protected void m_7562_() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ = (int)((double)this.f_20891_ + 1.1);
        }
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn instanceof BreakShieldEntity) {
            BreakShieldEntity breakShield = (BreakShieldEntity)entityIn;
            this.disableShieldBreak(breakShield.getShieldBreakStrength());
        }
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn) || entityIn.m_213824_()) {
            this.disableShield();
        }
        this.disableShieldTry();
    }

    public boolean isDamageSourceBlocks(DamageSource damageSource) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = this.m_20171_(0.0f, this.m_6080_());
            Vec3 vec32 = object.m_82505_(this.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    protected void m_7909_(float f) {
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_SHIELD_CAN_BREAK) && this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && f >= 3.0f) {
            int n = 1 + Mth.m_14143_((float)f);
            InteractionHand interactionHand = this.m_7655_();
            this.f_20935_.m_41622_(n, (LivingEntity)this, player -> player.m_21190_(interactionHand));
            if (this.f_20935_.m_41619_()) {
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void disableShield() {
        if (this.m_217043_().m_188501_() <= 1.0f - (float)(this.getShieldLevel() - 1) * 0.2f) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldTry() {
        if ((double)this.m_217043_().m_188501_() <= 0.15 - (double)((float)(this.getShieldLevel() - 1) * 0.05f)) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldBreak(int tick) {
        if (tick == 0) {
            return;
        }
        if (this.shieldCoolDown < tick) {
            this.shieldCoolDown = tick;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setMeleeTick(20);
            this.setInvisibility(false);
            if (!this.isMelee() || this.m_21205_().m_41619_()) {
                this.setAnimTick(5);
            } else {
                this.setAnimTick(10);
            }
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 15) {
                this.setAnimationState("attack1");
            } else {
                this.setAnimationState("attack2");
            }
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
            }
            if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                ItemStack hand = this.m_21205_();
                hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return bl;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl) {
            this.stopTrading();
        }
        return bl;
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (JerotesGameRules.JEROTES_ARMOR_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_ARMOR_CAN_BREAK) && damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack head = this.m_6844_(EquipmentSlot.HEAD);
            ItemStack chest = this.m_6844_(EquipmentSlot.CHEST);
            ItemStack legs = this.m_6844_(EquipmentSlot.LEGS);
            ItemStack feet = this.m_6844_(EquipmentSlot.FEET);
            if (!damageSource.m_276093_(DamageTypes.f_268468_) || !head.m_41720_().m_41475_() && !damageSource.m_269533_(DamageTypeTags.f_268490_)) {
                if (head.m_41720_() instanceof ArmorItem) {
                    head.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.HEAD));
                }
                if (chest.m_41720_() instanceof ArmorItem) {
                    chest.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.CHEST));
                }
                if (legs.m_41720_() instanceof ArmorItem) {
                    legs.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.LEGS));
                }
                if (feet.m_41720_() instanceof ArmorItem) {
                    feet.m_41622_((int)damage, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            RandomSource randomSource = serverLevelAccessor.m_213780_();
            this.m_213945_(randomSource, difficultyInstance);
            this.m_213946_(randomSource, difficultyInstance);
            this.setFemale(true);
            this.setSkinType(this.MaxSkinType());
            if (this.m_6095_() == JerotesVillageEntityType.COVEN_HAG_ONE.get()) {
                this.setSkinColor(7);
                this.setEyeType(3);
                this.setEyeColor(1);
                this.setHairType(17);
                this.setHairColor(3);
                this.setAddType_1(0);
                this.setAddType_2(0);
                this.setAddType_3(0);
                this.setJacketColor(1);
                this.setPantsColor(1);
                this.setShoesColor(1);
                this.setHatType(9);
                this.setHatColor(1);
                this.setOvercoatType(1);
                this.setOvercoatColor(1);
            } else if (this.m_6095_() == JerotesVillageEntityType.COVEN_HAG_TWO.get()) {
                this.setSkinColor(1);
                this.setEyeType(1);
                this.setEyeColor(1);
                this.setHairType(18);
                this.setHairColor(2);
                this.setAddType_1(0);
                this.setAddType_2(0);
                this.setAddType_3(0);
                this.setJacketColor(1);
                this.setPantsColor(1);
                this.setShoesColor(1);
                this.setHatType(10);
                this.setHatColor(1);
                this.setOvercoatType(2);
                this.setOvercoatColor(1);
            } else if (this.m_6095_() == JerotesVillageEntityType.PURPLE_SAND_HAG.get()) {
                this.setSkinColor(2);
                this.setEyeType(1);
                this.setEyeColor(1);
                this.setHairType(19);
                this.setHairColor(1);
                this.setAddType_1(1);
                this.setAddType_2(0);
                this.setAddType_3(0);
                this.setJacketColor(1);
                this.setPantsColor(1);
                this.setShoesColor(1);
                this.setHatType(11);
                this.setHatColor(1);
                this.setOvercoatType(3);
                this.setOvercoatColor(1);
            } else {
                this.setSkinColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxSkinColor()));
                if (serverLevelAccessor.m_213780_().m_188501_() < 0.03f) {
                    this.setEyeType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxEyeType()));
                } else {
                    this.setEyeType(1);
                }
                this.setEyeColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxEyeColor()));
                if (serverLevelAccessor.m_213780_().m_188501_() < 0.2f) {
                    this.setAddType_1(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxAddType()));
                    if (serverLevelAccessor.m_213780_().m_188501_() < 0.3f) {
                        this.setAddType_2(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxAddType()));
                        if (this.AddType_1() == this.AddType_2()) {
                            this.setAddType_2(0);
                        }
                        if (serverLevelAccessor.m_213780_().m_188501_() < 0.4f) {
                            this.setAddType_3(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxAddType()));
                            if (this.AddType_2() == this.AddType_3()) {
                                this.setAddType_3(0);
                            }
                        }
                    }
                }
                this.setHairType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)0, (int)this.MaxHairType()));
                this.setHairColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxHairColor()));
                this.setJacketType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxJacketType()));
                this.setJacketColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxJacketColor()));
                this.setPantsType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxPantsType()));
                this.setPantsColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxPantsColor()));
                this.setGlovesType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxGlovesType()));
                this.setGlovesColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxGlovesColor()));
                if (serverLevelAccessor.m_213780_().m_188501_() < 0.2f) {
                    this.setBaubleType_1(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxBaubleType()));
                    if (serverLevelAccessor.m_213780_().m_188501_() < 0.3f) {
                        this.setBaubleType_2(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxBaubleType()));
                        if (this.BaubleType_1() == this.BaubleType_2()) {
                            this.setBaubleType_2(0);
                        }
                        if (serverLevelAccessor.m_213780_().m_188501_() < 0.4f) {
                            this.setBaubleType_3(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxBaubleType()));
                            if (this.BaubleType_2() == this.BaubleType_3()) {
                                this.setBaubleType_3(0);
                            }
                        }
                    }
                }
                this.setShoesType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxShoesType()));
                this.setShoesColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxShoesColor()));
                if (serverLevelAccessor.m_213780_().m_188501_() < 0.2f) {
                    this.setHatType(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxHairType()));
                }
                this.setHatColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxHairColor()));
                this.setOvercoatType(4);
                this.setOvercoatColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)1, (int)this.MaxOvercoatColor()));
            }
            float weaponRandom = this.f_19796_.m_188501_();
            float offhandRandom = this.f_19796_.m_188501_();
            this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon(weaponRandom));
            this.m_8061_(EquipmentSlot.OFFHAND, this.createSpawnOffhand(offhandRandom, weaponRandom));
        }
        return spawnGroupData;
    }

    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public ItemStack createSpawnOffhand(float offhandRandom, float weaponRandom) {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void m_6255_(@Nullable MerchantOffers merchantOffers) {
    }

    public void m_6621_(int n) {
    }

    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(merchantOffer);
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.m_45383_()) {
            int n = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), n));
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public void m_7713_(ItemStack itemStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!itemStack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public int m_7809_() {
        return 0;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12275_;
    }

    protected SoundEvent getTradeUpdatedSound(boolean bl) {
        return bl ? SoundEvents.f_12275_ : JerotesVillageSounds.MEROR_TOOL_USE;
    }

    @Nullable
    public Entity m_5489_(ServerLevel serverLevel) {
        this.stopTrading();
        return super.m_5489_(serverLevel);
    }

    protected void stopTrading() {
        this.m_7189_(null);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.stopTrading();
    }

    public SlotAccess m_141942_(int n) {
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.m_35311_().m_6643_()) {
            return SlotAccess.m_147292_((Container)this.m_35311_(), (int)n2);
        }
        return super.m_141942_(n);
    }

    protected void updateTrades() {
        VillagerTrades.ItemListing[] arritemListing = (VillagerTrades.ItemListing[])HAG.get(1);
        if (arritemListing == null) {
            return;
        }
        MerchantOffers merchantOffers = this.m_6616_();
        this.addOffersFromItemListings(merchantOffers, arritemListing, 8);
    }

    protected void addOffersFromItemListings(MerchantOffers merchantOffers, VillagerTrades.ItemListing[] arritemListing, int n) {
        ArrayList arrayList = Lists.newArrayList((Object[])arritemListing);
        int n2 = 0;
        while (n2 < n && !arrayList.isEmpty()) {
            MerchantOffer merchantOffer = ((VillagerTrades.ItemListing)arrayList.remove(this.f_19796_.m_188503_(arrayList.size()))).m_213663_((Entity)this, this.f_19796_);
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
            ++n2;
        }
    }

    public Vec3 m_7398_(float f) {
        float f2 = Mth.m_14179_((float)f, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.m_20191_().m_82376_() - 1.0, 0.2);
        return this.m_20318_(f).m_82549_(vec3.m_82524_(-f2));
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }
}

