/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.ShiftKeyDownEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.entity.UseBowEntity;
import com.jerotes.jerotes.entity.UseCrossbowEntity;
import com.jerotes.jerotes.entity.UseDaggerEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.entity.WizardEntity;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIVMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesPikeUseGoal;
import com.jerotes.jerotes.goal.JerotesRangedBowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedCrossbowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.tool.ItemToolBaseCrossbow;
import com.jerotes.jerotes.item.tool.ItemToolBaseDagger;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ExplorerEntity
extends MeleeIllagerEntity
implements SpellUseEntity,
ShiftKeyDownEntity,
WizardEntity,
UseDaggerEntity,
UseThrowEntity,
UseThrownJavelinEntity,
InventoryCarrier,
InventoryEntity,
UseBowEntity,
UseCrossbowEntity,
UseShieldEntity,
JerotesEntity,
CrossbowAttackMob,
NeutralMob,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILL_COUNT = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_USE_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILL_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> KILL_USE_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AOE_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AOE_USE_TICK = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(ExplorerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("c41eb6f6-4040-4bf1-b1d3-366a71985f70");
    private static final UUID MAX_HEALTH_MODIFIER_UUID = UUID.fromString("534545d6-2a1b-4822-8a50-984d3939024c");
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("912560ac-eba5-4eb2-b78d-0eab82b85df0");
    private static final UUID FOLLOW_RANGE_MODIFIER_UUID = UUID.fromString("c9a5be24-8aaa-4f56-b76f-703581b4e337");
    private static final String TAG_KILLER = "Killer";
    public boolean isKiller;
    public int spellLevel = 1;
    List<LivingEntity> aoeList;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public ExplorerEntity(EntityType<? extends ExplorerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
    }

    public boolean asUseDagger() {
        return this.isKiller && InventoryEntity.isMeleeWeapon((InventoryEntity)this, (ItemStack)this.m_21205_()) && this.f_19797_ % 120 < 20 && this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) <= 2.5;
    }

    public boolean baseShouldShiftKeyDown() {
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) <= this.daggerShiftKeyDownReach()) {
            ItemToolBaseDagger itemToolBaseDagger;
            Item item = this.m_21205_().m_41720_();
            return (item instanceof ItemToolBaseDagger && (itemToolBaseDagger = (ItemToolBaseDagger)item).canShiftKeyDownUse((LivingEntity)this) || this.asUseDagger()) && this.m_20096_();
        }
        return false;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.EXPLORER_HELMET.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.EXPLORER_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.EXPLORER_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.EXPLORER_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        if (randomSource.m_188501_() < 0.3f) {
            this.m_8061_(equipmentSlot, itemStack);
        }
    }

    @Override
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21055_(Items.f_42717_) || this.m_5912_() && InventoryEntity.isCrossbow((ItemStack)this.m_21205_())) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        if (this.m_5912_() && InventoryEntity.isBow((ItemStack)this.m_21205_())) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        if (InventoryEntity.isCrossbow((ItemStack)this.m_21205_())) {
            return AbstractIllager.IllagerArmPose.NEUTRAL;
        }
        if (this.m_5912_()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return super.m_6768_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIMagicAttackGoal((PathfinderMob)this, 0.2, true, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIVMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedCrossbowAttackGoal((Mob)this, 1.0, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesSpearUseGoal((PathfinderMob)this, 1.0, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesPikeUseGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (ExplorerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new ExplorerKillerAttackGoal(this));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
        }
        if (InventoryEntity.isBow((ItemStack)handItem)) {
            this.useBowShoot((LivingEntity)this, livingEntity, f, this.getBowLevel(), 20);
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (InventoryEntity.isCrossbow((ItemStack)handItem)) {
            this.useCrossbowShoot((LivingEntity)this, 3.15f);
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public ItemStack m_6298_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)item;
            Predicate predicate = projectileWeaponItem.m_6442_();
            ItemStack itemStack2 = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            if (predicate.test(this.m_21205_())) {
                itemStack2 = this.m_21205_();
            } else if (predicate.test(this.m_21206_())) {
                itemStack2 = this.m_21206_();
            } else {
                for (int n = 0; n < this.inventoryCount(); ++n) {
                    ItemStack finds = this.mobInventory().m_8020_(n);
                    if (!predicate.test(finds)) continue;
                    itemStack2 = finds;
                    break;
                }
            }
            return itemStack2.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemStack2;
        }
        return ItemStack.f_41583_;
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float f) {
        float f2;
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item;
            f2 = itemToolBaseCrossbow.m_40945_(itemStack);
        } else {
            f2 = 3.15f;
        }
        this.m_32322_((LivingEntity)this, livingEntity, projectile, f, f2);
    }

    public void m_32322_(LivingEntity livingEntity, LivingEntity livingEntity2, Projectile projectile, float f, float f2) {
        double d0 = livingEntity2.m_20185_() - livingEntity.m_20185_();
        double d1 = livingEntity2.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = livingEntity2.m_20227_(0.3333333333333333) - projectile.m_20186_() + d2 * 0.1;
        Vector3f vector3f = this.m_252851_(livingEntity, new Vec3(d0, d3, d1), f);
        projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), f2, (float)Math.max(0, 20 - this.getBowLevel()) / 5.0f);
        livingEntity.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public AbstractArrow getCustomArrow(ItemStack itemStack, float f) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemStack, (float)f);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean bl) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)bl);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem instanceof BowItem || projectileWeaponItem instanceof CrossbowItem || super.m_5886_(projectileWeaponItem);
    }

    @Override
    public boolean canUseCrossbow() {
        return true;
    }

    @Override
    public boolean canUseThrow() {
        return true;
    }

    @Override
    public boolean canUseRangeJavelin() {
        return true;
    }

    @Override
    public boolean canUseBow() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.EXPLORER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.EXPLORER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_276146_) && this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.EXPLORER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.EXPLORER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42383_);
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44977_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    public boolean m_20151_() {
        if (this.isKiller) {
            return true;
        }
        return super.m_20151_();
    }

    public boolean m_20067_() {
        if (this.isKiller && this.m_20145_()) {
            return true;
        }
        return super.m_20067_();
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.getKillUseTick() > 0 || this.getAoeUseTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public int getKillCount() {
        return (Integer)this.m_20088_().m_135370_(KILL_COUNT);
    }

    public void setKillCount(int n) {
        this.m_20088_().m_135381_(KILL_COUNT, (Object)n);
    }

    public int getJumpTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_TICK);
    }

    public void setJumpTick(int n) {
        this.m_20088_().m_135381_(JUMP_TICK, (Object)n);
    }

    public int getJumpUseTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_USE_TICK);
    }

    public void setJumpUseTick(int n) {
        this.m_20088_().m_135381_(JUMP_USE_TICK, (Object)n);
    }

    public int getKillTick() {
        return (Integer)this.m_20088_().m_135370_(KILL_TICK);
    }

    public void setKillTick(int n) {
        this.m_20088_().m_135381_(KILL_TICK, (Object)n);
    }

    public int getKillUseTick() {
        return (Integer)this.m_20088_().m_135370_(KILL_USE_TICK);
    }

    public void setKillUseTick(int n) {
        this.m_20088_().m_135381_(KILL_USE_TICK, (Object)n);
    }

    public int getAoeTick() {
        return (Integer)this.m_20088_().m_135370_(AOE_TICK);
    }

    public void setAoeTick(int n) {
        this.m_20088_().m_135381_(AOE_TICK, (Object)n);
    }

    public int getAoeUseTick() {
        return (Integer)this.m_20088_().m_135370_(AOE_USE_TICK);
    }

    public void setAoeUseTick(int n) {
        this.m_20088_().m_135381_(AOE_USE_TICK, (Object)n);
    }

    public boolean specialAction() {
        return this.getJumpUseTick() > 0 || this.getKillUseTick() > 0 || this.getAoeUseTick() > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        if (component != null && (component.getString().equals(TAG_KILLER) || component.getString().equals("Assassin")) != this.isKiller) {
            if (!this.m_9236_().m_5776_()) {
                this.setKillCount(0);
            }
            this.m_21051_(Attributes.f_22276_).m_22120_(MAX_HEALTH_MODIFIER_UUID);
            this.m_21051_(Attributes.f_22281_).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
            this.m_21051_(Attributes.f_22279_).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
            this.m_21051_(Attributes.f_22277_).m_22120_(FOLLOW_RANGE_MODIFIER_UUID);
        }
        this.isKiller = component != null && component.getString().equals(TAG_KILLER);
    }

    public void SpellUseAfterAttack(String string, MagicType magicType, MagicType magicType2) {
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(10);
        }
    }

    public List<SpellTypeInterface> SelfMainSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public List<SpellTypeInterface> SelfAddSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    @Override
    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public boolean isMagicUseStyle() {
        return this.getSpellTick() > 0;
    }

    public boolean isSpellHumanoid() {
        return true;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.isKiller) {
            compoundTag.m_128379_(TAG_KILLER, true);
        }
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128405_("KillCount", this.getKillCount());
        compoundTag.m_128405_("JumpTick", this.getJumpTick());
        compoundTag.m_128405_("JumpUseTick", this.getJumpUseTick());
        compoundTag.m_128405_("KillTick", this.getKillTick());
        compoundTag.m_128405_("KillUseTick", this.getKillUseTick());
        compoundTag.m_128405_("AoeTick", this.getAoeTick());
        compoundTag.m_128405_("AoeUseTick", this.getAoeUseTick());
        this.m_21678_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        this.setKillCount(compoundTag.m_128451_("KillCount"));
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_(TAG_KILLER, 99)) {
            this.isKiller = compoundTag.m_128471_(TAG_KILLER);
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setJumpTick(compoundTag.m_128451_("JumpTick"));
        this.setJumpUseTick(compoundTag.m_128451_("JumpUseTick"));
        this.setKillTick(compoundTag.m_128451_("KillTick"));
        this.setKillUseTick(compoundTag.m_128451_("KillUseTick"));
        this.setAoeTick(compoundTag.m_128451_("AoeTick"));
        this.setAoeUseTick(compoundTag.m_128451_("AoeUseTick"));
        this.addKillerAbout();
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(KILL_COUNT, (Object)0);
        this.m_20088_().m_135372_(JUMP_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(KILL_TICK, (Object)0);
        this.m_20088_().m_135372_(KILL_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(AOE_TICK, (Object)0);
        this.m_20088_().m_135372_(AOE_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (!this.m_5912_() && this.isKiller && !this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (interactionHand == InteractionHand.MAIN_HAND) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)("Kill Count " + this.getKillCount())).m_130940_(ChatFormatting.RED));
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
        }
        if (this.isKiller && this.m_6084_()) {
            ServerLevel serverLevel;
            Level level;
            LivingEntity target;
            ServerLevel serverLevel2;
            Level level2;
            if (this.getJumpTick() >= 240 && this.spellNeed(0.0f, 32.0f, 2) && !this.m_9236_().m_5776_()) {
                this.setJumpUseTick(30);
                this.setJumpTick(0);
            }
            if (this.getJumpUseTick() == 30) {
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.EXPLORER_JUMP, 5.0f, 1.0f);
                }
                if ((level2 = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel2 = (ServerLevel)level2;
                    if (!this.m_20145_()) {
                        serverLevel2.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.LEAPING_SLAYER_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getJumpUseTick() >= 10) {
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
                this.m_21573_().m_26573_();
            }
            if (this.getJumpUseTick() == 10) {
                this.RushAttack();
            }
            if (this.getKillTick() >= 360 && this.spellNeed(0.0f, 16.0f, 2) && !this.m_9236_().m_5776_()) {
                this.setKillUseTick(40);
                this.setKillTick(0);
            }
            if (this.getKillUseTick() == 40) {
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.EXPLORER_KILL, 5.0f, 1.0f);
                }
                if ((level2 = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel2 = (ServerLevel)level2;
                    if (!this.m_20145_()) {
                        serverLevel2.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.PIERCING_SLAYER_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getKillUseTick() >= 40) {
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
                this.m_21573_().m_26573_();
            }
            if (this.getKillUseTick() < 30 && this.getKillUseTick() >= 5) {
                this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get(), 5, 0, false, false), (Entity)this);
            }
            if (this.getKillUseTick() == 10 && (target = this.m_5448_()) != null && (level = this.m_9236_()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                Vec3 targetPos = target.m_20182_();
                Vec3 lookVec = this.m_20154_().m_82541_();
                Vec3 dashEndPos = targetPos.m_82549_(lookVec.m_82490_(6.0));
                Vec3 startPos = this.m_20182_();
                this.drawDashPath(serverLevel, startPos, dashEndPos, true);
                this.m_6021_(dashEndPos.f_82479_, dashEndPos.f_82480_, dashEndPos.f_82481_);
                this.damageEntitiesAlongPath(serverLevel, startPos, dashEndPos);
                if (!this.m_20067_()) {
                    this.m_5496_(SoundEvents.f_12316_, 1.0f, 0.8f);
                }
            }
            if (!(this.getKillUseTick() != 2 || this.m_20096_() && this.m_9236_().m_8055_(this.m_20097_().m_7494_()).m_60795_() && this.m_9236_().m_8055_(this.m_20097_().m_7494_().m_7494_()).m_60795_())) {
                BlockPos blockPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)this, (int)3);
                this.m_6021_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            }
            if (this.getAoeTick() >= 360 && this.spellNeed(0.0f, 16.0f, 2) && !this.m_9236_().m_5776_()) {
                this.setAoeUseTick(40);
                this.setAoeTick(0);
            }
            if (this.getAoeUseTick() == 40) {
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.EXPLORER_AOE, 5.0f, 1.0f);
                }
                if ((serverLevel = this.m_9236_()) instanceof ServerLevel) {
                    serverLevel2 = serverLevel;
                    if (!this.m_20145_()) {
                        serverLevel2.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.INSTANT_SLAYER_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.getAoeUseTick() < 30 && this.getAoeUseTick() >= 5) {
                this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get(), 5, 0, false, false), (Entity)this);
            }
            if (this.getAoeUseTick() < 25 && this.getAoeUseTick() >= 10) {
                for (int i2 = 0; i2 <= 256; ++i2) {
                    Level level3;
                    Vec3 vec3 = new Vec3(this.m_20185_() + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f * 10.0f), this.m_20186_() + 0.1, this.m_20189_() + (double)((this.m_217043_().m_188501_() - 0.5f) * 2.0f * 10.0f));
                    if (!(vec3.m_82554_(this.m_20318_(0.0f)) <= 10.0) || !((level3 = this.m_9236_()) instanceof ServerLevel)) continue;
                    ServerLevel serverLevel3 = (ServerLevel)level3;
                    serverLevel3.m_8767_((ParticleOptions)ParticleTypes.f_123808_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, 0.0, 0.0125, 0.0, 1.0);
                    serverLevel3.m_8767_((ParticleOptions)ParticleTypes.f_123797_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), 0, 0.0, 0.0125, 0.0, 1.0);
                }
            }
            if (this.getAoeUseTick() == 16) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82406_(9.0));
                list.removeIf(livingEntity -> AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)livingEntity));
                this.aoeList = list;
            }
            if (this.getAoeUseTick() <= 15 && this.getAoeUseTick() > 5 && this.aoeList != null && !this.aoeList.isEmpty() && this.aoeList.get(0) != null) {
                LivingEntity hurt = this.aoeList.get(0);
                AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
                AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.5f, (float)1.0f, (boolean)false, (float)0.0f);
                this.aoeList.remove(hurt);
                level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    this.drawDashPath(serverLevel, this.m_20318_(0.0f), hurt.m_20318_(0.0f), false);
                }
                this.m_6021_(hurt.m_20185_(), hurt.m_20186_(), hurt.m_20189_());
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.m_5912_()) {
                    this.setJumpTick(Math.min(240, this.getJumpTick() + 1));
                } else {
                    this.setJumpTick(0);
                }
                this.setJumpUseTick(Math.max(0, this.getJumpUseTick() - 1));
                this.setKillTick(Math.min(360, this.getKillTick() + 1));
                this.setKillUseTick(Math.max(0, this.getKillUseTick() - 1));
                this.setAoeTick(Math.min(480, this.getAoeTick() + 1));
                this.setAoeUseTick(Math.max(0, this.getAoeUseTick() - 1));
            }
        }
    }

    public boolean spellNeed(float min, float max, int time) {
        return this.getSpellTick() <= 0 && !this.specialAction() && this.m_6084_() && !this.m_21525_() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_20270_((Entity)this) > min && this.m_5448_().m_20270_((Entity)this) < max && this.m_217043_().m_188503_(time * 20) == 1;
    }

    public boolean RushAttack() {
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 0.5f;
        this.m_20334_(f3 *= f7 / f6 * 2.0f, f4 *= f7 / f6 * 2.0f + 0.5f, f5 *= f7 / f6 * 2.0f);
        return true;
    }

    private void drawDashPath(ServerLevel level, Vec3 start, Vec3 end, boolean type) {
        double distance = start.m_82554_(end);
        int particleCount = (int)(distance * 5.0);
        if (type) {
            for (int i = 0; i <= particleCount; ++i) {
                for (int i2 = 0; i2 <= 64; ++i2) {
                    double progress = (double)i / (double)particleCount;
                    double x = Mth.m_14139_((double)progress, (double)start.f_82479_, (double)end.f_82479_);
                    double y = Mth.m_14139_((double)progress, (double)start.f_82480_, (double)end.f_82480_) + 1.25;
                    double z = Mth.m_14139_((double)progress, (double)start.f_82481_, (double)end.f_82481_);
                    level.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.BLOODY_SCREAM.get()), x + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.25f), y + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.25f), z + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.25f), 0, (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), 0.125);
                }
            }
        } else {
            double z;
            double y;
            double x;
            double progress;
            int i2;
            int i;
            for (i = 0; i <= particleCount; ++i) {
                for (i2 = 0; i2 <= 64; ++i2) {
                    progress = (double)i / (double)particleCount;
                    x = Mth.m_14139_((double)progress, (double)start.f_82479_, (double)end.f_82479_);
                    y = Mth.m_14139_((double)progress, (double)start.f_82480_, (double)end.f_82480_) + 1.25;
                    z = Mth.m_14139_((double)progress, (double)start.f_82481_, (double)end.f_82481_);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123808_, x + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), y + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), z + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), 0, (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), 0.0125);
                }
            }
            for (i = 0; i <= particleCount; ++i) {
                for (i2 = 0; i2 <= 64; ++i2) {
                    progress = (double)i / (double)particleCount;
                    x = Mth.m_14139_((double)progress, (double)start.f_82479_, (double)end.f_82479_);
                    y = Mth.m_14139_((double)progress, (double)start.f_82480_, (double)end.f_82480_) + 1.25;
                    z = Mth.m_14139_((double)progress, (double)start.f_82481_, (double)end.f_82481_);
                    level.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.BLAMER_SOUL.get()), x + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), y + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), z + (double)((this.m_217043_().m_188501_() - 0.5f) * 0.05f), 0, (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), (double)((this.m_217043_().m_188501_() - 0.5f) * 0.15f), 0.0125);
                }
            }
        }
    }

    private void damageEntitiesAlongPath(ServerLevel level, Vec3 start, Vec3 end) {
        double radius = 1.5;
        AABB pathBox = new AABB(Math.min(start.f_82479_, end.f_82479_) - radius, Math.min(start.f_82480_, end.f_82480_) - radius, Math.min(start.f_82481_, end.f_82481_) - radius, Math.max(start.f_82479_, end.f_82479_) + radius, Math.max(start.f_82480_, end.f_82480_) + radius, Math.max(start.f_82481_, end.f_82481_) + radius);
        List list = this.m_9236_().m_45976_(LivingEntity.class, pathBox);
        for (LivingEntity hurt : list) {
            if (hurt == null || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !this.isEntityOnPath(hurt.m_20182_(), start, end, radius)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.25f, (float)3.0f, (boolean)false, (float)0.0f);
            if (!bl) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123797_, hurt.m_20185_(), hurt.m_20186_() + (double)(hurt.m_20206_() / 2.0f), hurt.m_20189_(), 5, (double)(this.m_217043_().m_188501_() - 0.5f), 0.3, (double)(this.m_217043_().m_188501_() - 0.5f), 0.1);
        }
    }

    private boolean isEntityOnPath(Vec3 entityPos, Vec3 pathStart, Vec3 pathEnd, double radius) {
        Vec3 pathVec = pathEnd.m_82546_(pathStart);
        Vec3 entityToStart = entityPos.m_82546_(pathStart);
        double pathLength = pathVec.m_82553_();
        double dot = entityToStart.m_82526_(pathVec) / (pathLength * pathLength);
        Vec3 closestPoint = pathStart.m_82549_(pathVec.m_82490_(dot = Mth.m_14008_((double)dot, (double)0.0, (double)1.0)));
        return entityPos.m_82554_(closestPoint) <= radius;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        if (bl) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.EXPLORER_ATTACK, 1.0f, 1.0f);
            }
            if (this.isKiller && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200, 0, false, false), (Entity)this);
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, false), (Entity)this);
                }
                if (!this.m_9236_().f_46443_) {
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 72000, 1, false, false), (Entity)this);
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19600_, 72000, 2, false, false), (Entity)this);
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19594_, 72000, 4, false, false), (Entity)this);
                    this.m_147207_(new MobEffectInstance(MobEffects.f_19601_, 1, 1, false, false), (Entity)this);
                }
                if (!this.m_9236_().m_5776_()) {
                    this.setJumpTick(0);
                }
            }
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (this.isKiller && (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_))) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl && !this.m_9236_().m_5776_()) {
            this.setJumpTick(this.getJumpTick() + (int)amount);
        }
        return bl;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (this.isKiller) {
            if (mobEffectInstance.m_19544_() == MobEffects.f_19615_) {
                return false;
            }
            if (mobEffectInstance.m_19544_() == MobEffects.f_216964_) {
                return false;
            }
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        if (this.isKiller) {
            if (!this.m_9236_().m_5776_()) {
                this.m_147207_(new MobEffectInstance(MobEffects.f_19617_, 1200, 2, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance(MobEffects.f_19616_, 1200, 3, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance(MobEffects.f_19605_, 120, 2, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get(), 240, 0, false, false), (Entity)this);
                this.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 1200, 1, false, false), (Entity)this);
                this.setKillCount(this.getKillCount() + 1);
            }
            this.addKillerAbout();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.m_5634_(livingEntity.m_21233_() / 10.0f);
                for (MobEffectInstance mobEffectInstance : livingEntity.m_21220_()) {
                    if (!mobEffectInstance.m_19544_().m_19486_() || this.m_9236_().m_5776_()) continue;
                    this.m_147207_(mobEffectInstance, (Entity)this);
                }
            }
        }
    }

    public void addKillerAbout() {
        if (!this.m_9236_().f_46443_) {
            int n = Math.min(this.getKillCount(), 666);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22120_(MAX_HEALTH_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22120_(FOLLOW_RANGE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22118_(new AttributeModifier(MAX_HEALTH_MODIFIER_UUID, "Killer max health", (double)(0.5f * (float)n), AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Killer attack damage", (double)(0.05f * (float)n), AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Killer movement speed", (double)(5.0E-4f * (float)n), AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22118_(new AttributeModifier(FOLLOW_RANGE_MODIFIER_UUID, "Killer follow range", (double)(0.1f * (float)n), AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        if (weaponRandom > 0.85f) {
            return new ItemStack((ItemLike)Items.f_42717_);
        }
        return new ItemStack((ItemLike)Items.f_42383_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    static class ExplorerKillerAttackGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public ExplorerKillerAttackGoal(ExplorerEntity explorer) {
            super((Mob)explorer, LivingEntity.class, 0, true, true, LivingEntity::m_5789_);
        }

        public boolean m_8036_() {
            if (((ExplorerEntity)this.f_26135_).isKiller && super.m_8036_()) {
                return this.f_26050_ != null && (!Main.canSee((Entity)this.f_26135_, (Entity)this.f_26050_) || this.f_26135_.m_20145_());
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_26135_.m_21310_(0);
        }
    }
}

