/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.SpellIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireSpitterEntity
extends SpellIllagerEntity
implements RangedAttackMob,
SpellUseEntity {
    public AnimationState drinkAnimationState = new AnimationState();
    public AnimationState spitteAnimationState = new AnimationState();
    public int spellLevel = 2;

    public FireSpitterEntity(EntityType<? extends FireSpitterEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 25;
        this.m_21553_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false){

            public boolean m_8036_() {
                if (FireSpitterEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.m_21023_(MobEffects.f_19607_) && this.getSpellOneTick() <= 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(60);
                this.setSpellOneTick(120);
                this.setAnimTick(60);
                this.setAnimationState("spitte");
            }
            OtherSpellList.OminousFlames(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        }
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.FIRE_SPITTER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.FIRE_SPITTER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.FIRE_SPITTER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.FIRE_SPITTER_CHEER;
    }

    @Override
    protected SoundEvent m_7894_() {
        return JerotesVillageSounds.FIRE_SPITTER_SPITTE;
    }

    @Override
    public SpellcasterIllager.IllagerSpell customSpell() {
        return SpellcasterIllager.IllagerSpell.WOLOLO;
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.getSpellOneTick() > 0 && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 12.0f || this.m_21211_().m_41720_() instanceof PotionItem) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "drink")) {
            return 1;
        }
        if (Objects.equals(animation, "spitte")) {
            return 2;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.drinkAnimationState);
        list.add(this.spitteAnimationState);
        return list;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.drinkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.drinkAnimationState);
                    break;
                }
                case 2: {
                    this.spitteAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.spitteAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!(this.m_6117_() || this.m_5448_() == null && (this.m_217043_().m_188503_(600) != 1 || this.m_21525_()) || this.m_21023_(MobEffects.f_19607_) || this.m_21206_().m_41720_() != Items.f_42589_ || PotionUtils.m_43579_((ItemStack)this.m_21206_()) != Potions.f_43611_ && PotionUtils.m_43579_((ItemStack)this.m_21206_()) != Potions.f_43610_)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.FIRE_SPITTER_DRINK, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.m_6672_(InteractionHand.OFF_HAND);
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(35);
                this.setSpellOneTick(35);
                this.setAnimTick(35);
                this.setAnimationState("drink");
            }
        }
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268745_)) {
            if (!(this.m_6117_() || this.m_21023_(MobEffects.f_19607_) || this.m_21206_().m_41720_() != Items.f_42589_ || PotionUtils.m_43579_((ItemStack)this.m_21206_()) != Potions.f_43611_ && PotionUtils.m_43579_((ItemStack)this.m_21206_()) != Potions.f_43610_)) {
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.FIRE_SPITTER_DRINK, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                }
                this.m_6672_(InteractionHand.OFF_HAND);
                if (!this.m_9236_().m_5776_()) {
                    this.setSpellTick(35);
                    this.setSpellOneTick(35);
                    this.setAnimTick(35);
                    this.setAnimationState("drink");
                }
            }
            return super.m_6469_(damagesource, amount / 5.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        Potion potion = Potions.f_43610_;
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }
}

