/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotes.goal.JerotesFireRangeAttackGoal;
import com.jerotes.jerotes.goal.JerotesFlyingRandomStrollGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.SpellIllagerEntity;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.goal.SerponOpenDoorGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GavilerEntity
extends SpellIllagerEntity
implements RangedAttackMob,
SpellUseEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState upAnimationState = new AnimationState();
    public AnimationState downAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6, false);
    public boolean isLandNavigatorType = true;
    public int spellLevel = 3;

    public GavilerEntity(EntityType<? extends GavilerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 80;
        this.m_21553_(false);
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22280_, 1.25);
        builder = builder.m_22268_(Attributes.f_22276_, 80.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        return builder;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new SerponOpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesFireRangeAttackGoal((RangedAttackMob)this, 1.25, 60, 12.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesAttackAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 16.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new JerotesFlyingRandomStrollGoal((PathfinderMob)this, 0.8, 10));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, false){

            @Override
            public boolean m_8036_() {
                if (GavilerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, new HighNearestAttackableTargetGoal<AbstractVillager>((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, new HighNearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        int spellLevel = this.getSpellLevel();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Master".equals(string)) {
            spellLevel = this.getSpellLevel() + 1;
        }
        if (this.m_20270_((Entity)livingEntity) < 16.0f && !this.specialAction()) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setAnimTick(20);
                this.setAnimationState("shoot");
            }
            OtherSpellList.PushForce(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        }
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.GAVILER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.GAVILER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.GAVILER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.GAVILER_CHEER;
    }

    @Override
    protected SoundEvent m_7894_() {
        return JerotesVillageSounds.GAVILER_SHOOT;
    }

    @Override
    public SpellcasterIllager.IllagerSpell customSpell() {
        return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    public boolean specialAction() {
        return this.getSpellTick() > 0 || this.getSpellOneTick() > 0 || this.getSpellTwoTick() > 0;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "shoot")) {
            return 1;
        }
        if (Objects.equals(animation, "up")) {
            return 2;
        }
        if (Objects.equals(animation, "down")) {
            return 3;
        }
        if (Objects.equals(animation, "dead")) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.shootAnimationState);
        list.add(this.upAnimationState);
        list.add(this.downAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                    break;
                }
                case 2: {
                    this.upAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.upAnimationState);
                    break;
                }
                case 3: {
                    this.downAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.downAnimationState);
                    break;
                }
                case 4: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        BlockState blockState;
        boolean fly;
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        boolean bl = fly = !this.m_20096_() || this.f_19862_ || this.m_5912_();
        if (fly && this.isLandNavigatorType) {
            this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
            this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!fly && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (((blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60795_() || (double)this.m_21573_().m_26570_().m_77406_().m_123342_() > this.m_20186_() + 1.0 || this.m_5448_() != null && !this.m_5448_().m_20096_() || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() + 1.0) && this.m_20096_() || this.f_19862_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.5, 0.0));
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_20096_()) {
            for (int i = 0; i < 3; ++i) {
                if (!this.m_9236_().f_46443_) continue;
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.PUSH_FORCE.get(), this.m_20208_(1.5), this.m_20186_(), this.m_20262_(1.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_5448_() != null && (this.m_5448_().m_20188_() > this.m_20188_() && !this.m_5448_().m_20096_() || this.m_20188_() < this.m_5448_().m_20188_() + (double)(this.m_5448_().m_20206_() + 0.5f) && this.m_5448_().m_20096_())) {
            this.m_6853_(false);
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20188_() + 6.0 < this.m_20188_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        List listRaider = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(16.0, 16.0, 16.0));
        listRaider.removeIf(entity -> this.m_5448_() == entity || entity == this || entity.m_5448_() == this || (!EntityFactionFind.isRaider((LivingEntity)entity) || this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        listRaider.removeIf(entity -> entity.m_5448_() != null);
        for (Object raider : listRaider) {
            if (raider == null) continue;
            Vec3 vec32 = raider.m_20184_();
            if (!raider.m_20096_() && raider.m_20184_().f_82480_ < 0.0) {
                raider.m_20256_(vec32.m_82542_(1.0, 0.6, 1.0));
            }
            if (this.f_19797_ % 5 != 0) continue;
            raider.m_183634_();
        }
        List listArrow = this.m_9236_().m_45976_(Projectile.class, this.m_20191_().m_82377_(4.0, 4.0, 4.0));
        listArrow.removeIf(entity -> !(entity instanceof AbstractArrow) && !(entity instanceof ThrowableProjectile));
        listArrow.removeIf(entity -> {
            LivingEntity livingEntity;
            Entity patt16486$temp = entity.m_19749_();
            return patt16486$temp instanceof LivingEntity && AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)(livingEntity = (LivingEntity)patt16486$temp));
        });
        for (Projectile arrow : listArrow) {
            if (arrow == null || !Main.canSee((Entity)arrow, (Entity)this) && (arrow.m_19749_() == null || !Main.canSee((Entity)arrow.m_19749_(), (Entity)this))) continue;
            arrow.m_20256_(arrow.m_20184_().m_82542_(-1.0, -1.0, -1.0));
        }
        if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > 24.0f && !this.specialAction()) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.RushAttack();
        }
        List listTarget = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        listTarget.removeIf(entity -> {
            Mob mob;
            return !(this.m_5448_() == entity || !entity.m_7307_((Entity)this) && (entity instanceof AbstractVillager || entity instanceof IronGolem) || entity instanceof Player || entity instanceof Mob && (mob = (Mob)entity).m_5448_() == this);
        });
        listTarget.removeIf(entity -> {
            Player player;
            return entity instanceof Player && (player = (Player)entity).m_7307_((Entity)this);
        });
        listTarget.removeIf(entity -> entity == this);
        listTarget.removeIf(entity -> this.m_5448_() != entity && !this.m_142582_((Entity)entity));
        int spellLevel = this.getSpellLevel();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Master".equals(string)) {
            spellLevel = this.getSpellLevel() + 1;
        }
        if (this.m_5448_() != null && !this.m_21525_() && this.m_5448_().m_6084_() && !this.specialAction() && this.m_142582_((Entity)this.m_5448_()) && this.getSpellOneTick() <= 0 && this.getSpellThreeTick() <= 0 && this.m_217043_().m_188503_(20) == 1 && this.m_5448_().m_20096_() && this.m_20270_((Entity)this.m_5448_()) <= (float)(spellLevel * 8)) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setSpellOneTick(20);
                this.setSpellThreeTick(120);
                this.setAnimTick(20);
                this.setAnimationState("up");
            }
            OtherSpellList.FloatingForce(spellLevel, (LivingEntity)this, (Entity)this).spellUse();
        }
        if (this.m_5448_() != null && !this.m_21525_() && this.m_5448_().m_6084_() && !this.specialAction() && this.m_142582_((Entity)this.m_5448_()) && this.getSpellTwoTick() <= 0 && this.getSpellThreeTick() <= 0 && this.m_217043_().m_188503_(20) == 1 && !this.m_5448_().m_20096_() && this.m_20270_((Entity)this.m_5448_()) <= (float)(spellLevel * 8)) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setSpellTwoTick(20);
                this.setSpellThreeTick(120);
                this.setAnimTick(20);
                this.setAnimationState("down");
            }
            OtherSpellList.GravityForce(spellLevel, (LivingEntity)this, (Entity)this).spellUse();
        }
    }

    public boolean RushAttack() {
        float f = this.m_146908_();
        float f2 = this.m_146909_();
        float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = 0.03f;
        float f8 = f4 *= f7 / f6 * 2.0f;
        this.m_5997_(f3 *= f7 / f6 * 2.0f, f8, f5 *= f7 / f6 * 2.0f);
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268526_) || damageSource.m_276093_(DamageTypes.f_268659_) || damageSource.m_276093_(DamageTypes.f_268513_) || damageSource.m_276093_(DamageTypes.f_268576_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            return super.m_6469_(damagesource, amount / 5.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        this.idleAnimationState.m_216973_();
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

