/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Boss.OminousBannerProjectionEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.SpellIllagerEntity;
import com.jerotes.jerotesvillage.entity.Other.UncleanTentacleEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class NecromancyWarlockEntity
extends SpellIllagerEntity
implements RangedAttackMob,
SpellUseEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState gearAnimationState = new AnimationState();
    public AnimationState screamAnimationState = new AnimationState();
    public AnimationState whisperAnimationState = new AnimationState();
    public AnimationState rainAnimationState = new AnimationState();
    public AnimationState fogAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6, false);
    public int spellLevel = 3;

    public NecromancyWarlockEntity(EntityType<? extends NecromancyWarlockEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 80;
        this.m_21553_(false);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 95.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.4, 120, 12.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false){

            public boolean m_8036_() {
                if (NecromancyWarlockEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.getSpellTick() > 0) {
            return;
        }
        List listRaider = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        listRaider.removeIf(entity -> this.m_5448_() == entity || entity == this || entity.m_5448_() == this || (!EntityFactionFind.isRaider((LivingEntity)entity) || this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        listRaider.removeIf(entity -> entity instanceof NecromancyWarlockEntity);
        int spellLevel = this.getSpellLevel();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Master".equals(string)) {
            spellLevel = this.getSpellLevel() + 1;
        }
        List listTentacle = this.m_9236_().m_45976_(UncleanTentacleEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listRaider.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        List ListWarlock = this.m_9236_().m_45976_(NecromancyWarlockEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        ListWarlock.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        if (this.f_19796_.m_188501_() < 0.8f && listRaider.isEmpty() && listTentacle.size() <= ListWarlock.size() * 4) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(40);
                this.setAnimTick(20);
                this.setAnimationState("summon");
            }
            OtherSpellList.EvilSummoning(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else if (this.f_19796_.m_188501_() < 0.2f && this.m_20270_((Entity)livingEntity) < 12.0f && livingEntity.m_20096_()) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(90);
                this.setSpellOneTick(90);
                this.setAnimTick(90);
                this.setAnimationState("gear");
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.NECROMANCY_WARLOCK_GEAR, this.m_5720_(), 5.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
            }
        } else if (this.f_19796_.m_188501_() < 0.2f) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setAnimTick(20);
                this.setAnimationState("scream");
            }
            OtherSpellList.BloodyScream(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else if (this.f_19796_.m_188501_() < 0.15f && !livingEntity.m_21023_(MobEffects.f_216964_)) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(25);
                this.setAnimTick(25);
                this.setAnimationState("whisper");
            }
            OtherSpellList.WarlockWhisper(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else if (this.f_19796_.m_188501_() < 0.4f) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(15);
                this.setSpellTwoTick(15);
                this.setAnimTick(15);
                this.setAnimationState("rain");
            }
        } else if (this.f_19796_.m_188501_() < 0.2f && listTentacle.size() <= ListWarlock.size() * 4) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(40);
                this.setAnimTick(20);
                this.setAnimationState("summon");
            }
            OtherSpellList.EvilSummoning(spellLevel, (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(15);
            this.setSpellThreeTick(15);
            this.setAnimTick(15);
            this.setAnimationState("fog");
        }
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_CHEER;
    }

    @Override
    protected SoundEvent m_7894_() {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_GEAR;
    }

    @Override
    public SpellcasterIllager.IllagerSpell customSpell() {
        return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "gear")) {
            return 1;
        }
        if (Objects.equals(animation, "scream")) {
            return 2;
        }
        if (Objects.equals(animation, "whisper")) {
            return 3;
        }
        if (Objects.equals(animation, "rain")) {
            return 4;
        }
        if (Objects.equals(animation, "fog")) {
            return 5;
        }
        if (Objects.equals(animation, "summon")) {
            return 6;
        }
        if (Objects.equals(animation, "dead")) {
            return 7;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.gearAnimationState);
        list.add(this.screamAnimationState);
        list.add(this.whisperAnimationState);
        list.add(this.rainAnimationState);
        list.add(this.fogAnimationState);
        list.add(this.summonAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.gearAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.gearAnimationState);
                    break;
                }
                case 2: {
                    this.screamAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.screamAnimationState);
                    break;
                }
                case 3: {
                    this.whisperAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.whisperAnimationState);
                    break;
                }
                case 4: {
                    this.rainAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.rainAnimationState);
                    break;
                }
                case 5: {
                    this.fogAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.fogAnimationState);
                    break;
                }
                case 6: {
                    this.summonAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.summonAnimationState);
                    break;
                }
                case 7: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        int spellLevel = this.getSpellLevel();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Master".equals(string)) {
            spellLevel = this.getSpellLevel() + 1;
        }
        if (this.m_6084_()) {
            if (this.getSpellOneTick() > 0 && this.getSpellOneTick() % 10 == 0) {
                OtherSpellList.OminousGear(spellLevel, (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
            }
            if (this.getSpellTwoTick() == 5 && this.m_5448_() != null) {
                OtherSpellList.UncleanBloodRain(spellLevel, (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
            }
            if (this.getSpellThreeTick() == 5 && this.m_5448_() != null) {
                OtherSpellList.UncleanBloodFog(spellLevel, (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
            }
            if (this.f_19797_ % 5 == 0) {
                List listRaider = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
                listRaider.stream().filter(entity -> AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)entity)).filter(entity -> !(entity instanceof NecromancyWarlockEntity)).forEach(raider -> {
                    if (raider.m_21023_((MobEffect)JerotesVillageMobEffects.UNCLEAN_BODY.get())) {
                        raider.m_21195_((MobEffect)JerotesVillageMobEffects.UNCLEAN_BODY.get());
                    }
                    if (raider.m_21023_(MobEffects.f_19604_)) {
                        raider.m_21195_(MobEffects.f_19604_);
                    }
                });
            }
        }
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (!damagesource.m_269533_(DamageTypeTags.f_268738_) && amount <= this.m_21233_() * 20.0f) {
            List listRaider = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
            listRaider.removeIf(entity -> this.m_5448_() == entity || entity == this || entity.m_5448_() == this || (!EntityFactionFind.isRaider((LivingEntity)entity) || this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
            listRaider.removeIf(entity -> entity instanceof NecromancyWarlockEntity || entity instanceof OminousBannerProjectionEntity);
            if (!listRaider.isEmpty() && this.m_9236_().m_213780_().m_188501_() < 0.5f + (float)listRaider.size() * 0.05f && !damagesource.m_269533_(DamageTypeTags.f_268738_)) {
                for (LivingEntity hurt : listRaider) {
                    Level level;
                    ServerLevel serverLevel;
                    if (hurt == null || !hurt.m_6084_()) continue;
                    Level level2 = this.m_9236_();
                    if (level2 instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level2;
                        for (int i = 0; i < 24; ++i) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    this.m_6021_(hurt.m_20185_(), hurt.m_20186_(), hurt.m_20189_());
                    Level i = this.m_9236_();
                    if (i instanceof ServerLevel) {
                        serverLevel = (ServerLevel)i;
                        for (int i2 = 0; i2 < 24; ++i2) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    if ((level = this.m_9236_()) instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        if (!this.m_20145_()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.OMINOUS_SELECTION_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    if (!this.m_20067_() && this.f_19796_.m_188501_() < 0.5f) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.NECROMANCY_WARLOCK_SELECTION, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                    hurt.m_6469_(damagesource, amount * 0.8f);
                    return false;
                }
            }
        }
        float damage = 1.0f;
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            damage *= 0.2f;
        }
        return super.m_6469_(damagesource, amount * damage);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.UNCLEAN_BODY.get()) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19604_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

