/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.Piglin;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.JerotesPiglinEntity;
import com.jerotes.jerotes.entity.ShiftKeyDownEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.entity.UseBowEntity;
import com.jerotes.jerotes.entity.UseCrossbowEntity;
import com.jerotes.jerotes.entity.UseDaggerEntity;
import com.jerotes.jerotes.entity.UseShieldEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.entity.WizardEntity;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIVMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesPikeUseGoal;
import com.jerotes.jerotes.goal.JerotesRangedBowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedCrossbowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesItems;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.item.tool.ItemToolBaseCrossbow;
import com.jerotes.jerotes.spell.MagicType;
import com.jerotes.jerotes.spell.SpellTypeInterface;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.joml.Vector3f;

public class PiglinResidentEntity
extends Piglin
implements SpellUseEntity,
UseDaggerEntity,
ShiftKeyDownEntity,
NeutralMob,
WizardEntity,
JerotesPiglinEntity,
UseThrowEntity,
UseThrownJavelinEntity,
InventoryCarrier,
InventoryEntity,
UseBowEntity,
UseCrossbowEntity,
UseShieldEntity,
JerotesEntity {
    private static final String TAG_PIGMAN = "Pigman";
    boolean isPigman;
    private static final EntityDataAccessor<Integer> COMBAT_STYLE = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> USE_SELF_NOT_SPELL_LIST = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOW_LEVEL = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHIELD_LEVEL = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_INVENTORY = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_CHANGE_MELEE_OR_RANGE = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_WEAPON = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NO_COMBAT_EMPTY_SHIELD = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHANGE_INVENTORY_COOLDOWN_TICK = SynchedEntityData.m_135353_(PiglinResidentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final SimpleContainer inventory = new SimpleContainer(this.inventoryCount());
    private LazyOptional<?> itemHandler = null;
    public int shieldCoolDown;
    public int shieldCanUse = 1;
    public int spellLevel = 1;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public PiglinResidentEntity(EntityType<? extends PiglinResidentEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.m_274367_(0.6f);
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.itemHandler = LazyOptional.of(this::createCombinedHandler);
    }

    private IItemHandler createCombinedHandler() {
        EntityHandsInvWrapper handsHandler = new EntityHandsInvWrapper((LivingEntity)this);
        EntityArmorInvWrapper armorHandler = new EntityArmorInvWrapper((LivingEntity)this);
        InvWrapper customHandler = new InvWrapper((Container)this.inventory);
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{armorHandler, handsHandler, customHandler});
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (EntityFactionFind.isPiglin((LivingEntity)(livingEntity = (LivingEntity)entity)) || OtherEntityFactionFind.isFactionPiglinResidentDetachment(livingEntity));
    }

    public String getFactionTypeName() {
        return "piglin_resident_detachment";
    }

    @VisibleForDebug
    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null && this.m_6084_() ? this.itemHandler.cast() : super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    protected ItemStack m_34778_(ItemStack itemStack) {
        return this.inventory.m_19173_(itemStack);
    }

    protected boolean m_34780_(ItemStack itemStack) {
        return this.inventory.m_19183_(itemStack);
    }

    public ItemStack m_255207_(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        boolean bl = this.m_7808_(itemStack, itemStack2);
        if (equipmentSlot.m_254934_() && !bl) {
            equipmentSlot = EquipmentSlot.MAINHAND;
            itemStack2 = this.m_6844_(equipmentSlot);
            bl = itemStack2.m_41619_();
        }
        if (bl && this.m_7252_(itemStack)) {
            double d = this.m_21519_(equipmentSlot);
            if (this.m_34780_(itemStack2)) {
                this.m_34778_(itemStack2);
            } else {
                this.m_19983_(itemStack2);
            }
            if (equipmentSlot.m_254934_() && itemStack.m_41613_() > 1) {
                ItemStack itemStack3 = itemStack.m_255036_(1);
                this.m_21468_(equipmentSlot, itemStack3);
                return itemStack3;
            }
            this.m_21468_(equipmentSlot, itemStack);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean m_7808_(ItemStack newItem, ItemStack oldItem) {
        return InventoryEntity.canReplaceCurrentItem((InventoryEntity)this, (ItemStack)newItem, (ItemStack)oldItem);
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        super.m_7472_(damageSource, n, bl);
        this.inventory.m_19195_().forEach(arg_0 -> ((PiglinResidentEntity)this).m_19983_(arg_0));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIMagicAttackGoal((PathfinderMob)this, 0.2, true, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIVMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesSpearUseGoal((PathfinderMob)this, 1.0, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesPikeUseGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedCrossbowAttackGoal((Mob)this, 1.0, 15.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, AbstractPiglin.class, 3.0f, 1.0f));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((PiglinResidentEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
        }
        if (InventoryEntity.isBow((ItemStack)handItem)) {
            this.useBowShoot((LivingEntity)this, livingEntity, f, this.getBowLevel(), 20);
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (InventoryEntity.isCrossbow((ItemStack)handItem)) {
            this.useCrossbowShoot((LivingEntity)this, 3.15f);
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public ItemStack m_6298_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem projectileWeaponItem = (ProjectileWeaponItem)item;
            Predicate predicate = projectileWeaponItem.m_6442_();
            ItemStack itemStack2 = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            if (predicate.test(this.m_21205_())) {
                itemStack2 = this.m_21205_();
            } else if (predicate.test(this.m_21206_())) {
                itemStack2 = this.m_21206_();
            } else {
                for (int n = 0; n < this.inventoryCount(); ++n) {
                    ItemStack finds = this.mobInventory().m_8020_(n);
                    if (!predicate.test(finds)) continue;
                    itemStack2 = finds;
                    break;
                }
            }
            return itemStack2.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemStack2;
        }
        return ItemStack.f_41583_;
    }

    public void m_5811_(LivingEntity livingEntity, ItemStack itemStack, Projectile projectile, float f) {
        float f2;
        Item item = itemStack.m_41720_();
        if (item instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item;
            f2 = itemToolBaseCrossbow.m_40945_(itemStack);
        } else {
            f2 = 3.15f;
        }
        this.m_32322_((LivingEntity)this, livingEntity, projectile, f, f2);
    }

    public void m_32322_(LivingEntity livingEntity, LivingEntity livingEntity2, Projectile projectile, float f, float f2) {
        double d0 = livingEntity2.m_20185_() - livingEntity.m_20185_();
        double d1 = livingEntity2.m_20189_() - livingEntity.m_20189_();
        double d2 = Math.sqrt(d0 * d0 + d1 * d1);
        double d3 = livingEntity2.m_20227_(0.3333333333333333) - projectile.m_20186_() + d2 * 0.1;
        Vector3f vector3f = this.m_252851_(livingEntity, new Vec3(d0, d3, d1), f);
        projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), f2, (float)Math.max(0, 20 - this.getBowLevel()) / 5.0f);
        livingEntity.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (livingEntity.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public AbstractArrow getCustomArrow(ItemStack itemStack, float f) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemStack, (float)f);
    }

    public boolean m_5886_(ProjectileWeaponItem projectileWeaponItem) {
        return projectileWeaponItem instanceof BowItem || projectileWeaponItem instanceof CrossbowItem || super.m_5886_(projectileWeaponItem);
    }

    public static AttributeSupplier.Builder m_34770_() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.34);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        return builder;
    }

    protected SoundEvent m_7515_() {
        if (this.isPigman) {
            return this.m_5912_() ? SoundEvents.f_12611_ : SoundEvents.f_12610_;
        }
        if (this.m_9236_().f_46443_) {
            return null;
        }
        return PiglinAi.m_34947_((Piglin)this).orElse(null);
    }

    protected SoundEvent m_5592_() {
        if (this.isPigman) {
            return SoundEvents.f_12612_;
        }
        return SoundEvents.f_12242_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        if (damageSource.m_269533_(DamageTypeTags.f_276146_) && this.m_21254_()) {
            return SoundEvents.f_12346_;
        }
        if (this.isPigman) {
            return SoundEvents.f_12613_;
        }
        return SoundEvents.f_12244_;
    }

    protected boolean m_34665_() {
        if (this.isPigman) {
            return true;
        }
        return super.m_34665_();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected void m_8063_(ServerLevel serverLevel) {
        SimpleContainer simpleContainer = this.mobInventory();
        for (int i = 0; i < simpleContainer.m_6893_(); ++i) {
            this.m_19983_(simpleContainer.m_8020_(i));
        }
        super.m_8063_(serverLevel);
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public boolean canUseRangeJavelin() {
        return true;
    }

    public MobType m_6336_() {
        if (this.isPigman) {
            return MobType.f_21641_;
        }
        return super.m_6336_();
    }

    public boolean shieldCanUse() {
        return this.shieldCanUse == 1 && this.shieldCoolDown <= 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        if (!this.isPigman && component != null && component.getString().equals(TAG_PIGMAN)) {
            this.isPigman = true;
        }
    }

    public SimpleContainer mobInventory() {
        return this.inventory;
    }

    public int inventoryCount() {
        return 8;
    }

    public boolean isCanChangeInventory() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_INVENTORY);
    }

    public void setCanChangeInventory(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_INVENTORY, (Object)bl);
    }

    public boolean isCanChangeMeleeOrRange() {
        return (Boolean)this.m_20088_().m_135370_(CAN_CHANGE_MELEE_OR_RANGE);
    }

    public void setCanChangeMeleeOrRange(boolean bl) {
        this.m_20088_().m_135381_(CAN_CHANGE_MELEE_OR_RANGE, (Object)bl);
    }

    public boolean NonCombatEmptyWeapon() {
        return this.isNoCombatEmptyWeapon();
    }

    public boolean NonCombatEmptyShield() {
        return this.isNoCombatEmptyShield();
    }

    public int changeInventoryCooldownTick() {
        return this.getChangeInventoryCooldownTick();
    }

    public boolean isNoCombatEmptyWeapon() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_WEAPON);
    }

    public void setNoCombatEmptyWeapon(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_WEAPON, (Object)bl);
    }

    public boolean isNoCombatEmptyShield() {
        return (Boolean)this.m_20088_().m_135370_(NO_COMBAT_EMPTY_SHIELD);
    }

    public void setNoCombatEmptyShield(boolean bl) {
        this.m_20088_().m_135381_(NO_COMBAT_EMPTY_SHIELD, (Object)bl);
    }

    public int getChangeInventoryCooldownTick() {
        return (Integer)this.m_20088_().m_135370_(CHANGE_INVENTORY_COOLDOWN_TICK);
    }

    public void setChangeInventoryCooldownTick(int n) {
        this.m_20088_().m_135381_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)n);
    }

    public void SpellUseAfterAttack(String string, MagicType magicType, MagicType magicType2) {
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(10);
        }
    }

    public List<SpellTypeInterface> SelfMainSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public List<SpellTypeInterface> SelfAddSpellList() {
        return new ArrayList<SpellTypeInterface>();
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setSpellTick(int n) {
        this.m_20088_().m_135381_(SPELL_TICK, (Object)n);
    }

    public int getSpellTick() {
        return (Integer)this.m_20088_().m_135370_(SPELL_TICK);
    }

    public void setBowLevel(int n) {
        this.m_20088_().m_135381_(BOW_LEVEL, (Object)n);
    }

    public int getBowLevel() {
        return (Integer)this.m_20088_().m_135370_(BOW_LEVEL);
    }

    public void setShieldLevel(int n) {
        this.m_20088_().m_135381_(SHIELD_LEVEL, (Object)n);
    }

    public int getShieldLevel() {
        return (Integer)this.m_20088_().m_135370_(SHIELD_LEVEL);
    }

    public int getCombatStyle() {
        return (Integer)this.m_20088_().m_135370_(COMBAT_STYLE);
    }

    public void setCombatStyle(int n) {
        this.m_20088_().m_135381_(COMBAT_STYLE, (Object)n);
    }

    public boolean isUseSelfNotStringSpellList() {
        return (Boolean)this.m_20088_().m_135370_(USE_SELF_NOT_SPELL_LIST);
    }

    public void setUseSelfNotStringSpellList(boolean bl) {
        this.m_20088_().m_135381_(USE_SELF_NOT_SPELL_LIST, (Object)bl);
    }

    public boolean isMagicUseStyle() {
        return this.getSpellTick() > 0;
    }

    public boolean isSpellHumanoid() {
        return true;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.isPigman) {
            compoundTag.m_128379_(TAG_PIGMAN, true);
        }
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("SpellTick", this.getSpellTick());
        compoundTag.m_128405_("BowLevel", this.getBowLevel());
        compoundTag.m_128405_("ShieldLevel", this.getShieldLevel());
        compoundTag.m_128405_("CombatStyle", this.getCombatStyle());
        compoundTag.m_128379_("UseSelfNotStringSpellList", this.isUseSelfNotStringSpellList());
        compoundTag.m_128379_("IsNoCombatEmptyWeapon", this.isNoCombatEmptyWeapon());
        compoundTag.m_128379_("IsNoCombatEmptyShield", this.isNoCombatEmptyShield());
        compoundTag.m_128405_("ChangeInventoryCooldownTick", this.getChangeInventoryCooldownTick());
        compoundTag.m_128379_("IsCanChangeInventory", this.isCanChangeInventory());
        compoundTag.m_128379_("IsCanChangeMeleeOrRange", this.isCanChangeMeleeOrRange());
        compoundTag.m_128405_("ShieldCoolDown", this.shieldCoolDown);
        compoundTag.m_128405_("ShieldCanUse", this.shieldCanUse);
        this.m_21678_(compoundTag);
        this.m_252802_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_(TAG_PIGMAN, 99)) {
            this.isPigman = compoundTag.m_128471_(TAG_PIGMAN);
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setSpellTick(compoundTag.m_128451_("SpellTick"));
        this.setBowLevel(compoundTag.m_128451_("BowLevel"));
        this.setShieldLevel(compoundTag.m_128451_("ShieldLevel"));
        this.setCombatStyle(compoundTag.m_128451_("CombatStyle"));
        this.setUseSelfNotStringSpellList(compoundTag.m_128471_("UseSelfNotStringSpellList"));
        this.setNoCombatEmptyWeapon(compoundTag.m_128471_("IsNoCombatEmptyWeapon"));
        this.setNoCombatEmptyShield(compoundTag.m_128471_("IsNoCombatEmptyShield"));
        this.setChangeInventoryCooldownTick(compoundTag.m_128451_("ChangeInventoryCooldownTick"));
        this.setCanChangeInventory(compoundTag.m_128471_("IsCanChangeInventory"));
        this.setCanChangeMeleeOrRange(compoundTag.m_128471_("IsCanChangeMeleeOrRange"));
        this.shieldCoolDown = compoundTag.m_128451_("ShieldCoolDown");
        this.shieldCanUse = compoundTag.m_128451_("ShieldCanUse");
        this.m_147285_(this.m_9236_(), compoundTag);
        this.m_253224_(compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SPELL_TICK, (Object)0);
        this.m_20088_().m_135372_(BOW_LEVEL, (Object)15);
        this.m_20088_().m_135372_(SHIELD_LEVEL, (Object)1);
        this.m_20088_().m_135372_(USE_SELF_NOT_SPELL_LIST, (Object)true);
        this.m_20088_().m_135372_(COMBAT_STYLE, (Object)1);
        this.m_20088_().m_135372_(CAN_CHANGE_INVENTORY, (Object)false);
        this.m_20088_().m_135372_(CAN_CHANGE_MELEE_OR_RANGE, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_WEAPON, (Object)false);
        this.m_20088_().m_135372_(NO_COMBAT_EMPTY_SHIELD, (Object)false);
        this.m_20088_().m_135372_(CHANGE_INVENTORY_COOLDOWN_TICK, (Object)50);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        this.m_21203_();
        this.m_7562_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(Math.max(0, this.getSpellTick() - 1));
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
            this.shieldCanUse = 0;
        }
        if (this.shieldCoolDown <= 0) {
            this.shieldCanUse = 1;
        }
        Main.destroyRides((Mob)this);
        this.useBlockingItem((Mob)this);
        this.changeInventory((Mob)this);
    }

    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        if (bl && JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return bl;
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        if (entityIn instanceof BreakShieldEntity) {
            BreakShieldEntity breakShield = (BreakShieldEntity)entityIn;
            this.disableShieldBreak(breakShield.getShieldBreakStrength());
        }
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn) || entityIn.m_213824_()) {
            this.disableShield();
        }
        this.disableShieldTry();
    }

    public boolean isDamageSourceBlocks(DamageSource damageSource) {
        Vec3 object;
        boolean bl;
        Entity entity = damageSource.m_7640_();
        boolean bl2 = bl = entity instanceof AbstractArrow && ((AbstractArrow)entity).m_36796_() > 0;
        if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !bl && (object = damageSource.m_7270_()) != null) {
            Vec3 vec3 = this.m_20171_(0.0f, this.m_6080_());
            Vec3 vec32 = object.m_82505_(this.m_20182_());
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_).m_82541_();
            return vec32.m_82526_(vec3) < 0.0;
        }
        return false;
    }

    protected void m_7909_(float f) {
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_SHIELD_CAN_BREAK) && this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && f >= 3.0f) {
            int n = 1 + Mth.m_14143_((float)f);
            InteractionHand interactionHand = this.m_7655_();
            this.f_20935_.m_41622_(n, (LivingEntity)this, player -> player.m_21190_(interactionHand));
            if (this.f_20935_.m_41619_()) {
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void disableShield() {
        if (this.m_217043_().m_188501_() <= 1.0f - (float)(this.getShieldLevel() - 1) * 0.2f) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldTry() {
        if ((double)this.m_217043_().m_188501_() <= 0.15 - (double)((float)(this.getShieldLevel() - 1) * 0.05f)) {
            if (this.shieldCoolDown < 100) {
                this.shieldCoolDown = 100;
            }
            this.shieldCanUse = 0;
            if (this.m_21211_().m_41720_() instanceof ShieldItem) {
                this.m_5810_();
            }
        }
    }

    public void disableShieldBreak(int tick) {
        if (tick == 0) {
            return;
        }
        if (this.shieldCoolDown < tick) {
            this.shieldCoolDown = tick;
        }
        this.shieldCanUse = 0;
        if (this.m_21211_().m_41720_() instanceof ShieldItem) {
            this.m_5810_();
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData spawnGroupData2 = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42476_));
            this.m_213945_(randomSource, difficultyInstance);
            this.m_213946_(randomSource, difficultyInstance);
            float weaponRandom = this.f_19796_.m_188501_();
            this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon(weaponRandom));
        }
        return spawnGroupData2;
    }

    private ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesItems.GOLDEN_JAVELIN.get());
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

