/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotesvillage.goal.BulgeFloatGoal;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.goal.RuinsBreezeAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RuinsBreeze
extends Monster
implements RangedAttackMob,
JerotesEntity,
SpellUseEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(RuinsBreeze.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(RuinsBreeze.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> JUMP_TICK = SynchedEntityData.m_135353_(RuinsBreeze.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(RuinsBreeze.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState longJumpAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public int spellLevel = 1;
    private int jumpTrailStartedTick = 0;

    public RuinsBreeze(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.6);
        builder = builder.m_22268_(Attributes.f_22276_, 35.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BulgeFloatGoal((Mob)this, 0.15f));
        this.f_21345_.m_25352_(1, (Goal)new RuinsBreezeAttackGoal(this, 1.0, 30, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAttackAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 0.6));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, (double)0.6f, 0.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            @Override
            public boolean m_8036_() {
                if (RuinsBreeze.this.m_9236_().m_46791_() == Difficulty.PEACEFUL || this.target != null && RuinsBreeze.this.m_20270_((Entity)this.target) > 12.0f) {
                    return false;
                }
                return super.m_8036_();
            }
        });
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.getShootTick() > 0) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(60);
            this.setAnimTick(23);
            this.setAnimationState("shoot");
        }
        this.m_21573_().m_26573_();
        this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_INHALE, 1.0f, 1.0f);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return livingEntity.m_6095_() != JerotesVillageEntityType.RUINS_BREEZE.get() && super.m_6779_(livingEntity);
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setJumpTick(int n) {
        this.m_20088_().m_135381_(JUMP_TICK, (Object)n);
    }

    public int getJumpTick() {
        return (Integer)this.m_20088_().m_135370_(JUMP_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "longJump")) {
            return 1;
        }
        if (Objects.equals(animation, "shoot")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.longJumpAnimationState);
        list.add(this.shootAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("JumpTick", this.getJumpTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setJumpTick(compoundTag.m_128451_("JumpTick"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(JUMP_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.longJumpAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.longJumpAnimationState);
                    break;
                }
                case 2: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(Math.max(0, this.getShootTick() - 1));
        }
        this.resetJumpTrail().emitGroundParticles(1 + this.m_217043_().m_188503_(1));
        if (!this.m_21573_().m_26571_() && this.m_20096_()) {
            this.emitGroundParticles(20);
            if (this.f_19797_ % 40 == 0) {
                this.m_216990_(JerotesVillageSounds.RUINS_BREEZE_SLIDE);
            }
        }
        if (this.getJumpTick() > 5) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpTick(this.getJumpTick() - 1);
            }
            this.emitJumpTrailParticles();
        }
        if (this.getJumpTick() <= 5 && this.getJumpTick() > 0 && this.m_20096_()) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpTick(0);
            }
            if (this.m_5448_() != null) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_LAND, 1.0f, 1.0f);
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.getJumpTick() <= 0 && this.getJumpTick() > -40) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpTick(this.getJumpTick() - 1);
            }
            this.emitJumpTrailParticles();
        }
        if (this.f_19797_ % 80 == 0 && this.m_217043_().m_188501_() > 0.75f) {
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_WHIRL, 1.0f, 1.0f);
        }
        if (this.getShootTick() == 50 && this.m_5448_() != null && this.m_6084_()) {
            OtherSpellList.RuinsWindCharge(this.getSpellLevel(), (LivingEntity)this, (Entity)this.m_5448_()).spellUse();
        }
        if (this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_6084_() && this.getShootTick() > 30 && this.getShootTick() <= 40 && this.canJump(this.m_9236_(), this) && this.m_217043_().m_188501_() > 0.25f && (RuinsBreeze.hasLineOfSight(this, this.m_5448_().m_20097_().m_252807_()) || RuinsBreeze.hasLineOfSight(this, this.m_5448_().m_20097_().m_6630_(4).m_252807_())) && !this.m_20159_() && !this.m_20069_() && this.m_21124_(MobEffects.f_19620_) == null) {
            if (!this.m_9236_().m_5776_()) {
                this.setJumpTick(10);
                this.setAnimTick(23);
                this.setAnimationState("longJump");
            }
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_JUMP, 1.0f, 1.0f);
            this.jumpToTarget(this.m_5448_());
        }
    }

    public void m_6845_(boolean bl) {
    }

    public void m_20321_(boolean bl) {
        this.m_183634_();
    }

    public boolean jumpToTarget(LivingEntity target) {
        this.m_21563_().m_24960_((Entity)target, 360.0f, 360.0f);
        this.m_21391_((Entity)target, 360.0f, 360.0f);
        double smoothX = Mth.m_14008_((double)Math.abs(target.m_20185_() - this.m_20185_()), (double)0.0, (double)1.0);
        double smoothZ = Mth.m_14008_((double)Math.abs(target.m_20189_() - this.m_20189_()), (double)0.0, (double)1.0);
        double d0 = (target.m_20185_() - this.m_20185_()) * 0.3 * smoothX;
        double d2 = (target.m_20189_() - this.m_20189_()) * 0.3 * smoothZ;
        float up = 0.5f + this.m_217043_().m_188501_() * 0.8f;
        this.m_20256_(this.m_20184_().m_82520_(d0 * 0.75, (double)up, d2 * 0.75));
        return true;
    }

    protected boolean canJump(Level level, RuinsBreeze breeze) {
        if (!breeze.m_20096_() && !breeze.m_20069_()) {
            return false;
        }
        LivingEntity livingEntity = breeze.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (RuinsBreeze.tooCloseForJump(breeze, livingEntity)) {
            return false;
        }
        if (!RuinsBreeze.canJumpFromCurrentPosition(level, breeze)) {
            return false;
        }
        BlockPos blockPos = RuinsBreeze.snapToSurface((LivingEntity)breeze, RuinsBreeze.randomPointBehindTarget(livingEntity, breeze.m_217043_()));
        if (blockPos == null) {
            return false;
        }
        return RuinsBreeze.hasLineOfSight(breeze, blockPos.m_252807_()) || RuinsBreeze.hasLineOfSight(breeze, blockPos.m_6630_(4).m_252807_());
    }

    @Nullable
    private static BlockPos snapToSurface(LivingEntity livingEntity, Vec3 vec3) {
        ClipContext clipContext = new ClipContext(vec3, vec3.m_231075_(Direction.DOWN, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity);
        BlockHitResult blockHitResult = livingEntity.m_9236_().m_45547_(clipContext);
        if (blockHitResult.m_6662_() == HitResult.Type.BLOCK) {
            return BlockPos.m_274446_((Position)blockHitResult.m_82450_()).m_7494_();
        }
        ClipContext clipContext2 = new ClipContext(vec3, vec3.m_231075_(Direction.UP, 10.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity);
        BlockHitResult blockHitResult2 = livingEntity.m_9236_().m_45547_(clipContext2);
        if (blockHitResult2.m_6662_() == HitResult.Type.BLOCK) {
            return BlockPos.m_274446_((Position)blockHitResult.m_82450_()).m_7494_();
        }
        return null;
    }

    private static Vec3 randomPointBehindTarget(LivingEntity livingEntity, RandomSource randomSource) {
        int n = 90;
        float f = livingEntity.f_20885_ + 180.0f + (float)randomSource.m_188583_() * 90.0f / 2.0f;
        float f2 = Mth.m_14179_((float)randomSource.m_188501_(), (float)4.0f, (float)8.0f);
        Vec3 vec3 = Vec3.m_82498_((float)0.0f, (float)f).m_82490_((double)f2);
        return livingEntity.m_20182_().m_82549_(vec3);
    }

    public static boolean hasLineOfSight(RuinsBreeze breeze, Vec3 vec3) {
        Vec3 vec32 = new Vec3(breeze.m_20185_(), breeze.m_20186_(), breeze.m_20189_());
        if (vec3.m_82554_(vec32) > 50.0) {
            return false;
        }
        return breeze.m_9236_().m_45547_(new ClipContext(vec32, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)breeze)).m_6662_() == HitResult.Type.MISS;
    }

    private static boolean outOfAggroRange(RuinsBreeze breeze, LivingEntity livingEntity) {
        return !livingEntity.m_19950_((Entity)breeze, 24.0);
    }

    private static boolean tooCloseForJump(RuinsBreeze breeze, LivingEntity livingEntity) {
        return livingEntity.m_20270_((Entity)breeze) - 4.0f <= 0.0f;
    }

    private static boolean canJumpFromCurrentPosition(Level level, RuinsBreeze breeze) {
        BlockPos blockPos = breeze.m_20183_();
        for (int i = 1; i <= 4; ++i) {
            BlockPos blockPos2 = blockPos.m_5484_(Direction.UP, i);
            if (level.m_8055_(blockPos2).m_60795_() || level.m_6425_(blockPos2).m_205070_(FluidTags.f_13131_)) continue;
            return false;
        }
        return true;
    }

    public RuinsBreeze resetJumpTrail() {
        this.jumpTrailStartedTick = 0;
        return this;
    }

    public void emitJumpTrailParticles() {
        if (++this.jumpTrailStartedTick <= 5) {
            BlockState $$0 = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            Vec3 $$1 = this.m_20184_();
            Vec3 $$2 = this.m_20182_().m_82549_($$1).m_82520_(0.0, (double)0.1f, 0.0);
            for (int $$3 = 0; $$3 < 3; ++$$3) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, $$0), $$2.f_82479_, $$2.f_82480_, $$2.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    public void emitGroundParticles(int p_310885_) {
        Vec3 $$1 = this.m_20191_().m_82399_();
        Vec3 $$2 = new Vec3($$1.f_82479_, this.m_20182_().f_82480_, $$1.f_82481_);
        BlockState $$3 = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        if ($$3.m_60799_() != RenderShape.INVISIBLE) {
            for (int $$4 = 0; $$4 < p_310885_; ++$$4) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, $$3), $$2.f_82479_, $$2.f_82480_, $$2.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_20096_() ? JerotesVillageSounds.RUINS_BREEZE_AMBIENT : JerotesVillageSounds.RUINS_BREEZE_AMBIENT_AIR;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.RUINS_BREEZE_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.RUINS_BREEZE_HURT;
    }

    public int m_8085_() {
        return 30;
    }

    public int m_21529_() {
        return 25;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268576_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return damageSource.m_269533_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("breeze_immune_to"))) || damageSource.m_7639_() instanceof RuinsBreeze || super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (damageSource.m_269533_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("breeze_immune_to")))) {
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_DEFLECT, 1.0f, 1.0f);
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268714_) || damageSource.m_276093_(DamageTypes.f_268739_)) {
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_DEFLECT, 1.0f, 1.0f);
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public double m_20204_() {
        return this.m_20192_();
    }

    public boolean m_142535_(float f, float f2, DamageSource damageSource) {
        if (f > 3.0f) {
            this.m_5496_(JerotesVillageSounds.RUINS_BREEZE_LAND, 1.0f, 1.0f);
        }
        return super.m_142535_(f, f2, damageSource);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }
}

