/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.ShiftKeyDownEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesNoFireFleeSunGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesTryFindWaterGoal;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class TanglerEntity
extends Monster
implements JerotesEntity,
ShiftKeyDownEntity {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(TanglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(TanglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WANT_TANGLE = SynchedEntityData.m_135353_(TanglerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public boolean isLandNavigatorType = true;
    public int canTangle;
    private Entity control;

    public TanglerEntity(EntityType<? extends TanglerEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 15;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new JerotesTryFindWaterGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new JerotesNoFireFleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 0.2, 120));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        return builder;
    }

    public boolean shouldShiftKeyDown() {
        return this.baseShouldShiftKeyDown() || this.m_5448_() != null && this.m_20069_() && this.canTangleEntity((Entity)this.m_5448_()) && this.canTangle == 1;
    }

    protected SoundEvent m_7515_() {
        if (this.isWantTangle()) {
            return null;
        }
        return JerotesVillageSounds.TANGLER_AMBIENT;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return JerotesVillageSounds.TANGLER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.TANGLER_DEATH;
    }

    public int m_8100_() {
        return 120;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.7));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    protected float m_6121_() {
        return 1.6f;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    public boolean isWantTangle() {
        return (Boolean)this.m_20088_().m_135370_(WANT_TANGLE);
    }

    public void setWantTangle(boolean bl) {
        this.m_20088_().m_135381_(WANT_TANGLE, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("CanTangle", this.canTangle);
        compoundTag.m_128379_("IsWantTangle", this.isWantTangle());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.canTangle = compoundTag.m_128451_("CanTangle");
        this.setWantTangle(compoundTag.m_128471_("IsWantTangle"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(WANT_TANGLE, (Object)false);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        ServerLevel serverLevel;
        BlockState blockState;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.2f, true);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel2 = (ServerLevel)level;
                serverLevel2.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_5448_() != null && this.m_20069_() && this.canTangleEntity((Entity)this.m_5448_())) {
            if (this.canTangle == 1) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.0075, 0.0));
            }
            if (this.canTangle == 0 && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                this.setWantTangle(true);
                this.canTangle = 1;
            }
        }
        if (this.m_5448_() == null || !this.m_20069_() || !this.canTangleEntity((Entity)this.m_5448_())) {
            this.setWantTangle(false);
            this.control = null;
            this.canTangle = 2;
            if (this.m_5448_() == null) {
                this.canTangle = 0;
            }
        }
        if (this.control != null && this.m_6084_()) {
            Level n = this.m_9236_();
            if (n instanceof ServerLevel) {
                serverLevel = (ServerLevel)n;
                for (int i = 0; i < 5; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.control.m_20069_() && this.m_217043_().m_188503_(800) != 1) {
                Entity i;
                if (!this.m_9236_().f_46443_ && (i = this.control) instanceof LivingEntity) {
                    LivingEntity livingEntity2 = (LivingEntity)i;
                    livingEntity2.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 20, 0), (Entity)this);
                }
                this.m_20343_(this.control.m_20185_(), this.control.m_20186_(), this.control.m_20189_());
            } else {
                this.canTangle = 2;
                this.control = null;
                this.setWantTangle(false);
            }
        }
        if (this.m_5448_() != null && this.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
            Level i = this.m_9236_();
            if (i instanceof ServerLevel) {
                serverLevel = (ServerLevel)i;
                for (int i2 = 0; i2 < 5; ++i2) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123768_, this.m_20208_(0.7), this.m_20187_(), this.m_20262_(0.7), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if ((this.m_20270_((Entity)this.m_5448_()) > 4.0f || this.isWantTangle()) && this.canTangle != 2 && this.control == null && !this.m_9236_().f_46443_) {
                this.m_147207_(new MobEffectInstance(MobEffects.f_19609_, 5, 0, false, false), (Entity)this);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.canTangle == 1 && this.isWantTangle() && this.control == null) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.TANGLER_TANGLE, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            this.control = entity;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.TANGLER_TANGLE_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        boolean bl = super.m_7327_(entity);
        return bl;
    }

    public boolean canTangleEntity(Entity entity) {
        return Main.mobSizeSmall((Entity)entity) || Main.mobSizeMedium((Entity)entity);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_269533_(DamageTypeTags.f_268581_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        this.canTangle = 2;
        this.control = null;
        this.setWantTangle(false);
        return super.m_6469_(damagesource, amount);
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        Creeper creeper;
        super.m_7472_(damageSource, n, bl);
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)JerotesVillageItems.TANGLER_HEAD.get());
        }
    }
}

