/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.WickedRidiculeCalls;

import com.jerotes.jerotes.entity.CanNotSkeletonSpiderEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.Mob.HumanEntity;
import com.jerotes.jerotes.entity.WickedRidiculeCallsEntity;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.entity.Monster.WickedRidiculeCalls.SecondRounderSkeletonEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.network.JerotesVillageLevelData;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SecondRounderSpiderEntity
extends Spider
implements JerotesEntity,
WickedRidiculeCallsEntity,
CanNotSkeletonSpiderEntity {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(SecondRounderSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PUSH_TICK = SynchedEntityData.m_135353_(SecondRounderSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SecondRounderSpiderEntity(EntityType<? extends SecondRounderSpiderEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionWickedRidiculeCalls(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "wicked_ridicule_calls";
    }

    public static AttributeSupplier.Builder m_33815_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.34);
        builder = builder.m_22268_(Attributes.f_22276_, 28.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 35.0);
        return builder;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, livingEntity -> EntityFactionFind.isHateFaction((LivingEntity)this, (LivingEntity)livingEntity)));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, HumanEntity.class, false));
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.75f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public void addInWickedRidiculeNight(boolean bl) {
        if (!this.m_9236_().m_5776_()) {
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.DEEP_BLESS.get(), 5, 0), (Entity)this);
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT.get(), 5, 0), (Entity)this);
            this.m_147207_(new MobEffectInstance(MobEffects.f_19600_, 5, 0), (Entity)this);
            this.m_147207_(new MobEffectInstance(MobEffects.f_19606_, 5, 0), (Entity)this);
        }
    }

    public void setColor(int n) {
        this.m_20088_().m_135381_(COLOR, (Object)n);
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setPushTick(int n) {
        this.m_20088_().m_135381_(PUSH_TICK, (Object)n);
    }

    public int getPushTick() {
        return (Integer)this.m_20088_().m_135370_(PUSH_TICK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Color", this.getColor());
        compoundTag.m_128405_("PushTick", this.getPushTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setColor(compoundTag.m_128451_("Color"));
        this.setPushTick(compoundTag.m_128451_("PushTick"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR, (Object)1);
        this.m_20088_().m_135372_(PUSH_TICK, (Object)0);
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        if (!blockState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(blockState, vec3);
        }
        this.m_183634_();
    }

    protected void m_7324_(Entity entity) {
        if (!(entity instanceof WickedRidiculeCallsEntity) && !entity.m_7307_((Entity)this) || entity.m_5829_() || this.m_5448_() == null) {
            super.m_7324_(entity);
        } else {
            this.setPushTick(5);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.getPushTick() > 0 && !this.m_9236_().m_5776_()) {
            this.setPushTick(this.getPushTick() - 1);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268581_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        Entity object;
        SpawnGroupData spawnGroupData2 = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (randomSource.m_188503_(40) == 1 && (object = ((EntityType)JerotesVillageEntityType.SECOND_ROUNDER_SKELETON.get()).m_20615_(this.m_9236_())) != null) {
            object.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            ((SecondRounderSkeletonEntity)object).m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, null, null);
            if (!this.m_9236_().m_5776_()) {
                object.m_20329_((Entity)this);
            }
        }
        if (spawnGroupData2 == null) {
            spawnGroupData2 = new SpiderEffectsGroupData();
            if (serverLevelAccessor.m_46791_() == Difficulty.HARD && randomSource.m_188501_() < 0.1f * difficultyInstance.m_19057_()) {
                ((SpiderEffectsGroupData)spawnGroupData2).setRandomEffect(randomSource);
            }
        }
        this.setColor(Main.randomReach((RandomSource)serverLevelAccessor.m_213780_(), (int)0, (int)0xFFFFFF));
        if (JerotesVillageLevelData.get((LevelAccessor)serverLevelAccessor) != null && JerotesVillageLevelData.get((LevelAccessor)serverLevelAccessor).WickedRidiculeNight) {
            this.setColor(0xFF0000);
        }
        return spawnGroupData2;
    }

    public static class SpiderEffectsGroupData
    implements SpawnGroupData {
        @Nullable
        public MobEffect effect;

        public void setRandomEffect(RandomSource p_219119_) {
            int i = p_219119_.m_188503_(9);
            if (i <= 1) {
                this.effect = (MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get();
            } else if (i <= 2) {
                this.effect = (MobEffect)JerotesMobEffects.INVISIBLE_PASSAGE.get();
            } else if (i <= 3) {
                this.effect = (MobEffect)JerotesMobEffects.COUNTERSPELL.get();
            } else if (i <= 4) {
                this.effect = (MobEffect)JerotesVillageMobEffects.RAMPANT.get();
            } else if (i <= 5) {
                this.effect = (MobEffect)JerotesVillageMobEffects.ABUNDANT_COURAGE.get();
            } else if (i <= 6) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 7) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 8) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 9) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

