/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.entity.CarvedEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesAttackAvoidEntityGoal;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpCarvedGoal;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.CarvedHoundEntity;
import com.jerotes.jerotesvillage.entity.Animal.CarvedLlamaEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.DefectorEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Other.CarvedAllayAmethystEntity;
import com.jerotes.jerotesvillage.event.RelationshipEvent;
import com.jerotes.jerotesvillage.goal.CarvedAllayRangedAttackGoal;
import com.jerotes.jerotesvillage.goal.HelpVillagerGoal;
import com.jerotes.jerotesvillage.init.JerotesVillagePotions;
import com.jerotes.jerotesvillage.item.CarvedFlag;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class CarvedAllayEntity
extends Allay
implements JerotesEntity,
CarvedEntity,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> VEX = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEAL_TICK = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(CarvedAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public CarvedAllayEntity(EntityType<? extends CarvedAllayEntity> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    public static AttributeSupplier.Builder m_218388_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.12);
        builder = builder.m_22268_(Attributes.f_22280_, 0.12);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionCopperCarvedCompany(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "copper_carved_company";
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new CarvedAllayRangedAttackGoal(this, 1.25, 60, 18.0f));
        this.f_21345_.m_25352_(3, (Goal)new JerotesAttackAvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, IronGolem.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, CarvedAllayEntity.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, CarvedHoundEntity.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, CarvedLlamaEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpCarvedGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HelpVillagerGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        CarvedAllayAmethystEntity allayAmethyst = new CarvedAllayAmethystEntity(this.m_9236_(), (LivingEntity)this);
        double d = livingEntity.m_20185_() - this.m_20185_();
        double d2 = livingEntity.m_20227_(0.3333333333333333) - allayAmethyst.m_20186_();
        double d3 = livingEntity.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d * d + d3 * d3);
        allayAmethyst.m_6686_(d, d2 + d4 * 0.2, d3, 1.0f, 0.0f);
        allayAmethyst.m_5602_((Entity)this);
        this.m_9236_().m_7967_((Entity)allayAmethyst);
        if (!this.m_20067_()) {
            this.m_5496_(SoundEvents.f_215678_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        this.m_6710_(null);
        this.m_21561_(false);
    }

    public void rangeHealThrow(LivingEntity livingEntity) {
        Player player;
        ThrownPotion thrownPotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
        Potion potion = Potions.f_43581_;
        if (livingEntity.m_6336_() == MobType.f_21641_) {
            potion = Potions.f_43583_;
        }
        if (livingEntity.m_6095_() == EntityType.f_20492_ || livingEntity.m_6095_() == EntityType.f_20494_ || EntityFactionFind.isCarved((EntityType)livingEntity.m_6095_()) || livingEntity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)livingEntity, 500)) {
            potion = (Potion)JerotesVillagePotions.CARVED_VILLAGE_ARROW.get();
        }
        thrownPotion.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
        double d = livingEntity.m_20185_() - this.m_20185_();
        double d2 = livingEntity.m_20227_(0.3333333333333333) - this.m_20186_();
        double d3 = livingEntity.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d * d + d3 * d3);
        thrownPotion.m_6686_(d, d2 + d4 * 0.2, d3, 1.0f, 0.0f);
        thrownPotion.m_5602_((Entity)this);
        this.m_9236_().m_7967_((Entity)thrownPotion);
        if (!this.m_20067_()) {
            this.m_5496_(SoundEvents.f_215678_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isVexRace()) {
            return SoundEvents.f_12499_;
        }
        return this.m_21033_(EquipmentSlot.MAINHAND) ? SoundEvents.f_215670_ : SoundEvents.f_215671_;
    }

    protected SoundEvent m_7975_(DamageSource p_218369_) {
        if (this.isVexRace()) {
            return SoundEvents.f_12502_;
        }
        return SoundEvents.f_215675_;
    }

    protected SoundEvent m_5592_() {
        if (this.isVexRace()) {
            return SoundEvents.f_12501_;
        }
        return SoundEvents.f_215672_;
    }

    public boolean isEmerald(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42616_)}).test(stack);
    }

    public int getHealTick() {
        return (Integer)this.m_20088_().m_135370_(HEAL_TICK);
    }

    public void setHealTick(int n) {
        this.m_20088_().m_135381_(HEAL_TICK, (Object)n);
    }

    protected Component m_5677_() {
        if (this.isVexRace()) {
            return Component.m_237115_((String)"entity.jerotesvillage.carved_allay.vex");
        }
        return Component.m_237115_((String)this.m_6095_().m_20675_());
    }

    public void m_6593_(Component component) {
        String string = ChatFormatting.m_126649_((String)component.getString());
        super.m_6593_(component);
        if ("Vex".equals(string)) {
            this.setVexRace(true);
        } else if ("Allay".equals(string)) {
            this.setVexRace(false);
        }
    }

    public boolean isVexRace() {
        return (Boolean)this.m_20088_().m_135370_(VEX);
    }

    public void setVexRace(boolean bl) {
        this.m_20088_().m_135381_(VEX, (Object)bl);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listTag = new ListTag();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
        }
        compoundTag.m_128365_("Trusted", (Tag)listTag);
        compoundTag.m_128405_("HealTick", this.getHealTick());
        compoundTag.m_128379_("IsVex", this.isVexRace());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        ListTag listTag = compoundTag.m_128437_("Trusted", 11);
        for (Tag tag : listTag) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)tag));
        }
        this.setHealTick(compoundTag.m_128451_("HealTick"));
        this.setVexRace(compoundTag.m_128471_("IsVex"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.m_20088_().m_135372_(DATA_TYPE_ID, (Object)0);
        this.m_20088_().m_135372_(HEAL_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(VEX, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (VEX.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return arrayList;
    }

    public void addTrustedUUID(@Nullable UUID uUID) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(uUID));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(uUID));
        }
    }

    protected void m_5502_(Player player, Mob mob) {
        this.addTrustedUUID(player.m_20148_());
    }

    public boolean trusts(UUID uUID) {
        return this.getTrustedUUIDs().contains(uUID);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_41720_() instanceof CarvedFlag) {
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_215676_, 1.0f, f1);
            }
            return InteractionResult.PASS;
        }
        if (!this.m_5912_() && this.isEmerald(itemstack)) {
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 12000, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 12000, 4));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 3));
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_215676_, 1.0f, f1);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            float f = (float)this.m_20186_();
            Vec3 vec3 = this.m_20184_();
            for (int i = 0; i < 10; ++i) {
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)f2, (double)(f + 1.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            if (!this.trusts(player.m_20148_())) {
                RelationshipEvent.AddCopperCarvedCompanyRelationship(player, 5);
            }
            this.addTrustedUUID(player.m_20148_());
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        ItemStack itemStack2 = this.m_21120_(InteractionHand.MAIN_HAND);
        if (this.m_239559_() && itemstack.m_41720_() == Items.f_151049_) {
            if (itemStack2.m_41619_() && !itemStack.m_41619_()) {
                ItemStack itemStack3 = itemStack.m_255036_(1);
                this.m_21008_(InteractionHand.MAIN_HAND, itemStack3);
                this.m_239358_(player, itemStack);
                this.m_9236_().m_6269_(player, (Entity)this, SoundEvents.f_215676_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                this.m_6274_().m_21879_(MemoryModuleType.f_217778_, (Object)player.m_20148_());
                return InteractionResult.SUCCESS;
            }
            if (!itemStack2.m_41619_() && interactionHand == InteractionHand.MAIN_HAND && itemStack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                this.m_9236_().m_6269_(player, (Entity)this, SoundEvents.f_215677_, SoundSource.NEUTRAL, 2.0f, 1.0f);
                this.m_6674_(InteractionHand.MAIN_HAND);
                for (ItemStack itemStack4 : this.m_35311_().m_19195_()) {
                    BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)itemStack4, (Vec3)this.m_20182_());
                }
                this.m_6274_().m_21936_(MemoryModuleType.f_217778_);
                player.m_36356_(itemStack2);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    private void m_239358_(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setHealTick(Math.max(0, this.getHealTick() - 1));
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        double d = Double.MAX_VALUE;
        for (LivingEntity carved : list) {
            Player player2;
            Mob mob;
            if (carved == null || this.m_20280_((Entity)carved) > d || carved == this || carved instanceof Mob && (mob = (Mob)carved).m_5448_() == this || this.m_5448_() == carved || this.getHealTick() > 0 || carved.m_21223_() >= carved.m_21233_() || !OtherEntityFactionFind.isCarved(carved.m_6095_()) && !(carved instanceof Villager) && !this.trusts(carved.m_20148_()) && (!(carved instanceof Player) || !RelationshipEvent.MoreCopperCarvedCompanyRelationship(player2 = (Player)carved, 500)) && !carved.m_7307_((Entity)this) || !(this.m_20270_((Entity)carved) <= 8.0f)) continue;
            this.rangeHealThrow(carved);
            if (this.m_9236_().m_5776_()) continue;
            this.setHealTick(80);
        }
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        if (!this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 660, 0));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        Player player;
        Entity entity;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        boolean bl = super.m_6469_(damageSource, f);
        if (bl && (entity = damageSource.m_7639_()) instanceof Player && !this.trusts((player = (Player)entity).m_20148_()) && this.m_5448_() == null) {
            RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -2);
        }
        return bl;
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        Player player;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.trusts(entity.m_20148_())) {
            return true;
        }
        if (entity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)entity, 500)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        Player player;
        DefectorEntity defector;
        if (this.trusts(livingEntity.m_20148_())) {
            return false;
        }
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        if (OtherMainConfig.CarvedCanNotAttackList.contains(livingEntity.m_20078_())) {
            return false;
        }
        if (livingEntity instanceof DefectorEntity && (defector = (DefectorEntity)livingEntity).m_5448_() != this && !defector.isMustEnemy()) {
            return false;
        }
        if (livingEntity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)livingEntity, 500)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public void m_6667_(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -10);
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && !this.getTrustedUUIDs().isEmpty()) {
            List<UUID> list = this.getTrustedUUIDs();
            for (UUID uUID : list) {
                ServerLevel serverLevel;
                Level level;
                if (uUID == null || !(this.m_9236_() instanceof ServerLevel) || !((level = this.m_9236_()) instanceof ServerLevel) || !((level = (serverLevel = (ServerLevel)level).m_8791_(uUID)) instanceof Player)) continue;
                Player player = (Player)level;
                player.m_213846_(this.m_21231_().m_19293_());
            }
        }
        super.m_6667_(damageSource);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            this.m_213946_(randomSource, difficultyInstance);
            RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
            if (randomSourceSkin.m_188501_() < 0.05f) {
                this.setVexRace(true);
            } else {
                this.setVexRace(false);
            }
            float f = this.f_19796_.m_188501_();
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }
}

