/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral.MerorMachine;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Neutral.MerorMachine.MerorMachineEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;

public class MerorGolemEntity
extends MerorMachineEntity
implements SpellUseEntity,
EliteEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState sendAnimationState = new AnimationState();
    public AnimationState standAnimationState = new AnimationState();
    public AnimationState standStartAnimationState = new AnimationState();
    public AnimationState standStopAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(MerorGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEND_TICK = SynchedEntityData.m_135353_(MerorGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEND_USE_TICK = SynchedEntityData.m_135353_(MerorGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STAND_TICK = SynchedEntityData.m_135353_(MerorGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STAND = SynchedEntityData.m_135353_(MerorGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_12, false);
    public int spellLevel = 4;
    private int sitTick = 0;

    public MerorGolemEntity(EntityType<? extends MerorGolemEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 100;
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 220.0);
        builder = builder.m_22268_(Attributes.f_22282_, 3.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 8.0);
        builder = builder.m_22268_(Attributes.f_22281_, 20.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((MerorGolemEntity)this).m_21674_(arg_0)));
    }

    protected SoundEvent m_7515_() {
        if (this.getStandTick() > 0 && !this.isInSittingPose()) {
            return JerotesVillageSounds.MEROR_GOLEM_AMBIENT;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (!EntityAndItemFind.isMerorAttack((DamageSource)damageSource)) {
            return JerotesVillageSounds.MEROR_TOUGHNESS;
        }
        return JerotesVillageSounds.MEROR_GOLEM_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.MEROR_GOLEM_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.MEROR_GOLEM_WALK, 0.5f, 1.0f);
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 2.95f;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.5 && this.f_19796_.m_188503_(5) == 1;
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.2, 1.2, 1.2);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setStandTick(int n) {
        this.m_20088_().m_135381_(STAND_TICK, (Object)n);
    }

    public int getStandTick() {
        return (Integer)this.m_20088_().m_135370_(STAND_TICK);
    }

    public void setSendTick(int n) {
        this.m_20088_().m_135381_(SEND_TICK, (Object)n);
    }

    public int getSendTick() {
        return (Integer)this.m_20088_().m_135370_(SEND_TICK);
    }

    public void setSendUseTick(int n) {
        this.m_20088_().m_135381_(SEND_USE_TICK, (Object)n);
    }

    public int getSendUseTick() {
        return (Integer)this.m_20088_().m_135370_(SEND_USE_TICK);
    }

    public boolean isStand() {
        return (Boolean)this.m_20088_().m_135370_(STAND);
    }

    public void setStand(boolean bl) {
        this.m_20088_().m_135381_(STAND, (Object)bl);
    }

    @Override
    public boolean specialAction() {
        return (this.getStandTick() < 0 || this.getStandTick() > 5980) && !this.isTame() || this.getSendUseTick() > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "send")) {
            return 3;
        }
        if (Objects.equals(animation, "dead")) {
            return 4;
        }
        return super.getAnimationState(animation);
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        List<AnimationState> list = super.getAllAnimations();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.sendAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128379_("IsStand", this.isStand());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("StandTick", this.getStandTick());
        compoundTag.m_128405_("SendTick", this.getSendTick());
        compoundTag.m_128405_("SendUseTick", this.getSendUseTick());
        compoundTag.m_128405_("SitTick", this.sitTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128441_("IsStand")) {
            this.setStand(compoundTag.m_128471_("IsStand"));
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setStandTick(compoundTag.m_128451_("StandTick"));
        this.setSendTick(compoundTag.m_128451_("SendTick"));
        this.setSendUseTick(compoundTag.m_128451_("SendUseTick"));
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(STAND_TICK, (Object)-10);
        this.m_20088_().m_135372_(SEND_TICK, (Object)0);
        this.m_20088_().m_135372_(SEND_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(STAND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (STAND.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.sendAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sendAnimationState);
                    break;
                }
                case 4: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.m_20069_()) {
            this.f_19812_ = true;
        }
        if (this.m_6084_() && !this.isTame() && this.getStandTick() > 40 || this.isTame() && !this.isInSittingPose()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-5, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 8 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.specialAction() || this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.m_6084_()) {
            if (this.isTame()) {
                if (this.isInSittingPose()) {
                    this.idleAnimationState.m_216973_();
                } else {
                    this.standAnimationState.m_216973_();
                }
                if (this.isInSittingPose() && this.sitTick <= 0) {
                    this.sitTick = 40;
                }
                if (!this.isInSittingPose() && this.sitTick > 0) {
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    this.sitTick = 0;
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216973_();
                }
                if (this.sitTick == 40) {
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick == 20) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick > 5) {
                    --this.sitTick;
                }
            } else {
                if (this.getStandTick() >= 0) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setStandTick(this.getStandTick() - 1);
                    }
                } else if (this.m_217043_().m_188503_(100) == 1 && this.m_6084_()) {
                    this.m_5634_(5.0f);
                }
                if (this.m_5912_() || this.getSendUseTick() > 0 || this.m_5448_() != null || this.m_21188_() != null) {
                    if (this.getStandTick() <= 20) {
                        if (!this.m_9236_().m_5776_()) {
                            this.setStand(false);
                            this.setStandTick(6000);
                        }
                    } else if (this.getStandTick() < 5980 && !this.m_9236_().m_5776_()) {
                        this.setStandTick(5980);
                    }
                }
                if (this.getStandTick() == 6000) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_GOLEM_AMBIENT, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                }
                if (this.getStandTick() == 5979) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                }
                if (this.getStandTick() == 21) {
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.getStandTick() <= 0) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                    if (!this.isStand() && !this.m_9236_().m_5776_()) {
                        this.setStand(true);
                    }
                } else {
                    this.standAnimationState.m_216973_();
                }
            }
        }
        if (!this.specialAction() && !this.m_21525_() && this.getSendTick() >= 400 && this.getAttackTick() <= -5 && (this.getStandTick() > 20 || this.isTame()) && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_() instanceof LivingEntity && this.m_20270_((Entity)this.m_5448_()) < 16.0f && !this.m_9236_().m_5776_()) {
            this.setSendUseTick(90);
        }
        if (this.getSendUseTick() == 90 && !this.m_9236_().m_5776_()) {
            this.setSendTick(0);
            this.setAnimTick(90);
            this.setAnimationState("send");
        }
        if (this.getSendUseTick() > 0) {
            this.m_21573_().m_26573_();
            if (!this.m_9236_().m_5776_()) {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            }
        }
        if ((this.getSendUseTick() == 75 || this.getSendUseTick() == 65 || this.getSendUseTick() == 55 || this.getSendUseTick() == 45 || this.getSendUseTick() == 35 || this.getSendUseTick() == 25) && this.m_6084_()) {
            String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
            if (this.m_217043_().m_188501_() <= 0.85f && !"Redstone Golem".equals(string) && !"\u7ea2\u77f3\u5080\u5121".equals(string)) {
                if (this.m_5448_() != null) {
                    OtherSpellFind.MerorTrap((LivingEntity)this, this.m_5448_(), this.getSpellLevel() * 2, this.getSpellLevel() * 4, 6, 2);
                } else {
                    OtherSpellFind.MerorTrap((LivingEntity)this, (LivingEntity)this, this.getSpellLevel() * 2, this.getSpellLevel() * 4, 6, 2);
                }
            } else if (this.getSendUseTick() == 65 || this.getSendUseTick() == 45 || this.getSendUseTick() == 25) {
                if (this.m_5448_() != null) {
                    OtherSpellFind.MerorMines((LivingEntity)this, this.m_5448_(), this.getSpellLevel(), this.getSpellLevel() * 2, 6, 2);
                } else {
                    OtherSpellFind.MerorMines((LivingEntity)this, (LivingEntity)this, this.getSpellLevel(), this.getSpellLevel() * 2, 6, 2);
                }
            }
            if (this.getSendUseTick() == 75 && !this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_GOLEM_ROAR, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSendTick(Math.min(400, this.getSendTick() + 1));
            this.setSendUseTick(Math.max(0, this.getSendUseTick() - 1));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.specialAction()) {
            return false;
        }
        if (this.getAttackTick() > -5) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(15);
            this.setAnimTick(15);
            int attackRandom = this.m_217043_().m_188503_(30);
            if (attackRandom > 15) {
                this.setAnimationState("attack1");
            } else {
                this.setAnimationState("attack2");
            }
        }
        return true;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.MEROR_GOLEM_ATTACK, 2.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82400_(1.0));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        this.standAnimationState.m_216973_();
        this.standStopAnimationState.m_216973_();
        this.standStartAnimationState.m_216973_();
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

