/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral;

import com.jerotes.jerotes.entity.ChangePoseAbout;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.TameMobEntity;
import com.jerotes.jerotes.entity.UseSpearSpecialEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.goal.JerotesChangeFollowMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeFollowOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeHelpMobOwnerGoal;
import com.jerotes.jerotes.goal.JerotesChangeOwnerHurtByTargetGoal;
import com.jerotes.jerotes.goal.JerotesChangeOwnerHurtTargetGoal;
import com.jerotes.jerotes.goal.JerotesChangeSitWhenOrderedToGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesPikeUseGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.entity.in.HasHomePosEntity;
import com.jerotes.jerotesvillage.goal.BaseTamableAnimalGoHomeGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SpearMachineEntity
extends PathfinderMob
implements NeutralMob,
UseSpearSpecialEntity,
JerotesEntity,
ChangePoseAbout,
HasHomePosEntity,
RangedAttackMob,
OwnableEntity,
TameMobEntity,
UseThrownJavelinEntity {
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> IS_WANDER = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GOING_HOME = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(SpearMachineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean orderedToSit;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public SpearMachineEntity(EntityType<? extends SpearMachineEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.6f);
        this.f_21364_ = 0;
        this.reassessTameGoals();
        this.m_21530_();
    }

    public float getDamageMultiple() {
        return 2.5f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 15.0);
        builder = builder.m_22268_(Attributes.f_22284_, 18.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.8);
        builder = builder.m_22268_(Attributes.f_22282_, 0.7);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesChangeSitWhenOrderedToGoal((ChangePoseAbout)this));
        this.f_21345_.m_25352_(2, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 30, 12.0f, 3.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesSpearUseGoal((PathfinderMob)this, 1.5, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new JerotesPikeUseGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new BaseTamableAnimalGoHomeGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new JerotesChangeFollowOwnerGoal((ChangePoseAbout)this, 1.3, 5.0f, 1.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new JerotesChangeFollowMobOwnerGoal((ChangePoseAbout)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new JerotesChangeHelpMobOwnerGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesChangeOwnerHurtByTargetGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(2, (Goal)new JerotesChangeOwnerHurtTargetGoal((ChangePoseAbout)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SpearMachineEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return JerotesVillageSounds.SPEAR_MACHINE_DEATH;
    }

    public SoundEvent m_5592_() {
        return JerotesVillageSounds.SPEAR_MACHINE_DEATH;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(JerotesVillageSounds.SPEAR_MACHINE_WALK, 0.15f, 1.0f);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.0, 1.0, 1.0);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    protected void reassessTameGoals() {
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity == this.m_269323_();
    }

    public boolean isOrderedToSit() {
        return this.orderedToSit;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID)).orElse(null);
    }

    public void setTame(boolean bl) {
        byte bl1 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 | 4)));
            this.m_21051_(Attributes.f_22281_).m_22100_(7.0);
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 & 0xFFFFFFFB)));
            this.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        }
        this.reassessTameGoals();
    }

    @Override
    public void setHomePos(BlockPos blockPos) {
        this.f_19804_.m_135381_(HOME_POS, (Object)blockPos);
    }

    @Override
    public BlockPos getHomePos() {
        return (BlockPos)this.f_19804_.m_135370_(HOME_POS);
    }

    @Override
    public boolean isGoingHome() {
        return (Boolean)this.f_19804_.m_135370_(GOING_HOME);
    }

    @Override
    public void setGoingHome(boolean bl) {
        this.f_19804_.m_135381_(GOING_HOME, (Object)bl);
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : SpearMachineEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return SpearMachineEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public boolean isWander() {
        return (Boolean)this.m_20088_().m_135370_(IS_WANDER);
    }

    public void setWander(boolean bl) {
        this.m_20088_().m_135381_(IS_WANDER, (Object)bl);
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.m_269323_()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public void setOrderedToSit(boolean bl) {
        this.orderedToSit = bl;
    }

    public void setInSittingPose(boolean bl) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsWander", this.isWander());
        compoundTag.m_128379_("IsGoingHome", this.isGoingHome());
        compoundTag.m_128405_("HomePosX", this.getHomePos().m_123341_());
        compoundTag.m_128405_("HomePosY", this.getHomePos().m_123342_());
        compoundTag.m_128405_("HomePosZ", this.getHomePos().m_123343_());
        if (this.m_21805_() != null) {
            compoundTag.m_128362_("Owner", this.m_21805_());
        }
        compoundTag.m_128379_("Sitting", this.orderedToSit);
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        UUID uuid;
        super.m_7378_(compoundTag);
        this.setWander(compoundTag.m_128471_("IsWander"));
        this.setGoingHome(compoundTag.m_128471_("IsGoingHome"));
        int n = compoundTag.m_128451_("HomePosX");
        int n2 = compoundTag.m_128451_("HomePosY");
        int n3 = compoundTag.m_128451_("HomePosZ");
        this.setHomePos(new BlockPos(n, n2, n3));
        if (compoundTag.m_128403_("Owner")) {
            uuid = compoundTag.m_128342_("Owner");
        } else {
            String string = compoundTag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
        this.orderedToSit = compoundTag.m_128471_("Sitting");
        this.setInSittingPose(this.orderedToSit);
        this.m_147285_(this.m_9236_(), compoundTag);
    }

    public boolean m_6072_() {
        return super.m_6072_() && this.getChangeType() != 3;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_WANDER, (Object)false);
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(HOME_POS, (Object)BlockPos.f_121853_);
        this.m_20088_().m_135372_(GOING_HOME, (Object)false);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
    }

    public static boolean targetJavelinWeapon(ItemStack javelin) {
        return InventoryEntity.isRangeJavelin((ItemStack)javelin) || InventoryEntity.isSpear((ItemStack)javelin) || InventoryEntity.isPike((ItemStack)javelin) || javelin.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tools/tridents"))) || javelin.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tools/pikes"))) || javelin.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:tools/spears")));
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        if (this.m_9236_().m_5776_()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)player) || SpearMachineEntity.targetJavelinWeapon(itemStack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player)) {
                InteractionResult interactionResult;
                if (!player.m_6144_()) {
                    if (SpearMachineEntity.targetJavelinWeapon(itemStack)) {
                        this.swapItem(player, EquipmentSlot.MAINHAND, itemStack, interactionHand);
                        int health = 7 + itemStack.m_41720_().m_41462_() / 100;
                        this.m_21051_(Attributes.f_22276_).m_22100_((double)health);
                        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
                        return InteractionResult.SUCCESS;
                    }
                    if (this.m_5448_() == null) {
                        this.m_5634_(4.0f);
                        this.m_9236_().m_7605_((Entity)this, (byte)11);
                        return super.m_6071_(player, interactionHand);
                    }
                }
                if ((interactionResult = super.m_6071_(player, interactionHand)).m_19077_() && !this.m_6162_() || !this.isOwnedBy((LivingEntity)player)) {
                    return interactionResult;
                }
                if (!this.m_20160_()) {
                    int pose = this.getChangeType() + 1;
                    if (pose > 4) {
                        pose = 1;
                    }
                    this.setChangeType(pose, player);
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (SpearMachineEntity.targetJavelinWeapon(itemStack)) {
                if (!this.isTame()) {
                    this.tame(player);
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.setChangeType(1, player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    return InteractionResult.SUCCESS;
                }
                this.m_9236_().m_7605_((Entity)this, (byte)6);
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            retval = super.m_6071_(player, interactionHand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        return retval;
    }

    public int getChangeType() {
        return (this.isOrderedToSit() ? 1 : 2) + (this.isWander() ? 2 : 0);
    }

    public void setChangeType(int n) {
        n = Mth.m_14045_((int)n, (int)1, (int)4);
        switch (n) {
            case 1: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 2: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(false);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 3: {
                this.setOrderedToSit(true);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                    this.setHomePos(this.m_20183_());
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                break;
            }
            case 4: {
                this.setOrderedToSit(false);
                if (!this.m_9236_().m_5776_()) {
                    this.setWander(true);
                }
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
        }
    }

    public void setChangeType(int n, Player player) {
        this.setChangeType(n);
        if (!this.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_213846_((Component)Component.m_237110_((String)("talk.jerotes.pose_" + n), (Object[])new Object[]{this.m_5446_()}).m_130940_(ChatFormatting.WHITE));
        }
    }

    protected void spawnTamingParticles(boolean bl) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!bl) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected void spawnHealParticles() {
        SimpleParticleType particleoptions = ParticleTypes.f_123748_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private boolean swapItem(Player player, EquipmentSlot equipmentSlot, ItemStack itemStack, InteractionHand interactionHand) {
        ItemStack itemStack2 = this.m_6844_(equipmentSlot);
        if (player.m_150110_().f_35937_ && itemStack2.m_41619_() && !itemStack.m_41619_()) {
            this.m_8061_(equipmentSlot, itemStack.m_255036_(1));
            return true;
        }
        if (!itemStack.m_41619_() && itemStack.m_41613_() > 1) {
            if (!itemStack2.m_41619_()) {
                return false;
            }
            this.m_8061_(equipmentSlot, itemStack.m_41620_(1));
            return true;
        }
        this.m_8061_(equipmentSlot, itemStack);
        player.m_21008_(interactionHand, itemStack2);
        return true;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_21203_();
        this.updateNoActionTime();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (this.isWander() && this.isInSittingPose() && !this.m_9236_().f_46443_) {
            this.setInSittingPose(false);
        }
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ = (int)((double)this.f_20891_ + 2.5);
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl = super.m_7327_(entity);
        if (bl) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.SPEAR_MACHINE_ATTACK, 1.0f, 1.0f);
            }
            if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
                ItemStack hand = this.m_21205_();
                hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl && !this.m_9236_().m_5776_() && this.getChangeType() == 1) {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setChangeType(2, player);
            } else {
                this.setChangeType(2);
            }
        }
        return bl;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 7) {
            this.spawnTamingParticles(true);
        } else if (by == 6) {
            this.spawnTamingParticles(false);
        } else if (by == 11) {
            this.spawnHealParticles();
        } else {
            super.m_7822_(by);
        }
    }

    public boolean m_7307_(Entity entity) {
        if (this.isTame()) {
            LivingEntity livingentity = this.m_269323_();
            if (entity == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        return !this.isOwnedBy(livingEntity) && super.m_6779_(livingEntity);
    }

    public boolean wantsToAttack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        return AttackFind.wantsToAttack((Mob)this, (LivingEntity)livingEntity, (LivingEntity)livingEntity2);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setHomePos(this.m_20183_());
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6667_(DamageSource damageSource) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(damageSource);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }
}

