/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class UnicycleEntity
extends PathfinderMob
implements JerotesEntity,
Saddleable,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> RUSH_TICK = SynchedEntityData.m_135353_(UnicycleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RUSH_STRENGTH = SynchedEntityData.m_135353_(UnicycleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public UnicycleEntity(EntityType<? extends UnicycleEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.6f);
        this.f_21364_ = 0;
        this.m_21530_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 5.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.7);
        return builder;
    }

    public SoundEvent m_5592_() {
        return JerotesVillageSounds.UNICYCLE_DEATH;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return JerotesVillageSounds.UNICYCLE_DEATH;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    public boolean m_6741_() {
        return this.m_6084_();
    }

    public void m_5853_(@Nullable SoundSource p_21748_) {
    }

    public boolean m_6254_() {
        return true;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(JerotesVillageSounds.UNICYCLE_WALK, 0.15f, 1.0f);
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        Vec3 vec3 = this.getPassengerRidingPosition(entity);
        moveFunction.m_20372_(entity, vec3.f_82479_, vec3.f_82480_ + (double)this.getMyRidingOffset((Entity)this), vec3.f_82481_);
    }

    public float getMyRidingOffset(Entity entity) {
        return this.ridingOffset(entity) * this.m_6134_();
    }

    protected float ridingOffset(Entity entity) {
        return -0.6f;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return new Vec3(this.getPassengerAttachmentPoint(entity, this.m_6972_(this.m_20089_()), this.m_6134_()).rotateY(-this.f_20883_ * ((float)Math.PI / 180))).m_82549_(this.m_20182_());
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_, 0.0f);
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_() && this.m_146895_() instanceof Player) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = 0.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public void setRushTick(int n) {
        this.m_20088_().m_135381_(RUSH_TICK, (Object)n);
    }

    public int getRushTick() {
        return (Integer)this.m_20088_().m_135370_(RUSH_TICK);
    }

    public void setRushStrength(int n) {
        this.m_20088_().m_135381_(RUSH_STRENGTH, (Object)n);
    }

    public int getRushStrength() {
        return (Integer)this.m_20088_().m_135370_(RUSH_STRENGTH);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("RushTick", this.getRushTick());
        compoundTag.m_128405_("RushStrength", this.getRushStrength());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setRushTick(compoundTag.m_128451_("RushTick"));
        this.setRushStrength(compoundTag.m_128451_("RushStrength"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(RUSH_TICK, (Object)0);
        this.m_20088_().m_135372_(RUSH_STRENGTH, (Object)0);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(1.0f);
        }
        if (this.m_6688_() != null && this.getRushTick() == 60) {
            this.RushAttack((float)this.getRushStrength() / 300.0f);
            this.setRushStrength(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setRushTick(Math.max(0, this.getRushTick() - 1));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (!this.m_9236_().f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        Entity entity2;
        if (this.m_6254_() && (entity2 = (entity = this.m_146895_())) instanceof Player) {
            Player player = (Player)entity2;
            return player;
        }
        return super.m_6688_();
    }

    public void m_7888_(int i) {
    }

    public boolean m_7132_() {
        return this.m_20096_() && this.getRushTick() <= 0;
    }

    public int m_245614_() {
        return this.getRushTick();
    }

    public void m_7199_(int i) {
        if (this.m_6688_() != null && !this.m_9236_().m_5776_()) {
            this.setRushTick(60);
            this.setRushStrength(i);
        }
    }

    public void m_8012_() {
    }

    public boolean RushAttack(float f7) {
        this.m_6853_(false);
        this.m_5997_(0.0, 0.5, 0.0);
        return true;
    }
}

