/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.google.common.annotations.VisibleForTesting;
import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.control.NoRotationControl;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public class AnimatedChainEntity
extends PathfinderMob
implements JerotesEntity,
TraceableEntity,
CanBeIllagerFactionEntity,
OwnableEntity {
    private static final EntityDataAccessor<Float> ID_SIZE = SynchedEntityData.m_135353_(AnimatedChainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int hasUse;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private LivingEntity prisoner;
    @Nullable
    private UUID prisonerUUID;

    public AnimatedChainEntity(EntityType<? extends AnimatedChainEntity> type, Level world) {
        super(type, world);
        this.m_252801_();
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 12.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11794_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11744_;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public void m_20256_(Vec3 vec3) {
        super.m_20256_(new Vec3(0.0, vec3.f_82480_, 0.0));
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new NoRotationControl((Mob)this);
    }

    public boolean isIllagerFaction() {
        return this.m_269323_() != null && EntityFactionFind.isRaider((LivingEntity)this.m_269323_());
    }

    public void setIllagerFaction(boolean b) {
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.0f;
    }

    protected AABB m_142242_() {
        return AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() + (double)(this.getSize() / 2.0f), this.m_20189_()), (double)this.getSize(), (double)this.getSize(), (double)this.getSize());
    }

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Nullable
    public LivingEntity m_269323_() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    @Nullable
    public LivingEntity getPrisoner() {
        Entity entity;
        if (this.prisoner == null && this.prisonerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.prisonerUUID)) instanceof LivingEntity) {
            this.prisoner = (LivingEntity)entity;
        }
        return this.prisoner;
    }

    public void setPrisoner(@Nullable LivingEntity livingEntity) {
        this.prisoner = livingEntity;
        this.prisonerUUID = livingEntity == null ? null : livingEntity.m_20148_();
        this.hasUse = 1;
        this.m_20011_(this.m_142242_());
    }

    @VisibleForTesting
    public void setSize(float f) {
        float f2 = Mth.m_14036_((float)f, (float)0.0f, (float)256.0f);
        this.f_19804_.m_135381_(ID_SIZE, (Object)Float.valueOf(f2));
        this.m_20011_(this.m_142242_());
        this.m_20090_();
        this.m_6210_();
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(ID_SIZE)).floatValue();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("HasUse", this.hasUse);
        compoundTag.m_128350_("Size", this.getSize());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        if (this.prisonerUUID != null) {
            compoundTag.m_128362_("Prisoner", this.prisonerUUID);
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        this.setSize(compoundTag.m_128457_("Size"));
        super.m_7378_(compoundTag);
        this.hasUse = compoundTag.m_128451_("HasUse");
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        if (compoundTag.m_128403_("Prisoner")) {
            this.prisonerUUID = compoundTag.m_128342_("Prisoner");
        }
        this.m_20011_(this.m_142242_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ID_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ID_SIZE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_6210_() {
        double d = this.m_20185_();
        double d2 = this.m_20186_();
        double d3 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, d2, d3);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19794_ = true;
        this.m_20242_(true);
        this.m_6862_(false);
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            this.f_21345_.m_25360_(Goal.Flag.TARGET, false);
            this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20095_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.f_19797_ % 60 == 0) {
            this.m_6469_(this.m_269291_().m_287172_(), 4.0f);
        }
        if (this.getPrisoner() != null) {
            this.m_6027_(this.getPrisoner().m_20185_(), this.getPrisoner().m_20227_(0.5) - (double)(this.getSize() / 2.0f), this.getPrisoner().m_20189_());
            if (!this.getPrisoner().m_9236_().f_46443_) {
                this.getPrisoner().m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.ENSLAVEMENT.get(), 5, 0, false, false), (Entity)this);
            }
        }
        if (!(this.hasUse != 1 || this.getPrisoner() != null && this.getPrisoner().m_6084_())) {
            this.m_6469_(this.m_269291_().m_287172_(), 20.0f);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268752_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268613_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268469_)) {
            return false;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            for (int i = 0; i < 24; ++i) {
                _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50184_.m_49966_()), this.getChainX(0.5), this.getChainY(0.5), this.getChainZ(0.5), 0, 0.3, 0.0, 0.3, 0.0);
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public double getChainX(double d) {
        return this.m_20185_() + (double)this.getSize() * d;
    }

    public double m_20208_(double d) {
        return this.getChainX((2.0 * this.f_19796_.m_188500_() - 1.0) * d);
    }

    public double getChainY(double d) {
        return this.m_20186_() + (double)this.getSize() * d;
    }

    public double getRandomY(double d) {
        return this.getChainY((2.0 * this.f_19796_.m_188500_() - 1.0) * d);
    }

    public double getChainZ(double d) {
        return this.m_20189_() + (double)this.getSize() * d;
    }

    public double m_20262_(double d) {
        return this.getChainZ((2.0 * this.f_19796_.m_188500_() - 1.0) * d);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setSize(1.0f);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

