/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.entity.BasePartEntity;
import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.control.NoRotationControl;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.BitterColdSorcererEntity;
import com.jerotes.jerotesvillage.entity.Part.BitterColdAltarPart;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class BitterColdAltarEntity
extends Mob
implements JerotesEntity,
TraceableEntity,
CanBeIllagerFactionEntity,
OwnableEntity {
    private static final EntityDataAccessor<Integer> START_TICK = SynchedEntityData.m_135353_(BitterColdAltarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(BitterColdAltarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(BitterColdAltarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState stopAnimationState = new AnimationState();
    private BitterColdAltarPart part_1;
    private BitterColdAltarPart part_2;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    public float faces;

    public BitterColdAltarEntity(EntityType<? extends BitterColdAltarEntity> type, Level world) {
        super(type, world);
        this.startAnimationState.m_216977_(this.f_19797_);
        this.resetParts();
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    public void resetParts() {
        PlayerTeam teams;
        ServerLevel serverLevel;
        this.removeParts();
        this.part_1 = new BitterColdAltarPart(this, 0.0f, 0.0f, 1.5f, 1.0f, 3.5f, 1.0f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            teams = (PlayerTeam)this.m_5647_();
            if (teams != null) {
                serverLevel.m_6188_().m_6546_(this.part_1.m_20149_(), teams);
            }
        }
        this.part_1.m_20359_((Entity)this);
        this.part_1.setParent((Entity)this);
        this.part_2 = new BitterColdAltarPart(this, 0.0f, 0.0f, 0.5f, 5.0f, 1.0f, 1.0f);
        teams = this.m_9236_();
        if (teams instanceof ServerLevel) {
            serverLevel = (ServerLevel)teams;
            teams = (PlayerTeam)this.m_5647_();
            if (teams != null) {
                serverLevel.m_6188_().m_6546_(this.part_2.m_20149_(), teams);
            }
        }
        this.part_2.m_20359_((Entity)this);
        this.part_2.setParent((Entity)this);
    }

    public void updateParts() {
        Main.updatePart((BasePartEntity)this.part_1, (LivingEntity)this);
        Main.updatePart((BasePartEntity)this.part_2, (LivingEntity)this);
    }

    private void removeParts() {
        if (this.part_1 != null) {
            this.part_1.m_142687_(Entity.RemovalReason.DISCARDED);
            this.part_1 = null;
        }
        if (this.part_2 != null) {
            this.part_2.m_142687_(Entity.RemovalReason.DISCARDED);
            this.part_2 = null;
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        this.removeParts();
        super.m_142687_(reason);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11983_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11985_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_203117_() {
        return false;
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    public void m_20256_(Vec3 vec3) {
        super.m_20256_(new Vec3(0.0, vec3.f_82480_, 0.0));
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new NoRotationControl(this);
    }

    public boolean isIllagerFaction() {
        return this.m_269323_() != null && EntityFactionFind.isRaider((LivingEntity)this.m_269323_());
    }

    public void setIllagerFaction(boolean b) {
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Nullable
    public LivingEntity m_269323_() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "start")) {
            return 1;
        }
        if (Objects.equals(animation, "stop")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.startAnimationState);
        list.add(this.stopAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.startAnimationState) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setStartTick(int n) {
        this.m_20088_().m_135381_(START_TICK, (Object)n);
    }

    public int getStartTick() {
        return (Integer)this.m_20088_().m_135370_(START_TICK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Faces", this.faces);
        compoundTag.m_128405_("StartTick", this.getStartTick());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.faces = compoundTag.m_128457_("Faces");
        this.setStartTick(compoundTag.m_128451_("StartTick"));
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.resetParts();
        float facing = 0.0f;
        if (this.faces > 0.75f) {
            facing = 90.0f;
        } else if (this.faces > 0.5f) {
            facing = 180.0f;
        } else if (this.faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(START_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.startAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.startAnimationState);
                    break;
                }
                case 2: {
                    this.stopAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.stopAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6862_(false);
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            this.f_21345_.m_25360_(Goal.Flag.TARGET, false);
            this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        }
        this.updateParts();
        if (this.part_1 == null || this.part_2 == null || this.part_1.m_20270_((Entity)this) > 10.0f || this.part_2.m_20270_((Entity)this) > 10.0f) {
            this.resetParts();
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        this.m_20095_();
        if (!this.m_9236_().m_5776_()) {
            this.setStartTick(this.getStartTick() + 1);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_146888_() > 0) {
            this.m_146917_(0);
        }
        if (this.m_5448_() != null && this.m_5448_().m_20270_((Entity)this) <= 24.0f && (livingEntity = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)livingEntity;
            _level.m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(0.5), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 3.0) + 1.5, this.m_20262_(0.5), 15, 0.3, 0.0, 0.3, 0.0);
        }
        List listSorcerer = this.m_9236_().m_45976_(BitterColdSorcererEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0));
        listSorcerer.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        if (listSorcerer.isEmpty() && this.getStartTick() % 60 == 0) {
            this.m_6469_(this.m_269291_().m_287172_(), 5.0f);
        }
        if (this.getStartTick() % 120 == 0 && this.f_20919_ == 0) {
            Level level;
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.BITTER_COLD_SORCERER_ALTAR_USE, this.m_5720_(), 5.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                List list = serverLevel.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(12.0, 12.0, 12.0));
                for (LivingEntity livingEntityDeter : list) {
                    Mob mob;
                    OwnableEntity ownable;
                    Mob mob2;
                    if (livingEntityDeter == null || this.m_20270_((Entity)livingEntityDeter) > 24.0f || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)livingEntityDeter) || this.m_5647_() == null && livingEntityDeter.m_5647_() == null && livingEntityDeter instanceof Mob && (mob2 = (Mob)livingEntityDeter).m_5448_() != this && this.m_5448_() != mob2 && EntityFactionFind.isRaider((LivingEntity)mob2) && this.isIllagerFaction() || livingEntityDeter instanceof BitterColdAltarEntity || livingEntityDeter instanceof OwnableEntity && (ownable = (OwnableEntity)livingEntityDeter).m_269323_() == this.owner && (!(livingEntityDeter instanceof Mob) || (mob = (Mob)livingEntityDeter).m_5448_() != this) && this.m_5448_() != ownable) continue;
                    livingEntityDeter.m_146917_(livingEntityDeter.m_146888_() + 240);
                    if (livingEntityDeter.m_9236_().f_46443_) continue;
                    livingEntityDeter.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 120, 0), (Entity)this);
                    livingEntityDeter.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 120, 0), (Entity)this);
                }
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.BITTER_COLD_ALTAR.get()), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_269533_(DamageTypeTags.f_268419_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Level handItem;
        Entity i3;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268738_) || amount >= 300.0f) {
            Level level;
            if (amount >= 5.0f && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                for (int i2 = 0; i2 < 24; ++i2) {
                    _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)JerotesVillageBlocks.ICE_ROCK.get()).m_49966_()), this.m_20208_(0.5), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 3.0) + 1.5, this.m_20262_(0.5), 15, 0.3, 0.0, 0.3, 0.0);
                }
            }
            return super.m_6469_(damageSource, amount);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            Level i2;
            if (amount >= 5.0f && (i2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)i2;
                for (int i3 = 0; i3 < 24; ++i3) {
                    _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)JerotesVillageBlocks.ICE_ROCK.get()).m_49966_()), this.m_20208_(0.5), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 3.0) + 1.5, this.m_20262_(0.5), 15, 0.3, 0.0, 0.3, 0.0);
                }
            }
            return super.m_6469_(damageSource, amount * 3.0f);
        }
        if (EntityAndItemFind.isMeleeDamage((DamageSource)damageSource) && (i3 = damageSource.m_7639_()) instanceof LivingEntity) {
            Item item;
            LivingEntity livingEntity = (LivingEntity)i3;
            handItem = livingEntity.m_21205_();
            if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand((LivingEntity)livingEntity)) {
                handItem = livingEntity.m_21206_();
            }
            if ((item = handItem.m_41720_()) instanceof PickaxeItem) {
                Level level;
                PickaxeItem pickaxeItem = (PickaxeItem)item;
                if (amount >= 5.0f && (level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)level;
                    for (int i4 = 0; i4 < 24; ++i4) {
                        _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)JerotesVillageBlocks.ICE_ROCK.get()).m_49966_()), this.m_20208_(0.5), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 3.0) + 1.5, this.m_20262_(0.5), 15, 0.3, 0.0, 0.3, 0.0);
                    }
                }
                int n = (int)pickaxeItem.m_43314_().m_6624_() + pickaxeItem.getEnchantmentLevel((ItemStack)handItem, Enchantments.f_44984_);
                return super.m_6469_(damageSource, amount * (float)n / 2.0f);
            }
        }
        if (amount >= 5.0f) {
            handItem = this.m_9236_();
            if (handItem instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)handItem;
                for (int i5 = 0; i5 < 24; ++i5) {
                    _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)JerotesVillageBlocks.ICE_ROCK.get()).m_49966_()), this.m_20208_(0.5), this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * 3.0) + 1.5, this.m_20262_(0.5), 15, 0.3, 0.0, 0.3, 0.0);
                }
            }
            return super.m_6469_(damageSource, 5.0f);
        }
        return false;
    }

    public void m_8127_() {
        super.m_8127_();
        float facing = 0.0f;
        if (this.faces > 0.75f) {
            facing = 90.0f;
        } else if (this.faces > 0.5f) {
            facing = 180.0f;
        } else if (this.faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        float faces;
        this.faces = faces = this.m_9236_().m_213780_().m_188501_();
        float facing = 0.0f;
        if (faces > 0.75f) {
            facing = 90.0f;
        } else if (faces > 0.5f) {
            facing = 180.0f;
        } else if (faces > 0.25f) {
            facing = 270.0f;
        }
        this.m_146922_(facing);
        this.m_5616_(facing);
        this.m_5618_(facing);
        this.f_20884_ = facing;
        this.f_20883_ = facing;
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            this.setAnimTick(20);
            this.setAnimationState("stop");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

