/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class CelestialCoilvineFlowerEntity
extends Mob
implements JerotesEntity,
TraceableEntity,
OwnableEntity {
    private static final EntityDataAccessor<Integer> START_TICK = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState spellAnimationState = new AnimationState();
    public AnimationState stopAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIGHT_LOCK_X = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIGHT_LOCK_Y = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIGHT_LOCK_Z = SynchedEntityData.m_135353_(CelestialCoilvineFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int maxTick = 480;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public CelestialCoilvineFlowerEntity(EntityType<? extends CelestialCoilvineFlowerEntity> type, Level world) {
        super(type, world);
    }

    public CelestialCoilvineFlowerEntity(Level p_36926_, double p_36927_, double p_36928_, double p_36929_, float p_36930_, LivingEntity p_36932_) {
        this((EntityType<? extends CelestialCoilvineFlowerEntity>)((EntityType)JerotesVillageEntityType.CELESTIAL_COILVINE_FLOWER.get()), p_36926_);
        this.setOwner(p_36932_);
        this.m_146922_(p_36930_ * 57.295776f);
        this.m_6034_(p_36927_, p_36928_, p_36929_);
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 25.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11990_;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6138_() {
    }

    public void m_20256_(Vec3 vec3) {
        super.m_20256_(new Vec3(0.0, 0.0, 0.0));
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.75f;
    }

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Nullable
    public LivingEntity m_269323_() {
        LivingEntity living;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : CelestialCoilvineFlowerEntity.getLivingEntityByUUID(this.m_9236_(), uuid);
        }
        int id = this.getOwnerId();
        return id <= -1 ? null : ((entity = this.m_9236_().m_6815_(this.getOwnerId())) instanceof LivingEntity && (living = (LivingEntity)entity) != this ? living : null);
    }

    public int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerId(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static LivingEntity getLivingEntityByUUID(Level level, UUID uuid) {
        return CelestialCoilvineFlowerEntity.getLivingEntityByUUID(level.m_7654_(), uuid);
    }

    public static LivingEntity getLivingEntityByUUID(MinecraftServer server, UUID uuid) {
        if (uuid != null && server != null) {
            for (ServerLevel world : server.m_129785_()) {
                Entity entity = world.m_8791_(uuid);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
        }
        return null;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "start")) {
            return 1;
        }
        if (Objects.equals(animation, "spell")) {
            return 2;
        }
        if (Objects.equals(animation, "stop")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.startAnimationState);
        list.add(this.spellAnimationState);
        list.add(this.stopAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setStartTick(int n) {
        this.m_20088_().m_135381_(START_TICK, (Object)n);
    }

    public int getStartTick() {
        return (Integer)this.m_20088_().m_135370_(START_TICK);
    }

    public void setLightLockX(int n) {
        this.m_20088_().m_135381_(LIGHT_LOCK_X, (Object)n);
    }

    public int getLightLockX() {
        return (Integer)this.m_20088_().m_135370_(LIGHT_LOCK_X);
    }

    public void setLightLockY(int n) {
        this.m_20088_().m_135381_(LIGHT_LOCK_Y, (Object)n);
    }

    public int getLightLockY() {
        return (Integer)this.m_20088_().m_135370_(LIGHT_LOCK_Y);
    }

    public void setLightLockZ(int n) {
        this.m_20088_().m_135381_(LIGHT_LOCK_Z, (Object)n);
    }

    public int getLightLockZ() {
        return (Integer)this.m_20088_().m_135370_(LIGHT_LOCK_Z);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("StartTick", this.getStartTick());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        compoundTag.m_128405_("MaxTick", this.maxTick);
        compoundTag.m_128405_("LightLockX", this.getLightLockX());
        compoundTag.m_128405_("LightLockY", this.getLightLockY());
        compoundTag.m_128405_("LightLockZ", this.getLightLockZ());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStartTick(compoundTag.m_128451_("StartTick"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        this.maxTick = compoundTag.m_128451_("MaxTick");
        this.setLightLockX(compoundTag.m_128451_("LightLockX"));
        this.setLightLockY(compoundTag.m_128451_("LightLockY"));
        this.setLightLockZ(compoundTag.m_128451_("LightLockZ"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_OWNER_ID, (Object)-1);
        this.m_20088_().m_135372_(START_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(LIGHT_LOCK_X, (Object)0);
        this.m_20088_().m_135372_(LIGHT_LOCK_Y, (Object)0);
        this.m_20088_().m_135372_(LIGHT_LOCK_Z, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.startAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.startAnimationState);
                    break;
                }
                case 2: {
                    this.spellAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.spellAnimationState);
                    break;
                }
                case 3: {
                    this.stopAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.stopAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6862_(false);
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        }
    }

    public void m_8107_() {
        ServerLevel serverLevel;
        Level level;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_269323_() != null && this.getOwnerId() == -1) {
            this.setOwnerId(this.m_269323_().m_19879_());
        }
        if (!this.m_9236_().m_5776_()) {
            this.setStartTick(this.getStartTick() + 1);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        int trueMaxTick = this.maxTick;
        if (this.maxTick == 0) {
            trueMaxTick = 30;
        }
        if (this.getStartTick() >= trueMaxTick) {
            this.m_6469_(this.m_269291_().m_287172_(), 200.0f);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.getStartTick() % 5 == 0) {
            if (this.m_269323_() != null) {
                this.setLightLockX(this.m_269323_().m_20097_().m_123341_());
                this.setLightLockY(this.m_269323_().m_20097_().m_123342_() + 1);
                this.setLightLockZ(this.m_269323_().m_20097_().m_123343_());
            } else {
                this.setLightLockX(this.m_20097_().m_123341_());
                this.setLightLockY(this.m_20097_().m_123342_());
                this.setLightLockZ(this.m_20097_().m_123343_());
            }
        }
        if (this.m_6084_() && this.getStartTick() > 100 && this.getStartTick() % 80 == 0 && !this.m_6060_() && this.m_269323_() != null && this.m_20270_((Entity)this.m_269323_()) <= 128.0f) {
            this.m_269323_().m_20095_();
            this.m_269323_().m_5634_(Math.min(this.m_269323_().m_21233_() / 400.0f, 2.0f));
            level = this.m_9236_();
            if (level instanceof ServerLevel) {
                int i;
                serverLevel = (ServerLevel)level;
                Vec3 vec3 = this.m_146892_();
                Vec3 vec32 = this.m_269323_().m_20318_(0.0f).m_82520_(0.0, 4.0, 0.0).m_82546_(vec3);
                Vec3 vec33 = vec32.m_82541_();
                for (i = 1; i < Mth.m_14107_((double)vec32.m_82553_()) * 6 + 1; ++i) {
                    Vec3 vec34 = vec3.m_82549_(vec33.m_82490_((double)((float)i / 6.0f)));
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, vec34.f_82479_, vec34.f_82480_, vec34.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 24; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, this.m_20208_(0.75), this.m_20187_(), this.m_20262_(0.75), 0, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_276452_, this.m_269323_().m_20208_(0.75), this.m_269323_().m_20187_(), this.m_269323_().m_20262_(0.75), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(10);
                this.setAnimationState("spell");
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        AbstractArrow arrow;
        Entity entity;
        if (this.m_6673_(damageSource)) {
            return super.m_6673_(damageSource);
        }
        if (damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_269533_(DamageTypeTags.f_268419_) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            f *= 2.0f;
        }
        if (damageSource.m_7640_() != null && (entity = damageSource.m_7640_()) instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_6060_() || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            f *= 15.0f;
        } else if (EntityAndItemFind.isMeleeDamage((DamageSource)damageSource) && (entity = damageSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack handItem = livingEntity.m_21205_();
            if (!EntityAndItemFind.MeleeDamageFromMainHandNotOffHand((LivingEntity)livingEntity)) {
                handItem = livingEntity.m_21206_();
            }
            if (handItem.getEnchantmentLevel(Enchantments.f_44981_) > 0) {
                f *= 15.0f;
            }
        }
        return super.m_6469_(damageSource, f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(100);
            this.setAnimationState("start");
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            this.setAnimTick(20);
            this.setAnimationState("stop");
        }
        ++this.f_20919_;
        this.startAnimationState.m_216973_();
        this.spellAnimationState.m_216973_();
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

