/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;

public class EarthquakeFallingBlock
extends Entity
implements OwnableEntity {
    public static float DROP_FACTORS = 0.1f;
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> ANIM_V_Y = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> PUSH_TICK = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Boolean> BREAK_BLOCK = SynchedEntityData.m_135353_(EarthquakeFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public EarthquakeFallingBlock(EntityType<EarthquakeFallingBlock> entityType, Level level) {
        super(entityType, level);
        this.setDuration(20);
    }

    public EarthquakeFallingBlock(Level worldIn, BlockState blockState, float vy) {
        super((EntityType)JerotesVillageEntityType.EARTHQUAKE_FALLING_BLOCK.get(), worldIn);
        this.setMode(FallingMoveType.RENDER_MOVE);
        this.setBlockState(blockState);
        this.setAnimVY(vy);
    }

    public EarthquakeFallingBlock(Level level, double px, double py, double pz, BlockState blockState, int duration) {
        super((EntityType)JerotesVillageEntityType.EARTHQUAKE_FALLING_BLOCK.get(), level);
        this.setMode(FallingMoveType.OVERALL_MOVE);
        this.setBlockState(blockState);
        this.m_6034_(px, py + (double)((1.0f - this.m_20206_()) / 2.0f), pz);
        this.setDuration(duration);
        this.f_19854_ = px;
        this.f_19855_ = py;
        this.f_19856_ = pz;
        this.m_20256_(Vec3.f_82478_);
    }

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    @Nullable
    public LivingEntity m_269323_() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(BLOCK_STATE, (Object)Blocks.f_50493_.m_49966_());
        this.m_20088_().m_135372_(BREAK_BLOCK, (Object)true);
        this.m_20088_().m_135372_(MODE, (Object)FallingMoveType.OVERALL_MOVE.toString());
        this.m_20088_().m_135372_(ANIM_V_Y, (Object)Float.valueOf(1.0f));
        this.m_20088_().m_135372_(DURATION, (Object)120);
        this.m_20088_().m_135372_(PUSH_TICK, (Object)-10);
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        BlockState blockState = this.getBlockState();
        compoundTag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        compoundTag.m_128405_("Duration", this.getDuration());
        compoundTag.m_128379_("BreakBlock", this.isBreakBlock());
        compoundTag.m_128405_("PushTick", this.getPushTick());
        compoundTag.m_128405_("TickCount", this.f_19797_);
        compoundTag.m_128350_("VY", ((Float)this.m_20088_().m_135370_(ANIM_V_Y)).floatValue());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        this.setBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("BlockState")));
        this.setDuration(compoundTag.m_128451_("Duration"));
        this.setBreakBlock(compoundTag.m_128471_("BreakBlock"));
        this.setPushTick(compoundTag.m_128451_("PushTick"));
        this.f_19797_ = compoundTag.m_128451_("TickCount");
        this.setAnimVY(compoundTag.m_128457_("VY"));
    }

    public void m_8119_() {
        if (this.getMode() == FallingMoveType.RENDER_MOVE) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
        if (this.getMode() == FallingMoveType.OVERALL_MOVE) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, (double)(DROP_FACTORS / 2.0f), 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            if (this.m_20096_() && this.f_19797_ > this.getDuration() || this.f_19797_ > 300) {
                this.attack();
            }
            if (this.f_19862_ || this.f_19863_) {
                this.attack();
            }
        } else {
            float animVY = this.getAnimVY();
            this.prevAnimY = this.animY;
            this.animY += animVY;
            this.setAnimVY(animVY - DROP_FACTORS);
            if ((double)this.animY < -0.5) {
                this.attack();
            }
        }
        if (this.getPushTick() > 0 && this.m_269323_() != null) {
            this.setPushTick(this.getPushTick() - 1);
            if (this.getPushTick() == 0) {
                float f = this.m_269323_().m_146908_();
                float f2 = this.m_269323_().m_146909_();
                float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
                float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
                float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
                float f7 = 1.2f;
                this.m_5997_(f3 *= f7 / f6 * 2.0f, f4 *= f7 / f6 * 2.0f + 0.2f, f5 *= f7 / f6 * 2.0f);
            }
        }
        List listAttack = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
        listAttack.removeIf(livingEntity -> this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)livingEntity));
        for (LivingEntity hurt : listAttack) {
            if (hurt == null || hurt == this.m_269323_()) continue;
            this.attack();
            break;
        }
    }

    public void m_7334_(Entity entity) {
    }

    public void attack() {
        Level hurt2;
        if (RandomSource.m_216327_().m_188501_() > 0.75f) {
            this.m_216990_(SoundEvents.f_12319_);
        }
        List listAttack = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
        listAttack.removeIf(livingEntity -> this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)livingEntity));
        for (Level hurt2 : listAttack) {
            OwnableEntity ownable;
            if (hurt2 == null || hurt2 == this.m_269323_() || hurt2 instanceof OwnableEntity && (ownable = (OwnableEntity)hurt2).m_269323_() == this.m_269323_() || this.m_269323_() != null && AttackFind.FindCanNotAttack((LivingEntity)this.m_269323_(), (Entity)hurt2)) continue;
            hurt2.m_6469_(this.m_269291_().m_269299_((Entity)this, this.m_269323_()), 12.0f);
        }
        hurt2 = this.m_9236_();
        if (hurt2 instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)hurt2;
            if (!this.getBlockState().m_60795_()) {
                for (int i = 0; i < 6; ++i) {
                    _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.getBlockState()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.3, 0.0, 0.3, 0.0);
                }
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && this.isBreakBlock() && (this.m_269323_() == null || !(this.m_20186_() < this.m_269323_().m_20186_()))) {
            boolean bl = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            AABB aABB = this.m_20191_().m_82400_(0.5).m_82386_(0.0, 0.5, 0.0);
            for (BlockPos blockPos : BlockPos.m_121976_((int)Mth.m_14107_((double)aABB.f_82288_), (int)Mth.m_14107_((double)aABB.f_82289_), (int)Mth.m_14107_((double)aABB.f_82290_), (int)Mth.m_14107_((double)aABB.f_82291_), (int)Mth.m_14107_((double)aABB.f_82292_), (int)Mth.m_14107_((double)aABB.f_82293_))) {
                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                float block = blockState.m_60800_((BlockGetter)this.m_9236_(), blockPos);
                if (block >= 5.0f || block < 0.0f) continue;
                if ((blockState.m_204336_(BlockTags.f_278411_) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_215823_) || blockState.m_204336_(BlockTags.f_144266_)) && (double)this.f_19796_.m_188501_() > 0.05) {
                    bl = this.m_9236_().m_46953_(blockPos, false, (Entity)this) || bl;
                    continue;
                }
                bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
            }
        }
        this.m_146870_();
    }

    public void m_20334_(double x, double y, double z) {
        if (this.getMode() == FallingMoveType.OVERALL_MOVE) {
            super.m_20334_(x, y, z);
        }
    }

    public boolean m_6051_() {
        return false;
    }

    public BlockState getBlockState() {
        return (BlockState)this.f_19804_.m_135370_(BLOCK_STATE);
    }

    public void setBlockState(BlockState p_270267_) {
        this.f_19804_.m_135381_(BLOCK_STATE, (Object)p_270267_);
    }

    public boolean isBreakBlock() {
        return (Boolean)this.f_19804_.m_135370_(BREAK_BLOCK);
    }

    public void setBreakBlock(boolean bl) {
        this.f_19804_.m_135381_(BREAK_BLOCK, (Object)bl);
    }

    public FallingMoveType getMode() {
        String mode = (String)this.f_19804_.m_135370_(MODE);
        if (mode.isEmpty()) {
            return FallingMoveType.RENDER_MOVE;
        }
        return FallingMoveType.valueOf(mode);
    }

    public void setMode(FallingMoveType type) {
        this.f_19804_.m_135381_(MODE, (Object)type.toString());
    }

    public float getAnimVY() {
        return ((Float)this.m_20088_().m_135370_(ANIM_V_Y)).floatValue();
    }

    private void setAnimVY(float vy) {
        this.m_20088_().m_135381_(ANIM_V_Y, (Object)Float.valueOf(vy));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    public int getPushTick() {
        return (Integer)this.m_20088_().m_135370_(PUSH_TICK);
    }

    public void setPushTick(int pushTick) {
        this.m_20088_().m_135381_(PUSH_TICK, (Object)pushTick);
    }

    public static enum FallingMoveType {
        RENDER_MOVE,
        OVERALL_MOVE;

    }
}

