/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public class MerorTrapEntity
extends Entity
implements TraceableEntity,
OwnableEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 30;
    private boolean clientSideAttackStarted;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    public MerorTrapEntity(EntityType<? extends MerorTrapEntity> entityType, Level level) {
        super(entityType, level);
    }

    public MerorTrapEntity(Level level, double d, double d2, double d3, float f, int n, LivingEntity livingEntity) {
        this((EntityType<? extends MerorTrapEntity>)((EntityType)JerotesVillageEntityType.MEROR_TRAP.get()), level);
        this.warmupDelayTicks = n;
        this.setOwner(livingEntity);
        this.m_146922_(f * 57.295776f);
        this.m_6034_(d, d2, d3);
    }

    protected void m_8097_() {
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    @Nullable
    public LivingEntity m_269323_() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.warmupDelayTicks = compoundTag.m_128451_("Warmup");
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 18) {
                    for (int i = 0; i < 12; ++i) {
                        double d = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d2 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d4 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.005;
                        double d5 = this.f_19796_.m_188500_() * 0.005;
                        double d6 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.005;
                        this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.MEROR.get(), d, d2 + 1.0, d3, d4, d5, d6);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
                for (LivingEntity livingEntity : list) {
                    this.dealDamageTo(livingEntity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    private void dealDamageTo(LivingEntity livingEntity) {
        LivingEntity livingEntity2 = this.m_269323_();
        if (!livingEntity.m_6084_() || livingEntity.m_20147_() || livingEntity == livingEntity2) {
            return;
        }
        if (livingEntity2 == null) {
            DamageSource damageSources = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
            livingEntity.m_6469_(damageSources, 14.0f);
        } else {
            if (AttackFind.FindCanNotAttack((LivingEntity)livingEntity2, (Entity)livingEntity)) {
                return;
            }
            AttackFind.attackBegin((LivingEntity)livingEntity2, (Entity)livingEntity);
            DamageSource damageSources = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this, (Entity)livingEntity2);
            AttackFind.attackAfterCustomDamage((LivingEntity)livingEntity2, (Entity)livingEntity, (DamageSource)damageSources, (float)0.0f, (float)0.0f, (boolean)true, (float)14.0f);
        }
    }

    public void m_7822_(byte by) {
        super.m_7822_(by);
        if (by == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_TOOL_USE, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float f) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int n = this.lifeTicks - 2;
        if (n <= 0) {
            return 1.0f;
        }
        return 1.0f - ((float)n - f) / 20.0f;
    }
}

