/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.entity.CanBeIllagerFactionEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class UncleanTentacleEntity
extends Mob
implements JerotesEntity,
TraceableEntity,
CanBeIllagerFactionEntity,
OwnableEntity {
    private static final EntityDataAccessor<Integer> START_TICK = SynchedEntityData.m_135353_(UncleanTentacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState startAnimationState = new AnimationState();
    public AnimationState stopAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(UncleanTentacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(UncleanTentacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(UncleanTentacleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    public int maxTick = 600;

    public UncleanTentacleEntity(EntityType<? extends UncleanTentacleEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_TENTACLE_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.NECROMANCY_WARLOCK_TENTACLE_HURT;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_20256_(Vec3 vec3) {
        super.m_20256_(new Vec3(0.0, vec3.f_82480_, 0.0));
    }

    public boolean isIllagerFaction() {
        return this.m_269323_() != null && EntityFactionFind.isRaider((LivingEntity)this.m_269323_());
    }

    public void setIllagerFaction(boolean b) {
    }

    public AABB getAttackBoundingBox() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.25, 1.25, 1.25);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.getAttackBoundingBox().m_82381_(livingEntity.m_20191_());
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    @Nullable
    public UUID m_21805_() {
        return this.ownerUUID;
    }

    @Nullable
    public LivingEntity m_269323_() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public boolean m_7307_(Entity entity) {
        if (this.m_269323_() != null) {
            LivingEntity livingEntity = this.m_269323_();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.m_7307_(entity);
            }
        }
        return super.m_7307_(entity);
    }

    public Team m_5647_() {
        LivingEntity livingEntity;
        if (this.m_269323_() != null && (livingEntity = this.m_269323_()) != null) {
            return livingEntity.m_5647_();
        }
        return super.m_5647_();
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "start")) {
            return 2;
        }
        if (Objects.equals(animation, "stop")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.startAnimationState);
        list.add(this.stopAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception || state == this.startAnimationState) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void setStartTick(int n) {
        this.m_20088_().m_135381_(START_TICK, (Object)n);
    }

    public int getStartTick() {
        return (Integer)this.m_20088_().m_135370_(START_TICK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("StartTick", this.getStartTick());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("MaxTick", this.maxTick);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStartTick(compoundTag.m_128451_("StartTick"));
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
        }
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.maxTick = compoundTag.m_128451_("MaxTick");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(START_TICK, (Object)0);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.startAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.startAnimationState);
                    break;
                }
                case 3: {
                    this.stopAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.stopAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6862_(false);
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        }
    }

    public void m_8107_() {
        Mob mob;
        LivingEntity livingEntity;
        Player player;
        LivingEntity livingEntity2;
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.setStartTick(this.getStartTick() + 1);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity2 = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity2).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.getStartTick() == 10) {
            this.startAnimationState.m_216973_();
        }
        int trueMaxTick = this.maxTick;
        if (this.maxTick == 0) {
            trueMaxTick = 600;
        }
        if (this.getStartTick() >= trueMaxTick) {
            this.m_6469_(this.m_269291_().m_287172_(), 20.0f);
        }
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 5; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.UNCLEAN_BLOOD_RAIN.get(), this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if ((livingEntity = this.owner) instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null) {
            this.m_21563_().m_24960_((Entity)mob.m_5448_(), 30.0f, 30.0f);
            this.m_21391_((Entity)mob.m_5448_(), 30.0f, 30.0f);
        }
        if (this.getAttackTick() <= -20 && this.m_5448_() != null && this.m_217066_(this.m_5448_()) && this.m_21574_().m_148306_((Entity)this.m_5448_()) && this.getAttackBoundingBox().m_82381_(this.m_5448_().m_20191_()) && this.m_21574_().m_148306_((Entity)this.m_5448_()) && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)this.m_5448_())) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_7327_((Entity)this.m_5448_());
        } else if (this.getAttackTick() <= -20 && (livingEntity = this.owner) instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null && this.m_217066_(mob.m_5448_()) && this.m_217066_(mob.m_5448_()) && this.m_21574_().m_148306_((Entity)mob.m_5448_()) && this.getAttackBoundingBox().m_82381_(mob.m_5448_().m_20191_()) && this.m_21574_().m_148306_((Entity)mob.m_5448_()) && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)mob.m_5448_())) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_21563_().m_24960_((Entity)mob.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)mob.m_5448_(), 360.0f, 360.0f);
            this.m_7327_((Entity)mob.m_5448_());
        } else if (this.getAttackTick() <= -20 && this.owner != null && this.owner.m_21214_() != null && this.m_217066_(this.owner.m_21214_()) && this.m_217066_(this.owner.m_21214_()) && this.m_21574_().m_148306_((Entity)this.owner.m_21214_()) && this.getAttackBoundingBox().m_82381_(this.owner.m_21214_().m_20191_()) && this.m_21574_().m_148306_((Entity)this.owner.m_21214_()) && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)this.owner.m_21214_())) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_21563_().m_24960_((Entity)this.owner.m_21214_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.owner.m_21214_(), 360.0f, 360.0f);
            this.m_7327_((Entity)this.owner.m_21214_());
        } else if (this.getAttackTick() <= -20 && this.owner != null && this.owner.m_21188_() != null && this.m_217066_(this.owner.m_21188_()) && this.m_217066_(this.owner.m_21188_()) && this.m_21574_().m_148306_((Entity)this.owner.m_21188_()) && this.getAttackBoundingBox().m_82381_(this.owner.m_21188_().m_20191_()) && this.m_21574_().m_148306_((Entity)this.owner.m_21188_()) && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)this.owner.m_21188_())) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_21563_().m_24960_((Entity)this.owner.m_21188_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.owner.m_21188_(), 360.0f, 360.0f);
            this.m_7327_((Entity)this.owner.m_21188_());
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-20, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() == 6 && this.f_20919_ == 0) {
            this.trueHurt();
        }
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.NECROMANCY_WARLOCK_TENTACLE_ATTACK, 1.0f, 1.0f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.getAttackBoundingBox().m_82400_(0.75));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this);
            if (this.m_269323_() != null) {
                damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this, (Entity)this.m_269323_());
                if (this.m_269323_() instanceof Player) {
                    damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_), (Entity)this, (Entity)this.m_269323_());
                }
            }
            AttackFind.attackAfterCustomDamageNoEnchantAbout((LivingEntity)this, (Entity)hurt, (DamageSource)damageSource, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        return true;
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > -20) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            this.setAnimTick(20);
            this.setAnimationState("attack");
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268613_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.UNCLEAN_BODY.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("start");
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0) {
            this.setAnimTick(20);
            this.setAnimationState("stop");
        }
        ++this.f_20919_;
        this.idleAnimationState.m_216973_();
        this.attackAnimationState.m_216973_();
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

