/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Other;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotesvillage.entity.in.SkinEntity;
import com.jerotes.jerotesvillage.goal.ViewerLookGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.PlayerName;
import com.jerotes.jerotesvillage.util.PlayerSkin;
import com.jerotes.jerotesvillage.util.ViewerNameManager;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class ViewerEntity
extends PathfinderMob
implements JerotesEntity,
SkinEntity {
    public AnimationState armWideScaleAnimationState = new AnimationState();
    public AnimationState armSlimScaleAnimationState = new AnimationState();
    public AnimationState clap1AnimationState = new AnimationState();
    public AnimationState clap2AnimationState = new AnimationState();
    private static final EntityDataAccessor<String> SKIN_NAME = SynchedEntityData.m_135353_(ViewerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ViewerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(ViewerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private GameProfile profile;
    @Nullable
    private ResourceLocation skin;
    @Nullable
    private ResourceLocation cape;
    @Nullable
    private ResourceLocation elytra;
    private boolean skinAvailable;
    private boolean capeAvailable;
    private boolean elytraAvailable;

    public ViewerEntity(EntityType<? extends ViewerEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ViewerLookGoal((Mob)this, Player.class, 256.0f, 10.0f, false));
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.VIEWER_DEATH;
    }

    protected float m_6121_() {
        return 40.0f;
    }

    protected Vector3f getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vector3f(0.0f, entityDimensions.f_20378_ + 0.0625f * f, 0.0f);
    }

    protected float ridingOffset(Entity entity) {
        return -0.7f;
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public int m_8085_() {
        return 360;
    }

    public int m_8132_() {
        return 360;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        return builder;
    }

    public void m_8119_() {
        boolean slim;
        super.m_8119_();
        boolean bl = slim = PlayerSkin.getPlayerSkinType(this.getProfile()) == PlayerSkin.SkinType.SLIM;
        if (!slim) {
            this.armSlimScaleAnimationState.m_216973_();
            this.armWideScaleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.armWideScaleAnimationState.m_216973_();
            this.armSlimScaleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
    }

    public void setSkinName(String string) {
        this.m_20088_().m_135381_(SKIN_NAME, (Object)string);
    }

    public String getSkinName() {
        return (String)this.m_20088_().m_135370_(SKIN_NAME);
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        if (!this.m_9236_().m_5776_() && component != null) {
            this.setSkinName(this.m_5446_().getString());
        }
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "clap1")) {
            return 1;
        }
        if (Objects.equals(animation, "clap2")) {
            return 2;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.clap1AnimationState);
        list.add(this.clap2AnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128359_("SkinName", this.getSkinName());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setSkinName(compoundTag.m_128461_("SkinName"));
        String skinName = compoundTag.m_128461_("SkinName");
        if (!StringUtil.m_14408_((String)skinName)) {
            this.setUsername(skinName);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SKIN_NAME, (Object)"Jerotes_");
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.clap1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.clap1AnimationState);
                    break;
                }
                case 2: {
                    this.clap2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.clap2AnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @OnlyIn(value=Dist.CLIENT)
    public SkinManager.SkinTextureCallback getSkinCallback() {
        return (type, location, profileTexture) -> {
            switch (type) {
                case SKIN: {
                    this.skin = location;
                    this.skinAvailable = true;
                    break;
                }
                case CAPE: {
                    this.cape = location;
                    this.capeAvailable = true;
                    break;
                }
                case ELYTRA: {
                    this.elytra = location;
                    this.elytraAvailable = true;
                }
            }
        };
    }

    @Nullable
    public GameProfile getProfile() {
        if (this.profile == null && this.hasUsername()) {
            this.profile = new GameProfile(null, this.getUsername().getSkinName());
            ProfileUpdater.updateProfile(this);
        }
        return this.profile;
    }

    public void setProfile(@Nullable GameProfile profile) {
        this.profile = profile;
    }

    public boolean hasUsername() {
        return !StringUtil.m_14408_((String)((String)this.m_20088_().m_135370_(SKIN_NAME)));
    }

    public PlayerName getUsername() {
        return new PlayerName((String)this.m_20088_().m_135370_(SKIN_NAME));
    }

    public void setUsername(String username) {
        PlayerName playerName = new PlayerName(username);
        this.setUsername(playerName);
    }

    public void setUsername(PlayerName name) {
        PlayerName oldName = this.hasUsername() ? this.getUsername() : null;
        this.m_20088_().m_135381_(SKIN_NAME, (Object)name.getCombinedNames());
        if (!Objects.equals(oldName, name)) {
            this.setProfile(null);
            this.getProfile();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTextureAvailable(MinecraftProfileTexture.Type type) {
        return this.skinAvailable;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(MinecraftProfileTexture.Type type) {
        if (type == MinecraftProfileTexture.Type.SKIN) {
            return this.skin;
        }
        if (type == MinecraftProfileTexture.Type.ELYTRA) {
            return this.elytra;
        }
        return this.cape;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        String randomName = ViewerNameManager.getInstance().getRandomName();
        this.setUsername(randomName);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public class ProfileUpdater {
        private static final Queue<ViewerEntity> entities = new ArrayDeque<ViewerEntity>();
        @Nullable
        private static Thread thread;

        public static void updateProfile(ViewerEntity entity) {
            entities.add(entity);
            if (thread == null || thread.getState() == Thread.State.TERMINATED) {
                thread = new Thread(() -> {
                    while (!entities.isEmpty()) {
                        ViewerEntity mob = entities.remove();
                        if (mob == null) continue;
                        SkullBlockEntity.m_155738_((GameProfile)mob.getProfile(), mob::setProfile);
                    }
                });
                thread.start();
            }
        }
    }
}

