/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.event;

import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.SpellList;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.item.BaseHagEye;
import com.tacz.guns.entity.EntityKineticBullet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ArmorEvent {
    @SubscribeEvent
    public static void BigWitchsHat(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            if (!livingEntity.m_9236_().m_5776_() && damagesource.m_269533_(DamageTypeTags.f_268731_) && livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.BIG_WITCHS_HAT.get()) {
                SpellList.MagicAbsorption((int)3, (LivingEntity)livingEntity, (Entity)livingEntity).spellUse();
                float newAmount = event.getAmount() - event.getAmount() * 0.3f;
                if (Float.isNaN(newAmount) || Float.isInfinite(newAmount)) {
                    newAmount = 0.0f;
                }
                event.setAmount(newAmount);
            }
        }
    }

    @SubscribeEvent
    public static void HagEye(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof BaseHagEye && !livingEntity.m_9236_().m_5776_()) {
            livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19611_, 5, 0, false, false), (Entity)livingEntity);
        }
    }

    @SubscribeEvent
    public static void MagickaScaleTick(LivingEvent.LivingTickEvent event) {
        boolean boots;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_HELMET.get();
        boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_CHESTPLATE.get();
        boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_LEGGINGS.get();
        boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_BOOTS.get();
        if (!livingEntity.m_9236_().m_5776_() && helmet && chestplate && leggings && boots && livingEntity.m_21223_() <= livingEntity.m_21233_() / 2.0f) {
            livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 25, 1, false, false), (Entity)livingEntity);
        }
    }

    @SubscribeEvent
    public static void MagickaScaleAttack(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_() && (damagesource.m_276093_(DamageTypes.f_268613_) || damagesource.m_276093_(DamageTypes.f_268612_) || damagesource.m_276093_(DamageTypes.f_268440_)) && helmet && chestplate && leggings && boots) {
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void MagickaScaleHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MAGICKA_SCALE_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_()) {
                if (damagesource.m_269533_(DamageTypeTags.f_268745_) || damagesource.m_269533_(DamageTypeTags.f_268725_) || damagesource.m_269533_(DamageTypeTags.f_268419_) || damagesource.m_269533_(DamageTypeTags.f_268581_)) {
                    float damages = 1.0f;
                    if (helmet) {
                        damages -= 0.23f;
                    }
                    if (chestplate) {
                        damages -= 0.23f;
                    }
                    if (leggings) {
                        damages -= 0.23f;
                    }
                    if (boots) {
                        damages -= 0.23f;
                    }
                    event.setAmount(event.getAmount() * damages);
                }
                if (EntityAndItemFind.MagicResistance((DamageSource)damagesource) && helmet && chestplate && leggings && boots) {
                    float newAmount = event.getAmount() - event.getAmount() * (0.25f + livingEntity.m_21223_() <= livingEntity.m_21233_() / 2.0f ? 0.15f : 0.0f);
                    if (Float.isNaN(newAmount) || Float.isInfinite(newAmount)) {
                        newAmount = 0.0f;
                    }
                    event.setAmount(newAmount);
                }
            }
        }
    }

    @SubscribeEvent
    public static void ElementHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            if (!livingEntity.m_9236_().m_5776_()) {
                Optional boots;
                Optional leggings;
                Optional chestplate;
                float damages = 1.0f;
                Optional head = ArmorTrim.m_266285_((RegistryAccess)livingEntity.m_9236_().m_9598_(), (ItemStack)livingEntity.m_6844_(EquipmentSlot.HEAD));
                if (head.isPresent()) {
                    ArmorTrim armorTrim = (ArmorTrim)head.get();
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "fire_secretor_adhesive"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "frost_yeti_hair"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268419_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "lightning_worm_chitin"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268725_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "malignasaur_teeth"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268581_)) {
                        damages -= 0.08f;
                    }
                }
                if ((chestplate = ArmorTrim.m_266285_((RegistryAccess)livingEntity.m_9236_().m_9598_(), (ItemStack)livingEntity.m_6844_(EquipmentSlot.CHEST))).isPresent()) {
                    ArmorTrim armorTrim = (ArmorTrim)chestplate.get();
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "fire_secretor_adhesive"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "frost_yeti_hair"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268419_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "lightning_worm_chitin"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268725_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "malignasaur_teeth"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268581_)) {
                        damages -= 0.08f;
                    }
                }
                if ((leggings = ArmorTrim.m_266285_((RegistryAccess)livingEntity.m_9236_().m_9598_(), (ItemStack)livingEntity.m_6844_(EquipmentSlot.LEGS))).isPresent()) {
                    ArmorTrim armorTrim = (ArmorTrim)leggings.get();
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "fire_secretor_adhesive"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "frost_yeti_hair"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268419_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "lightning_worm_chitin"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268725_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "malignasaur_teeth"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268581_)) {
                        damages -= 0.08f;
                    }
                }
                if ((boots = ArmorTrim.m_266285_((RegistryAccess)livingEntity.m_9236_().m_9598_(), (ItemStack)livingEntity.m_6844_(EquipmentSlot.FEET))).isPresent()) {
                    ArmorTrim armorTrim = (ArmorTrim)boots.get();
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "fire_secretor_adhesive"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "frost_yeti_hair"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268419_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "lightning_worm_chitin"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268725_)) {
                        damages -= 0.08f;
                    }
                    if (armorTrim.m_266210_().m_203565_(((Holder.Reference)livingEntity.m_9236_().m_9598_().m_175515_(Registries.f_266076_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation("jerotesvillage", "malignasaur_teeth"))).get()).m_205785_()) && damagesource.m_269533_(DamageTypeTags.f_268581_)) {
                        damages -= 0.08f;
                    }
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void SerponWizardHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.SERPON_WIZARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.SERPON_WIZARD_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.SERPON_WIZARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.SERPON_WIZARD_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_() && EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
                float damages = 1.0f;
                if (helmet) {
                    damages -= 0.15f;
                }
                if (chestplate) {
                    damages -= 0.15f;
                }
                if (leggings) {
                    damages -= 0.15f;
                }
                if (boots) {
                    damages -= 0.15f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void SerponWizardAttack(LivingHurtEvent event) {
        block8: {
            boolean boots;
            LivingEntity living;
            DamageSource damagesource;
            block10: {
                block9: {
                    if (event == null || event.getEntity() == null) break block8;
                    LivingEntity livingEntity = event.getEntity();
                    damagesource = event.getSource();
                    Entity entity = damagesource.m_7639_();
                    if (!(entity instanceof LivingEntity)) break block9;
                    living = (LivingEntity)entity;
                    if (livingEntity != null) break block10;
                }
                return;
            }
            boolean helmet = living.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.SERPON_WIZARD_HELMET.get();
            boolean chestplate = living.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.SERPON_WIZARD_CHESTPLATE.get();
            boolean leggings = living.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.SERPON_WIZARD_LEGGINGS.get();
            boolean bl = boots = living.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.SERPON_WIZARD_BOOTS.get();
            if (!living.m_9236_().m_5776_() && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                float damages = 1.0f;
                if (helmet) {
                    damages += 0.25f;
                }
                if (chestplate) {
                    damages += 0.25f;
                }
                if (leggings) {
                    damages += 0.25f;
                }
                if (boots) {
                    damages += 0.25f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void FireApostleHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_() && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                float damages = 1.0f;
                if (helmet) {
                    damages -= 0.2f;
                }
                if (chestplate) {
                    damages -= 0.2f;
                }
                if (leggings) {
                    damages -= 0.2f;
                }
                if (boots) {
                    damages -= 0.2f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void FireApostleAttack(LivingHurtEvent event) {
        block8: {
            boolean boots;
            LivingEntity living;
            DamageSource damagesource;
            block10: {
                block9: {
                    if (event == null || event.getEntity() == null) break block8;
                    LivingEntity livingEntity = event.getEntity();
                    damagesource = event.getSource();
                    Entity entity = damagesource.m_7639_();
                    if (!(entity instanceof LivingEntity)) break block9;
                    living = (LivingEntity)entity;
                    if (livingEntity != null) break block10;
                }
                return;
            }
            boolean helmet = living.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_HELMET.get();
            boolean chestplate = living.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_CHESTPLATE.get();
            boolean leggings = living.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_LEGGINGS.get();
            boolean bl = boots = living.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.FIRE_APOSTLE_BOOTS.get();
            if (!living.m_9236_().m_5776_() && damagesource.m_269533_(DamageTypeTags.f_268745_)) {
                float damages = 1.0f;
                if (helmet) {
                    damages += 0.3f;
                }
                if (chestplate) {
                    damages += 0.3f;
                }
                if (leggings) {
                    damages += 0.3f;
                }
                if (boots) {
                    damages += 0.3f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void MerorMetalHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_METAL_HELMET.get() || livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_METAL_CHESTPLATE.get() || livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
            boolean warBeast = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_METAL_WAR_BEAST_ARMOR.get();
            boolean giantBeast = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_METAL_GIANT_BEAST_ARMOR.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_METAL_LEGGINGS.get() || livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_METAL_BOOTS.get() || livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_() && !EntityAndItemFind.isMerorAttack((DamageSource)damagesource)) {
                float damages = 1.0f;
                if (helmet) {
                    damages -= 0.12f;
                }
                if (chestplate) {
                    damages -= 0.12f;
                }
                if (warBeast) {
                    damages -= 0.36f;
                }
                if (giantBeast) {
                    damages -= 0.36f;
                }
                if (leggings) {
                    damages -= 0.12f;
                }
                if (boots) {
                    damages -= 0.12f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void GiantMonsterHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.GIANT_MONSTER_HELMET.get() || livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.GIANT_MONSTER_HORNED_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.GIANT_MONSTER_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.GIANT_MONSTER_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.GIANT_MONSTER_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_() && damagesource.m_269533_(DamageTypeTags.f_268419_)) {
                float damages = 1.0f;
                if (helmet) {
                    damages -= 0.16f;
                }
                if (chestplate) {
                    damages -= 0.16f;
                }
                if (leggings) {
                    damages -= 0.16f;
                }
                if (boots) {
                    damages -= 0.16f;
                }
                event.setAmount(event.getAmount() * damages);
            }
        }
    }

    @SubscribeEvent
    public static void BlamerRobeTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.BLAMER_ROBE.get()) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.CLOAKING.get(), 25, 0, false, false), (Entity)livingEntity);
            }
            if (livingEntity.getPersistentData().m_128423_("jerotes_cloaking_shift_key_down") != null && !livingEntity.getPersistentData().m_128471_("jerotes_cloaking_shift_key_down") && livingEntity.m_6144_()) {
                for (int i = 0; i < 7; ++i) {
                    double d = livingEntity.m_217043_().m_188583_() * 0.02;
                    double d2 = livingEntity.m_217043_().m_188583_() * 0.02;
                    double d3 = livingEntity.m_217043_().m_188583_() * 0.02;
                    livingEntity.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.BLAMER_SOUL.get(), livingEntity.m_20208_(1.0), livingEntity.m_20187_() + 0.5, livingEntity.m_20262_(1.0), d, d2, d3);
                }
            }
        }
    }

    @SubscribeEvent
    public static void MerorBountyHunterTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_BOUNTY_HUNTER_HELMET.get() && !livingEntity.m_9236_().m_5776_()) {
            livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19611_, 245, 0, false, false), (Entity)livingEntity);
            livingEntity.m_21195_(MobEffects.f_19614_);
            livingEntity.m_21195_((MobEffect)JerotesMobEffects.DEADLY_POISON.get());
            livingEntity.m_21195_((MobEffect)JerotesVillageMobEffects.WILDERNESS_GIANT_POISON.get());
        }
    }

    @SubscribeEvent
    public static void MerorBountyHunterAddEffect(MobEffectEvent event) {
        LivingEntity livingEntity = event.getEntity();
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        if (livingEntity == null) {
            return;
        }
        if (mobEffectInstance == null) {
            return;
        }
        if (livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_BOUNTY_HUNTER_HELMET.get()) {
            if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
                event.setResult(Event.Result.DENY);
            }
            if (mobEffectInstance.m_19544_() == JerotesMobEffects.DEADLY_POISON.get()) {
                event.setResult(Event.Result.DENY);
            }
            if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.WILDERNESS_GIANT_POISON.get()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void MerorStandardTick(LivingEvent.LivingTickEvent event) {
        boolean boots;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
        boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
        boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
        boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
        if (!livingEntity.m_9236_().m_5776_()) {
            if (helmet) {
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19611_, 245, 0, false, false), (Entity)livingEntity);
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.TRUESIGHT.get(), 245, 0, false, false), (Entity)livingEntity);
                if (livingEntity.m_20069_()) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19608_, 245, 0, false, false), (Entity)livingEntity);
                }
            }
            if (chestplate) {
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19600_, 65, 0, false, false), (Entity)livingEntity);
            }
            if (leggings) {
                if (livingEntity.m_6144_()) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19609_, 65, 0, false, false), (Entity)livingEntity);
                }
                if (livingEntity.m_20142_()) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19596_, 25, 1, false, false), (Entity)livingEntity);
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19603_, 25, 1, false, false), (Entity)livingEntity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void MerorStandardHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            DamageSource damagesource = event.getSource();
            LivingEntity livingEntity = event.getEntity();
            Entity attackBy = event.getSource().m_7639_();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_()) {
                float amout = event.getAmount();
                if (helmet && damagesource.m_276093_(DamageTypes.f_268612_)) {
                    amout -= 8.0f;
                }
                if (chestplate) {
                    if (!damagesource.m_269533_(DamageTypeTags.f_268738_)) {
                        amout -= 4.0f;
                    }
                    if (EntityAndItemFind.MagicResistance((DamageSource)damagesource) && attackBy instanceof LivingEntity) {
                        LivingEntity livingAttackBy = (LivingEntity)attackBy;
                        livingAttackBy.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 240, 1, false, false), (Entity)livingEntity);
                    }
                }
                if (boots && damagesource.m_269533_(DamageTypeTags.f_268549_)) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
                if (helmet && chestplate && leggings && boots) {
                    amout -= event.getAmount() * 0.3f;
                }
                if (amout < 0.0f && event.getAmount() >= 0.0f) {
                    amout = 0.0f;
                }
                event.setAmount(amout);
            }
        }
    }

    @SubscribeEvent
    public static void MerorStandardTaczHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity entity;
            boolean boots;
            DamageSource damagesource = event.getSource();
            LivingEntity livingEntity = event.getEntity();
            Entity attackBy = event.getSource().m_7639_();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
            if (ModList.get().isLoaded("tacz") && (entity = damagesource.m_7640_()) instanceof EntityKineticBullet) {
                EntityKineticBullet entityKineticBullet = (EntityKineticBullet)entity;
                float amout = event.getAmount();
                float damages = 1.0f;
                if (helmet) {
                    amout -= 1.0f;
                    damages -= 0.2f;
                }
                if (chestplate) {
                    amout -= 1.0f;
                    damages -= 0.2f;
                }
                if (leggings) {
                    amout -= 1.0f;
                    damages -= 0.2f;
                }
                if (boots) {
                    amout -= 1.0f;
                    damages -= 0.2f;
                }
                if (amout < 0.0f && event.getAmount() >= 0.0f) {
                    amout = 0.0f;
                }
                event.setAmount(amout * damages);
            }
        }
    }

    @SubscribeEvent
    public static void MerorStandardTaczAttack(LivingAttackEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity entity;
            boolean boots;
            DamageSource damagesource = event.getSource();
            LivingEntity livingEntity = event.getEntity();
            Entity attackBy = event.getSource().m_7639_();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
            if (ModList.get().isLoaded("tacz") && (entity = damagesource.m_7640_()) instanceof EntityKineticBullet) {
                EntityKineticBullet entityKineticBullet = (EntityKineticBullet)entity;
                float amout = event.getAmount();
                if (helmet) {
                    amout -= 1.0f;
                }
                if (chestplate) {
                    amout -= 1.0f;
                }
                if (leggings) {
                    amout -= 1.0f;
                }
                if (boots) {
                    amout -= 1.0f;
                }
                if (amout <= 0.0f) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void MerorStandardAttack(LivingAttackEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean boots;
            DamageSource damagesource = event.getSource();
            LivingEntity livingEntity = event.getEntity();
            Entity attackBy = event.getSource().m_7639_();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            boolean helmet = livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MEROR_STANDARD_HELMET.get();
            boolean chestplate = livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MEROR_STANDARD_CHESTPLATE.get();
            boolean leggings = livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MEROR_STANDARD_LEGGINGS.get();
            boolean bl = boots = livingEntity.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MEROR_STANDARD_BOOTS.get();
            if (!livingEntity.m_9236_().m_5776_()) {
                float amout = event.getAmount();
                if (helmet && damagesource.m_276093_(DamageTypes.f_268612_) && (amout <= 8.0f || chestplate && amout <= 12.0f)) {
                    event.setCanceled(true);
                }
                if (chestplate && !damagesource.m_269533_(DamageTypeTags.f_268738_) && amout <= 4.0f) {
                    event.setCanceled(true);
                }
                if (boots && damagesource.m_269533_(DamageTypeTags.f_268549_)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void MountainRealmTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingTarget;
        Entity entity;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity == null) {
            return;
        }
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_HELMET.get() && Main.getTargetedEntity((Player)player, (double)32.0) != null && (entity = Main.getTargetedEntity((Player)player, (double)32.0)) instanceof LivingEntity && !AttackFind.FindCanNotAttack((LivingEntity)player, (Entity)(livingTarget = (LivingEntity)entity)) && !livingEntity.m_9236_().m_5776_()) {
            livingTarget.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.ABACK.get(), 5, 0), (Entity)player);
        }
        if (livingEntity.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_LEGGINGS.get() && livingEntity.m_20142_() && livingEntity.f_19797_ % 5 == 0) {
            List list = livingEntity.m_9236_().m_45976_(LivingEntity.class, livingEntity.m_20191_().m_82377_(6.0, 6.0, 6.0));
            double d = Double.MAX_VALUE;
            for (LivingEntity livingEntityControl : list) {
                if (livingEntityControl == null || livingEntityControl == livingEntity || AttackFind.FindCanNotAttack((LivingEntity)livingEntity, (Entity)livingEntityControl) || livingEntity.m_20280_((Entity)livingEntityControl) > d || livingEntityControl.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_LEGGINGS.get() || livingEntityControl.m_9236_().m_5776_()) continue;
                livingEntityControl.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 60, 1), (Entity)livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void MountainRealmAttackTo(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            boolean chestplate;
            DamageSource damagesource = event.getSource();
            LivingEntity livingEntity = event.getEntity();
            Entity attackBy = event.getSource().m_7639_();
            if (damagesource == null || livingEntity == null || !(attackBy instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)attackBy;
            boolean bl = chestplate = attacker.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_CHESTPLATE.get();
            if (chestplate && EntityAndItemFind.isMeleeDamage((DamageSource)damagesource)) {
                double d = livingEntity.m_21051_(Attributes.f_22278_) != null ? livingEntity.m_21133_(Attributes.f_22278_) : 0.0;
                double d2 = Math.max(0.0, 1.0 - d) + (double)0.3f;
                if (!EntityAndItemFind.isNoSpecialKnockback((EntityType)livingEntity.m_6095_()) && (Main.mobSizeSmall((Entity)livingEntity) || Main.mobSizeMedium((Entity)livingEntity) || Main.mobSizeLarge((Entity)livingEntity))) {
                    livingEntity.m_6853_(false);
                    livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(-((attacker.m_20185_() - livingEntity.m_20185_()) * d2 / 3.0) * 0.8666666716337204, -(attacker.m_20186_() - livingEntity.m_20186_()) * 1.5 * d2 * 0.8666666716337204, -((attacker.m_20189_() - livingEntity.m_20189_()) * d2 / 3.0) * 0.8666666716337204));
                }
            }
        }
    }
}

