/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.event;

import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.RustleFoxEntity;
import com.jerotes.jerotesvillage.entity.Monster.BitterColdWindEntity;
import com.jerotes.jerotesvillage.event.AdvancementEvent;
import com.jerotes.jerotesvillage.event.WorldEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import com.jerotes.jerotesvillage.init.JerotesVillageDimensions;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.network.JerotesVillageLevelData;
import com.jerotes.jerotesvillage.util.OtherEntityAndItemFind;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.village.VillageSiegeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WeatherEvent {
    @SubscribeEvent
    public static void SecondRoundVillageSiege(VillageSiegeEvent event) {
        Level level = event.getLevel();
        if (level.m_46472_() == JerotesVillageDimensions.SECOND_ROUND_WORLD) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void SecondRound(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (entity.m_9236_().m_46472_() == JerotesVillageDimensions.SECOND_ROUND_WORLD && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_()) && entity.m_217043_().m_216339_(1, 900) == 1) {
            entity.m_5634_(1.0f);
        }
    }

    @SubscribeEvent
    public static void BitterCold(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (entity.m_9236_().m_204166_(BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_())).m_203565_(JerotesVillageBiomes.BITTER_COLD) && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_())) {
            boolean knock;
            boolean type = entity.m_6095_().m_204039_(EntityTypeTags.f_144294_);
            boolean armor = entity.m_6844_(EquipmentSlot.HEAD).m_204117_(ItemTags.f_144320_) || entity.m_6844_(EquipmentSlot.CHEST).m_204117_(ItemTags.f_144320_) || entity.m_6844_(EquipmentSlot.LEGS).m_204117_(ItemTags.f_144320_) || entity.m_6844_(EquipmentSlot.FEET).m_204117_(ItemTags.f_144320_);
            boolean bl = knock = entity.m_21133_(Attributes.f_22278_) >= 0.4;
            if (type || armor) {
                return;
            }
            if (entity.m_142079_() && (entity.m_9236_().m_46471_() || entity.m_9236_().m_46470_())) {
                entity.m_146924_(true);
            }
            if (knock) {
                return;
            }
            if (event.getEntity().m_9236_().m_46468_() % 10L == 1L && !entity.m_9236_().m_5776_()) {
                entity.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.BITTER_COLD.get(), 25, 0, false, false));
            }
        }
    }

    @SubscribeEvent
    public static void BitterCold(LivingDeathEvent event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Mob) && !(entity instanceof Player)) {
            return;
        }
        if (entity.m_21023_((MobEffect)JerotesVillageMobEffects.BITTER_COLD.get()) && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_()) && !(entity instanceof BitterColdWindEntity) && (level = entity.m_9236_()) instanceof ServerLevel) {
            BitterColdWindEntity bitterColdWind;
            ServerLevel _level = (ServerLevel)level;
            if (!entity.m_9236_().m_5776_() && entity.m_217043_().m_216339_(1, 100) == 1 && (bitterColdWind = (BitterColdWindEntity)((EntityType)JerotesVillageEntityType.BITTER_COLD_WIND.get()).m_262496_(_level, BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), MobSpawnType.MOB_SUMMONED)) != null) {
                entity.m_9236_().m_220407_(GameEvent.f_157810_, new BlockPos((int)bitterColdWind.m_20185_(), (int)bitterColdWind.m_20186_(), (int)bitterColdWind.m_20189_()), GameEvent.Context.m_223717_((Entity)bitterColdWind));
            }
        }
    }

    @SubscribeEvent
    public static void PurpleDesert(TickEvent.PlayerTickEvent event) {
        Level level;
        Player player = event.player;
        if (player == null) {
            return;
        }
        if (player.m_9236_().m_204166_(BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20186_(), (double)player.m_20189_())).m_203565_(JerotesVillageBiomes.PURPLE_DESERT) && !WorldEvent.ZsieinModerateInfectedAbove(player.m_9236_()) && (level = player.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.player.m_9236_().m_46468_() % 10L == 1L) {
                boolean feet;
                boolean helmet = player.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.SPIRVE_HELMET.get() || player.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.SPIRVE_HEAD.get();
                boolean chestplate = player.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.SPIRVE_CHESTPLATE.get();
                boolean legs = player.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.SPIRVE_LEGGINGS.get();
                boolean bl = feet = player.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.SPIRVE_BOOTS.get();
                if (!(!((double)player.m_217043_().m_188501_() < OtherMainConfig.PurpleSandWeatherLightningChance / 2.0) || helmet || chestplate || legs || feet)) {
                    LightningBolt lightningBolt;
                    BlockPos summonPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)player, (int)16);
                    for (int find = 0; find < 12; ++find) {
                        if (serverLevel.m_45527_(summonPos)) continue;
                        summonPos = Main.findSpawnPositionNearFillOnBlock((LivingEntity)player, (int)16);
                    }
                    if (serverLevel.m_45527_(summonPos) && !serverLevel.m_46859_(summonPos.m_7495_()) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_262496_(serverLevel, BlockPos.m_274561_((double)summonPos.m_123341_(), (double)summonPos.m_123342_(), (double)summonPos.m_123343_()), MobSpawnType.NATURAL)) != null) {
                        lightningBolt.m_20874_(true);
                        if (!(lightningBolt.m_9236_() instanceof ServerLevel)) {
                            lightningBolt.m_9236_().m_6580_(2);
                        } else {
                            List list1 = lightningBolt.m_9236_().m_6249_((Entity)lightningBolt, new AABB(lightningBolt.m_20185_() - 1.0, lightningBolt.m_20186_() - 1.0, lightningBolt.m_20189_() - 1.0, lightningBolt.m_20185_() + 1.0, lightningBolt.m_20186_() + 2.0 + 1.0, lightningBolt.m_20189_() + 1.0), Entity::m_6084_);
                            for (Entity entity : list1) {
                                if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)lightningBolt)) continue;
                                entity.m_8038_((ServerLevel)lightningBolt.m_9236_(), lightningBolt);
                                if (!(entity instanceof ServerPlayer)) continue;
                                ServerPlayer serverPlayer = (ServerPlayer)entity;
                                AdvancementEvent.AdvancementGive(serverPlayer, "jerotesvillage:a_bolt_from_the_purple");
                            }
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void HarmoniousWonderland(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity.m_9236_().m_204166_(BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_())).m_203565_(JerotesVillageBiomes.HARMONIOUS_WONDERLAND) && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_())) {
            OwnableEntity ownable;
            if (entity.m_217043_().m_188503_(100) == 1 && !(entity instanceof AbstractSchoolingFish) || entity.m_217043_().m_188503_(16000) == 1) {
                entity.m_5634_(1.0f);
                Level level = entity.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)level;
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_276452_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 6, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (event.getEntity().m_9236_().m_46468_() % 10L == 1L && entity instanceof Enemy && (!(entity instanceof OwnableEntity) || (ownable = (OwnableEntity)entity).m_269323_() instanceof Enemy) && !entity.m_9236_().m_5776_()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 25, 0, false, false));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 25, 0, false, false));
            }
        }
    }

    @SubscribeEvent
    public static void UnKnownDeep(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (event.getEntity().m_9236_().m_46468_() % 10L == 1L && entity.m_9236_().m_204166_(BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_())).m_203565_(JerotesVillageBiomes.UNKNOWN_DEEP) && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_())) {
            int n = 0;
            if (JerotesVillageLevelData.get((LevelAccessor)entity.m_9236_()) != null && JerotesVillageLevelData.get((LevelAccessor)entity.m_9236_()).WickedRidiculeNight) {
                n = 2;
            }
            if (!entity.m_9236_().m_5776_()) {
                entity.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.DEEP_BLESS.get(), 25, n, false, false));
            }
        }
    }

    @SubscribeEvent
    public static void VirtualCave(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (livingEntity == null || entity == null) {
            return;
        }
        if (!(livingEntity instanceof Enemy)) {
            return;
        }
        Enemy enemy = (Enemy)livingEntity;
        if (!(enemy instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)enemy;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (mob.m_5448_() != player) {
            return;
        }
        if (mob.m_9236_().m_204166_(BlockPos.m_274561_((double)mob.m_20185_(), (double)mob.m_20186_(), (double)mob.m_20189_())).m_203565_(JerotesVillageBiomes.VIRTUAL_CAVE) && !WorldEvent.ZsieinModerateInfectedAbove(entity.m_9236_())) {
            ItemEntity itemEntity;
            int reward = player.m_217043_().m_188503_(100);
            ItemStack itemStack2 = new ItemStack((ItemLike)Items.f_41852_, 1);
            if (reward <= 5) {
                itemStack2 = new ItemStack((ItemLike)JerotesVillageItems.VIRTUAL_CAVE_EVIL_CRYSTAL.get(), 1);
            } else if (reward <= 7) {
                itemStack2 = new ItemStack((ItemLike)JerotesVillageItems.VIRTUAL_CAVE_EVIL_CRYSTAL.get(), 2);
            }
            if (reward <= 7 && (itemEntity = mob.m_5552_(itemStack2, 1.0f)) != null) {
                itemEntity.m_6034_(mob.m_20185_(), mob.m_20188_(), mob.m_20189_());
            }
        }
    }

    @SubscribeEvent
    public static void PlagueZone(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        boolean zsiein = OtherEntityFactionFind.isZsiein(entity.m_6095_());
        boolean plagueZone = entity.m_9236_().m_204166_(BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_())).m_203565_(JerotesVillageBiomes.PLAGUE_ZONE);
        if ((!zsiein && plagueZone && WorldEvent.ZsieinMildInfectedAbove(entity.m_9236_()) || WorldEvent.ZsieinSevereInfectedAbove(entity.m_9236_())) && !entity.m_9236_().m_5776_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.ZSIEIN_FOG.get(), 25, 0, false, false));
        }
        if (WorldEvent.ZsieinMildInfectedAbove(entity.m_9236_()) && !zsiein && (Main.isInFluid((LivingEntity)entity) || entity.m_20072_() || entity.m_20070_()) && plagueZone && !OtherEntityAndItemFind.isZsieinAboutImmune((Entity)entity) && !entity.m_9236_().m_5776_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.CORROSIVE.get(), 25, 0, false, false));
        }
        if (WorldEvent.ZsieinSevereInfectedAbove(entity.m_9236_()) && !zsiein) {
            if (!entity.f_19794_ && entity.m_20184_().f_82480_ > -1.0 && !OtherEntityAndItemFind.isZsieinAboutImmune((Entity)entity)) {
                entity.m_20334_(entity.m_20184_().f_82479_, -0.5, entity.m_20184_().f_82481_);
            }
            if (!entity.m_9236_().m_5776_()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 25, 0, false, false));
            }
            if ((Main.isInFluid((LivingEntity)entity) || entity.m_20072_() || entity.m_20070_()) && !plagueZone && !OtherEntityAndItemFind.isZsieinAboutImmune((Entity)entity) && !entity.m_9236_().m_5776_()) {
                entity.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.CORROSIVE.get(), 25, 0, false, false));
            }
        }
        if (!(!WorldEvent.ZsieinExtremelyInfectedAbove(entity.m_9236_()) || zsiein || entity.m_6336_() != MobType.f_21641_ || EntityAndItemFind.isBoss((EntityType)entity.m_6095_()) || OtherEntityAndItemFind.isZsieinAboutImmune((Entity)entity) || entity.m_9236_().m_5776_())) {
            entity.m_7292_(new MobEffectInstance((MobEffect)JerotesMobEffects.HOLD_MOB.get(), 25, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void SomeDay(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (WeatherEvent.isAprilFoolsDay() && OtherMainConfig.SpecialDay && event.getLevel().m_46472_() == JerotesVillageDimensions.SECOND_ROUND_WORLD && entity instanceof Player) {
            ServerLevel serverLevel;
            List foxList;
            Player player = (Player)entity;
            Level level = event.getLevel();
            if (level instanceof ServerLevel && (foxList = (serverLevel = (ServerLevel)level).m_45976_(RustleFoxEntity.class, player.m_20191_().m_82377_(32.0, 32.0, 32.0))).isEmpty()) {
                RustleFoxEntity fox = new RustleFoxEntity((EntityType<? extends Fox>)((EntityType)JerotesVillageEntityType.RUSTLE_FOX.get()), (Level)serverLevel);
                fox.m_6027_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                fox.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(entity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                fox.m_6593_((Component)Component.m_237113_((String)"\u4f60\u7684\u4f19\u4f34"));
                fox.tame(player);
                serverLevel.m_7967_((Entity)fox);
            }
        }
    }

    public static boolean isAprilFoolsDay() {
        LocalDate localDate = LocalDate.now();
        int n = localDate.get(ChronoField.DAY_OF_MONTH);
        int n2 = localDate.get(ChronoField.MONTH_OF_YEAR);
        return n2 == 4 && n == 1;
    }
}

