/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Animal.GiantMonsterEntity;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class GiantMonsterWrestleAttackGoal
extends Goal {
    protected final GiantMonsterEntity mob;
    private final double speedModifier;
    private final boolean followingNotAttackTargetEvenIfNotSeen;
    private Path path;
    private double pathedNotAttackTargetX;
    private double pathedNotAttackTargetY;
    private double pathedNotAttackTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

    public GiantMonsterWrestleAttackGoal(GiantMonsterEntity pathfinderMob) {
        this.mob = pathfinderMob;
        this.speedModifier = 1.4;
        this.followingNotAttackTargetEvenIfNotSeen = true;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        LivingEntity livingEntity = this.mob.getNotAttackTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!(livingEntity instanceof GiantMonsterEntity)) {
            return false;
        }
        GiantMonsterEntity giantMonster = (GiantMonsterEntity)livingEntity;
        if (!this.mob.isHorn()) {
            return false;
        }
        if (!giantMonster.isHorn()) {
            return false;
        }
        if (this.mob.getWrestleCooldown() < 2000) {
            return false;
        }
        if (giantMonster.getWrestleCooldown() < 2000) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.mob.m_217066_(livingEntity);
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.getNotAttackTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!(livingEntity instanceof GiantMonsterEntity)) {
            return false;
        }
        GiantMonsterEntity giantMonster = (GiantMonsterEntity)livingEntity;
        if (!this.mob.isHorn()) {
            return false;
        }
        if (!giantMonster.isHorn()) {
            return false;
        }
        if (this.mob.getWrestleCooldown() < 2000) {
            return false;
        }
        if (giantMonster.getWrestleCooldown() < 2000) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (!this.followingNotAttackTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        return this.mob.m_21444_(livingEntity.m_20183_());
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.getNotAttackTarget();
        this.mob.setNotAttackTarget(null);
        if (livingEntity != null && livingEntity instanceof GiantMonsterEntity) {
            GiantMonsterEntity giantMonster = (GiantMonsterEntity)livingEntity;
            giantMonster.setNotAttackTarget(null);
        }
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.getNotAttackTarget();
        if (livingEntity == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingNotAttackTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedNotAttackTargetX == 0.0 && this.pathedNotAttackTargetY == 0.0 && this.pathedNotAttackTargetZ == 0.0 || livingEntity.m_20275_(this.pathedNotAttackTargetX, this.pathedNotAttackTargetY, this.pathedNotAttackTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.pathedNotAttackTargetX = livingEntity.m_20185_();
            this.pathedNotAttackTargetY = livingEntity.m_20186_();
            this.pathedNotAttackTargetZ = livingEntity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            double d = this.mob.m_20280_((Entity)livingEntity);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingEntity);
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity) {
        if (this.canPerformAttack(livingEntity)) {
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.wrestleTarget(livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity) {
        return this.isTimeToAttack() && this.mob.m_217066_(livingEntity) && this.mob.m_21574_().m_148306_((Entity)livingEntity);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }
}

