/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Animal.GiantMonsterEntity;
import com.jerotes.jerotesvillage.goal.GiantMonsterTargetGoal;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class GiantMonsterWrestleTargetGoal<T extends GiantMonsterEntity>
extends GiantMonsterTargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 180;
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected GiantMonsterEntity target;
    protected TargetingConditions targetConditions;

    public GiantMonsterWrestleTargetGoal(GiantMonsterEntity mob, Class<T> class_, boolean bl) {
        this(mob, class_, 360, bl, false, null);
    }

    public GiantMonsterWrestleTargetGoal(GiantMonsterEntity mob, Class<T> class_, boolean bl, Predicate<LivingEntity> predicate) {
        this(mob, class_, 360, bl, false, predicate);
    }

    public GiantMonsterWrestleTargetGoal(GiantMonsterEntity mob, Class<T> class_, boolean bl, boolean bl2) {
        this(mob, class_, 360, bl, bl2, null);
    }

    public GiantMonsterWrestleTargetGoal(GiantMonsterEntity mob, Class<T> class_, int n, boolean bl, boolean bl2, @Nullable Predicate<LivingEntity> predicate) {
        super(mob, bl, bl2);
        this.targetType = class_;
        this.randomInterval = NearestAttackableTargetGoal.m_186073_((int)n);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.getFollowDistance()).m_26888_(predicate);
    }

    public boolean m_8036_() {
        if (this.mob.getWrestleCooldown() > 0) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.getNotAttackTarget() != null) {
            return false;
        }
        if (this.mob.m_21824_()) {
            return false;
        }
        if (this.mob.m_6162_()) {
            return false;
        }
        if (this.mob.m_27593_()) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null && this.target.m_5448_() == null && this.target.getNotAttackTarget() == null && this.target.getWrestleCooldown() <= 0 && !this.target.m_21824_() && !this.target.m_6162_() && !this.target.m_27593_();
    }

    @Override
    public boolean m_8045_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.mob.getWrestleCooldown() < 2000) {
            return false;
        }
        if (this.mob.m_21824_()) {
            return false;
        }
        if (this.mob.m_6162_()) {
            return false;
        }
        if (this.mob.m_27593_()) {
            return false;
        }
        return super.m_8045_();
    }

    protected AABB getNotAttackTargetSearchArea(double d) {
        return this.mob.m_20191_().m_82377_(d, 4.0, d);
    }

    protected void findTarget() {
        this.target = (GiantMonsterEntity)this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.targetType, this.getNotAttackTargetSearchArea(this.getFollowDistance()), livingEntity -> true), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
    }

    @Override
    public void m_8056_() {
        if (this.target != null && this.mob != null && !this.mob.m_9236_().m_5776_()) {
            this.mob.setNotAttackTarget((LivingEntity)this.target);
            this.mob.setWrestleCooldown(2400);
            this.target.setNotAttackTarget((LivingEntity)this.mob);
            this.target.setWrestleCooldown(2400);
        }
        super.m_8056_();
    }
}

