/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.item.tool.ItemToolBaseCrossbow;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class JerotesVillagerRangedCrossbowAttackGoal<T extends Mob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private float attackRadius;
    private float attackRadiusSqr;
    private int attackSpeedCooldownTick;
    private int seeTime;
    private int attackDelay;
    private int attackCooldown;
    private int updatePathDelay;

    public JerotesVillagerRangedCrossbowAttackGoal(T t, double d, float f) {
        this.mob = t;
        this.speedModifier = d;
        this.attackRadius = f;
        this.attackRadiusSqr = f * f;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attackSpeedCooldownTick = 20;
    }

    public JerotesVillagerRangedCrossbowAttackGoal(T t, double d, float f, int n) {
        this(t, d, f);
        this.attackSpeedCooldownTick = n;
    }

    public boolean m_8036_() {
        return this.isValidTarget() && JerotesVillagerRangedCrossbowAttackGoal.isHoldingCrossbow(this.mob);
    }

    public static boolean isHoldingCrossbow(Mob mob) {
        Item main = mob.m_21205_().m_41720_();
        Item off = mob.m_21206_().m_41720_();
        float reach = 8.0f;
        if (mob instanceof InventoryEntity) {
            InventoryEntity inventoryEntity = (InventoryEntity)mob;
            reach = inventoryEntity.meleeOrRangeDistance();
        }
        if (InventoryEntity.isMeleeWeapon((ItemStack)mob.m_21205_()) && mob.m_5448_() != null && mob.m_20270_((Entity)mob.m_5448_()) <= reach) {
            return false;
        }
        return main instanceof CrossbowItem || off instanceof CrossbowItem && (mob.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)mob.m_21205_()));
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && JerotesVillagerRangedCrossbowAttackGoal.isHoldingCrossbow(this.mob);
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        InventoryEntity inventoryEntity;
        T t;
        super.m_8041_();
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null || !((t = this.mob) instanceof InventoryEntity) || !(inventoryEntity = (InventoryEntity)t).isCanChangeMeleeOrRange()) {
            this.mob.m_21561_(false);
            this.mob.m_6710_(null);
        } else {
            this.mob.m_21573_().m_26573_();
        }
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
            CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Item item;
        ItemStack handItem = this.mob.m_21205_();
        if ((this.mob.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.mob.m_21205_())) && !this.mob.m_21206_().m_41619_() && (item = this.mob.m_21206_().m_41720_()) instanceof CrossbowItem) {
            CrossbowItem crossbowItem = (CrossbowItem)item;
            handItem = this.mob.m_21206_();
        }
        --this.attackCooldown;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return;
        }
        int addReach = 0;
        Item item2 = handItem.m_41720_();
        if (item2 instanceof ItemToolBaseCrossbow) {
            ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item2;
            addReach = itemToolBaseCrossbow.mobUseAddReach();
        }
        float allReach = Math.max(0.0f, this.attackRadius + (float)addReach);
        this.attackRadiusSqr = allReach * allReach;
        boolean bl3 = this.mob.m_21574_().m_148306_((Entity)livingEntity);
        boolean bl = this.seeTime > 0;
        boolean bl4 = bl;
        if (bl3 != bl) {
            this.seeTime = 0;
        }
        this.seeTime = bl3 ? (this.seeTime = this.seeTime + 1) : (this.seeTime = this.seeTime - 1);
        double d = this.mob.m_20280_((Entity)livingEntity);
        boolean bl2 = (d > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        boolean bl5 = bl2;
        if (bl2) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.m_21573_().m_5624_((Entity)livingEntity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.m_21573_().m_26573_();
        }
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!bl2) {
                this.mob.m_6672_(ProjectileUtil.m_37297_(this.mob, (Item)handItem.m_41720_()));
                this.crossbowState = CrossbowState.CHARGING;
                ((CrossbowAttackMob)this.mob).m_6136_(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemStack;
            int n;
            if (!this.mob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((n = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemStack = this.mob.m_21211_()))) {
                this.mob.m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = this.attackSpeedCooldownTick + this.mob.m_217043_().m_188503_(this.attackSpeedCooldownTick);
                ((CrossbowAttackMob)this.mob).m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && bl3 && this.attackCooldown <= 0) {
            ItemStack itemStack = this.mob.m_21120_(ProjectileUtil.m_37297_(this.mob, (Item)handItem.m_41720_()));
            if (ItemToolBaseCrossbow.getBullet((ItemStack)itemStack) > 0) {
                ((RangedAttackMob)this.mob).m_6504_(livingEntity, 1.0f);
                ItemToolBaseCrossbow.setBullet((ItemStack)itemStack, (int)(ItemToolBaseCrossbow.getBullet((ItemStack)itemStack) - 1));
                int n = 5;
                Item item3 = handItem.m_41720_();
                if (item3 instanceof ItemToolBaseCrossbow) {
                    ItemToolBaseCrossbow itemToolBaseCrossbow = (ItemToolBaseCrossbow)item3;
                    n = itemToolBaseCrossbow.mobUseCooldownTick(handItem);
                }
                this.attackCooldown = n;
            } else {
                CrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static final class CrossbowState {
        public static final CrossbowState UNCHARGED = new CrossbowState();
        public static final CrossbowState CHARGING = new CrossbowState();
        public static final CrossbowState CHARGED = new CrossbowState();
        public static final CrossbowState READY_TO_ATTACK = new CrossbowState();
        private static final CrossbowState[] $VALUES = CrossbowState.$values();

        CrossbowState() {
        }

        public static CrossbowState[] values() {
            return (CrossbowState[])$VALUES.clone();
        }

        private static CrossbowState[] $values() {
            return new CrossbowState[]{UNCHARGED, CHARGING, CHARGED, READY_TO_ATTACK};
        }
    }
}

