/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class MerorPanicGoal
extends Goal {
    public static final int WATER_CHECK_DISTANCE_VERTICAL = 1;
    protected final PathfinderMob mob;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;

    public MerorPanicGoal(PathfinderMob pathfinderMob, double d) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos blockPos;
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.mob.m_21223_() >= this.mob.m_21233_() / 4.0f) {
            return false;
        }
        if (this.mob.m_6060_() && (blockPos = this.lookForWater((BlockGetter)this.mob.m_9236_(), (Entity)this.mob, 5)) != null) {
            this.posX = blockPos.m_123341_();
            this.posY = blockPos.m_123342_();
            this.posZ = blockPos.m_123343_();
            return true;
        }
        return this.findRandomPosition() && this.mob.m_21223_() < this.mob.m_21233_() / 4.0f;
    }

    protected boolean shouldPanic() {
        if (this.mob.m_21223_() >= this.mob.m_21233_() / 4.0f) {
            return false;
        }
        return (this.mob.m_21188_() != null || this.mob.m_203117_() || this.mob.m_6060_()) && this.mob.m_21223_() < this.mob.m_21233_() / 4.0f || this.mob.m_21223_() < this.mob.m_21233_() / 4.0f;
    }

    protected boolean findRandomPosition() {
        Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)5, (int)4);
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.f_82479_;
        this.posY = vec3.f_82480_;
        this.posZ = vec3.f_82481_;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void m_8041_() {
        this.isRunning = false;
    }

    public boolean m_8045_() {
        if (this.mob.m_21223_() >= this.mob.m_21233_() / 4.0f) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_() && this.mob.m_21223_() < this.mob.m_21233_() / 4.0f;
    }

    @Nullable
    protected BlockPos lookForWater(BlockGetter blockGetter, Entity entity, int n) {
        BlockPos blockPos2 = entity.m_20183_();
        if (!blockGetter.m_8055_(blockPos2).m_60812_(blockGetter, blockPos2).m_83281_()) {
            return null;
        }
        return BlockPos.m_121930_((BlockPos)entity.m_20183_(), (int)n, (int)1, blockPos -> blockGetter.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)).orElse(null);
    }
}

