/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Smart.SmartBulgeEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SmartBulgeAttackGoal
extends Goal {
    private final SmartBulgeEntity mob;
    private final RangedAttackMob rangedAttackMob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public SmartBulgeAttackGoal(SmartBulgeEntity p_25768_, double p_25769_, int p_25770_, float p_25771_) {
        this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
    }

    public SmartBulgeAttackGoal(SmartBulgeEntity p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
        if (!(p_25773_ instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackMob = p_25773_;
        this.mob = p_25773_;
        this.speedModifier = p_25774_;
        this.attackIntervalMin = p_25775_;
        this.attackIntervalMax = p_25776_;
        this.attackRadius = p_25777_;
        this.attackRadiusSqr = p_25777_ * p_25777_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity $$0 = this.mob.m_5448_();
        if ($$0 != null && $$0.m_6084_()) {
            this.target = $$0;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean canSee;
        if (this.target == null) {
            return;
        }
        double distanceSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean bl = canSee = this.mob.hasLineOfSightWithBlock && this.mob.hasLineOfSightWithEntity;
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (this.strafingTime >= 20) {
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                this.strafingClockwise = !this.strafingClockwise;
                boolean bl2 = this.strafingClockwise;
            }
            if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                this.strafingBackwards = !this.strafingBackwards;
            }
            this.strafingTime = 0;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.target.m_20182_());
        if (distanceSqr > (double)this.attackRadiusSqr) {
            if (this.mob.canMoveTo) {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
        } else if ((this.mob.distanceToTarget < Math.max(12.0f, this.target.m_20205_() / 0.6f) || this.mob.distanceToTarget < Math.max(16.0f, this.target.m_20205_() / 0.3f) && this.mob.targetMoveState == 1.0f) && this.mob.canMoveTo && vec3 != null && !(this.target.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.target.m_20280_((Entity)this.mob))) {
            PathNavigation pathNav = this.mob.m_21573_();
            Path path = pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
            if (path == null || path.m_77392_()) {
                this.mob.m_21573_().m_26536_(path, this.speedModifier);
            }
        } else if (!canSee || this.mob.heightWithTarget > -5.0f && !this.mob.canMoveTo || this.mob.distanceToTarget < Math.max(12.0f, this.target.m_20205_() / 0.6f)) {
            this.mob.m_21573_().m_26573_();
            ++this.strafingTime;
            if (this.strafingTime > -1) {
                if (distanceSqr > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceSqr < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
            }
        } else if (this.mob.heightWithTarget <= -5.0f && this.mob.canMoveTo) {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        } else if (distanceSqr <= (double)this.attackRadiusSqr && this.seeTime >= 5) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 360.0f, 360.0f);
        this.mob.m_21391_((Entity)this.target, 360.0f, 360.0f);
        if (--this.attackTime == 0) {
            if (!canSee) {
                return;
            }
            float $$2 = (float)Math.sqrt(distanceSqr) / this.attackRadius;
            float $$3 = Mth.m_14036_((float)$$2, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(this.target, $$3);
            this.attackTime = Mth.m_14143_((float)($$2 * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distanceSqr) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
    }
}

