/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Neutral.Wonderlin.BaseWonderlinEntity;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.scores.Team;

public abstract class WonderlinTargetGoal
extends Goal {
    private static final int EMPTY_REACH_CACHE = 0;
    private static final int CAN_REACH_CACHE = 1;
    private static final int CANT_REACH_CACHE = 2;
    protected final BaseWonderlinEntity mob;
    protected final boolean mustSee;
    private final boolean mustReach;
    private int reachCache;
    private int reachCacheTime;
    private int unseenTicks;
    @Nullable
    protected LivingEntity targetMob;
    protected int unseenMemoryTicks = 60;

    public WonderlinTargetGoal(BaseWonderlinEntity p_26140_, boolean p_26141_) {
        this(p_26140_, p_26141_, false);
    }

    public WonderlinTargetGoal(BaseWonderlinEntity p_26143_, boolean p_26144_, boolean p_26145_) {
        this.mob = p_26143_;
        this.mustSee = p_26144_;
        this.mustReach = p_26145_;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.getNotAttackTarget();
        if (livingentity == null) {
            livingentity = this.targetMob;
        }
        if (livingentity == null) {
            return false;
        }
        if (!this.mob.m_6779_(livingentity)) {
            return false;
        }
        Team team = this.mob.m_5647_();
        Team team1 = livingentity.m_5647_();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getFollowDistance();
        if (this.mob.m_20280_((Entity)livingentity) > d0 * d0) {
            return false;
        }
        if (this.mustSee) {
            if (this.mob.m_21574_().m_148306_((Entity)livingentity)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > WonderlinTargetGoal.m_186073_((int)this.unseenMemoryTicks)) {
                return false;
            }
        }
        this.mob.setNotAttackTarget(livingentity);
        return true;
    }

    protected double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }

    public void m_8056_() {
        this.reachCache = 0;
        this.reachCacheTime = 0;
        this.unseenTicks = 0;
    }

    public void m_8041_() {
        this.mob.setNotAttackTarget(null);
        this.targetMob = null;
    }

    protected boolean canAttack(@Nullable LivingEntity p_26151_, TargetingConditions p_26152_) {
        if (p_26151_ == null) {
            return false;
        }
        if (!p_26152_.m_26885_((LivingEntity)this.mob, p_26151_)) {
            return false;
        }
        if (!this.mob.m_21444_(p_26151_.m_20183_())) {
            return false;
        }
        if (this.mustReach) {
            if (--this.reachCacheTime <= 0) {
                this.reachCache = 0;
            }
            if (this.reachCache == 0) {
                int n = this.reachCache = this.canReach(p_26151_) ? 1 : 2;
            }
            if (this.reachCache == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canReach(LivingEntity p_26149_) {
        int j;
        this.reachCacheTime = WonderlinTargetGoal.m_186073_((int)(10 + this.mob.m_217043_().m_188503_(5)));
        Path path = this.mob.m_21573_().m_6570_((Entity)p_26149_, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - p_26149_.m_146903_();
        return (double)(i * i + (j = node.f_77273_ - p_26149_.m_146907_()) * j) <= 2.25;
    }

    public WonderlinTargetGoal setUnseenMemoryTicks(int p_26147_) {
        this.unseenMemoryTicks = p_26147_;
        return this;
    }
}

