/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item;

import com.jerotes.jerotes.item.ItemModelArmor;
import com.jerotes.jerotesvillage.client.model.Modelhorned_armor;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class GiantMonsterArmor
extends ArmorItem {
    public GiantMonsterArmor(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties) {
        super(armorMaterial, type, properties);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)this.getDisplayName().m_130940_(ChatFormatting.GRAY));
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }

    public static class Boots
    extends BaseType {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jerotesvillage:textures/models/armor/giant_monster_layer_1.png";
        }

        public boolean canWalkOnPowderedSnow(ItemStack itemstack, LivingEntity entity) {
            return true;
        }
    }

    public static class Leggings
    extends BaseType {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jerotesvillage:textures/models/armor/giant_monster_layer_2.png";
        }
    }

    public static class Chestplate
    extends BaseType {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jerotesvillage:textures/models/armor/giant_monster_layer_1.png";
        }
    }

    public static class HornedHelmet
    extends HornType {
        public HornedHelmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            super.initializeClient(consumer);
            consumer.accept(new IClientItemExtensions(){

                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    Modelhorned_armor model = new Modelhorned_armor(Minecraft.m_91087_().m_167973_().m_171103_(Modelhorned_armor.LAYER_LOCATION)).getArmor(livingEntity);
                    model.f_102809_.f_104207_ = equipmentSlot == EquipmentSlot.HEAD;
                    model.f_102810_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                    model.f_102811_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                    model.f_102812_.f_104207_ = equipmentSlot == EquipmentSlot.CHEST;
                    model.f_102813_.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                    model.f_102814_.f_104207_ = equipmentSlot == EquipmentSlot.FEET;
                    model.f_102610_ = original.f_102610_;
                    model.f_102817_ = original.f_102817_;
                    model.f_102609_ = original.f_102609_;
                    model.f_102816_ = original.f_102816_;
                    model.f_102815_ = original.f_102815_;
                    return model;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            if (entity instanceof AbstractIllager && (!OtherMainConfig.CarvedVillagerHelmetHeightAsVillager || entity.m_6095_() != JerotesVillageEntityType.CARVED_VILLAGER.get()) || entity.m_6095_() == EntityType.f_20530_ || entity.m_6095_() == EntityType.f_20492_ || entity.m_6095_() == EntityType.f_20494_) {
                return "jerotesvillage:textures/models/armor/villager_giant_monster_horned_layer_1.png";
            }
            return "jerotesvillage:textures/models/armor/giant_monster_horned_layer_1.png";
        }
    }

    public static class Helmet
    extends BaseType {
        public Helmet() {
            super(ArmorItem.Type.HELMET, new Item.Properties());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "jerotesvillage:textures/models/armor/giant_monster_layer_1.png";
        }
    }

    public static abstract class HornType
    extends GiantMonsterArmor
    implements ItemModelArmor {
        public HornType(ArmorItem.Type type, Item.Properties properties) {
            super(new ArmorMaterial(){

                public int m_266425_(ArmorItem.Type type) {
                    return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 22;
                }

                public int m_7366_(ArmorItem.Type type) {
                    return (new int[]{3, 4, 5, 3})[type.m_266308_().m_20749_()];
                }

                public int m_6646_() {
                    return 15;
                }

                public SoundEvent m_7344_() {
                    return SoundEvents.f_11678_;
                }

                public Ingredient m_6230_() {
                    return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JerotesVillageItems.GIANT_MONSTER_HAIR.get())});
                }

                public String m_6082_() {
                    return "giant_monster_horned_armor";
                }

                public float m_6651_() {
                    return 2.0f;
                }

                public float m_6649_() {
                    return 0.16f;
                }
            }, type, properties);
        }
    }

    public static abstract class BaseType
    extends GiantMonsterArmor {
        public BaseType(ArmorItem.Type type, Item.Properties properties) {
            super(new ArmorMaterial(){

                public int m_266425_(ArmorItem.Type type) {
                    return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 22;
                }

                public int m_7366_(ArmorItem.Type type) {
                    return (new int[]{3, 4, 5, 3})[type.m_266308_().m_20749_()];
                }

                public int m_6646_() {
                    return 15;
                }

                public SoundEvent m_7344_() {
                    return SoundEvents.f_11678_;
                }

                public Ingredient m_6230_() {
                    return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)JerotesVillageItems.GIANT_MONSTER_HAIR.get())});
                }

                public String m_6082_() {
                    return "giant_monster_armor";
                }

                public float m_6651_() {
                    return 2.0f;
                }

                public float m_6649_() {
                    return 0.16f;
                }
            }, type, properties);
        }
    }
}

