/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item;

import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class WonderlinSmallBag
extends Item {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)1.0f, (float)0.4f);

    public WonderlinSmallBag(Item.Properties properties) {
        super(properties);
    }

    public static float getFullnessDisplay(ItemStack itemStack) {
        return (float)WonderlinSmallBag.getContentWeight(itemStack) / 64.0f;
    }

    public boolean m_142207_(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemStack3 = slot.m_7993_();
        if (itemStack3.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            WonderlinSmallBag.removeOne(itemStack).ifPresent(itemStack2 -> WonderlinSmallBag.add(itemStack, slot.m_150659_(itemStack2)));
        } else if (itemStack3.m_41720_().m_142095_()) {
            int n = (64 - WonderlinSmallBag.getContentWeight(itemStack)) / WonderlinSmallBag.getWeight(itemStack3);
            int n2 = WonderlinSmallBag.add(itemStack, slot.m_150647_(itemStack3.m_41613_(), n, player));
            if (n2 > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean m_142305_(ItemStack itemStack2, ItemStack itemStack3, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (itemStack3.m_41619_()) {
            WonderlinSmallBag.removeOne(itemStack2).ifPresent(itemStack -> {
                this.playRemoveOneSound((Entity)player);
                slotAccess.m_142104_(itemStack);
            });
        } else {
            int n = WonderlinSmallBag.add(itemStack2, itemStack3);
            if (n > 0) {
                this.playInsertSound((Entity)player);
                itemStack3.m_41774_(n);
            }
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (WonderlinSmallBag.dropContents(itemStack, player)) {
            this.playDropContentsSound((Entity)player);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public boolean m_142522_(ItemStack itemStack) {
        return WonderlinSmallBag.getContentWeight(itemStack) > 0;
    }

    public int m_142158_(ItemStack itemStack) {
        return Math.min(1 + 12 * WonderlinSmallBag.getContentWeight(itemStack) / 64, 13);
    }

    public int m_142159_(ItemStack itemStack) {
        return BAR_COLOR;
    }

    private static int add(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack2.m_41619_() || !itemStack2.m_41720_().m_142095_()) {
            return 0;
        }
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            compoundTag.m_128365_(TAG_ITEMS, (Tag)new ListTag());
        }
        int n = WonderlinSmallBag.getContentWeight(itemStack);
        int n2 = WonderlinSmallBag.getWeight(itemStack2);
        int n3 = Math.min(itemStack2.m_41613_(), (64 - n) / n2);
        if (n3 == 0) {
            return 0;
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        Optional<CompoundTag> optional = WonderlinSmallBag.getMatchingItem(itemStack2, listTag);
        if (optional.isPresent()) {
            CompoundTag compoundTag2 = optional.get();
            ItemStack itemStack3 = ItemStack.m_41712_((CompoundTag)compoundTag2);
            itemStack3.m_41769_(n3);
            itemStack3.m_41739_(compoundTag2);
            listTag.remove((Object)compoundTag2);
            listTag.add(0, (Tag)compoundTag2);
        } else {
            ItemStack itemStack4 = itemStack2.m_255036_(n3);
            CompoundTag compoundTag3 = new CompoundTag();
            itemStack4.m_41739_(compoundTag3);
            listTag.add(0, (Tag)compoundTag3);
        }
        return n3;
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack itemStack, ListTag listTag) {
        if (itemStack.m_150930_((Item)JerotesVillageItems.WONDERLIN_SMALL_BAG.get())) {
            return Optional.empty();
        }
        if (itemStack.m_150930_(Items.f_151058_)) {
            return Optional.empty();
        }
        return listTag.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).filter(compoundTag -> ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag), (ItemStack)itemStack)).findFirst();
    }

    private static int getWeight(ItemStack itemStack) {
        CompoundTag compoundTag;
        if (itemStack.m_150930_((Item)JerotesVillageItems.WONDERLIN_SMALL_BAG.get())) {
            return 4 + WonderlinSmallBag.getContentWeight(itemStack);
        }
        if (itemStack.m_150930_(Items.f_151058_)) {
            return 4 + WonderlinSmallBag.getContentWeight(itemStack);
        }
        if ((itemStack.m_150930_(Items.f_42786_) || itemStack.m_150930_(Items.f_42785_)) && itemStack.m_41782_() && (compoundTag = BlockItem.m_186336_((ItemStack)itemStack)) != null && !compoundTag.m_128437_("Bees", 10).isEmpty()) {
            return 64;
        }
        return 64 / itemStack.m_41741_();
    }

    private static int getContentWeight(ItemStack itemStack2) {
        return WonderlinSmallBag.getContents(itemStack2).mapToInt(itemStack -> WonderlinSmallBag.getWeight(itemStack) * itemStack.m_41613_()).sum();
    }

    private static Optional<ItemStack> removeOne(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        if (listTag.isEmpty()) {
            return Optional.empty();
        }
        boolean bl = false;
        CompoundTag compoundTag2 = listTag.m_128728_(0);
        ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag2);
        listTag.remove(0);
        if (listTag.isEmpty()) {
            itemStack.m_41749_(TAG_ITEMS);
        }
        return Optional.of(itemStack2);
    }

    private static boolean dropContents(ItemStack itemStack, Player player) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (!compoundTag.m_128441_(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                ItemStack itemStack2 = ItemStack.m_41712_((CompoundTag)compoundTag2);
                player.m_36176_(itemStack2, true);
            }
        }
        itemStack.m_41749_(TAG_ITEMS);
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag == null) {
            return Stream.empty();
        }
        ListTag listTag = compoundTag.m_128437_(TAG_ITEMS, 10);
        return listTag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack itemStack) {
        NonNullList nonNullList = NonNullList.m_122779_();
        WonderlinSmallBag.getContents(itemStack).forEach(arg_0 -> nonNullList.add(arg_0));
        return Optional.of(new BundleTooltip(nonNullList, WonderlinSmallBag.getContentWeight(itemStack)));
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237110_((String)"item.jerotesvillage.wonderlin_small_bag.fullness", (Object[])new Object[]{WonderlinSmallBag.getContentWeight(itemStack), 64}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemUtils.m_150952_((ItemEntity)itemEntity, WonderlinSmallBag.getContents(itemEntity.m_32055_()));
    }

    private void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11988_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11991_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_11989_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

